/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.RhinoStringPool;
import com.google.javascript.rhino.SourcePosition;
import com.google.javascript.rhino.Token;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.jspecify.nullness.Nullable;

public class JSDocInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long propertyBits;
    private final long propertyKeysBitset;
    private final @Nullable Object propertyValues;
    private static final Property<Visibility> VISIBILITY = new Property("visibility");
    private static final TypeProperty TYPE = new TypeProperty("type");
    private static final TypeProperty RETURN_TYPE = new TypeProperty("returnType");
    private static final TypeProperty ENUM_PARAMETER_TYPE = new TypeProperty("enumParameterType");
    private static final TypeProperty TYPEDEF_TYPE = new TypeProperty("typedefType");
    private static final TypeProperty THIS_TYPE = new TypeProperty("thisType");
    private static final Property<Integer> ORIGINAL_COMMENT_POSITION = new Property("originalCommentPosition");
    private static final Property<IdGenerator> ID_GENERATOR = new Property("idGenerator");
    private static final TypeProperty BASE_TYPE = new TypeProperty("baseType");
    private static final TypeListProperty EXTENDED_INTERFACES = new TypeListProperty("extendedInterfaces");
    private static final TypeListProperty IMPLEMENTED_INTERFACES = new TypeListProperty("extendedInterfaces");
    private static final TypeMapProperty PARAMETERS = new TypeMapProperty("parameters");
    private static final Property<List<String>> THROWS_ANNOTATIONS = new Property("throws");
    private static final TypeMapProperty TEMPLATE_TYPE_NAMES = new TypeMapProperty("templateTypeNames");
    private static final NodeMapProperty TYPE_TRANSFORMATIONS = new NodeMapProperty("typeTransformations");
    private static final Property<String> DESCRIPTION = new Property("description");
    private static final Property<String> MEANING = new Property("meaning");
    private static final Property<String> ALTERNATE_MESSAGE_ID = new Property("alternateMessageId");
    private static final Property<String> DEPRECATION_REASON = new Property("deprecationReason");
    private static final Property<String> LICENSE = new Property("license");
    private static final Property<ImmutableMap<ImmutableSet<String>, String>> SUPPRESSIONS = new Property("suppressions");
    private static final Property<ImmutableSet<String>> MODIFIES = new Property("modifies");
    private static final TypeProperty LENDS_NAME = new TypeProperty("lendsName");
    private static final Property<String> CLOSURE_PRIMITIVE_ID = new Property("closurePrimitiveId");
    private static final Property<String> SOURCE_COMMENT = new Property("sourceComment");
    private static final Property<ArrayList<Marker>> MARKERS = new MarkerListProperty("markers");
    private static final Property<LinkedHashMap<String, String>> PARAMETER_DESCRIPTIONS = new Property("parameterDescriptions");
    private static final Property<String> BLOCK_DESCRIPTION = new Property("blockDescription");
    private static final Property<String> FILEOVERVIEW_DESCRIPTION = new Property("fileoverviewDescription");
    private static final Property<String> RETURN_DESCRIPTION = new Property("returnDescription");
    private static final Property<String> ENHANCED_NAMESPACE = new Property("enhance");
    private static final Property<String> MODS = new Property("mods");
    private static final Property<List<String>> TS_TYPES = new Property("tsType");
    private static final Property<List<String>> AUTHORS = new Property("authors");
    private static final Property<List<String>> SEES = new Property("sees");
    private static final long EQUIVALENCE_IGNORED_BITS = Bit.INCLUDE_DOCUMENTATION.mask | Bit.INLINE_TYPE.mask;

    private JSDocInfo(long bits, TreeMap<Property<?>, Object> props) {
        long keys = 0L;
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<Property<?>, Object> entry : props.entrySet()) {
            Object value;
            Property<?> prop = entry.getKey();
            if (prop.isDefault(value = entry.getValue())) continue;
            keys |= prop.mask;
            Preconditions.checkState((!(value instanceof Object[]) && value != null ? 1 : 0) != 0);
            values.add(value);
        }
        this.propertyBits = bits;
        this.propertyKeysBitset = keys;
        this.propertyValues = JSDocInfo.packPropertyValues(values);
    }

    private boolean checkBit(Bit bit) {
        return (this.propertyBits & bit.mask) != 0L;
    }

    private TreeMap<Property<?>, Object> asMap() {
        int low;
        TreeMap map = new TreeMap();
        int index = 0;
        for (long bits = this.propertyKeysBitset; bits > 0L; bits &= 1L << low ^ 0xFFFFFFFFFFFFFFFFL) {
            low = Long.numberOfTrailingZeros(bits);
            map.put(Property.values[low], this.getPropertyValueByIndex(index++));
        }
        return map;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return this.toBuilder(null);
    }

    private Builder toBuilder(@Nullable TypeTransform transform) {
        Builder builder = new Builder();
        builder.bits = this.propertyBits & (Bit.INLINE_TYPE.mask ^ 0xFFFFFFFFFFFFFFFFL);
        builder.props = this.asMap();
        builder.populated = true;
        for (Map.Entry<Property<?>, Object> entry : builder.props.entrySet()) {
            entry.setValue(entry.getKey().clone(entry.getValue(), transform));
        }
        return builder;
    }

    public JSDocInfo clone() {
        return this.clone(false);
    }

    public JSDocInfo cloneAndReplaceTypeNames(Set<String> names) {
        return this.toBuilder(type -> type.replaceNamesWithUnknownType(names)).build();
    }

    public JSDocInfo clone(boolean cloneTypeNodes) {
        return cloneTypeNodes ? this.toBuilder(JSTypeExpression::copy).build() : this.toBuilder().build();
    }

    @VisibleForTesting
    public static boolean areEquivalent(JSDocInfo jsDoc1, JSDocInfo jsDoc2) {
        int low;
        if (jsDoc1 == null != (jsDoc2 == null)) {
            return false;
        }
        if (jsDoc1 == null) {
            return true;
        }
        if (((jsDoc1.propertyBits ^ jsDoc2.propertyBits) & (EQUIVALENCE_IGNORED_BITS ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return false;
        }
        if (jsDoc1.propertyKeysBitset != jsDoc2.propertyKeysBitset) {
            return false;
        }
        int index = 0;
        for (long bits = jsDoc1.propertyKeysBitset; bits > 0L; bits &= 1L << low ^ 0xFFFFFFFFFFFFFFFFL) {
            Object b;
            low = Long.numberOfTrailingZeros(bits);
            Property<?> prop = Property.values[low];
            Object a = jsDoc1.getPropertyValueByIndex(index);
            if (a == null == ((b = jsDoc2.getPropertyValueByIndex(index++)) == null) && (a == null || prop.equalValues(a, b))) continue;
            return false;
        }
        return true;
    }

    boolean isDocumentationIncluded() {
        return this.checkBit(Bit.INCLUDE_DOCUMENTATION);
    }

    public boolean isAnyIdGenerator() {
        return (this.propertyKeysBitset & JSDocInfo.ID_GENERATOR.mask) != 0L;
    }

    public boolean isConsistentIdGenerator() {
        return ID_GENERATOR.get(this) == IdGenerator.CONSISTENT;
    }

    public boolean isStableIdGenerator() {
        return ID_GENERATOR.get(this) == IdGenerator.STABLE;
    }

    public boolean isXidGenerator() {
        return ID_GENERATOR.get(this) == IdGenerator.XID;
    }

    public boolean isMappedIdGenerator() {
        return ID_GENERATOR.get(this) == IdGenerator.MAPPED;
    }

    public boolean isIdGenerator() {
        return ID_GENERATOR.get(this) == IdGenerator.UNIQUE;
    }

    public boolean isConstant() {
        return (this.propertyBits & (Bit.CONST.mask | Bit.DEFINE.mask | Bit.FINAL.mask)) != 0L || (this.propertyKeysBitset & JSDocInfo.DESCRIPTION.mask) != 0L;
    }

    public boolean hasConstAnnotation() {
        return this.checkBit(Bit.CONST);
    }

    public boolean isFinal() {
        return this.checkBit(Bit.FINAL);
    }

    public boolean isConstructor() {
        return this.checkBit(Bit.CONSTRUCTOR);
    }

    public boolean isAbstract() {
        return this.checkBit(Bit.ABSTRACT);
    }

    public boolean usesImplicitMatch() {
        return this.checkBit(Bit.RECORD);
    }

    public boolean makesUnrestricted() {
        return this.checkBit(Bit.UNRESTRICTED);
    }

    public boolean makesStructs() {
        return this.checkBit(Bit.STRUCT);
    }

    public boolean makesDicts() {
        return this.checkBit(Bit.DICT);
    }

    public boolean isDefine() {
        return this.checkBit(Bit.DEFINE);
    }

    public boolean isHidden() {
        return this.checkBit(Bit.HIDDEN);
    }

    public boolean isOverride() {
        return this.checkBit(Bit.OVERRIDE);
    }

    public boolean isDeprecated() {
        return this.checkBit(Bit.DEPRECATED);
    }

    public boolean isInterface() {
        return (this.propertyBits & (Bit.INTERFACE.mask | Bit.RECORD.mask)) != 0L;
    }

    public boolean isConstructorOrInterface() {
        return (this.propertyBits & (Bit.CONSTRUCTOR.mask | Bit.INTERFACE.mask | Bit.RECORD.mask)) != 0L;
    }

    public boolean isExport() {
        return this.checkBit(Bit.EXPORT);
    }

    public boolean isImplicitCast() {
        return this.checkBit(Bit.IMPLICITCAST);
    }

    public boolean isNoSideEffects() {
        return this.checkBit(Bit.NOSIDEEFFECTS);
    }

    public boolean isExterns() {
        return this.checkBit(Bit.EXTERNS);
    }

    public boolean isNoCoverage() {
        return this.checkBit(Bit.NOCOVERAGE);
    }

    public boolean isTypeSummary() {
        return this.checkBit(Bit.TYPE_SUMMARY);
    }

    public boolean isNoCompile() {
        return this.checkBit(Bit.NOCOMPILE);
    }

    public boolean isNoDts() {
        return this.checkBit(Bit.NODTS);
    }

    public boolean isNoCollapse() {
        return this.checkBit(Bit.NOCOLLAPSE);
    }

    public boolean isNoInline() {
        return this.checkBit(Bit.NOINLINE);
    }

    public boolean isCollapsibleOrBreakMyCode() {
        return this.checkBit(Bit.COLLAPSIBLE_OR_BREAK_MY_CODE);
    }

    public boolean isPureOrBreakMyCode() {
        return this.checkBit(Bit.PURE_OR_BREAK_MY_CODE);
    }

    public boolean isProvideGoog() {
        return this.checkBit(Bit.PROVIDE_GOOG);
    }

    public boolean isProvideAlreadyProvided() {
        return this.checkBit(Bit.PROVIDE_ALREADY_PROVIDED);
    }

    public boolean containsDeclarationExcludingTypelessConst() {
        return (this.propertyBits & (Bit.CONSTRUCTOR.mask | Bit.DEFINE.mask | Bit.OVERRIDE.mask | Bit.EXPORT.mask | Bit.DEPRECATED.mask | Bit.INTERFACE.mask | Bit.IMPLICITCAST.mask | Bit.NOSIDEEFFECTS.mask | Bit.RECORD.mask)) != 0L || (this.propertyKeysBitset & (JSDocInfo.TYPE.mask | JSDocInfo.RETURN_TYPE.mask | JSDocInfo.ENUM_PARAMETER_TYPE.mask | JSDocInfo.TYPEDEF_TYPE.mask | JSDocInfo.THIS_TYPE.mask | JSDocInfo.PARAMETERS.mask | JSDocInfo.IMPLEMENTED_INTERFACES.mask | JSDocInfo.BASE_TYPE.mask | JSDocInfo.VISIBILITY.mask)) != 0L;
    }

    public boolean containsTypeDeclaration() {
        return (this.propertyKeysBitset & (JSDocInfo.TYPE.mask | JSDocInfo.RETURN_TYPE.mask | JSDocInfo.ENUM_PARAMETER_TYPE.mask | JSDocInfo.TYPEDEF_TYPE.mask | JSDocInfo.THIS_TYPE.mask | JSDocInfo.PARAMETERS.mask | JSDocInfo.BASE_TYPE.mask)) != 0L;
    }

    public boolean containsDeclaration() {
        return this.containsDeclarationExcludingTypelessConst() || this.checkBit(Bit.CONST);
    }

    @Deprecated
    public boolean containsFunctionDeclaration() {
        if (this.checkBit(Bit.CONSTRUCTOR) || (this.propertyKeysBitset & (JSDocInfo.RETURN_TYPE.mask | JSDocInfo.THIS_TYPE.mask | JSDocInfo.PARAMETERS.mask)) != 0L) {
            return true;
        }
        JSTypeExpression type = (JSTypeExpression)TYPE.get(this);
        if (type != null) {
            return type.getRoot().isFunction();
        }
        return this.checkBit(Bit.NOSIDEEFFECTS);
    }

    public boolean containsTypeDefinition() {
        return (this.propertyBits & (Bit.CONSTRUCTOR.mask | Bit.INTERFACE.mask)) != 0L || (this.propertyKeysBitset & (JSDocInfo.ENUM_PARAMETER_TYPE.mask | JSDocInfo.TYPEDEF_TYPE.mask)) != 0L;
    }

    public boolean isAtSignCodePresent() {
        String entireComment = this.getOriginalCommentString();
        return entireComment == null ? false : entireComment.contains("@code");
    }

    public Visibility getVisibility() {
        Visibility visibility = VISIBILITY.get(this);
        return visibility != null ? visibility : Visibility.INHERITED;
    }

    public @Nullable JSTypeExpression getParameterType(String parameter) {
        LinkedHashMap params = (LinkedHashMap)PARAMETERS.get(this);
        return params != null ? (JSTypeExpression)params.get(parameter) : null;
    }

    public boolean hasParameter(String parameter) {
        LinkedHashMap params = (LinkedHashMap)PARAMETERS.get(this);
        return params != null && params.containsKey(parameter);
    }

    public boolean hasParameterType(String parameter) {
        return this.getParameterType(parameter) != null;
    }

    public Set<String> getParameterNames() {
        LinkedHashMap params = (LinkedHashMap)PARAMETERS.get(this);
        return params != null ? ImmutableSet.copyOf(params.keySet()) : ImmutableSet.of();
    }

    public @Nullable String getParameterNameAt(int index) {
        LinkedHashMap params = (LinkedHashMap)PARAMETERS.get(this);
        if (params == null || index >= params.size()) {
            return null;
        }
        return (String)Iterables.get(params.keySet(), (int)index);
    }

    public int getParameterCount() {
        LinkedHashMap params = (LinkedHashMap)PARAMETERS.get(this);
        return params != null ? params.size() : 0;
    }

    public List<String> getThrowsAnnotations() {
        ImmutableList annotations = THROWS_ANNOTATIONS.get(this);
        return annotations != null ? annotations : ImmutableList.of();
    }

    public boolean hasEnumParameterType() {
        return ENUM_PARAMETER_TYPE.get(this) != null;
    }

    public boolean hasTypedefType() {
        return TYPEDEF_TYPE.get(this) != null;
    }

    public boolean hasReturnType() {
        return RETURN_TYPE.get(this) != null;
    }

    public boolean hasType() {
        return TYPE.get(this) != null;
    }

    public boolean hasTypeInformation() {
        return (this.propertyKeysBitset & (JSDocInfo.TYPE.mask | JSDocInfo.TYPEDEF_TYPE.mask | JSDocInfo.ENUM_PARAMETER_TYPE.mask | JSDocInfo.RETURN_TYPE.mask)) != 0L;
    }

    public boolean isInlineType() {
        return this.checkBit(Bit.INLINE_TYPE);
    }

    public JSTypeExpression getReturnType() {
        return (JSTypeExpression)RETURN_TYPE.get(this);
    }

    public JSTypeExpression getEnumParameterType() {
        return (JSTypeExpression)ENUM_PARAMETER_TYPE.get(this);
    }

    public JSTypeExpression getTypedefType() {
        return (JSTypeExpression)TYPEDEF_TYPE.get(this);
    }

    public JSTypeExpression getType() {
        return (JSTypeExpression)TYPE.get(this);
    }

    public JSTypeExpression getThisType() {
        return (JSTypeExpression)THIS_TYPE.get(this);
    }

    public boolean hasThisType() {
        return THIS_TYPE.get(this) != null;
    }

    public JSTypeExpression getBaseType() {
        return (JSTypeExpression)BASE_TYPE.get(this);
    }

    public String getDescription() {
        return DESCRIPTION.get(this);
    }

    public ImmutableList<String> getTsTypes() {
        List<String> types = TS_TYPES.get(this);
        return types != null ? ImmutableList.copyOf(types) : ImmutableList.of();
    }

    public String getMeaning() {
        return MEANING.get(this);
    }

    public String getAlternateMessageId() {
        return ALTERNATE_MESSAGE_ID.get(this);
    }

    public JSTypeExpression getLendsName() {
        return (JSTypeExpression)LENDS_NAME.get(this);
    }

    public boolean hasLendsName() {
        return this.getLendsName() != null;
    }

    public String getClosurePrimitiveId() {
        return CLOSURE_PRIMITIVE_ID.get(this);
    }

    public boolean hasClosurePrimitiveId() {
        return CLOSURE_PRIMITIVE_ID.get(this) != null;
    }

    public boolean isNgInject() {
        return this.checkBit(Bit.NG_INJECT);
    }

    public boolean isWizaction() {
        return this.checkBit(Bit.WIZ_ACTION);
    }

    public boolean isWizcallback() {
        return this.checkBit(Bit.WIZ_CALLBACK);
    }

    public boolean isPolymerBehavior() {
        return this.checkBit(Bit.POLYMER_BEHAVIOR);
    }

    public boolean isPolymer() {
        return this.checkBit(Bit.POLYMER);
    }

    public boolean isCustomElement() {
        return this.checkBit(Bit.CUSTOM_ELEMENT);
    }

    public boolean isMixinClass() {
        return this.checkBit(Bit.MIXIN_CLASS);
    }

    public boolean isMixinFunction() {
        return this.checkBit(Bit.MIXIN_FUNCTION);
    }

    public boolean isSassGeneratedCssTs() {
        return this.checkBit(Bit.SASS_GENERATED_CSS_TS);
    }

    public String getLicense() {
        return LICENSE.get(this);
    }

    public String toString() {
        return this.toStringVerbose();
    }

    @VisibleForTesting
    public String toStringVerbose() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("bitset", this.propertyBits == 0L ? null : Long.toHexString(this.propertyBits));
        for (Bit b : Bit.values()) {
            if (!this.checkBit(b)) continue;
            helper.add("bit:" + b.name, true);
        }
        long bits = this.propertyKeysBitset;
        int index = 0;
        while (bits > 0L) {
            int low = Long.numberOfTrailingZeros(bits);
            bits &= 1L << low ^ 0xFFFFFFFFFFFFFFFFL;
            helper = helper.add(Property.values[low].name, this.getPropertyValueByIndex(index++));
        }
        return helper.omitNullValues().toString();
    }

    public boolean hasBaseType() {
        return this.getBaseType() != null;
    }

    public List<JSTypeExpression> getImplementedInterfaces() {
        return IMPLEMENTED_INTERFACES.getUnmodifiable(this);
    }

    public int getImplementedInterfaceCount() {
        ArrayList list = (ArrayList)IMPLEMENTED_INTERFACES.get(this);
        return list != null ? list.size() : 0;
    }

    public List<JSTypeExpression> getExtendedInterfaces() {
        return EXTENDED_INTERFACES.getUnmodifiable(this);
    }

    public int getExtendedInterfacesCount() {
        ArrayList list = (ArrayList)EXTENDED_INTERFACES.get(this);
        return list != null ? list.size() : 0;
    }

    public String getDeprecationReason() {
        return DEPRECATION_REASON.get(this);
    }

    public Set<String> getSuppressions() {
        ImmutableMap<ImmutableSet<String>, String> suppressions = SUPPRESSIONS.get(this);
        if (suppressions == null) {
            return ImmutableSet.of();
        }
        ImmutableSet nameSets = suppressions.keySet();
        LinkedHashSet names = new LinkedHashSet();
        for (Set nameSet : nameSets) {
            names.addAll(nameSet);
        }
        return ImmutableSet.copyOf(names);
    }

    public ImmutableMap<ImmutableSet<String>, String> getSuppressionsAndTheirDescription() {
        ImmutableMap suppressions = SUPPRESSIONS.get(this);
        return suppressions != null ? suppressions : ImmutableMap.of();
    }

    public Set<String> getModifies() {
        ImmutableSet modifies = MODIFIES.get(this);
        return modifies != null ? modifies : ImmutableSet.of();
    }

    public boolean hasDescriptionForParameter(String name) {
        LinkedHashMap<String, String> params = PARAMETER_DESCRIPTIONS.get(this);
        return params != null && params.containsKey(name);
    }

    public @Nullable String getDescriptionForParameter(String name) {
        LinkedHashMap<String, String> params = PARAMETER_DESCRIPTIONS.get(this);
        return params != null ? params.get(name) : null;
    }

    public List<String> getAuthors() {
        return AUTHORS.get(this);
    }

    public List<String> getReferences() {
        return SEES.get(this);
    }

    public String getReturnDescription() {
        return RETURN_DESCRIPTION.get(this);
    }

    public String getBlockDescription() {
        return BLOCK_DESCRIPTION.get(this);
    }

    public boolean hasFileOverview() {
        return this.checkBit(Bit.FILEOVERVIEW);
    }

    public String getFileOverview() {
        return FILEOVERVIEW_DESCRIPTION.get(this);
    }

    public boolean hasEnhance() {
        return this.checkBit(Bit.ENHANCED_NAMESPACE);
    }

    public String getEnhance() {
        return ENHANCED_NAMESPACE.get(this);
    }

    public boolean hasMods() {
        return MODS.get(this) != null;
    }

    public String getMods() {
        return MODS.get(this);
    }

    public Collection<Marker> getMarkers() {
        ImmutableList markers = MARKERS.get(this);
        return markers != null ? markers : ImmutableList.of();
    }

    public ImmutableList<String> getTemplateTypeNames() {
        LinkedHashMap map = (LinkedHashMap)TEMPLATE_TYPE_NAMES.get(this);
        return map != null ? ImmutableList.copyOf(map.keySet()) : ImmutableList.of();
    }

    public ImmutableMap<String, JSTypeExpression> getTemplateTypes() {
        LinkedHashMap map = (LinkedHashMap)TEMPLATE_TYPE_NAMES.get(this);
        return map != null ? ImmutableMap.copyOf((Map)map) : ImmutableMap.of();
    }

    public ImmutableMap<String, Node> getTypeTransformations() {
        LinkedHashMap map = (LinkedHashMap)TYPE_TRANSFORMATIONS.get(this);
        return map != null ? ImmutableMap.copyOf((Map)map) : ImmutableMap.of();
    }

    public Collection<JSTypeExpression> getTypeExpressions() {
        ImmutableList.Builder builder = ImmutableList.builder();
        long bits = this.propertyKeysBitset;
        int index = 0;
        while (bits > 0L) {
            int low = Long.numberOfTrailingZeros(bits);
            bits &= 1L << low ^ 0xFFFFFFFFFFFFFFFFL;
            Property<?> prop = Property.values[low];
            for (JSTypeExpression type : prop.getTypeExpressions(this.getPropertyValueByIndex(index++))) {
                if (type == null) continue;
                builder.add((Object)type);
            }
        }
        return builder.build();
    }

    public Collection<Node> getTypeNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (JSTypeExpression type : this.getTypeExpressions()) {
            nodes.add(type.getRoot());
        }
        return nodes;
    }

    public boolean hasModifies() {
        return MODIFIES.get(this) != null;
    }

    public String getOriginalCommentString() {
        return SOURCE_COMMENT.get(this);
    }

    public int getOriginalCommentPosition() {
        Integer pos = ORIGINAL_COMMENT_POSITION.get(this);
        return pos != null ? pos : 0;
    }

    public boolean modifiesThis() {
        return this.getModifies().contains("this");
    }

    public boolean hasSideEffectsArgumentsAnnotation() {
        Set<String> modifies = this.getModifies();
        return modifies.size() > 1 || modifies.size() == 1 && !modifies.contains("this");
    }

    public boolean getLogTypeInCompiler() {
        return this.checkBit(Bit.LOG_TYPE_IN_COMPILER);
    }

    protected Object getPropertyValueByIndex(int index) {
        if (this.propertyValues == null) {
            throw new IllegalArgumentException("no property value");
        }
        if (this.propertyValues instanceof Object[]) {
            return ((Object[])this.propertyValues)[index];
        }
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.propertyValues;
    }

    private static @Nullable Object packPropertyValues(List<Object> values) {
        return values.isEmpty() ? null : (values.size() == 1 ? values.get(0) : values.toArray());
    }

    private static ImmutableSet<String> internSet(Set<String> strings) {
        ImmutableSet.Builder interned = ImmutableSet.builderWithExpectedSize((int)strings.size());
        for (String s : strings) {
            interned.add((Object)RhinoStringPool.addOrGet(s));
        }
        return interned.build();
    }

    private static class Property<T>
    implements Comparable<Property<Object>> {
        private static int bitCounter = 0;
        static final Property<?>[] values = new Property[64];
        final String name;
        final int bit;
        final long mask;

        private Property(String name) {
            this.name = name;
            this.bit = bitCounter++;
            this.mask = 1L << this.bit;
            if (this.bit > 63) {
                throw new AssertionError((Object)"Too many Properties");
            }
            Property.values[this.bit] = this;
        }

        @Nullable T get(JSDocInfo info) {
            if ((info.propertyKeysBitset & this.mask) == 0L) {
                return null;
            }
            return (T)info.getPropertyValueByIndex(Long.bitCount(info.propertyKeysBitset & this.mask - 1L));
        }

        T clone(T arg, @Nullable TypeTransform transform) {
            return arg;
        }

        boolean isDefault(T value) {
            return value == null || value == Visibility.INHERITED || value instanceof Collection && ((Collection)value).isEmpty() || value instanceof Map && ((Map)value).isEmpty();
        }

        boolean equalValues(T left, T right) {
            return left.equals(right);
        }

        Iterable<JSTypeExpression> getTypeExpressions(T value) {
            return ImmutableList.of();
        }

        @Override
        public int compareTo(Property<Object> that) {
            return this.bit - that.bit;
        }
    }

    private static enum Bit {
        INLINE_TYPE,
        INCLUDE_DOCUMENTATION,
        CONST,
        CONSTRUCTOR,
        DEFINE,
        HIDDEN,
        TYPE_SUMMARY,
        FINAL,
        OVERRIDE,
        DEPRECATED,
        INTERFACE,
        EXPORT,
        ENHANCED_NAMESPACE,
        NOINLINE,
        FILEOVERVIEW,
        IMPLICITCAST,
        NOSIDEEFFECTS,
        EXTERNS,
        NOCOMPILE,
        NODTS,
        UNRESTRICTED,
        STRUCT,
        DICT,
        NOCOLLAPSE,
        RECORD,
        ABSTRACT,
        PURE_OR_BREAK_MY_CODE,
        COLLAPSIBLE_OR_BREAK_MY_CODE,
        NOCOVERAGE,
        NG_INJECT,
        WIZ_ACTION,
        POLYMER_BEHAVIOR,
        POLYMER,
        CUSTOM_ELEMENT,
        MIXIN_CLASS,
        MIXIN_FUNCTION,
        SASS_GENERATED_CSS_TS,
        PROVIDE_GOOG,
        PROVIDE_ALREADY_PROVIDED,
        WIZ_CALLBACK,
        LOG_TYPE_IN_COMPILER;

        final String name;
        final long mask;

        private Bit() {
            if (this.ordinal() > 63) {
                throw new AssertionError((Object)"Too many Bits");
            }
            this.name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
            this.mask = 1L << this.ordinal();
        }
    }

    public static class Builder {
        TreeMap<Property<?>, Object> props = new TreeMap();
        long bits = 0L;
        boolean populated;
        Marker currentMarker;
        Set<String> licenseTexts;

        public static Builder copyFrom(JSDocInfo info) {
            return info.toBuilder();
        }

        public static Builder maybeCopyFrom(@Nullable JSDocInfo info) {
            return info != null ? info.toBuilder() : JSDocInfo.builder().parseDocumentation();
        }

        public static Builder maybeCopyFromWithNewType(JSDocInfo info, JSTypeExpression typeExpression) {
            if (info == null) {
                return JSDocInfo.builder().parseDocumentation().setType(typeExpression);
            }
            return info.toBuilder().setType(typeExpression);
        }

        public static Builder copyFromWithNewType(JSDocInfo info, JSTypeExpression typeExpression) {
            return info.toBuilder().setType(typeExpression);
        }

        public static Builder maybeCopyFromAndReplaceNames(JSDocInfo info, Set<String> moduleLocalNamesToReplace) {
            return info != null ? Builder.copyFromAndReplaceNames(info, moduleLocalNamesToReplace) : JSDocInfo.builder().parseDocumentation();
        }

        private static Builder copyFromAndReplaceNames(JSDocInfo info, Set<String> oldNames) {
            return info.cloneAndReplaceTypeNames(oldNames).toBuilder();
        }

        public Builder parseDocumentation() {
            this.setBit(Bit.INCLUDE_DOCUMENTATION, true);
            return this;
        }

        public boolean shouldParseDocumentation() {
            return this.checkBit(Bit.INCLUDE_DOCUMENTATION);
        }

        public void recordOriginalCommentString(String sourceComment) {
            if (this.shouldParseDocumentation()) {
                this.populated = true;
                this.setProp(SOURCE_COMMENT, sourceComment);
            }
        }

        public void recordOriginalCommentPosition(int position) {
            if (this.shouldParseDocumentation()) {
                this.populated = true;
                this.setProp(ORIGINAL_COMMENT_POSITION, position);
            }
        }

        public boolean isPopulatedWithFileOverview() {
            return this.populated && ((this.bits & (Bit.FILEOVERVIEW.mask | Bit.EXTERNS.mask | Bit.NOCOMPILE.mask | Bit.NOCOVERAGE.mask | Bit.TYPE_SUMMARY.mask | Bit.ENHANCED_NAMESPACE.mask)) != 0L || this.isModsRecorded());
        }

        public boolean isDescriptionRecorded() {
            return this.props.get(DESCRIPTION) != null;
        }

        public JSDocInfo build() {
            return this.build(false);
        }

        public @Nullable JSDocInfo build(boolean always) {
            if (this.populated || always) {
                JSDocInfo info = new JSDocInfo(this.bits, this.props);
                this.populated = false;
                return info;
            }
            return null;
        }

        public JSDocInfo buildAndReset() {
            JSDocInfo info = this.build();
            this.bits &= Bit.INCLUDE_DOCUMENTATION.mask;
            this.props.clear();
            this.populated = false;
            return info;
        }

        public void markAnnotation(String annotation, int lineno, int charno) {
            Marker marker = this.addMarker();
            if (marker != null) {
                TrimmedStringPosition position = new TrimmedStringPosition();
                position.setItem(annotation);
                position.setPositionInformation(lineno, charno, lineno, charno + annotation.length());
                marker.setAnnotation(position);
                this.populated = true;
            }
            this.currentMarker = marker;
        }

        private @Nullable Marker addMarker() {
            if (this.shouldParseDocumentation()) {
                ArrayList<Marker> markers = this.getProp(MARKERS);
                if (markers == null) {
                    markers = new ArrayList();
                    this.setProp(MARKERS, markers);
                }
                Marker marker = new Marker();
                markers.add(marker);
                return marker;
            }
            return null;
        }

        public void markText(String text, int startLineno, int startCharno, int endLineno, int endCharno) {
            if (this.currentMarker != null) {
                StringPosition position = new StringPosition();
                position.setItem(text);
                position.setPositionInformation(startLineno, startCharno, endLineno, endCharno);
                this.currentMarker.setDescription(position);
            }
        }

        public void markTypeNode(Node typeNode, int lineno, int startCharno, int endLineno, int endCharno, boolean hasLC) {
            if (this.currentMarker != null) {
                TypePosition position = new TypePosition();
                position.setItem(typeNode);
                position.setHasBrackets(hasLC);
                position.setPositionInformation(lineno, startCharno, endLineno, endCharno);
                this.currentMarker.setType(position);
            }
        }

        public void markName(String name, Node templateNode, int lineno, int charno) {
            if (this.currentMarker != null) {
                TrimmedStringPosition position = new TrimmedStringPosition();
                position.setItem(name);
                position.setPositionInformation(lineno, charno, lineno, charno + name.length());
                NamePosition nodePos = new NamePosition();
                Node node = Node.newString(Token.NAME, name).setLinenoCharno(lineno, charno);
                node.setLength(name.length());
                if (templateNode != null) {
                    node.setStaticSourceFileFrom(templateNode);
                }
                nodePos.setItem(node);
                nodePos.setPositionInformation(lineno, charno, lineno, charno + name.length());
                this.currentMarker.setNameNode(nodePos);
            }
        }

        public boolean recordBlockDescription(String description) {
            this.populated = true;
            if (!this.shouldParseDocumentation()) {
                return true;
            }
            return this.populateProp(BLOCK_DESCRIPTION, description);
        }

        public boolean recordVisibility(Visibility visibility) {
            if (this.getProp(VISIBILITY) == null) {
                this.populated = true;
                this.setProp(VISIBILITY, visibility);
                return true;
            }
            return false;
        }

        public void overwriteVisibility(Visibility visibility) {
            this.populated = true;
            this.setProp(VISIBILITY, visibility);
        }

        public boolean recordParameter(String parameterName, JSTypeExpression type) {
            return !this.hasAnySingletonTypeTags() && this.populatePropEntry(PARAMETERS, RhinoStringPool.addOrGet(parameterName), type);
        }

        public boolean recordParameterDescription(String parameterName, String description) {
            if (!this.shouldParseDocumentation()) {
                return true;
            }
            return this.populatePropEntry(PARAMETER_DESCRIPTIONS, RhinoStringPool.addOrGet(parameterName), description);
        }

        public boolean recordTemplateTypeName(String name) {
            return this.recordTemplateTypeName(name, null);
        }

        public boolean recordTemplateTypeName(String name, @Nullable JSTypeExpression bound) {
            Map transformations;
            if (bound == null) {
                bound = JSTypeExpression.IMPLICIT_TEMPLATE_BOUND;
            }
            if ((transformations = (Map)this.getProp(TYPE_TRANSFORMATIONS)) != null && transformations.containsKey(name) || this.props.containsKey(TYPEDEF_TYPE)) {
                return false;
            }
            return this.populatePropEntry(TEMPLATE_TYPE_NAMES, RhinoStringPool.addOrGet(name), bound);
        }

        public boolean recordTypeTransformation(String name, Node expr) {
            Map names = this.getProp(TEMPLATE_TYPE_NAMES);
            if (names != null && names.containsKey(name)) {
                return false;
            }
            return this.populatePropEntry(TYPE_TRANSFORMATIONS, RhinoStringPool.addOrGet(name), expr);
        }

        public boolean recordThrowsAnnotation(String annotation) {
            this.populated = true;
            if (!this.hasAnySingletonTypeTags()) {
                List throwsAnnotations = this.getPropWithDefault(THROWS_ANNOTATIONS, ArrayList::new);
                if (this.shouldParseDocumentation()) {
                    throwsAnnotations.add(annotation);
                } else if (throwsAnnotations.isEmpty()) {
                    throwsAnnotations.add("");
                }
                return true;
            }
            return false;
        }

        public boolean recordAuthor(String author) {
            this.populated = true;
            if (this.shouldParseDocumentation()) {
                this.getPropWithDefault(AUTHORS, ArrayList::new).add(author);
            }
            return true;
        }

        public boolean recordReference(String reference) {
            this.populated = true;
            if (this.shouldParseDocumentation()) {
                this.getPropWithDefault(SEES, ArrayList::new).add(reference);
            }
            return true;
        }

        public boolean recordConsistentIdGenerator() {
            return this.populateProp(ID_GENERATOR, IdGenerator.CONSISTENT);
        }

        public boolean recordStableIdGenerator() {
            return this.populateProp(ID_GENERATOR, IdGenerator.STABLE);
        }

        public boolean recordXidGenerator() {
            return this.populateProp(ID_GENERATOR, IdGenerator.XID);
        }

        public boolean recordMappedIdGenerator() {
            return this.populateProp(ID_GENERATOR, IdGenerator.MAPPED);
        }

        public boolean recordIdGenerator() {
            return this.populateProp(ID_GENERATOR, IdGenerator.UNIQUE);
        }

        public boolean recordDeprecationReason(String reason) {
            return this.populateProp(DEPRECATION_REASON, reason);
        }

        public boolean isDeprecationReasonRecorded() {
            return this.getProp(DEPRECATION_REASON) != null;
        }

        public void recordSuppressions(ImmutableSet<String> suppressions, String description) {
            this.populated = true;
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            ImmutableMap<ImmutableSet<String>, String> current = this.getProp(SUPPRESSIONS);
            if (current != null) {
                if (current.containsKey(suppressions)) {
                    return;
                }
                mapBuilder.putAll(current);
            }
            mapBuilder.put(JSDocInfo.internSet(suppressions), (Object)description);
            ImmutableMap suppressionsMap = mapBuilder.buildOrThrow();
            this.setProp(SUPPRESSIONS, suppressionsMap);
        }

        public void recordSuppressions(Set<String> suppressions) {
            this.recordSuppressions((ImmutableSet<String>)ImmutableSet.copyOf(suppressions), "");
        }

        public void recordSuppression(String suppression) {
            this.recordSuppressions((ImmutableSet<String>)ImmutableSet.of((Object)suppression), "");
        }

        public boolean recordModifies(Set<String> modifies) {
            return !this.hasAnySingletonSideEffectTags() && this.populateProp(MODIFIES, JSDocInfo.internSet(modifies));
        }

        public boolean recordType(JSTypeExpression type) {
            return type != null && !this.hasAnyTypeRelatedTags() && this.populateProp(TYPE, type);
        }

        public void recordInlineType() {
            this.populateBit(Bit.INLINE_TYPE, true);
        }

        public boolean recordTypedef(JSTypeExpression type) {
            return type != null && !this.hasAnyTypeRelatedTags() && this.getProp(TEMPLATE_TYPE_NAMES) == null && this.populateProp(TYPEDEF_TYPE, type);
        }

        public boolean recordReturnType(JSTypeExpression type) {
            return type != null && !this.hasAnySingletonTypeTags() && this.populateProp(RETURN_TYPE, type);
        }

        public boolean recordReturnDescription(String description) {
            if (!this.shouldParseDocumentation()) {
                return true;
            }
            return this.populateProp(RETURN_DESCRIPTION, description);
        }

        public boolean recordDefineType(JSTypeExpression type) {
            if (type != null && !this.checkBit(Bit.CONST) && !this.checkBit(Bit.DEFINE) && this.recordType(type)) {
                return this.populateBit(Bit.DEFINE, true);
            }
            return false;
        }

        public boolean recordEnumParameterType(JSTypeExpression type) {
            if (type != null && !this.hasAnyTypeRelatedTags()) {
                this.setProp(ENUM_PARAMETER_TYPE, type);
                this.populated = true;
                return true;
            }
            return false;
        }

        public boolean recordThisType(JSTypeExpression type) {
            return type != null && !this.hasAnySingletonTypeTags() && this.populateProp(THIS_TYPE, type);
        }

        public boolean recordBaseType(JSTypeExpression type) {
            return type != null && !this.hasAnySingletonTypeTags() && this.populateProp(BASE_TYPE, type);
        }

        public boolean changeBaseType(JSTypeExpression type) {
            if (type != null && !this.hasAnySingletonTypeTags()) {
                this.setProp(BASE_TYPE, type);
                this.populated = true;
                return true;
            }
            return false;
        }

        public boolean recordConstancy() {
            return this.populateBit(Bit.CONST, true);
        }

        public boolean recordMutable() {
            return this.populateBit(Bit.CONST, false);
        }

        public boolean recordFinality() {
            return this.populateBit(Bit.FINAL, true);
        }

        public boolean recordDescription(String description) {
            return this.populateProp(DESCRIPTION, description);
        }

        public void recordTsType(String tsType) {
            this.populated = true;
            this.getPropWithDefault(TS_TYPES, ArrayList::new).add(tsType);
        }

        public boolean recordMeaning(String meaning) {
            return this.populateProp(MEANING, meaning);
        }

        public boolean recordAlternateMessageId(String alternateMessageId) {
            return this.populateProp(ALTERNATE_MESSAGE_ID, alternateMessageId);
        }

        public boolean recordClosurePrimitiveId(String closurePrimitiveId) {
            return this.populateProp(CLOSURE_PRIMITIVE_ID, RhinoStringPool.addOrGet(closurePrimitiveId));
        }

        public boolean recordFileOverview(String description) {
            this.setBit(Bit.FILEOVERVIEW, true);
            this.populated = true;
            if (!this.shouldParseDocumentation()) {
                return true;
            }
            return this.populateProp(FILEOVERVIEW_DESCRIPTION, description);
        }

        public boolean recordEnhance(String namespace) {
            this.setBit(Bit.ENHANCED_NAMESPACE, true);
            this.populated = true;
            return this.populateProp(ENHANCED_NAMESPACE, namespace);
        }

        public boolean isModsRecorded() {
            return this.props.get(MODS) != null;
        }

        @CanIgnoreReturnValue
        public boolean recordMods(String namespace) {
            return this.populateProp(MODS, RhinoStringPool.addOrGet(namespace));
        }

        public boolean recordLicense(String license) {
            this.setProp(LICENSE, RhinoStringPool.addOrGet(license));
            this.populated = true;
            return true;
        }

        public boolean addLicense(String license) {
            if (this.licenseTexts == null) {
                this.licenseTexts = new LinkedHashSet<String>();
            }
            if (!this.licenseTexts.add(license)) {
                return false;
            }
            String txt = this.getProp(LICENSE);
            return this.recordLicense(RhinoStringPool.addOrGet(Strings.nullToEmpty((String)txt) + license));
        }

        public boolean recordHiddenness() {
            return this.populateBit(Bit.HIDDEN, true);
        }

        public boolean recordNoCompile() {
            return this.populateBit(Bit.NOCOMPILE, true);
        }

        public boolean recordNoDts() {
            return this.populateBit(Bit.NODTS, true);
        }

        public boolean recordNoCollapse() {
            return this.populateBit(Bit.NOCOLLAPSE, true);
        }

        public boolean recordNoInline() {
            return this.populateBit(Bit.NOINLINE, true);
        }

        public boolean recordPureOrBreakMyCode() {
            return this.populateBit(Bit.PURE_OR_BREAK_MY_CODE, true);
        }

        public boolean recordCollapsibleOrBreakMyCode() {
            return this.populateBit(Bit.COLLAPSIBLE_OR_BREAK_MY_CODE, true);
        }

        public boolean recordConstructor() {
            return !this.hasAnySingletonTypeTags() && !this.isConstructorOrInterface() && this.populateBit(Bit.CONSTRUCTOR, true);
        }

        public boolean recordImplicitMatch() {
            return !this.hasAnySingletonTypeTags() && !this.isConstructorOrInterface() && this.populateBit(Bit.RECORD, true) && this.populateBit(Bit.INTERFACE, true);
        }

        public boolean recordProvideGoog() {
            return this.populateBit(Bit.PROVIDE_GOOG, true);
        }

        public boolean recordProvideAlreadyProvided() {
            return this.populateBit(Bit.PROVIDE_ALREADY_PROVIDED, true);
        }

        public boolean isConstructorRecorded() {
            return this.checkBit(Bit.CONSTRUCTOR);
        }

        public boolean recordUnrestricted() {
            return !this.hasAnySingletonTypeTags() && (this.bits & (Bit.INTERFACE.mask | Bit.DICT.mask | Bit.STRUCT.mask)) == 0L && this.populateBit(Bit.UNRESTRICTED, true);
        }

        public boolean isUnrestrictedRecorded() {
            return this.checkBit(Bit.UNRESTRICTED);
        }

        public boolean recordAbstract() {
            return !this.hasAnySingletonTypeTags() && (this.bits & (Bit.INTERFACE.mask | Bit.FINAL.mask)) == 0L && this.getProp(VISIBILITY) != Visibility.PRIVATE && this.populateBit(Bit.ABSTRACT, true);
        }

        public boolean recordStruct() {
            return !this.hasAnySingletonTypeTags() && (this.bits & (Bit.DICT.mask | Bit.UNRESTRICTED.mask)) == 0L && this.populateBit(Bit.STRUCT, true);
        }

        public boolean isStructRecorded() {
            return this.checkBit(Bit.STRUCT);
        }

        public boolean recordDict() {
            return !this.hasAnySingletonTypeTags() && (this.bits & (Bit.STRUCT.mask | Bit.UNRESTRICTED.mask)) == 0L && this.populateBit(Bit.DICT, true);
        }

        public boolean isDictRecorded() {
            return this.checkBit(Bit.DICT);
        }

        public boolean recordOverride() {
            return this.populateBit(Bit.OVERRIDE, true);
        }

        public boolean recordDeprecated() {
            return this.populateBit(Bit.DEPRECATED, true);
        }

        public boolean recordInterface() {
            return !this.hasAnySingletonTypeTags() && (this.bits & (Bit.CONSTRUCTOR.mask | Bit.ABSTRACT.mask)) == 0L && this.populateBit(Bit.INTERFACE, true);
        }

        public boolean recordExport() {
            return this.populateBit(Bit.EXPORT, true);
        }

        public boolean removeExport() {
            return this.populateBit(Bit.EXPORT, false);
        }

        public boolean recordImplicitCast() {
            return this.populateBit(Bit.IMPLICITCAST, true);
        }

        public boolean recordNoSideEffects() {
            return !this.hasAnySingletonSideEffectTags() && this.populateBit(Bit.NOSIDEEFFECTS, true);
        }

        public boolean recordExterns() {
            return this.populateBit(Bit.EXTERNS, true);
        }

        @CanIgnoreReturnValue
        public boolean recordNoCoverage() {
            return this.populateBit(Bit.NOCOVERAGE, true);
        }

        public boolean recordTypeSummary() {
            return this.populateBit(Bit.TYPE_SUMMARY, true);
        }

        public boolean isInterfaceRecorded() {
            return this.checkBit(Bit.INTERFACE);
        }

        public boolean hasParameter(String name) {
            Map params = this.getProp(PARAMETERS);
            return params != null && params.containsKey(name);
        }

        public boolean recordImplementedInterface(JSTypeExpression interfaceType) {
            return interfaceType != null && this.addUnique(IMPLEMENTED_INTERFACES, interfaceType);
        }

        public boolean recordExtendedInterface(JSTypeExpression interfaceType) {
            return interfaceType != null && this.addUnique(EXTENDED_INTERFACES, interfaceType);
        }

        private boolean addUnique(Property<ArrayList<JSTypeExpression>> prop, JSTypeExpression elem) {
            ArrayList list = this.getPropWithDefault(prop, ArrayList::new);
            if (list.stream().anyMatch(elem::isEquivalentTo)) {
                return false;
            }
            list.add(elem);
            this.populated = true;
            return true;
        }

        public boolean recordLends(JSTypeExpression name) {
            return !this.hasAnyTypeRelatedTags() && this.populateProp(LENDS_NAME, name);
        }

        public boolean isNgInjectRecorded() {
            return this.checkBit(Bit.NG_INJECT);
        }

        public boolean recordNgInject(boolean ngInject) {
            return this.populateBit(Bit.NG_INJECT, true);
        }

        public boolean isWizactionRecorded() {
            return this.checkBit(Bit.WIZ_ACTION);
        }

        public boolean recordWizaction() {
            return this.populateBit(Bit.WIZ_ACTION, true);
        }

        public boolean isWizcallbackRecorded() {
            return this.checkBit(Bit.WIZ_CALLBACK);
        }

        public boolean recordWizcallback() {
            return this.populateBit(Bit.WIZ_CALLBACK, true);
        }

        public boolean isPolymerBehaviorRecorded() {
            return this.checkBit(Bit.POLYMER_BEHAVIOR);
        }

        public boolean recordPolymerBehavior() {
            return this.populateBit(Bit.POLYMER_BEHAVIOR, true);
        }

        public boolean isPolymerRecorded() {
            return this.checkBit(Bit.POLYMER);
        }

        public boolean recordPolymer() {
            return this.populateBit(Bit.POLYMER, true);
        }

        public boolean isCustomElementRecorded() {
            return this.checkBit(Bit.CUSTOM_ELEMENT);
        }

        public boolean recordCustomElement() {
            return this.populateBit(Bit.CUSTOM_ELEMENT, true);
        }

        public boolean isMixinClassRecorded() {
            return this.checkBit(Bit.MIXIN_CLASS);
        }

        public boolean recordMixinClass() {
            return this.populateBit(Bit.MIXIN_CLASS, true);
        }

        public boolean isMixinFunctionRecorded() {
            return this.checkBit(Bit.MIXIN_FUNCTION);
        }

        public boolean recordMixinFunction() {
            return this.populateBit(Bit.MIXIN_FUNCTION, true);
        }

        public boolean isSassGeneratedCssTsRecorded() {
            return this.checkBit(Bit.SASS_GENERATED_CSS_TS);
        }

        public void recordSassGeneratedCssTs() {
            this.populateBit(Bit.SASS_GENERATED_CSS_TS, true);
        }

        public boolean logTypeInCompiler() {
            return this.checkBit(Bit.LOG_TYPE_IN_COMPILER);
        }

        public boolean recordLogTypeInCompiler() {
            return this.populateBit(Bit.LOG_TYPE_IN_COMPILER, true);
        }

        Builder setType(JSTypeExpression type) {
            this.props.remove(RETURN_TYPE);
            this.props.remove(ENUM_PARAMETER_TYPE);
            this.props.remove(TYPEDEF_TYPE);
            this.setProp(TYPE, type);
            return this;
        }

        private boolean hasAnyTypeRelatedTags() {
            return (this.bits & (Bit.CONSTRUCTOR.mask | Bit.INTERFACE.mask | Bit.ABSTRACT.mask)) != 0L || this.hasAnyParameters() || this.getProp(RETURN_TYPE) != null || this.getProp(BASE_TYPE) != null || !this.isPropEmpty(EXTENDED_INTERFACES) || this.getProp(LENDS_NAME) != null || this.getProp(THIS_TYPE) != null || this.hasAnySingletonTypeTags();
        }

        private boolean hasAnyParameters() {
            Map params = this.getProp(PARAMETERS);
            return params != null && !params.isEmpty();
        }

        private boolean isPropEmpty(Property<? extends Collection<?>> prop) {
            Collection<?> c = this.getProp(prop);
            return c == null || c.isEmpty();
        }

        private boolean hasAnySingletonTypeTags() {
            return this.getProp(TYPE) != null || this.getProp(TYPEDEF_TYPE) != null || this.getProp(ENUM_PARAMETER_TYPE) != null;
        }

        private boolean hasAnySingletonSideEffectTags() {
            return this.checkBit(Bit.NOSIDEEFFECTS) || !this.isPropEmpty(MODIFIES);
        }

        private boolean isConstructorOrInterface() {
            return (this.bits & (Bit.CONSTRUCTOR.mask | Bit.INTERFACE.mask)) != 0L;
        }

        private <T> void setProp(Property<T> prop, T value) {
            this.props.put(prop, value);
        }

        private <T> @Nullable T getProp(Property<T> prop) {
            return (T)this.props.get(prop);
        }

        private <T> T getPropWithDefault(Property<T> prop, Supplier<T> supplier) {
            T value = this.getProp(prop);
            if (value == null) {
                value = supplier.get();
                this.setProp(prop, value);
            }
            return value;
        }

        private <K, V> boolean putPropEntry(Property<LinkedHashMap<K, V>> prop, K key, V value) {
            return this.getPropWithDefault(prop, LinkedHashMap::new).putIfAbsent(key, value) == null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private <K, V> boolean populatePropEntry(Property<LinkedHashMap<K, V>> prop, K key, V value) {
            if (!this.putPropEntry(prop, key, value)) return false;
            this.populated = true;
            if (!true) return false;
            return true;
        }

        private <T> boolean populateProp(Property<T> prop, T value) {
            this.populated = true;
            return this.props.putIfAbsent(prop, value) == null;
        }

        private boolean checkBit(Bit bit) {
            return (this.bits & bit.mask) != 0L;
        }

        private void setBit(Bit bit, boolean value) {
            this.bits = value ? (this.bits |= bit.mask) : (this.bits &= bit.mask ^ 0xFFFFFFFFFFFFFFFFL);
        }

        private boolean populateBit(Bit bit, boolean value) {
            if (this.checkBit(bit) != value) {
                this.setBit(bit, value);
                this.populated = true;
                return true;
            }
            return false;
        }
    }

    @FunctionalInterface
    private static interface TypeTransform {
        public JSTypeExpression apply(JSTypeExpression var1);
    }

    private static enum IdGenerator {
        XID,
        CONSISTENT,
        UNIQUE,
        STABLE,
        MAPPED;

    }

    private static final class TypeProperty
    extends Property<JSTypeExpression> {
        TypeProperty(String name) {
            super(name);
        }

        @Override
        JSTypeExpression clone(JSTypeExpression arg, TypeTransform transform) {
            return arg != null && transform != null ? transform.apply(arg) : arg;
        }

        @Override
        boolean equalValues(JSTypeExpression left, JSTypeExpression right) {
            return left.isEquivalentTo(right);
        }

        ImmutableList<JSTypeExpression> getTypeExpressions(JSTypeExpression type) {
            return ImmutableList.of((Object)type);
        }
    }

    private static final class TypeMapProperty
    extends Property<LinkedHashMap<String, JSTypeExpression>> {
        TypeMapProperty(String name) {
            super(name);
        }

        @Override
        LinkedHashMap<String, JSTypeExpression> clone(LinkedHashMap<String, JSTypeExpression> arg, TypeTransform transform) {
            LinkedHashMap<String, JSTypeExpression> out = new LinkedHashMap<String, JSTypeExpression>(arg);
            if (transform != null) {
                for (Map.Entry<String, JSTypeExpression> entry : out.entrySet()) {
                    JSTypeExpression elem = entry.getValue();
                    if (elem == null) continue;
                    entry.setValue(transform.apply(elem));
                }
            }
            return out;
        }

        @Override
        boolean equalValues(LinkedHashMap<String, JSTypeExpression> left, LinkedHashMap<String, JSTypeExpression> right) {
            Set<String> rightKeys;
            Set<String> leftKeys = left.keySet();
            if (!leftKeys.equals(rightKeys = right.keySet())) {
                return false;
            }
            for (String key : leftKeys) {
                JSTypeExpression rightExpr;
                JSTypeExpression leftExpr = left.get(key);
                if (this.areEquivalent(leftExpr, rightExpr = right.get(key))) continue;
                return false;
            }
            return true;
        }

        private boolean areEquivalent(JSTypeExpression expr1, JSTypeExpression expr2) {
            return Objects.equals(expr1, expr2) || expr1 != null && expr1.isEquivalentTo(expr2);
        }

        @Override
        Iterable<JSTypeExpression> getTypeExpressions(LinkedHashMap<String, JSTypeExpression> map) {
            return map.values();
        }
    }

    private static final class TypeListProperty
    extends Property<ArrayList<JSTypeExpression>> {
        TypeListProperty(String name) {
            super(name);
        }

        List<JSTypeExpression> getUnmodifiable(JSDocInfo info) {
            ArrayList value = (ArrayList)this.get(info);
            return value != null ? Collections.unmodifiableList(value) : ImmutableList.of();
        }

        @Override
        ArrayList<JSTypeExpression> clone(ArrayList<JSTypeExpression> arg, TypeTransform transform) {
            ArrayList<JSTypeExpression> out = new ArrayList<JSTypeExpression>(arg);
            if (transform != null) {
                for (int i = 0; i < out.size(); ++i) {
                    JSTypeExpression elem = out.get(i);
                    if (elem == null) continue;
                    out.set(i, transform.apply(elem));
                }
            }
            return out;
        }

        @Override
        boolean equalValues(ArrayList<JSTypeExpression> left, ArrayList<JSTypeExpression> right) {
            if (left.size() != right.size()) {
                return false;
            }
            Iterator<JSTypeExpression> leftIterator = left.iterator();
            Iterator<JSTypeExpression> rightIterator = right.iterator();
            while (leftIterator.hasNext()) {
                JSTypeExpression rightExpr;
                JSTypeExpression leftExpr = leftIterator.next();
                if (leftExpr.isEquivalentTo(rightExpr = rightIterator.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        Iterable<JSTypeExpression> getTypeExpressions(ArrayList<JSTypeExpression> types) {
            return types;
        }
    }

    public static enum Visibility {
        PRIVATE,
        PACKAGE,
        PROTECTED,
        PUBLIC,
        INHERITED;

    }

    private static final class NodeMapProperty
    extends Property<LinkedHashMap<String, Node>> {
        NodeMapProperty(String name) {
            super(name);
        }

        @Override
        LinkedHashMap<String, Node> clone(LinkedHashMap<String, Node> arg, TypeTransform transform) {
            return new LinkedHashMap<String, Node>(arg);
        }

        @Override
        boolean equalValues(LinkedHashMap<String, Node> left, LinkedHashMap<String, Node> right) {
            if (left.size() != right.size()) {
                return false;
            }
            for (Map.Entry<String, Node> entry : left.entrySet()) {
                Node rightValue = right.get(entry.getKey());
                if (rightValue != null && entry.getValue().isEquivalentTo(rightValue)) continue;
                return false;
            }
            return true;
        }
    }

    private static final class MarkerListProperty
    extends Property<ArrayList<Marker>> {
        MarkerListProperty(String name) {
            super(name);
        }

        @Override
        boolean equalValues(ArrayList<Marker> a, ArrayList<Marker> b) {
            if (a.size() != b.size()) {
                return false;
            }
            for (int i = 0; i < a.size(); ++i) {
                Marker m2;
                Marker m1 = a.get(i);
                if (m1 == null == ((m2 = b.get(i)) == null) && (m1 == null || m1.isEquivalentTo(m2))) continue;
                return false;
            }
            return true;
        }
    }

    public static final class Marker {
        private TrimmedStringPosition annotation;
        private NamePosition nameNode;
        private StringPosition description;
        private TypePosition type;

        public StringPosition getAnnotation() {
            return this.annotation;
        }

        void setAnnotation(TrimmedStringPosition p) {
            this.annotation = p;
        }

        public NamePosition getNameNode() {
            return this.nameNode;
        }

        void setNameNode(NamePosition p) {
            this.nameNode = p;
        }

        public StringPosition getDescription() {
            return this.description;
        }

        void setDescription(StringPosition p) {
            this.description = p;
        }

        public TypePosition getType() {
            return this.type;
        }

        void setType(TypePosition p) {
            this.type = p;
        }

        private boolean isEquivalentTo(Marker that) {
            return Marker.areEquivalent(this.annotation, that.annotation) && Marker.areEquivalent(this.nameNode, that.nameNode) && Marker.areEquivalent(this.description, that.description) && Marker.areEquivalent(this.type, that.type);
        }

        private static <T> boolean areEquivalent(@Nullable ComparableSourcePosition<T> p1, @Nullable ComparableSourcePosition<T> p2) {
            return p1 == null == (p2 == null) && (p1 == null || p1.isEquivalentTo(p2));
        }
    }

    public static class TypePosition
    extends ComparableSourcePosition<Node> {
        private boolean brackets = false;

        public boolean hasBrackets() {
            return this.brackets;
        }

        void setHasBrackets(boolean newVal) {
            this.brackets = newVal;
        }

        @Override
        boolean isEquivalentTo(SourcePosition<Node> that) {
            if (!(that instanceof TypePosition) || !this.isSamePositionAs(that) || this.brackets != ((TypePosition)that).brackets || this.getItem() == null != (that.getItem() == null)) {
                return false;
            }
            return this.getItem() == null || ((Node)this.getItem()).isEquivalentTo(that.getItem());
        }
    }

    public static class NamePosition
    extends ComparableSourcePosition<Node> {
        @Override
        boolean isEquivalentTo(SourcePosition<Node> that) {
            if (that == null || !this.isSamePositionAs(that) || this.getItem() == null != (that.getItem() == null)) {
                return false;
            }
            return this.getItem() == null || ((Node)this.getItem()).isEquivalentTo(that.getItem());
        }
    }

    static class TrimmedStringPosition
    extends StringPosition {
        TrimmedStringPosition() {
        }

        @Override
        public void setItem(String item) {
            Preconditions.checkArgument((item.charAt(0) != ' ' && item.charAt(item.length() - 1) != ' ' ? 1 : 0) != 0, (Object)"String has leading or trailing whitespace");
            super.setItem(item);
        }
    }

    public static class StringPosition
    extends ComparableSourcePosition<String> {
        @Override
        boolean isEquivalentTo(SourcePosition<String> that) {
            return that != null && this.isSamePositionAs(that) && Objects.equals(this.getItem(), that.getItem());
        }
    }

    private static abstract class ComparableSourcePosition<T>
    extends SourcePosition<T> {
        private ComparableSourcePosition() {
        }

        abstract boolean isEquivalentTo(SourcePosition<T> var1);
    }
}

