/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.serialization;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.javascript.jscomp.InvalidatingTypes;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.ColorId;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.serialization.JSTypeColorIdHasher;
import com.google.javascript.jscomp.serialization.ObjectTypeProto;
import com.google.javascript.jscomp.serialization.SerializationOptions;
import com.google.javascript.jscomp.serialization.StringPool;
import com.google.javascript.jscomp.serialization.SubtypingEdge;
import com.google.javascript.jscomp.serialization.TypePointers;
import com.google.javascript.jscomp.serialization.TypePool;
import com.google.javascript.jscomp.serialization.TypeProto;
import com.google.javascript.jscomp.serialization.UnionTypeProto;
import com.google.javascript.rhino.ClosurePrimitive;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jspecify.nullness.Nullable;

final class JSTypeReconserializer {
    private final JSTypeRegistry registry;
    private final SerializationOptions serializationMode;
    private final InvalidatingTypes invalidatingTypes;
    private final StringPool.Builder stringPoolBuilder;
    private final JSTypeColorIdHasher hasher;
    private final Predicate<String> shouldPropagatePropertyName;
    private final SeenTypeRecord unknownRecord;
    private final SeenTypeRecord topObjectRecord;
    private final IdentityHashMap<JSType, SeenTypeRecord> typeToRecordCache = new IdentityHashMap();
    private final LinkedHashMap<ColorId, SeenTypeRecord> seenTypeRecords = new LinkedHashMap();
    private final SetMultimap<Integer, Integer> disambiguateEdges = LinkedHashMultimap.create();
    private State state = State.COLLECTING_TYPES;
    private static final ImmutableMap<JSTypeNative, Color> JSTYPE_NATIVE_TO_AXIOMATIC_COLOR_MAP = ImmutableMap.builder().put((Object)JSTypeNative.ALL_TYPE, (Object)StandardColors.UNKNOWN).put((Object)JSTypeNative.CHECKED_UNKNOWN_TYPE, (Object)StandardColors.UNKNOWN).put((Object)JSTypeNative.NO_OBJECT_TYPE, (Object)StandardColors.UNKNOWN).put((Object)JSTypeNative.NO_TYPE, (Object)StandardColors.UNKNOWN).put((Object)JSTypeNative.UNKNOWN_TYPE, (Object)StandardColors.UNKNOWN).put((Object)JSTypeNative.BIGINT_TYPE, (Object)StandardColors.BIGINT).put((Object)JSTypeNative.BOOLEAN_TYPE, (Object)StandardColors.BOOLEAN).put((Object)JSTypeNative.NULL_TYPE, (Object)StandardColors.NULL_OR_VOID).put((Object)JSTypeNative.NUMBER_TYPE, (Object)StandardColors.NUMBER).put((Object)JSTypeNative.STRING_TYPE, (Object)StandardColors.STRING).put((Object)JSTypeNative.SYMBOL_TYPE, (Object)StandardColors.SYMBOL).put((Object)JSTypeNative.VOID_TYPE, (Object)StandardColors.NULL_OR_VOID).put((Object)JSTypeNative.FUNCTION_FUNCTION_TYPE, (Object)StandardColors.TOP_OBJECT).put((Object)JSTypeNative.FUNCTION_PROTOTYPE, (Object)StandardColors.TOP_OBJECT).put((Object)JSTypeNative.FUNCTION_INSTANCE_PROTOTYPE, (Object)StandardColors.TOP_OBJECT).put((Object)JSTypeNative.FUNCTION_TYPE, (Object)StandardColors.TOP_OBJECT).put((Object)JSTypeNative.OBJECT_FUNCTION_TYPE, (Object)StandardColors.TOP_OBJECT).put((Object)JSTypeNative.OBJECT_PROTOTYPE, (Object)StandardColors.TOP_OBJECT).put((Object)JSTypeNative.OBJECT_TYPE, (Object)StandardColors.TOP_OBJECT).buildOrThrow();

    private JSTypeReconserializer(JSTypeRegistry registry, InvalidatingTypes invalidatingTypes, StringPool.Builder stringPoolBuilder, Predicate<String> shouldPropagatePropertyName, SerializationOptions serializationMode) {
        this.registry = registry;
        this.hasher = new JSTypeColorIdHasher(registry);
        this.invalidatingTypes = invalidatingTypes;
        this.stringPoolBuilder = stringPoolBuilder;
        this.shouldPropagatePropertyName = shouldPropagatePropertyName;
        this.serializationMode = serializationMode;
        this.seedCachesWithAxiomaticTypes();
        this.unknownRecord = this.seenTypeRecords.get(StandardColors.UNKNOWN.getId());
        this.topObjectRecord = this.seenTypeRecords.get(StandardColors.TOP_OBJECT.getId());
    }

    public static JSTypeReconserializer create(JSTypeRegistry registry, InvalidatingTypes invalidatingTypes, StringPool.Builder stringPoolBuilder, Predicate<String> shouldPropagatePropertyName, SerializationOptions serializationMode) {
        JSTypeReconserializer serializer = new JSTypeReconserializer(registry, invalidatingTypes, stringPoolBuilder, shouldPropagatePropertyName, serializationMode);
        serializer.checkValidLinearTime();
        return serializer;
    }

    int serializeType(JSType type) {
        SeenTypeRecord record = this.recordType(type);
        return record.pointer;
    }

    private SeenTypeRecord recordType(JSType type) {
        JSType forwardedType = type.isNamedType() ? type.toMaybeNamedType().getReferencedType() : (type.isEnumElementType() ? type.toMaybeEnumElementType().getPrimitiveType() : (type.isTemplatizedType() ? type.toMaybeTemplatizedType().getReferencedType() : (type.isFunctionType() && type.toMaybeFunctionType().getCanonicalRepresentation() != null ? type.toMaybeFunctionType().getCanonicalRepresentation() : null)));
        if (forwardedType != null) {
            return this.recordType(forwardedType);
        }
        if (type.isUnknownType() || type.isNoResolvedType() || type.isTemplateType()) {
            return this.unknownRecord;
        }
        if (type.isFunctionType() && !type.toMaybeFunctionType().hasInstanceType() && type.toMaybeFunctionType().getClosurePrimitive() == null) {
            return this.topObjectRecord;
        }
        SeenTypeRecord jstypeRecord = this.typeToRecordCache.get(type);
        if (jstypeRecord != null) {
            return jstypeRecord;
        }
        if (type.isUnionType()) {
            return this.recordUnionType(type.toMaybeUnionType());
        }
        if (type.isObjectType()) {
            return this.recordObjectType(type.toMaybeObjectType());
        }
        throw new AssertionError(type);
    }

    private SeenTypeRecord recordUnionType(UnionType type) {
        Preconditions.checkNotNull((Object)type);
        LinkedHashSet<SeenTypeRecord> altRecords = new LinkedHashSet<SeenTypeRecord>();
        for (Object altType : type.getAlternates()) {
            SeenTypeRecord alt = this.recordType((JSType)altType);
            if (alt.unionMembers == null) {
                altRecords.add(alt);
                continue;
            }
            altRecords.addAll((Collection<SeenTypeRecord>)alt.unionMembers);
        }
        if (altRecords.size() == 1) {
            return (SeenTypeRecord)Iterables.getOnlyElement(altRecords);
        }
        ImmutableSet.Builder alternateIds = ImmutableSet.builder();
        for (SeenTypeRecord altRecord : altRecords) {
            alternateIds.add((Object)altRecord.colorId);
        }
        ColorId unionId = ColorId.union((Set<ColorId>)alternateIds.build());
        SeenTypeRecord record = this.getOrCreateRecord(unionId, type);
        if (record.unionMembers == null) {
            record.unionMembers = ImmutableSet.copyOf(altRecords);
        } else if (this.serializationMode.runValidation()) {
            Preconditions.checkState((boolean)altRecords.equals(record.unionMembers), (String)"Unions with same ID must have same members: %s => %s == %s", (Object)unionId, altRecords.stream().map(r -> r.colorId).collect(ImmutableSet.toImmutableSet()), record.unionMembers.stream().map(r -> r.colorId).collect(ImmutableSet.toImmutableSet()));
        }
        return record;
    }

    private SeenTypeRecord recordObjectType(ObjectType type) {
        FunctionType fnType;
        Preconditions.checkNotNull((Object)type);
        ColorId id = this.hasher.hashObjectType(type);
        SeenTypeRecord record = this.getOrCreateRecord(id, type);
        this.addSupertypeEdges(type, record.pointer);
        if (type.isFunctionType() && (fnType = type.toMaybeFunctionType()).hasInstanceType() && fnType.getInstanceType() != null) {
            this.serializeType(fnType.getInstanceType());
            this.serializeType(fnType.getPrototype());
        }
        return record;
    }

    private void addSupertypeEdges(ObjectType subtype, Integer serializedSubtype) {
        this.disambiguateEdges.putAll((Object)serializedSubtype, this.ownAncestorInterfacesOf(subtype));
        if (subtype.getImplicitPrototype() != null) {
            Integer supertype = this.serializeType(subtype.getImplicitPrototype());
            this.disambiguateEdges.put((Object)serializedSubtype, (Object)supertype);
        }
    }

    private SeenTypeRecord getOrCreateRecord(ColorId id, JSType jstype) {
        Preconditions.checkNotNull((Object)jstype);
        Preconditions.checkState((State.COLLECTING_TYPES == this.state || State.GENERATING_POOL == this.state ? 1 : 0) != 0);
        SeenTypeRecord record = this.seenTypeRecords.computeIfAbsent(id, unused -> {
            int pointer = this.seenTypeRecords.size();
            return new SeenTypeRecord(id, pointer);
        });
        this.typeToRecordCache.put(jstype, record);
        record.jstypes.add(jstype);
        return record;
    }

    private TypeProto reconcileUnionTypes(SeenTypeRecord seen) {
        return TypeProto.newBuilder().setUnion(UnionTypeProto.newBuilder().addAllUnionMember((Iterable)seen.unionMembers.stream().map(r -> r.pointer).sorted().collect(ImmutableList.toImmutableList())).build()).build();
    }

    private TypeProto reconcileObjectTypes(SeenTypeRecord seen) {
        LinkedHashSet<Integer> instancePointers = new LinkedHashSet<Integer>();
        LinkedHashSet<Integer> prototypePointers = new LinkedHashSet<Integer>();
        LinkedHashSet<Integer> ownProperties = new LinkedHashSet<Integer>();
        boolean isClosureAssert = false;
        boolean isConstructor = false;
        boolean isInvalidating = false;
        boolean propertiesKeepOriginalName = false;
        for (JSType type : seen.jstypes) {
            ObjectType objType = (ObjectType)Preconditions.checkNotNull((Object)type.toMaybeObjectType(), (Object)type);
            if (objType.isFunctionType()) {
                FunctionType fnType = objType.toMaybeFunctionType();
                if (fnType.hasInstanceType() && fnType.getInstanceType() != null) {
                    instancePointers.add(this.serializeType(fnType.getInstanceType()));
                    prototypePointers.add(this.serializeType(fnType.getPrototype()));
                    isConstructor |= fnType.isConstructor();
                }
                isClosureAssert |= JSTypeReconserializer.isClosureAssert(fnType.getClosurePrimitive());
            }
            for (String ownProperty : objType.getOwnPropertyNames()) {
                if (!this.shouldPropagatePropertyName.test(ownProperty)) continue;
                ownProperties.add(this.stringPoolBuilder.put(ownProperty));
            }
            isInvalidating |= this.invalidatingTypes.isInvalidating(objType);
            propertiesKeepOriginalName |= objType.isEnumType();
        }
        ObjectTypeProto objectProto = ObjectTypeProto.newBuilder().addAllInstanceType(instancePointers).addAllOwnProperty(ownProperties).addAllPrototype(prototypePointers).setClosureAssert(isClosureAssert).setIsInvalidating(isInvalidating).setMarkedConstructor(isConstructor).setPropertiesKeepOriginalName(propertiesKeepOriginalName).setUuid(seen.colorId.asByteString()).build();
        return TypeProto.newBuilder().setObject(objectProto).build();
    }

    private ImmutableList<Integer> ownAncestorInterfacesOf(ObjectType type) {
        FunctionType ctorType = type.getConstructor();
        if (ctorType == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder ancestors = ImmutableList.builder();
        for (JSType ancestor : Iterables.concat(ctorType.getExtendedInterfaces(), ctorType.getOwnImplementedInterfaces())) {
            ancestors.add((Object)this.serializeType(ancestor));
        }
        return ancestors.build();
    }

    private void seedCachesWithAxiomaticTypes() {
        Preconditions.checkState((boolean)this.seenTypeRecords.isEmpty());
        for (Color axiomatic2 : TypePointers.OFFSET_TO_AXIOMATIC_COLOR) {
            int index = this.seenTypeRecords.size();
            SeenTypeRecord record = new SeenTypeRecord(axiomatic2.getId(), index);
            this.seenTypeRecords.put(axiomatic2.getId(), record);
        }
        JSTYPE_NATIVE_TO_AXIOMATIC_COLOR_MAP.forEach((jstypeNative, axiomatic) -> this.getOrCreateRecord(axiomatic.getId(), this.registry.getNativeType((JSTypeNative)((Object)jstypeNative))));
        Preconditions.checkState((this.seenTypeRecords.size() == TypePointers.OFFSET_TO_AXIOMATIC_COLOR.size() ? 1 : 0) != 0);
    }

    private void checkValidLinearTime() {
        if (!this.serializationMode.runValidation()) {
            return;
        }
        int totalTypeCount = this.seenTypeRecords.size();
        for (SeenTypeRecord seen : this.seenTypeRecords.values()) {
            int offset = seen.pointer;
            Preconditions.checkState((offset >= 0 ? 1 : 0) != 0);
            Preconditions.checkState((offset <= totalTypeCount ? 1 : 0) != 0, (String)"Found invalid pointer %s, out of a total of %s user-defined types", (int)offset, (int)totalTypeCount);
        }
    }

    TypePool generateTypePool() {
        Preconditions.checkState((this.state == State.COLLECTING_TYPES ? 1 : 0) != 0);
        this.checkValidLinearTime();
        TypePool.Builder builder = TypePool.newBuilder();
        if (this.serializationMode.includeDebugInfo()) {
            TypePool.DebugInfo.Builder debugInfo = builder.getDebugInfoBuilder();
            this.invalidatingTypes.getMismatchLocations().inverse().asMap().forEach((location, types) -> debugInfo.addMismatchBuilder().setSourceRef(location.getLocation()).addAllInvolvedColor((Iterable)types.stream().peek(t -> Preconditions.checkState((!t.isUnionType() ? 1 : 0) != 0, (Object)t)).map(this::serializeType).distinct().sorted().collect(ImmutableList.toImmutableList())));
        }
        this.state = State.GENERATING_POOL;
        for (SeenTypeRecord seen : this.seenTypeRecords.values()) {
            if (StandardColors.AXIOMATIC_COLORS.containsKey((Object)seen.colorId)) {
                Preconditions.checkState((boolean)TypePointers.isAxiomatic(seen.pointer), (String)"Missing .type for SeenTypeRecord %s", (Object)seen);
                continue;
            }
            builder.addType(seen.unionMembers != null ? this.reconcileUnionTypes(seen) : this.reconcileObjectTypes(seen));
        }
        for (Integer subtype : this.disambiguateEdges.keySet()) {
            for (Integer supertype : this.disambiguateEdges.get((Object)subtype)) {
                builder.addDisambiguationEdges(SubtypingEdge.newBuilder().setSubtype(subtype).setSupertype(supertype));
            }
        }
        this.state = State.FINISHED;
        this.checkValidLinearTime();
        return builder.build();
    }

    ImmutableMultimap<String, JSType> getColorIdToJSTypeMapForDebugging() {
        ImmutableMultimap.Builder colorIdToTypes = ImmutableMultimap.builder().orderKeysBy(Comparator.naturalOrder());
        this.typeToRecordCache.forEach((jstype, record) -> colorIdToTypes.put((Object)record.colorId.toString(), jstype));
        return colorIdToTypes.build();
    }

    private static boolean isClosureAssert(@Nullable ClosurePrimitive primitive) {
        if (primitive == null) {
            return false;
        }
        switch (primitive) {
            case ASSERTS_TRUTHY: 
            case ASSERTS_MATCHES_RETURN: {
                return true;
            }
            case ASSERTS_FAIL: {
                return false;
            }
        }
        throw new AssertionError();
    }

    private static enum State {
        COLLECTING_TYPES,
        GENERATING_POOL,
        FINISHED;

    }

    private static final class SeenTypeRecord {
        final ColorId colorId;
        final int pointer;
        final ArrayList<JSType> jstypes = new ArrayList();
        @Nullable ImmutableSet<SeenTypeRecord> unionMembers = null;

        SeenTypeRecord(ColorId colorId, int pointer) {
            this.colorId = colorId;
            this.pointer = pointer;
        }
    }
}

