/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.serialization;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.serialization.ColorPool;
import com.google.javascript.jscomp.serialization.JSDocSerializer;
import com.google.javascript.jscomp.serialization.SerializationOptions;
import com.google.javascript.jscomp.serialization.SerializeTypesToPointers;
import com.google.javascript.jscomp.serialization.StringPool;
import com.google.javascript.jscomp.serialization.TypePool;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.util.IdentityHashMap;

public final class ConvertTypesToColors
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final SerializationOptions serializationOptions;

    public ConvertTypesToColors(AbstractCompiler compiler, SerializationOptions serializationOptions) {
        this.compiler = compiler;
        this.serializationOptions = serializationOptions;
    }

    @Override
    public void process(Node externs, Node root) {
        if (this.compiler.getLifeCycleStage().hasColorAndSimplifiedJSDoc()) {
            return;
        }
        Preconditions.checkState((!this.compiler.getLifeCycleStage().isNormalized() ? 1 : 0) != 0, (Object)"Not expected to run after normalization");
        Node externsAndJsRoot = root.getParent();
        if (!this.compiler.hasTypeCheckingRun()) {
            NodeTraversal.traverse(this.compiler, externsAndJsRoot, new RemoveTypes());
            this.compiler.clearJSTypeRegistry();
            this.compiler.initRuntimeLibraryTypedAsts((Optional<ColorPool.Builder>)Optional.absent());
            return;
        }
        StringPool.Builder stringPoolBuilder = StringPool.builder();
        SerializeTypesToPointers serializeJstypes = SerializeTypesToPointers.create(this.compiler, stringPoolBuilder, this.serializationOptions);
        serializeJstypes.gatherTypesOnAst(externsAndJsRoot);
        TypePool typePool = serializeJstypes.getTypePool();
        StringPool stringPool = stringPoolBuilder.build();
        ColorPool.Builder colorPoolBuilder = ColorPool.builder();
        this.compiler.initRuntimeLibraryTypedAsts((Optional<ColorPool.Builder>)Optional.of((Object)colorPoolBuilder));
        RemoveTypesAndApplyColors callback = new RemoveTypesAndApplyColors(colorPoolBuilder.addShard(typePool, stringPool), serializeJstypes.getTypePointersByJstype());
        ColorPool colorPool = colorPoolBuilder.build();
        NodeTraversal.traverse(this.compiler, externsAndJsRoot, callback);
        this.compiler.clearJSTypeRegistry();
        this.compiler.setColorRegistry(colorPool.getRegistry());
    }

    private static class RemoveTypes
    extends NodeTraversal.AbstractPostOrderCallback {
        RemoveTypes() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            n.setJSType(null);
            n.setJSTypeBeforeCast(null);
            n.setDeclaredTypeExpression(null);
            n.setTypedefTypeProp(null);
            JSDocInfo jsdoc = n.getJSDocInfo();
            if (jsdoc != null) {
                n.setJSDocInfo(JSDocSerializer.convertJSDocInfoForOptimizations(jsdoc));
            }
        }
    }

    private static class RemoveTypesAndApplyColors
    extends RemoveTypes {
        private final ColorPool.ShardView colorPoolShard;
        private final IdentityHashMap<JSType, Integer> typePointersByJstype;

        RemoveTypesAndApplyColors(ColorPool.ShardView colorPoolShard, IdentityHashMap<JSType, Integer> typePointersByJstype) {
            this.colorPoolShard = colorPoolShard;
            this.typePointersByJstype = typePointersByJstype;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Integer pointer;
            JSType oldType = n.getJSType();
            JSType oldTypeBeforeCast = n.getJSTypeBeforeCast();
            super.visit(t, n, parent);
            if (oldType != null && (pointer = this.typePointersByJstype.get(oldType)) != null) {
                n.setColor(this.colorPoolShard.getColor(pointer));
            }
            if (oldTypeBeforeCast != null) {
                n.setColorFromTypeCast();
            }
        }
    }
}

