/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.base.format.SimpleFormat;
import com.google.javascript.jscomp.parsing.parser.SourceFile;
import java.io.Serializable;

public class SourcePosition
implements Serializable {
    public final SourceFile source;
    public final int offset;
    public final int line;
    public final int column;

    public int getOffset() {
        return this.offset;
    }

    public SourcePosition(SourceFile source, int offset, int line, int column) {
        this.source = source;
        this.offset = offset;
        this.line = line;
        this.column = column;
    }

    public String toString() {
        return SimpleFormat.format("%s(%d, %d)", this.shortSourceName(), this.line + 1, this.column + 1);
    }

    private String shortSourceName() {
        if (this.source == null) {
            return "";
        }
        return (String)Iterables.getLast((Iterable)Splitter.on((char)'/').split((CharSequence)this.source.name));
    }
}

