/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser.trees;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.jscomp.parsing.parser.IdentifierToken;
import com.google.javascript.jscomp.parsing.parser.trees.FormalParameterListTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTreeType;
import com.google.javascript.jscomp.parsing.parser.util.SourceRange;
import org.jspecify.nullness.Nullable;

public class FunctionDeclarationTree
extends ParseTree {
    public final @Nullable IdentifierToken name;
    public final FormalParameterListTree formalParameterList;
    public final ParseTree functionBody;
    public final boolean isStatic;
    public final boolean isGenerator;
    public final boolean isOptional;
    public final boolean isAsync;
    public final Kind kind;

    public static Builder builder(Kind kind) {
        return new Builder(kind);
    }

    private FunctionDeclarationTree(Builder builder) {
        super(ParseTreeType.FUNCTION_DECLARATION, builder.location);
        this.name = builder.name;
        this.isStatic = builder.isStatic;
        this.isGenerator = builder.isGenerator;
        this.isOptional = builder.isOptional;
        this.kind = (Kind)((Object)Preconditions.checkNotNull((Object)((Object)builder.kind)));
        this.formalParameterList = (FormalParameterListTree)Preconditions.checkNotNull((Object)builder.formalParameterList);
        this.functionBody = (ParseTree)Preconditions.checkNotNull((Object)builder.functionBody);
        this.isAsync = builder.isAsync;
    }

    public static class Builder {
        private final Kind kind;
        private @Nullable IdentifierToken name = null;
        private @Nullable FormalParameterListTree formalParameterList = null;
        private @Nullable ParseTree functionBody = null;
        private boolean isStatic = false;
        private boolean isGenerator = false;
        private boolean isOptional = false;
        private boolean isAsync = false;
        private SourceRange location;

        Builder(Kind kind) {
            this.kind = kind;
        }

        @CanIgnoreReturnValue
        public Builder setName(IdentifierToken name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setFormalParameterList(FormalParameterListTree formalParameterList) {
            this.formalParameterList = formalParameterList;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setFunctionBody(ParseTree functionBody) {
            this.functionBody = functionBody;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setStatic(boolean isStatic) {
            this.isStatic = isStatic;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setGenerator(boolean isGenerator) {
            this.isGenerator = isGenerator;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setOptional(boolean isOptional) {
            this.isOptional = isOptional;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAsync(boolean isAsync) {
            this.isAsync = isAsync;
            return this;
        }

        public FunctionDeclarationTree build(SourceRange location) {
            this.location = location;
            return new FunctionDeclarationTree(this);
        }
    }

    public static enum Kind {
        DECLARATION,
        EXPRESSION,
        MEMBER,
        ARROW;

    }
}

