/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.modules;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.modules.AutoValue_ClosureRequireProcessor_Require;
import com.google.javascript.jscomp.modules.Binding;
import com.google.javascript.jscomp.modules.Import;
import com.google.javascript.rhino.Node;
import org.jspecify.nullness.Nullable;

final class ClosureRequireProcessor {
    private final Node nameDeclaration;
    private final Binding.CreatedBy requireKind;
    private static final ImmutableMap<String, Binding.CreatedBy> GOOG_DEPENDENCY_CALLS = ImmutableMap.of((Object)"require", (Object)((Object)Binding.CreatedBy.GOOG_REQUIRE), (Object)"requireType", (Object)((Object)Binding.CreatedBy.GOOG_REQUIRE_TYPE), (Object)"forwardDeclare", (Object)((Object)Binding.CreatedBy.GOOG_FORWARD_DECLARE));

    private ClosureRequireProcessor(Node nameDeclaration, Binding.CreatedBy requireKind) {
        Preconditions.checkArgument((boolean)NodeUtil.isNameDeclaration(nameDeclaration));
        this.nameDeclaration = nameDeclaration;
        this.requireKind = requireKind;
    }

    static ImmutableList<Require> getAllRequires(Node nameDeclaration) {
        Node rhs = nameDeclaration.getFirstChild().isDestructuringLhs() ? nameDeclaration.getFirstChild().getSecondChild() : nameDeclaration.getFirstFirstChild();
        Binding.CreatedBy requireKind = ClosureRequireProcessor.getModuleDependencyTypeFromRhs(rhs);
        if (requireKind == null) {
            return ImmutableList.of();
        }
        return new ClosureRequireProcessor(nameDeclaration, requireKind).getAllRequiresInDeclaration();
    }

    private static @Nullable Binding.CreatedBy getModuleDependencyTypeFromRhs(@Nullable Node value) {
        if (!(value != null && value.isCall() && value.hasTwoChildren() && value.getSecondChild().isStringLit())) {
            return null;
        }
        Node callee = value.getFirstChild();
        if (!callee.isGetProp()) {
            return null;
        }
        Node owner = callee.getFirstChild();
        if (!owner.isName() || !owner.getString().equals("goog")) {
            return null;
        }
        return (Binding.CreatedBy)((Object)GOOG_DEPENDENCY_CALLS.get((Object)callee.getString()));
    }

    private ImmutableList<Require> getAllRequiresInDeclaration() {
        Node rhs = this.nameDeclaration.getFirstChild().isDestructuringLhs() ? this.nameDeclaration.getFirstChild().getSecondChild() : this.nameDeclaration.getFirstFirstChild();
        String namespace = rhs.getSecondChild().getString();
        if (this.nameDeclaration.getFirstChild().isName()) {
            Node lhs = this.nameDeclaration.getFirstChild();
            return ImmutableList.of((Object)Require.create(lhs.getString(), Import.builder().moduleRequest(namespace).localName(lhs.getString()).importName("*exports*").importNode(this.nameDeclaration).nameNode(lhs).build(), this.requireKind));
        }
        Node objectPattern = this.nameDeclaration.getFirstFirstChild();
        if (!objectPattern.isObjectPattern()) {
            return ImmutableList.of();
        }
        return this.getAllRequiresFromDestructuring(objectPattern, namespace);
    }

    private ImmutableList<Require> getAllRequiresFromDestructuring(Node objectPattern, String namespace) {
        ImmutableList.Builder requireBuilder = ImmutableList.builder();
        for (Node key = objectPattern.getFirstChild(); key != null; key = key.getNext()) {
            Node lhs;
            if (!key.isStringKey() || !(lhs = key.getOnlyChild()).isName()) continue;
            requireBuilder.add((Object)Require.create(lhs.getString(), Import.builder().moduleRequest(namespace).localName(lhs.getString()).importName(key.getString()).importNode(this.nameDeclaration).nameNode(lhs).build(), this.requireKind));
        }
        return requireBuilder.build();
    }

    @AutoValue
    static abstract class Require {
        Require() {
        }

        abstract String localName();

        abstract Import importRecord();

        abstract Binding.CreatedBy createdBy();

        private static Require create(String localName, Import importRecord, Binding.CreatedBy createdBy) {
            Preconditions.checkArgument((boolean)createdBy.isClosureImport());
            return new AutoValue_ClosureRequireProcessor_Require(localName, importRecord, createdBy);
        }
    }
}

