/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.diagnostic;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.google.errorprone.annotations.MustBeClosed;
import com.google.gson.stream.JsonWriter;
import com.google.javascript.jscomp.diagnostic.NoOpLogFile;
import com.google.javascript.jscomp.diagnostic.WritingLogFile;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Supplier;

public abstract class LogFile
implements AutoCloseable {
    @MustBeClosed
    public static LogFile createOrReopen(Path file) {
        return WritingLogFile.create(file);
    }

    public static LogFile createNoOp() {
        return new NoOpLogFile();
    }

    LogFile() {
    }

    public abstract LogFile log(Object var1);

    public abstract LogFile log(String var1);

    public abstract LogFile log(Supplier<String> var1);

    @FormatMethod
    public abstract LogFile log(@FormatString String var1, Object ... var2);

    public abstract LogFile logJson(Object var1);

    public abstract LogFile logJson(Supplier<Object> var1);

    public abstract LogFile logJson(StreamedJsonProducer var1);

    public abstract boolean isLogging();

    @Override
    public abstract void close();

    public static interface StreamedJsonProducer {
        public void writeJson(JsonWriter var1) throws IOException;
    }
}

