/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.Locale;
import org.jspecify.nullness.Nullable;

public final class TranspilationUtil {
    public static final DiagnosticType CANNOT_CONVERT = DiagnosticType.error("JSC_CANNOT_CONVERT", "This code cannot be transpiled. {0}");
    public static final DiagnosticType CANNOT_CONVERT_YET = DiagnosticType.error("JSC_CANNOT_CONVERT_YET", "Transpilation of ''{0}'' is not yet implemented.");

    private TranspilationUtil() {
    }

    static void cannotConvert(AbstractCompiler compiler, Node n, String message) {
        compiler.report(JSError.make(n, CANNOT_CONVERT, message));
    }

    static void cannotConvertYet(AbstractCompiler compiler, Node n, String feature) {
        compiler.report(JSError.make(n, CANNOT_CONVERT_YET, feature));
    }

    static void preloadTranspilationRuntimeFunction(AbstractCompiler compiler, String function) {
        compiler.ensureLibraryInjected("es6/util/" + function.toLowerCase(Locale.ROOT), false);
    }

    static @Nullable JSType createType(boolean shouldCreate, JSTypeRegistry registry, JSTypeNative typeName) {
        if (!shouldCreate) {
            return null;
        }
        return registry.getNativeType(typeName);
    }

    static @Nullable JSType createGenericType(boolean shouldCreate, JSTypeRegistry registry, JSTypeNative typeName, JSType typeArg) {
        if (!shouldCreate) {
            return null;
        }
        ObjectType genericType = (ObjectType)registry.getNativeType(typeName);
        ObjectType uninstantiated = genericType.getRawType();
        return registry.createTemplatizedType(uninstantiated, (ImmutableList<JSType>)ImmutableList.of((Object)typeArg));
    }
}

