/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ConvertChunksToESModules;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.ModuleRenaming;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.modules.Module;
import com.google.javascript.jscomp.modules.ModuleMap;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplatizedType;
import java.util.Iterator;
import org.jspecify.nullness.Nullable;

public class RewriteDynamicImports
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType DYNAMIC_IMPORT_ALIASING_REQUIRED = DiagnosticType.warning("JSC_DYNAMIC_IMPORT_ALIASING_REQUIRED", "Dynamic import expressions should be aliased for language level. Use the --dynamic_import_alias flag.");
    static final DiagnosticType DYNAMIC_IMPORT_INVALID_ALIAS = DiagnosticType.error("JSC_DYNAMIC_IMPORT_INVALID_ALIAS", "Dynamic import alias is not a valid name");
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final String alias;
    private final boolean requiresAliasing;
    private final boolean shouldWrapDynamicImportCallbacks;
    private boolean dynamicImportsRemoved = false;
    private boolean wrappedDynamicImportCallback = false;

    public RewriteDynamicImports(AbstractCompiler compiler, @Nullable String alias, CompilerOptions.ChunkOutputType chunkOutputType) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.alias = alias;
        this.requiresAliasing = !compiler.getOptions().getOutputFeatureSet().contains(FeatureSet.Feature.DYNAMIC_IMPORT);
        this.shouldWrapDynamicImportCallbacks = chunkOutputType == CompilerOptions.ChunkOutputType.ES_MODULES;
    }

    private final boolean aliasIsValid() {
        return this.alias != null && (this.alias.equals("import") || NodeUtil.isValidQualifiedName(this.compiler.getAllowableFeatures(), this.alias));
    }

    @Override
    public void process(Node externs, Node root) {
        this.dynamicImportsRemoved = false;
        Preconditions.checkArgument((boolean)externs.isRoot(), (Object)externs);
        Preconditions.checkArgument((boolean)root.isRoot(), (Object)root);
        NodeTraversal.traverse(this.compiler, root, this);
        if (this.wrappedDynamicImportCallback) {
            this.injectWrappingFunctionExtern();
        }
        if (this.dynamicImportsRemoved) {
            this.compiler.markFeatureNotAllowed(FeatureSet.Feature.DYNAMIC_IMPORT);
            NodeUtil.removeFeatureFromAllScripts(root, FeatureSet.Feature.DYNAMIC_IMPORT, this.compiler);
            if (this.requiresAliasing && this.aliasIsValid()) {
                NodeTraversal.traverse(this.compiler, externs, new AliasInjectingTraversal());
            }
        }
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.getToken() != Token.DYNAMIC_IMPORT) {
            return;
        }
        ModuleMap moduleMap = this.compiler.getModuleMap();
        Node importSpecifier = n.getFirstChild();
        if (importSpecifier.isStringLit() && moduleMap != null) {
            Var targetModuleNS;
            ModuleLoader.ModulePath targetPath = t.getInput().getPath().resolveJsModule(importSpecifier.getString(), n.getSourceFileName(), n.getLineno(), n.getCharno());
            Module module = targetPath == null ? null : this.compiler.getModuleMap().getModule(targetPath);
            String targetModuleVarName = module == null ? null : ModuleRenaming.GlobalizedModuleName.create(module.metadata(), null, null).aliasName().join();
            Var var = targetModuleNS = targetModuleVarName == null ? null : (Var)t.getScope().getVar(targetModuleVarName);
            if (targetModuleNS != null) {
                JSChunk targetModule = targetModuleNS.getInput().getChunk();
                if (t.getChunk() == targetModule) {
                    this.replaceDynamicImportWithPromise(t, n, targetModuleNS);
                    return;
                }
                this.retargetImportSpecifier(t, n, targetModule);
                if (NodeUtil.isExpressionResultUsed(n)) {
                    this.addChainedThen(t, n, targetModuleNS);
                }
            }
        }
        if (this.aliasIsValid()) {
            this.aliasDynamicImport(t, n);
        } else if (this.alias != null) {
            t.report(n, DYNAMIC_IMPORT_INVALID_ALIAS, new String[0]);
        } else if (this.requiresAliasing) {
            t.report(n, DYNAMIC_IMPORT_ALIASING_REQUIRED, new String[0]);
        }
    }

    private void replaceDynamicImportWithPromise(NodeTraversal t, Node dynamicImport, Var targetModuleNS) {
        JSTypeRegistry registry = this.compiler.getTypeRegistry();
        Node promiseDotResolve = this.astFactory.createQName(this.compiler.getTranspilationNamespace(), "Promise.resolve");
        Node promiseResolveCall = this.astFactory.createCall(promiseDotResolve, AstFactory.type(dynamicImport), new Node[0]);
        boolean isExpressionUsed = NodeUtil.isExpressionResultUsed(dynamicImport);
        if (isExpressionUsed) {
            JSType moduleNamespaceType;
            if (dynamicImport.getJSType() != null && dynamicImport.getJSType().isTemplatizedType()) {
                TemplatizedType templatizedType = (TemplatizedType)dynamicImport.getJSType();
                moduleNamespaceType = (JSType)templatizedType.getTemplateTypes().get(0);
            } else {
                moduleNamespaceType = registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            promiseDotResolve.setJSType(registry.createFunctionType((JSType)registry.createTemplatizedType(registry.getNativeObjectType(JSTypeNative.PROMISE_TYPE), moduleNamespaceType), registry.getNativeType(JSTypeNative.ALL_TYPE)));
            promiseResolveCall.addChildToBack(this.createModuleNamespaceNode(targetModuleNS));
            promiseResolveCall.copyTypeFrom(dynamicImport);
        } else {
            promiseDotResolve.setJSType(registry.createFunctionType((JSType)registry.createTemplatizedType(registry.getNativeObjectType(JSTypeNative.PROMISE_TYPE), registry.getNativeType(JSTypeNative.VOID_TYPE)), registry.getNativeType(JSTypeNative.ALL_TYPE)));
            promiseResolveCall.setJSType(registry.createTemplatizedType(registry.getNativeObjectType(JSTypeNative.PROMISE_TYPE), registry.getNativeType(JSTypeNative.VOID_TYPE)));
        }
        promiseResolveCall.srcrefTree(dynamicImport);
        Node parent = dynamicImport.getParent();
        dynamicImport.replaceWith(promiseResolveCall);
        t.reportCodeChange(parent);
        this.dynamicImportsRemoved = true;
    }

    private static String getChunkFileName(JSChunk chunk) {
        return chunk.getName() + ".js";
    }

    private void retargetImportSpecifier(NodeTraversal t, Node dynamicImport, JSChunk targetModule) {
        String retargetedSpecifier;
        String importingChunkFilename = RewriteDynamicImports.getChunkFileName(t.getInput().getChunk());
        String targetChunkFilename = RewriteDynamicImports.getChunkFileName(targetModule);
        try {
            retargetedSpecifier = ModuleLoader.relativePathFrom(importingChunkFilename, targetChunkFilename);
        }
        catch (IllegalArgumentException e) {
            this.compiler.report(JSError.make(dynamicImport, ConvertChunksToESModules.UNABLE_TO_COMPUTE_RELATIVE_PATH, importingChunkFilename, targetChunkFilename));
            return;
        }
        Node originalSpecifierNode = dynamicImport.getFirstChild();
        Node newSpecifier = this.astFactory.createString(retargetedSpecifier).srcref(originalSpecifierNode);
        originalSpecifierNode.replaceWith(newSpecifier);
        t.reportCodeChange(newSpecifier);
    }

    private void addChainedThen(NodeTraversal t, Node dynamicImport, Var targetModuleNs) {
        JSTypeRegistry registry = this.compiler.getTypeRegistry();
        Node importParent = dynamicImport.getParent();
        Node placeholder = IR.empty();
        dynamicImport.replaceWith(placeholder);
        Node moduleNamespaceNode = this.createModuleNamespaceNode(targetModuleNs);
        Node callbackFn = this.astFactory.createZeroArgArrowFunctionForExpression(moduleNamespaceNode);
        callbackFn.setJSType(registry.createFunctionType((JSType)registry.createTemplatizedType(registry.getNativeObjectType(JSTypeNative.PROMISE_TYPE), registry.getNativeType(JSTypeNative.UNKNOWN_TYPE)), registry.createFunctionType(registry.getNativeType(JSTypeNative.ALL_TYPE), new JSType[0])));
        Node thenArgument = callbackFn;
        if (this.shouldWrapDynamicImportCallbacks) {
            Node wrappingFunction = this.astFactory.createName("jscomp$DynamicImportCallback", AstFactory.type(registry.createFunctionType(callbackFn.getJSType(), callbackFn.getJSType())));
            thenArgument = this.astFactory.createCall(wrappingFunction, AstFactory.type(callbackFn), callbackFn);
            this.wrappedDynamicImportCallback = true;
        }
        Node importThenCall = this.astFactory.createCall(this.astFactory.createGetPropWithUnknownType(dynamicImport, "then"), AstFactory.type(dynamicImport), thenArgument);
        importThenCall.srcrefTreeIfMissing(dynamicImport);
        if (dynamicImport.getJSType() != null) {
            importThenCall.copyTypeFrom(dynamicImport);
        }
        placeholder.replaceWith(importThenCall);
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.ARROW_FUNCTIONS, this.compiler);
        this.compiler.reportChangeToChangeScope(callbackFn);
        this.compiler.reportChangeToEnclosingScope(importParent);
    }

    private void aliasDynamicImport(NodeTraversal t, Node dynamicImport) {
        Preconditions.checkNotNull((Object)this.alias);
        Node aliasNode = this.astFactory.createQNameWithUnknownType(this.alias);
        aliasNode.setOriginalName("import");
        Node moduleSpecifier = dynamicImport.removeFirstChild();
        Node importAliasCall = this.astFactory.createCall(aliasNode, AstFactory.type(dynamicImport), moduleSpecifier).srcrefTreeIfMissing(dynamicImport);
        if (dynamicImport.getJSType() != null) {
            importAliasCall.copyTypeFrom(dynamicImport);
        }
        dynamicImport.replaceWith(importAliasCall);
        t.reportCodeChange(importAliasCall);
        this.dynamicImportsRemoved = true;
    }

    private Node createModuleNamespaceNode(Var moduleVar) {
        Node moduleVarNode = moduleVar.getNode();
        Node moduleNamespace = moduleVarNode.cloneNode();
        moduleNamespace.copyTypeFrom(moduleVarNode);
        return moduleNamespace;
    }

    private void injectWrappingFunctionExtern() {
        JSTypeRegistry registry = this.compiler.getTypeRegistry();
        TemplateType templateT = registry.createTemplateType("T");
        Node wrappingFunctionDefinition = this.astFactory.createFunction("jscomp$DynamicImportCallback", this.astFactory.createParamList("importCallback"), this.astFactory.createBlock(new Node[0]), AstFactory.type(registry.createFunctionType((JSType)templateT, templateT)));
        Node externsRoot = this.compiler.getSynthesizedExternsInput().getAstRoot(this.compiler);
        wrappingFunctionDefinition.srcrefTree(externsRoot);
        externsRoot.addChildToBack(wrappingFunctionDefinition);
        this.compiler.reportChangeToEnclosingScope(wrappingFunctionDefinition);
    }

    private class AliasInjectingTraversal
    extends NodeTraversal.AbstractPreOrderCallback {
        private AliasInjectingTraversal() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            Preconditions.checkState((boolean)RewriteDynamicImports.this.aliasIsValid());
            if (NodeUtil.isValidSimpleName(RewriteDynamicImports.this.alias) && t.getScope().getVar(RewriteDynamicImports.this.alias) != null) {
                return false;
            }
            JSTypeRegistry registry = RewriteDynamicImports.this.compiler.getTypeRegistry();
            JSType unknownType = registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            JSType promiseType = registry.getNativeType(JSTypeNative.PROMISE_TYPE);
            TemplatizedType promiseTemplatizedType = registry.createTemplatizedType(promiseType.toObjectType(), (ImmutableList<JSType>)ImmutableList.of((Object)unknownType));
            JSType stringType = registry.getNativeType(JSTypeNative.STRING_TYPE);
            Node externsRoot = RewriteDynamicImports.this.compiler.getSynthesizedExternsInput().getAstRoot(RewriteDynamicImports.this.compiler);
            if (RewriteDynamicImports.this.alias.equals("import") || NodeUtil.isValidSimpleName(RewriteDynamicImports.this.alias)) {
                Node aliasNode = RewriteDynamicImports.this.astFactory.createFunction(RewriteDynamicImports.this.alias, RewriteDynamicImports.this.astFactory.createParamList("specifier"), RewriteDynamicImports.this.astFactory.createBlock(new Node[0]), AstFactory.type(registry.createFunctionType((JSType)promiseTemplatizedType, stringType)));
                aliasNode.srcrefTree(externsRoot);
                externsRoot.addChildToBack(aliasNode);
            } else {
                String aliasRootName = NodeUtil.getRootOfQualifiedName(RewriteDynamicImports.this.alias);
                Var aliasVar = (Var)t.getScope().getVar(aliasRootName);
                if (aliasVar != null) {
                    return false;
                }
                Node aliasRootNode = RewriteDynamicImports.this.astFactory.createSingleVarNameDeclaration(aliasRootName, RewriteDynamicImports.this.astFactory.createObjectLit(new Node[0]));
                aliasRootNode.srcrefTree(externsRoot);
                externsRoot.addChildToBack(aliasRootNode);
                Iterator aliasNameParts = Splitter.on((String)".").split((CharSequence)RewriteDynamicImports.this.alias).iterator();
                Node qName = aliasRootNode.getFirstChild().cloneNode();
                aliasNameParts.next();
                while (aliasNameParts.hasNext()) {
                    qName = RewriteDynamicImports.this.astFactory.createGetPropWithUnknownType(qName.cloneTree(), (String)aliasNameParts.next());
                    Node assignedValue = !aliasNameParts.hasNext() ? RewriteDynamicImports.this.astFactory.createFunction("", RewriteDynamicImports.this.astFactory.createParamList("specifier"), RewriteDynamicImports.this.astFactory.createBlock(new Node[0]), AstFactory.type(registry.createFunctionType((JSType)promiseTemplatizedType, stringType))) : RewriteDynamicImports.this.astFactory.createObjectLit(new Node[0]);
                    Node expr = RewriteDynamicImports.this.astFactory.exprResult(RewriteDynamicImports.this.astFactory.createAssign(qName, assignedValue));
                    expr.srcrefTree(externsRoot);
                    externsRoot.addChildToBack(expr);
                }
            }
            RewriteDynamicImports.this.compiler.reportChangeToChangeScope(externsRoot);
            return false;
        }
    }
}

