/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CombinedCompilerPass;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

final class RescopeGlobalSymbols
implements CompilerPass {
    private static final String DISAMBIGUATION_SUFFIX = "$";
    private final AbstractCompiler compiler;
    private final String globalSymbolNamespace;
    private final boolean addExtern;
    private final boolean assumeCrossChunkNames;
    private final Set<String> crossChunkNames = new LinkedHashSet<String>();
    private final Set<String> maybeReferencesThis = new LinkedHashSet<String>();
    private ImmutableSet<String> externNames;

    RescopeGlobalSymbols(AbstractCompiler compiler, String globalSymbolNamespace, boolean assumeCrossChunkNames) {
        this(compiler, globalSymbolNamespace, true, assumeCrossChunkNames);
    }

    RescopeGlobalSymbols(AbstractCompiler compiler, String globalSymbolNamespace, boolean addExtern, boolean assumeCrossChunkNames) {
        this.compiler = compiler;
        this.globalSymbolNamespace = globalSymbolNamespace;
        this.addExtern = addExtern;
        this.assumeCrossChunkNames = assumeCrossChunkNames;
    }

    private boolean isCrossChunkName(String name) {
        return this.assumeCrossChunkNames || this.crossChunkNames.contains(name) || this.compiler.getCodingConvention().isExported(name, false);
    }

    private boolean isExternVar(String varname, NodeTraversal t) {
        if (varname.isEmpty()) {
            return false;
        }
        Var v = (Var)t.getScope().getVar(varname);
        return v == null || v.isExtern() || ((Scope)v.getScope()).isGlobal() && this.externNames.contains((Object)varname);
    }

    private void addExternForGlobalSymbolNamespace() {
        Node varNode = IR.var(IR.name(this.globalSymbolNamespace));
        CompilerInput input = this.compiler.getSynthesizedExternsInput();
        input.getAstRoot(this.compiler).addChildToBack(varNode);
        this.compiler.reportChangeToEnclosingScope(varNode);
    }

    @Override
    public void process(Node externs, Node root) {
        this.externNames = NodeUtil.collectExternVariableNames(this.compiler, externs);
        if (this.addExtern) {
            this.addExternForGlobalSymbolNamespace();
        }
        NodeTraversal.traverse(this.compiler, root, new RewriteGlobalClassFunctionDeclarationsToVarAssignmentsCallback());
        ArrayList<NodeTraversal.Callback> nonMutatingPasses = new ArrayList<NodeTraversal.Callback>();
        nonMutatingPasses.add(new FindCrossChunkNamesCallback());
        nonMutatingPasses.add(new FindNamesReferencingThis());
        CombinedCompilerPass.traverse(this.compiler, root, nonMutatingPasses);
        RewriteScopeCallback rewriteScope = new RewriteScopeCallback();
        NodeTraversal.traverse(this.compiler, root, rewriteScope);
        NodeTraversal.traverse(this.compiler, root, new RemoveGlobalVarCallback());
        rewriteScope.declareChunkGlobals();
    }

    private class RewriteGlobalClassFunctionDeclarationsToVarAssignmentsCallback
    extends NodeTraversal.AbstractShallowStatementCallback {
        private RewriteGlobalClassFunctionDeclarationsToVarAssignmentsCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!t.inGlobalScope()) {
                return;
            }
            if (!NodeUtil.isFunctionDeclaration(n) && !NodeUtil.isClassDeclaration(n)) {
                return;
            }
            Node nameNode = NodeUtil.getNameNode(n);
            String name = nameNode.getString();
            if (n.isClass()) {
                nameNode.replaceWith(IR.empty().srcref(nameNode));
            } else {
                nameNode.setString("");
                RescopeGlobalSymbols.this.compiler.reportChangeToEnclosingScope(nameNode);
            }
            Node prev = n.getPrevious();
            n.detach();
            Node var = NodeUtil.newVarNode(name, n);
            if (prev == null) {
                parent.addChildToFront(var);
            } else {
                var.insertAfter(prev);
            }
            RescopeGlobalSymbols.this.compiler.reportChangeToEnclosingScope(parent);
        }
    }

    private class FindCrossChunkNamesCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindCrossChunkNamesCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName()) {
                String name = n.getString();
                if ("".equals(name) || RescopeGlobalSymbols.this.crossChunkNames.contains(name)) {
                    return;
                }
                Scope s = t.getScope();
                Var v = (Var)s.getVar(name);
                if (v == null || !v.isGlobal()) {
                    return;
                }
                CompilerInput input = v.getInput();
                if (input == null) {
                    RescopeGlobalSymbols.this.crossChunkNames.add(name);
                    return;
                }
                JSChunk chunk = input.getChunk();
                if (chunk != t.getChunk()) {
                    RescopeGlobalSymbols.this.crossChunkNames.add(name);
                }
            }
        }
    }

    private class FindNamesReferencingThis
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindNamesReferencingThis() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName()) {
                String name = n.getString();
                if (name.isEmpty()) {
                    return;
                }
                Node value = null;
                if (parent.isAssign() && n == parent.getFirstChild()) {
                    value = parent.getLastChild();
                } else if (NodeUtil.isNameDeclaration(parent)) {
                    value = n.getFirstChild();
                } else if (parent.isFunction()) {
                    value = parent;
                }
                if (value == null && !NodeUtil.isLhsByDestructuring(n)) {
                    return;
                }
                if (RescopeGlobalSymbols.this.maybeReferencesThis.contains(name)) {
                    return;
                }
                Scope s = t.getScope();
                Var v = (Var)s.getVar(name);
                if (v == null || !v.isGlobal()) {
                    return;
                }
                if (value == null || !value.isFunction() || NodeUtil.referencesOwnReceiver(value)) {
                    RescopeGlobalSymbols.this.maybeReferencesThis.add(name);
                }
            }
        }
    }

    private class RewriteScopeCallback
    implements NodeTraversal.Callback {
        final List<ChunkGlobal> preDeclarations = new ArrayList<ChunkGlobal>();

        private RewriteScopeCallback() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (NodeUtil.isNameDeclaration(n)) {
                this.visitNameDeclaration(t, n);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName()) {
                this.visitName(t, n, parent);
            }
        }

        private void visitNameDeclaration(NodeTraversal t, Node declaration) {
            ArrayList<Node> allLhsNodes = new ArrayList<Node>();
            NodeUtil.visitLhsNodesInNode(declaration, allLhsNodes::add);
            if (allLhsNodes.isEmpty()) {
                return;
            }
            boolean hasImportantName = false;
            boolean isGlobalDeclaration = ((Var)t.getScope().getVar(((Node)allLhsNodes.get(0)).getString())).isGlobal();
            for (Node lhs : allLhsNodes) {
                Preconditions.checkState((boolean)lhs.isName(), (String)"Unexpected lhs node %s, expected NAME", (Object)lhs);
                if ((!isGlobalDeclaration || !RescopeGlobalSymbols.this.isCrossChunkName(lhs.getString())) && !RescopeGlobalSymbols.this.isExternVar(lhs.getString(), t)) continue;
                hasImportantName = true;
                break;
            }
            if (hasImportantName) {
                this.rewriteNameDeclaration(t, declaration, allLhsNodes, isGlobalDeclaration);
            }
        }

        private void rewriteNameDeclaration(NodeTraversal t, Node declaration, List<Node> allLhsNodes, boolean isGlobalDeclaration) {
            CompilerInput input = t.getInput();
            for (Node lhs : allLhsNodes) {
                String name = lhs.getString();
                if (isGlobalDeclaration && RescopeGlobalSymbols.this.isCrossChunkName(name) || RescopeGlobalSymbols.this.isExternVar(name, t)) continue;
                this.preDeclarations.add(new ChunkGlobal(input.getAstRoot(RescopeGlobalSymbols.this.compiler), IR.name(name).srcref(lhs)));
            }
            Node child = declaration.getFirstChild();
            while (child != null) {
                Node assign;
                Node next = child.getNext();
                if (child.isName() && child.hasChildren()) {
                    assign = IR.assign(child.cloneNode(), child.removeFirstChild());
                    child.replaceWith(assign);
                    assign.setJSDocInfo(declaration.getJSDocInfo());
                } else if (child.isDestructuringLhs()) {
                    if (child.hasOneChild()) {
                        Preconditions.checkState((boolean)NodeUtil.isEnhancedFor(declaration.getParent()), (String)"DESTRUCTURING_LHS should have two children: %s", (Object)declaration.toStringTree());
                        child.replaceWith(child.removeFirstChild());
                    } else {
                        assign = IR.assign(child.removeFirstChild(), child.removeFirstChild());
                        child.replaceWith(assign);
                        assign.setJSDocInfo(declaration.getJSDocInfo());
                    }
                }
                child = next;
            }
            RescopeGlobalSymbols.this.compiler.reportChangeToEnclosingScope(declaration);
        }

        private void visitName(NodeTraversal t, Node n, Node parent) {
            String name = n.getString();
            if (parent.isFunction() && name.isEmpty()) {
                return;
            }
            if (RescopeGlobalSymbols.this.isExternVar(name, t)) {
                return;
            }
            Var var = (Var)t.getScope().getVar(name);
            if (!var.isGlobal() && (name.equals(RescopeGlobalSymbols.this.globalSymbolNamespace) || name.startsWith(RescopeGlobalSymbols.this.globalSymbolNamespace + RescopeGlobalSymbols.DISAMBIGUATION_SUFFIX))) {
                n.setString(name + RescopeGlobalSymbols.DISAMBIGUATION_SUFFIX);
                RescopeGlobalSymbols.this.compiler.reportChangeToEnclosingScope(n);
            }
            if (!var.isGlobal() || !RescopeGlobalSymbols.this.isCrossChunkName(name)) {
                return;
            }
            this.replaceSymbol(n, name);
        }

        private void replaceSymbol(Node node, String name) {
            Node parent = node.getParent();
            Node replacement = IR.getprop(IR.name(RescopeGlobalSymbols.this.globalSymbolNamespace), name);
            replacement.srcrefTree(node);
            node.replaceWith(replacement);
            RescopeGlobalSymbols.this.compiler.reportChangeToEnclosingScope(replacement);
            if (parent.isCall() && !RescopeGlobalSymbols.this.maybeReferencesThis.contains(name)) {
                parent.putBooleanProp(Node.FREE_CALL, false);
            }
            RescopeGlobalSymbols.this.compiler.reportChangeToEnclosingScope(parent);
        }

        void declareChunkGlobals() {
            for (ChunkGlobal global : this.preDeclarations) {
                if (global.root.hasChildren() && global.root.getFirstChild().isVar()) {
                    global.root.getFirstChild().addChildToBack(global.name);
                } else {
                    global.root.addChildToFront(IR.var(global.name).srcref(global.name));
                }
                RescopeGlobalSymbols.this.compiler.reportChangeToEnclosingScope(global.root);
            }
        }

        private class ChunkGlobal {
            final Node root;
            final Node name;

            ChunkGlobal(Node root, Node name) {
                this.root = root;
                this.name = name;
            }
        }
    }

    private class RemoveGlobalVarCallback
    extends NodeTraversal.AbstractShallowStatementCallback {
        private RemoveGlobalVarCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!NodeUtil.isNameDeclaration(n)) {
                return;
            }
            ArrayList<Node> commas = new ArrayList<Node>();
            ArrayList<Object> interestingChildren = new ArrayList<Object>();
            boolean allNameOrDestructuring = true;
            for (Object c = n.getFirstChild(); c != null; c = ((Node)c).getNext()) {
                if (!((Node)c).isName() && !((Node)c).isDestructuringLhs()) {
                    allNameOrDestructuring = false;
                }
                if (!((Node)c).isAssign() && !NodeUtil.isAnyFor(parent)) continue;
                interestingChildren.add(c);
            }
            if (allNameOrDestructuring) {
                return;
            }
            for (Node node : interestingChildren) {
                if (NodeUtil.isAnyFor(parent) && parent.getFirstChild() == n) {
                    commas.add(node.cloneTree());
                    continue;
                }
                Node expr = IR.exprResult(node.cloneTree()).srcref(node);
                NodeUtil.markNewScopesChanged(expr, RescopeGlobalSymbols.this.compiler);
                expr.insertBefore(n);
            }
            if (!commas.isEmpty()) {
                Node comma = this.joinOnComma(commas, n);
                comma.insertBefore(n);
            }
            n.detach();
            NodeUtil.markFunctionsDeleted(n, RescopeGlobalSymbols.this.compiler);
            RescopeGlobalSymbols.this.compiler.reportChangeToEnclosingScope(parent);
        }

        private Node joinOnComma(List<Node> commas, Node source) {
            Node comma = commas.get(0);
            for (int i = 1; i < commas.size(); ++i) {
                Node nextComma = IR.comma(comma, commas.get(i));
                nextComma.srcrefIfMissing(source);
                comma = nextComma;
            }
            return comma;
        }
    }
}

