/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.javascript.jscomp.CodeChangeHandler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JvmMetrics;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PerformanceTrackerCodeSizeEstimator;
import com.google.javascript.jscomp.Platform;
import com.google.javascript.jscomp.RecentChange;
import com.google.javascript.jscomp.base.JSCompStrings;
import com.google.javascript.jscomp.base.format.SimpleFormat;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class PerformanceTracker {
    private static final int DEFAULT_WHEN_SIZE_UNTRACKED = -1;
    private final Node externsRoot;
    private final CompilerOptions.TracerMode mode;
    private final RecentChange codeChange = new RecentChange();
    private Node jsRoot;
    private int initAstSize = -1;
    private int initCodeSize = -1;
    private int initGzCodeSize = -1;
    private final long startTime;
    private long endTime;
    private int passesRuntime = 0;
    private int maxMem = 0;
    private int runs = 0;
    private int changes = 0;
    private int loopRuns = 0;
    private int loopChanges = 0;
    private int jsLines = 0;
    private int jsSources = 0;
    private int externLines = 0;
    private int externSources = 0;
    private int astSize = -1;
    private int codeSize = -1;
    private int gzCodeSize = -1;
    private int astDiff = 0;
    private int diff = 0;
    private int gzDiff = 0;
    private final Deque<Stats> currentPass = new ArrayDeque<Stats>();
    private ImmutableMap<String, Stats> passSummary;
    private ImmutableMultiset<Token> astManifest;
    private final List<Stats> log = new ArrayList<Stats>();
    private String disambiguatePropertiesSummary = "not executed";
    private String ambiguatePropertiesSummary = "not executed";

    PerformanceTracker(Node externsRoot, Node jsRoot, CompilerOptions.TracerMode mode) {
        Preconditions.checkArgument((mode != CompilerOptions.TracerMode.OFF ? 1 : 0) != 0, (Object)"PerformanceTracker can't work without tracer data.");
        this.startTime = System.currentTimeMillis();
        this.externsRoot = externsRoot;
        this.jsRoot = jsRoot;
        this.mode = mode;
    }

    CodeChangeHandler getCodeChangeHandler() {
        return this.codeChange;
    }

    void recordPassStart(String passName, boolean isOneTime) {
        this.currentPass.push(new Stats(passName, isOneTime));
        if (!passName.equals("toSource")) {
            this.codeChange.reset();
        }
    }

    void updateAfterDeserialize(Node jsRoot) {
        this.jsRoot = jsRoot;
        if (!this.tracksAstSize()) {
            return;
        }
        this.initAstSize = this.astSize = NodeUtil.countAstSize(this.jsRoot);
        if (!this.tracksSize()) {
            return;
        }
        PerformanceTrackerCodeSizeEstimator estimator = PerformanceTrackerCodeSizeEstimator.estimate(this.jsRoot, this.tracksGzSize());
        this.initCodeSize = this.codeSize = estimator.getCodeSize();
        if (this.tracksGzSize()) {
            this.initGzCodeSize = this.gzCodeSize = estimator.getZippedCodeSize();
        }
    }

    void recordPassStop(String passName, long runtime) {
        int allocMem = this.getAllocatedMegabytes();
        Stats logStats = this.currentPass.pop();
        Preconditions.checkState((boolean)passName.equals(logStats.pass));
        this.log.add(logStats);
        logStats.runtime = runtime;
        logStats.allocMem = allocMem;
        logStats.runs = 1;
        if (this.codeChange.hasCodeChanged()) {
            logStats.changes = 1;
        }
        if (passName.equals("parseInputs")) {
            this.recordParsingStop(logStats);
        } else if (this.codeChange.hasCodeChanged() && this.tracksAstSize()) {
            this.recordOtherPassStop(logStats);
        }
    }

    private void recordParsingStop(Stats logStats) {
        if (this.tracksAstManifest()) {
            this.populateAstManifest();
        }
        this.recordInputCount();
        if (!this.tracksAstSize()) {
            return;
        }
        this.initAstSize = this.astSize = NodeUtil.countAstSize(this.jsRoot);
        logStats.astSize = this.astSize;
        if (!this.tracksSize()) {
            return;
        }
        PerformanceTrackerCodeSizeEstimator estimator = PerformanceTrackerCodeSizeEstimator.estimate(this.jsRoot, this.tracksGzSize());
        this.initCodeSize = this.codeSize = estimator.getCodeSize();
        logStats.size = this.codeSize;
        if (this.tracksGzSize()) {
            this.initGzCodeSize = this.gzCodeSize = estimator.getZippedCodeSize();
            logStats.gzSize = this.gzCodeSize;
        }
    }

    private void recordOtherPassStop(Stats logStats) {
        int newSize = NodeUtil.countAstSize(this.jsRoot);
        logStats.astDiff = this.astSize - newSize;
        this.astSize = logStats.astSize = newSize;
        if (!this.tracksSize()) {
            return;
        }
        PerformanceTrackerCodeSizeEstimator estimator = PerformanceTrackerCodeSizeEstimator.estimate(this.jsRoot, this.tracksGzSize());
        newSize = estimator.getCodeSize();
        logStats.diff = this.codeSize - newSize;
        this.codeSize = logStats.size = newSize;
        if (this.tracksGzSize()) {
            newSize = estimator.getZippedCodeSize();
            logStats.gzDiff = this.gzCodeSize - newSize;
            this.gzCodeSize = logStats.gzSize = newSize;
        }
    }

    private void recordInputCount() {
        Node n;
        for (n = this.externsRoot.getFirstChild(); n != null; n = n.getNext()) {
            ++this.externSources;
            this.externLines += NodeUtil.estimateNumLines(n);
        }
        for (n = this.jsRoot.getFirstChild(); n != null; n = n.getNext()) {
            ++this.jsSources;
            this.jsLines += NodeUtil.estimateNumLines(n);
        }
    }

    private int bytesToMB(long bytes) {
        return (int)(bytes / 0x100000L);
    }

    private int getAllocatedMegabytes() {
        return this.bytesToMB(Platform.totalMemory() - Platform.freeMemory());
    }

    public boolean tracksSize() {
        return this.mode == CompilerOptions.TracerMode.RAW_SIZE || this.mode == CompilerOptions.TracerMode.ALL;
    }

    public boolean tracksGzSize() {
        return this.mode == CompilerOptions.TracerMode.ALL;
    }

    public boolean tracksAstSize() {
        return this.mode != CompilerOptions.TracerMode.TIMING_ONLY;
    }

    public boolean tracksAstManifest() {
        return this.mode.isOn();
    }

    public int getRuntime() {
        this.calcTotalStats();
        return this.passesRuntime;
    }

    public int getSize() {
        this.calcTotalStats();
        return this.codeSize;
    }

    public int getGzSize() {
        this.calcTotalStats();
        return this.gzCodeSize;
    }

    public int getAstSize() {
        this.calcTotalStats();
        return this.astSize;
    }

    @VisibleForTesting
    int getChanges() {
        this.calcTotalStats();
        return this.changes;
    }

    @VisibleForTesting
    int getLoopChanges() {
        this.calcTotalStats();
        return this.loopChanges;
    }

    @VisibleForTesting
    int getRuns() {
        this.calcTotalStats();
        return this.runs;
    }

    @VisibleForTesting
    int getLoopRuns() {
        this.calcTotalStats();
        return this.loopRuns;
    }

    public ImmutableMap<String, Stats> getStats() {
        this.calcTotalStats();
        return this.passSummary;
    }

    private void calcTotalStats() {
        if (this.passSummary != null) {
            return;
        }
        this.endTime = System.currentTimeMillis();
        this.populatePassSummary();
        for (Map.Entry entry : this.passSummary.entrySet()) {
            Stats stats = (Stats)entry.getValue();
            this.passesRuntime = (int)((long)this.passesRuntime + stats.runtime);
            this.maxMem = Math.max(this.maxMem, stats.allocMem);
            this.runs += stats.runs;
            this.changes += stats.changes;
            if (!stats.isOneTime) {
                this.loopRuns += stats.runs;
                this.loopChanges += stats.changes;
            }
            this.astDiff += stats.astDiff;
            this.diff += stats.diff;
            this.gzDiff += stats.gzDiff;
        }
        Preconditions.checkState((!this.tracksAstSize() || this.initAstSize == this.astDiff + this.astSize ? 1 : 0) != 0);
        Preconditions.checkState((!this.tracksSize() || this.initCodeSize == this.diff + this.codeSize ? 1 : 0) != 0);
        Preconditions.checkState((!this.tracksGzSize() || this.initGzCodeSize == this.gzDiff + this.gzCodeSize ? 1 : 0) != 0);
    }

    private void populatePassSummary() {
        LinkedHashMap<String, Stats> tmpPassSummary = new LinkedHashMap<String, Stats>();
        for (Stats logStat : this.log) {
            String passName = logStat.pass;
            Stats entry = tmpPassSummary.computeIfAbsent(passName, k -> new Stats((String)k, logStat.isOneTime));
            entry.runtime += logStat.runtime;
            entry.allocMem = Math.max(entry.allocMem, logStat.allocMem);
            ++entry.runs;
            entry.changes += logStat.changes;
            entry.astDiff += logStat.astDiff;
            entry.diff += logStat.diff;
            entry.gzDiff += logStat.gzDiff;
        }
        this.passSummary = ImmutableMap.copyOf(tmpPassSummary);
    }

    private void populateAstManifest() {
        if (this.astManifest != null) {
            return;
        }
        ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
        NodeUtil.visitPreOrder(this.jsRoot, n -> builder.add((Object)n.getToken()));
        this.astManifest = builder.build();
    }

    public void setDisambiguatePropertiesSummary(String summary) {
        this.disambiguatePropertiesSummary = summary;
    }

    public void setAmbiguatePropertiesSummary(String summary) {
        this.ambiguatePropertiesSummary = summary;
    }

    public void outputTracerReport(PrintStream output) {
        JvmMetrics.maybeWriteJvmMetrics(output, "verbose:pretty:all");
        this.calcTotalStats();
        output.println(JSCompStrings.lines("", "TOTAL:", "Start time(ms): " + this.startTime, "End time(ms): " + this.endTime, "Wall time(ms): " + (this.endTime - this.startTime), "Passes runtime(ms): " + this.passesRuntime, "Max mem usage (measured after each pass)(MB): " + this.maxMem, "#Runs: " + this.runs, "#Changing runs: " + this.changes, "#Loopable runs: " + this.loopRuns, "#Changing loopable runs: " + this.loopChanges, "Estimated AST reduction(#nodes): " + this.astDiff, "Estimated Reduction(bytes): " + this.diff, "Estimated GzReduction(bytes): " + this.gzDiff, "Estimated AST size(#nodes): " + this.astSize, "Estimated Size(bytes): " + this.codeSize, "Estimated GzSize(bytes): " + this.gzCodeSize, "", "DisambiguateProperties: " + this.disambiguatePropertiesSummary, "AmbiguateProperties: " + this.ambiguatePropertiesSummary));
        output.println(JSCompStrings.lines("", "Inputs:", "JS lines:   " + this.jsLines, "JS sources: " + this.jsSources, "Extern lines:   " + this.externLines, "Extern sources: " + this.externSources));
        output.println(JSCompStrings.lines("", "Summary:", "pass,runtime,allocMem,runs,changingRuns,astReduction,reduction,gzReduction"));
        this.passSummary.entrySet().stream().sorted(Comparator.comparingLong(e -> ((Stats)e.getValue()).runtime)).map(entry -> {
            String key = (String)entry.getKey();
            Stats stats = (Stats)entry.getValue();
            return SimpleFormat.format("%s,%d,%d,%d,%d,%d,%d,%d", key, stats.runtime, stats.allocMem, stats.runs, stats.changes, stats.astDiff, stats.diff, stats.gzDiff);
        }).forEach(output::println);
        output.println(JSCompStrings.lines("", "Log:", "pass,runtime,allocMem,codeChanged,astReduction,reduction,gzReduction,astSize,size,gzSize"));
        for (Stats stats : this.log) {
            output.print(SimpleFormat.format("%s,%d,%d,%b,%d,%d,%d,%d,%d,%d\n", stats.pass, stats.runtime, stats.allocMem, stats.changes == 1, stats.astDiff, stats.diff, stats.gzDiff, stats.astSize, stats.size, stats.gzSize));
        }
        if (this.astManifest != null) {
            output.println(JSCompStrings.lines("", "Input AST Manifest:", "token,count"));
            this.astManifest.entrySet().stream().map(e -> SimpleFormat.format("%s,%d", e.getElement(), e.getCount())).sorted().forEach(output::println);
        }
        output.println();
        try {
            ((FilterOutputStream)output).flush();
        }
        catch (IOException e2) {
            throw new RuntimeException("Unreachable.", e2);
        }
    }

    public static class Stats {
        public final String pass;
        public final boolean isOneTime;
        public long runtime = 0L;
        public int allocMem = 0;
        public int runs = 0;
        public int changes = 0;
        public int diff = 0;
        public int gzDiff = 0;
        public int size = 0;
        public int gzSize = 0;
        public int astDiff = 0;
        public int astSize = 0;

        Stats(String pass, boolean iot) {
            this.pass = pass;
            this.isOneTime = iot;
        }
    }
}

