/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Ordering;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DependencyOptions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.ModuleIdentifier;
import com.google.javascript.jscomp.base.format.SimpleFormat;
import com.google.javascript.jscomp.deps.SortedDependencies;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.StaticSourceFile;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.nullness.Nullable;

public final class JSChunkGraph
implements Serializable {
    static final DiagnosticType WEAK_FILE_REACHABLE_FROM_ENTRY_POINT_ERROR = DiagnosticType.error("JSC_WEAK_FILE_REACHABLE_FROM_ENTRY_POINT_ERROR", "File strongly reachable from an entry point must not be weak: {0}");
    static final DiagnosticType EXPLICIT_WEAK_ENTRY_POINT_ERROR = DiagnosticType.error("JSC_EXPLICIT_WEAK_ENTRY_POINT_ERROR", "Explicit entry point input must not be weak: {0}");
    static final DiagnosticType IMPLICIT_WEAK_ENTRY_POINT_ERROR = DiagnosticType.warning("JSC_IMPLICIT_WEAK_ENTRY_POINT_ERROR", "Implicit entry point input should not be weak: {0}");
    private final JSChunk[] chunks;
    private final BitSet[] selfPlusTransitiveDeps;
    private final int[] subtreeSize;
    private final List<List<JSChunk>> chunksByDepth;
    private final IdentityHashMap<JSChunk, Set<JSChunk>> dependencyMap = new IdentityHashMap();

    public JSChunkGraph(JSChunk[] chunksInDepOrder) {
        this(Arrays.asList(chunksInDepOrder));
    }

    public JSChunkGraph(List<JSChunk> chunksInDepOrder) {
        Preconditions.checkState((!chunksInDepOrder.isEmpty() ? 1 : 0) != 0);
        chunksInDepOrder = this.makeWeakChunk(chunksInDepOrder);
        this.chunks = new JSChunk[chunksInDepOrder.size()];
        for (int chunkIndex = 0; chunkIndex < this.chunks.length; ++chunkIndex) {
            JSChunk chunk = chunksInDepOrder.get(chunkIndex);
            Preconditions.checkState((chunk.getIndex() == -1 ? 1 : 0) != 0, (String)"Chunk index already set: %s", (Object)chunk);
            chunk.setIndex(chunkIndex);
            this.chunks[chunkIndex] = chunk;
        }
        this.chunksByDepth = this.initChunksByDepth();
        this.selfPlusTransitiveDeps = this.initTransitiveDepsBitSets();
        this.subtreeSize = this.initSubtreeSize();
        JSChunkGraph.moveMarkedWeakSources(this.getChunkByName("$weak$"), this.getAllInputs());
    }

    private List<List<JSChunk>> initChunksByDepth() {
        ArrayList<List<JSChunk>> tmpChunksByDepth = new ArrayList<List<JSChunk>>();
        for (int chunkIndex = 0; chunkIndex < this.chunks.length; ++chunkIndex) {
            JSChunk chunk = this.chunks[chunkIndex];
            Preconditions.checkState((chunk.getDepth() == -1 ? 1 : 0) != 0, (String)"Chunk depth already set: %s", (Object)chunk);
            int depth = 0;
            for (JSChunk dep : chunk.getDependencies()) {
                int depDepth = dep.getDepth();
                if (depDepth < 0) {
                    throw new ChunkDependenceException(SimpleFormat.format("Chunks not in dependency order: %s preceded %s", chunk.getName(), dep.getName()), chunk, dep);
                }
                depth = Math.max(depth, depDepth + 1);
            }
            chunk.setDepth(depth);
            if (depth == tmpChunksByDepth.size()) {
                tmpChunksByDepth.add(new ArrayList());
            }
            ((List)tmpChunksByDepth.get(depth)).add(chunk);
        }
        return tmpChunksByDepth;
    }

    private List<JSChunk> makeWeakChunk(List<JSChunk> chunksInDepOrder) {
        boolean hasWeakChunk = false;
        for (JSChunk chunk : chunksInDepOrder) {
            if (!chunk.getName().equals("$weak$")) continue;
            hasWeakChunk = true;
            LinkedHashSet<JSChunk> allOtherChunks = new LinkedHashSet<JSChunk>(chunksInDepOrder);
            allOtherChunks.remove(chunk);
            Preconditions.checkState((boolean)chunk.getAllDependencies().containsAll(allOtherChunks), (Object)"A weak chunk already exists but it does not depend on every other chunk.");
            Preconditions.checkState((chunk.getAllDependencies().size() == allOtherChunks.size() ? 1 : 0) != 0, (Object)"The weak chunk cannot have extra dependencies.");
            break;
        }
        if (hasWeakChunk) {
            ArrayList<CallSite> misplacedWeakFiles = new ArrayList<CallSite>();
            ArrayList<String> misplacedStrongFiles = new ArrayList<String>();
            for (JSChunk chunk : chunksInDepOrder) {
                boolean isWeakChunk = chunk.getName().equals("$weak$");
                for (CompilerInput input : chunk.getInputs()) {
                    if (isWeakChunk && !input.getSourceFile().isWeak()) {
                        misplacedStrongFiles.add(input.getSourceFile().getName());
                        continue;
                    }
                    if (isWeakChunk || !input.getSourceFile().isWeak()) continue;
                    misplacedWeakFiles.add((CallSite)((Object)(input.getSourceFile().getName() + " (in chunk " + chunk.getName() + ")")));
                }
            }
            if (!misplacedStrongFiles.isEmpty() || !misplacedWeakFiles.isEmpty()) {
                StringBuilder sb = new StringBuilder("A weak chunk exists but some sources are misplaced.");
                if (!misplacedStrongFiles.isEmpty()) {
                    sb.append("\nFound these strong sources in the weak chunk:\n  ").append(Joiner.on((String)"\n  ").join(misplacedStrongFiles));
                }
                if (!misplacedWeakFiles.isEmpty()) {
                    sb.append("\nFound these weak sources in other chunks:\n  ").append(Joiner.on((String)"\n  ").join(misplacedWeakFiles));
                }
                throw new IllegalStateException(sb.toString());
            }
        } else {
            JSChunk weakChunk = new JSChunk("$weak$");
            for (JSChunk chunk : chunksInDepOrder) {
                weakChunk.addDependency(chunk);
            }
            chunksInDepOrder = new ArrayList<JSChunk>(chunksInDepOrder);
            chunksInDepOrder.add(weakChunk);
        }
        return chunksInDepOrder;
    }

    private BitSet[] initTransitiveDepsBitSets() {
        BitSet[] array = new BitSet[this.chunks.length];
        for (int chunkIndex = 0; chunkIndex < this.chunks.length; ++chunkIndex) {
            BitSet selfPlusTransitiveDeps;
            JSChunk chunk = this.chunks[chunkIndex];
            array[chunkIndex] = selfPlusTransitiveDeps = new BitSet(chunkIndex + 1);
            selfPlusTransitiveDeps.set(chunkIndex);
            for (JSChunk dep : chunk.getDependencies()) {
                selfPlusTransitiveDeps.or(array[dep.getIndex()]);
            }
        }
        return array;
    }

    private int[] initSubtreeSize() {
        int[] subtreeSize = new int[this.chunks.length];
        for (int dependentIndex = 0; dependentIndex < this.chunks.length; ++dependentIndex) {
            BitSet dependencies = this.selfPlusTransitiveDeps[dependentIndex];
            int requiredIndex = dependentIndex;
            while (requiredIndex >= 0) {
                int n = requiredIndex;
                subtreeSize[n] = subtreeSize[n] + 1;
                requiredIndex = dependencies.previousSetBit(requiredIndex - 1);
            }
        }
        return subtreeSize;
    }

    Iterable<CompilerInput> getAllInputs() {
        return Iterables.concat((Iterable)Iterables.transform(Arrays.asList(this.chunks), JSChunk::getInputs));
    }

    int getInputCount() {
        int count = 0;
        for (JSChunk chunk : this.chunks) {
            count += chunk.getInputCount();
        }
        return count;
    }

    Iterable<JSChunk> getAllChunks() {
        return Arrays.asList(this.chunks);
    }

    @Nullable JSChunk getChunkByName(String name) {
        for (JSChunk m : this.chunks) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    Map<String, JSChunk> getChunksByName() {
        LinkedHashMap<String, JSChunk> result = new LinkedHashMap<String, JSChunk>();
        for (JSChunk m : this.chunks) {
            result.put(m.getName(), m);
        }
        return result;
    }

    int getChunkCount() {
        return this.chunks.length;
    }

    JSChunk getRootChunk() {
        return (JSChunk)Iterables.getOnlyElement((Iterable)this.chunksByDepth.get(0));
    }

    @GwtIncompatible(value="com.google.gson")
    JsonArray toJson() {
        JsonArray chunks = new JsonArray();
        for (JSChunk chunk : this.getAllChunks()) {
            Object m2;
            JsonObject node = new JsonObject();
            node.add("name", (JsonElement)new JsonPrimitive(chunk.getName()));
            JsonArray deps = new JsonArray();
            node.add("dependencies", (JsonElement)deps);
            for (Object m2 : chunk.getDependencies()) {
                deps.add((JsonElement)new JsonPrimitive(((JSChunk)m2).getName()));
            }
            JsonArray transitiveDeps = new JsonArray();
            node.add("transitive-dependencies", (JsonElement)transitiveDeps);
            m2 = this.getTransitiveDepsDeepestFirst(chunk).iterator();
            while (m2.hasNext()) {
                JSChunk m3 = (JSChunk)m2.next();
                transitiveDeps.add((JsonElement)new JsonPrimitive(m3.getName()));
            }
            JsonArray inputs = new JsonArray();
            node.add("inputs", (JsonElement)inputs);
            for (CompilerInput input : chunk.getInputs()) {
                inputs.add((JsonElement)new JsonPrimitive(input.getSourceFile().getName()));
            }
            chunks.add((JsonElement)node);
        }
        return chunks;
    }

    public boolean dependsOn(JSChunk src, JSChunk m) {
        return src != m && this.selfPlusTransitiveDeps[src.getIndex()].get(m.getIndex());
    }

    public JSChunk getSmallestCoveringSubtree(JSChunk parentTree, BitSet dependentChunks) {
        int parentTreeIndex;
        Preconditions.checkState((!dependentChunks.isEmpty() ? 1 : 0) != 0);
        int minDependentChunkIndex = this.chunks.length;
        BitSet candidates = new BitSet(this.chunks.length);
        candidates.set(0, this.chunks.length, true);
        int dependentIndex = dependentChunks.nextSetBit(0);
        while (dependentIndex >= 0) {
            minDependentChunkIndex = Math.min(minDependentChunkIndex, dependentIndex);
            candidates.and(this.selfPlusTransitiveDeps[dependentIndex]);
            dependentIndex = dependentChunks.nextSetBit(dependentIndex + 1);
        }
        Preconditions.checkState((!candidates.isEmpty() ? 1 : 0) != 0, (String)"No common dependency found for %s", (Object)dependentChunks);
        int bestCandidateIndex = parentTreeIndex = parentTree.getIndex();
        int candidateIndex = candidates.previousSetBit(minDependentChunkIndex);
        while (candidateIndex >= 0) {
            BitSet candidatePlusTransitiveDeps = this.selfPlusTransitiveDeps[candidateIndex];
            if (candidatePlusTransitiveDeps.get(parentTreeIndex)) {
                candidates.andNot(candidatePlusTransitiveDeps);
                if (this.subtreeSize[candidateIndex] < this.subtreeSize[bestCandidateIndex]) {
                    bestCandidateIndex = candidateIndex;
                }
            }
            candidateIndex = candidates.previousSetBit(candidateIndex - 1);
        }
        return this.chunks[bestCandidateIndex];
    }

    @Nullable JSChunk getDeepestCommonDependency(JSChunk m1, JSChunk m2) {
        int m1Depth = m1.getDepth();
        int m2Depth = m2.getDepth();
        for (int depth = Math.min(m1Depth, m2Depth) - 1; depth >= 0; --depth) {
            List<JSChunk> chunksAtDepth = this.chunksByDepth.get(depth);
            for (int i = chunksAtDepth.size() - 1; i >= 0; --i) {
                JSChunk m = chunksAtDepth.get(i);
                if (!this.dependsOn(m1, m) || !this.dependsOn(m2, m)) continue;
                return m;
            }
        }
        return null;
    }

    public JSChunk getDeepestCommonDependencyInclusive(JSChunk m1, JSChunk m2) {
        if (m2 == m1 || this.dependsOn(m2, m1)) {
            return m1;
        }
        if (this.dependsOn(m1, m2)) {
            return m2;
        }
        return this.getDeepestCommonDependency(m1, m2);
    }

    public JSChunk getDeepestCommonDependencyInclusive(Collection<JSChunk> chunks) {
        Iterator<JSChunk> iter = chunks.iterator();
        JSChunk dep = iter.next();
        while (iter.hasNext()) {
            dep = this.getDeepestCommonDependencyInclusive(dep, iter.next());
        }
        return dep;
    }

    @VisibleForTesting
    List<JSChunk> getTransitiveDepsDeepestFirst(JSChunk m) {
        return InverseDepthComparator.INSTANCE.sortedCopy(this.getTransitiveDeps(m));
    }

    private Set<JSChunk> getTransitiveDeps(JSChunk m) {
        return this.dependencyMap.computeIfAbsent(m, JSChunk::getAllDependencies);
    }

    private static void moveMarkedWeakSources(JSChunk weakChunk, Iterable<CompilerInput> inputs) {
        Preconditions.checkNotNull((Object)weakChunk);
        ImmutableList allInputs = ImmutableList.copyOf(inputs);
        for (CompilerInput i : allInputs) {
            JSChunk existingChunk;
            if (!i.getSourceFile().isWeak() || (existingChunk = i.getChunk()) == weakChunk) continue;
            if (existingChunk != null) {
                existingChunk.remove(i);
            }
            weakChunk.add(i);
        }
    }

    public ImmutableList<CompilerInput> manageDependencies(AbstractCompiler compiler, DependencyOptions dependencyOptions) throws SortedDependencies.MissingProvideException, MissingChunkException {
        ImmutableList originalInputs = ImmutableList.copyOf(this.getAllInputs());
        SortedDependencies<CompilerInput> sorter = new SortedDependencies<CompilerInput>((List<CompilerInput>)originalInputs);
        Set<CompilerInput> entryPointInputs = this.createEntryPointInputs(compiler, dependencyOptions, this.getAllInputs(), sorter);
        LinkedHashMap<String, Set<CompilerInput>> inputsByProvide = new LinkedHashMap<String, Set<CompilerInput>>();
        for (CompilerInput input : originalInputs) {
            for (String provide : input.getKnownProvides()) {
                inputsByProvide.computeIfAbsent(provide, k -> new LinkedHashSet());
                ((Set)inputsByProvide.get(provide)).add(input);
            }
            String chunkName = input.getPath().toModuleName();
            inputsByProvide.computeIfAbsent(chunkName, k -> new LinkedHashSet());
            ((Set)inputsByProvide.get(chunkName)).add(input);
        }
        for (CompilerInput input : originalInputs) {
            for (String require : input.getDynamicRequires()) {
                if (!inputsByProvide.containsKey(require)) continue;
                entryPointInputs.addAll((Collection)inputsByProvide.get(require));
            }
        }
        for (CompilerInput input : originalInputs) {
            for (String require : input.getRequireDynamicImports()) {
                if (!inputsByProvide.containsKey(require)) continue;
                entryPointInputs.addAll((Collection)inputsByProvide.get(require));
            }
        }
        ImmutableList<CompilerInput> absoluteOrder = sorter.getStrongDependenciesOf((List<CompilerInput>)originalInputs, dependencyOptions.shouldSort());
        LinkedListMultimap entryPointInputsPerChunk = LinkedListMultimap.create();
        for (CompilerInput input : entryPointInputs) {
            JSChunk[] chunk = input.getChunk();
            Preconditions.checkNotNull((Object)chunk);
            entryPointInputsPerChunk.put((Object)chunk, (Object)input);
        }
        for (JSChunk chunk : this.getAllChunks()) {
            chunk.removeAll();
        }
        ArrayList<CompilerInput> orderedInputs = new ArrayList<CompilerInput>();
        LinkedHashSet<CompilerInput> reachedInputs = new LinkedHashSet<CompilerInput>();
        for (JSChunk chunk : this.chunks) {
            ArrayList<CompilerInput> transitiveClosure;
            if (dependencyOptions.shouldSort() && dependencyOptions.shouldPrune()) {
                transitiveClosure = new ArrayList<CompilerInput>();
                LinkedHashSet<CompilerInput> inputsNotYetReached = new LinkedHashSet<CompilerInput>((Collection<CompilerInput>)originalInputs);
                for (CompilerInput entryPoint : entryPointInputsPerChunk.get((Object)chunk)) {
                    transitiveClosure.addAll(this.getDepthFirstDependenciesOf(entryPoint, inputsNotYetReached, inputsByProvide));
                }
                for (CompilerInput orderedInput : transitiveClosure) {
                    if (!reachedInputs.add(orderedInput)) continue;
                    orderedInputs.add(orderedInput);
                }
            } else {
                transitiveClosure = sorter.getStrongDependenciesOf(entryPointInputsPerChunk.get((Object)chunk), dependencyOptions.shouldSort());
            }
            for (CompilerInput input : transitiveClosure) {
                JSChunk oldChunk;
                if (dependencyOptions.shouldPrune() && input.getSourceFile().isWeak() && !entryPointInputs.contains(input)) {
                    compiler.report(JSError.make(WEAK_FILE_REACHABLE_FROM_ENTRY_POINT_ERROR, input.getSourceFile().getName()));
                }
                if ((oldChunk = input.getChunk()) == null) {
                    input.setChunk(chunk);
                    continue;
                }
                input.setChunk(null);
                input.setChunk(this.getDeepestCommonDependencyInclusive(oldChunk, chunk));
            }
        }
        if (!dependencyOptions.shouldSort() || !dependencyOptions.shouldPrune() || entryPointInputsPerChunk.isEmpty()) {
            orderedInputs = absoluteOrder;
        }
        JSChunk weakChunk = this.getChunkByName("$weak$");
        Preconditions.checkNotNull((Object)weakChunk);
        if (dependencyOptions.shouldPrune()) {
            ImmutableList<CompilerInput> weakInputs = sorter.getSortedWeakDependenciesOf(orderedInputs);
            for (CompilerInput i : weakInputs) {
                Preconditions.checkState((i.getChunk() == null ? 1 : 0) != 0);
                i.getSourceFile().setKind(StaticSourceFile.SourceKind.WEAK);
                i.setChunk(weakChunk);
                weakChunk.add(i);
            }
        } else {
            JSChunkGraph.moveMarkedWeakSources(weakChunk, (Iterable<CompilerInput>)originalInputs);
        }
        for (CompilerInput input : orderedInputs) {
            JSChunk chunk;
            chunk = input.getChunk();
            if (chunk == null || chunk.getByName(input.getName()) != null) continue;
            chunk.add(input);
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (JSChunk chunk : this.getAllChunks()) {
            result.addAll(chunk.getInputs());
        }
        return result.build();
    }

    private List<CompilerInput> getDepthFirstDependenciesOf(CompilerInput rootInput, Set<CompilerInput> unreachedInputs, Map<String, Set<CompilerInput>> inputsByProvide) {
        ArrayList<CompilerInput> orderedInputs = new ArrayList<CompilerInput>();
        if (!unreachedInputs.remove(rootInput)) {
            return orderedInputs;
        }
        for (String importedNamespace : rootInput.getRequiredSymbols()) {
            if (!inputsByProvide.containsKey(importedNamespace)) continue;
            for (CompilerInput input : inputsByProvide.get(importedNamespace)) {
                if (!unreachedInputs.contains(input)) continue;
                orderedInputs.addAll(this.getDepthFirstDependenciesOf(input, unreachedInputs, inputsByProvide));
            }
        }
        orderedInputs.add(rootInput);
        return orderedInputs;
    }

    private Set<CompilerInput> createEntryPointInputs(AbstractCompiler compiler, DependencyOptions dependencyOptions, Iterable<CompilerInput> inputs, SortedDependencies<CompilerInput> sorter) throws MissingChunkException, SortedDependencies.MissingProvideException {
        LinkedHashSet<CompilerInput> entryPointInputs = new LinkedHashSet<CompilerInput>();
        Map<String, JSChunk> chunksByName = this.getChunksByName();
        if (dependencyOptions.shouldPrune()) {
            CompilerInput baseJs = sorter.maybeGetInputProviding("goog");
            if (baseJs != null) {
                entryPointInputs.add(baseJs);
            }
            if (!dependencyOptions.shouldDropMoochers()) {
                for (CompilerInput entryPointInput : sorter.getInputsWithoutProvides()) {
                    if (entryPointInput.getSourceFile().isWeak()) {
                        compiler.report(JSError.make(IMPLICIT_WEAK_ENTRY_POINT_ERROR, entryPointInput.getSourceFile().getName()));
                        continue;
                    }
                    entryPointInputs.add(entryPointInput);
                }
            }
            for (ModuleIdentifier entryPoint : dependencyOptions.getEntryPoints()) {
                CompilerInput entryPointInput = null;
                try {
                    if (entryPoint.getClosureNamespace().equals(entryPoint.getModuleName())) {
                        entryPointInput = sorter.maybeGetInputProviding(entryPoint.getClosureNamespace());
                        if (entryPointInput == null) {
                            entryPointInput = sorter.getInputProviding(entryPoint.getName());
                        }
                    } else {
                        JSChunk chunk = chunksByName.get(entryPoint.getModuleName());
                        if (chunk == null) {
                            throw new MissingChunkException(entryPoint.getModuleName());
                        }
                        entryPointInput = sorter.getInputProviding(entryPoint.getClosureNamespace());
                        entryPointInput.overrideModule(chunk);
                    }
                }
                catch (SortedDependencies.MissingProvideException e) {
                    throw new SortedDependencies.MissingProvideException(entryPoint.getName(), e);
                }
                if (entryPointInput.getSourceFile().isWeak()) {
                    compiler.report(JSError.make(EXPLICIT_WEAK_ENTRY_POINT_ERROR, entryPointInput.getSourceFile().getName()));
                    continue;
                }
                entryPointInputs.add(entryPointInput);
            }
        } else {
            Iterables.addAll(entryPointInputs, inputs);
        }
        return entryPointInputs;
    }

    LinkedDirectedGraph<JSChunk, String> toGraphvizGraph() {
        LinkedDirectedGraph<JSChunk, String> graphViz = LinkedDirectedGraph.create();
        for (JSChunk chunk : this.getAllChunks()) {
            graphViz.createNode((Object)chunk);
            for (JSChunk dep : chunk.getDependencies()) {
                graphViz.createNode((Object)dep);
                graphViz.connect(chunk, "->", dep);
            }
        }
        return graphViz;
    }

    private static int depthCompare(JSChunk m1, JSChunk m2) {
        int d2;
        if (m1 == m2) {
            return 0;
        }
        int d1 = m1.getDepth();
        return d1 < (d2 = m2.getDepth()) ? -1 : (d2 == d1 ? m1.getName().compareTo(m2.getName()) : 1);
    }

    protected static class ChunkDependenceException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        private final JSChunk chunk;
        private final JSChunk dependentChunk;

        protected ChunkDependenceException(String message, JSChunk chunk, JSChunk dependentChunk) {
            super(message);
            this.chunk = chunk;
            this.dependentChunk = dependentChunk;
        }

        public JSChunk getChunk() {
            return this.chunk;
        }

        public JSChunk getDependentChunk() {
            return this.dependentChunk;
        }
    }

    private static final class InverseDepthComparator
    extends Ordering<JSChunk> {
        static final InverseDepthComparator INSTANCE = new InverseDepthComparator();

        private InverseDepthComparator() {
        }

        public int compare(JSChunk m1, JSChunk m2) {
            return JSChunkGraph.depthCompare(m2, m1);
        }
    }

    public static class MissingChunkException
    extends Exception {
        MissingChunkException(String chunkName) {
            super(chunkName);
        }
    }
}

