/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.J2clSourceFileChecker;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ProcessDefines;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

public class J2clUtilGetDefineRewriterPass
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private ImmutableSet<String> defines;

    public J2clUtilGetDefineRewriterPass(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        if (!J2clSourceFileChecker.shouldRunJ2clPasses(this.compiler)) {
            return;
        }
        this.defines = new ProcessDefines.Builder(this.compiler).setMode(ProcessDefines.Mode.OPTIMIZE).build().collectDefineNames(externs, root);
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (J2clUtilGetDefineRewriterPass.isUtilGetDefineCall(n)) {
            this.rewriteUtilGetDefine(t, n);
        }
    }

    private void rewriteUtilGetDefine(NodeTraversal t, Node callNode) {
        Node firstExpr = callNode.getSecondChild();
        Node secondExpr = callNode.getLastChild();
        if (secondExpr != firstExpr) {
            secondExpr.detach();
        } else {
            secondExpr = IR.nullNode();
        }
        Node replacement = this.getDefineReplacement(firstExpr, secondExpr);
        replacement.srcrefTreeIfMissing(callNode);
        callNode.replaceWith(replacement);
        t.reportCodeChange();
    }

    private Node getDefineReplacement(Node firstExpr, Node secondExpr) {
        if (this.defines.contains((Object)firstExpr.getString())) {
            Node define = NodeUtil.newQName(this.compiler, firstExpr.getString());
            Node defineStringValue = NodeUtil.newCallNode(IR.name("String"), define);
            return IR.comma(secondExpr, defineStringValue);
        }
        return secondExpr;
    }

    private static boolean isUtilGetDefineCall(Node n) {
        return n.isCall() && J2clUtilGetDefineRewriterPass.isUtilGetDefineMethodName(n.getFirstChild().getQualifiedName());
    }

    private static boolean isUtilGetDefineMethodName(String fnName) {
        return fnName != null && fnName.endsWith(".$getDefine") && fnName.contains("Util");
    }
}

