/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolyfillUsageFinder;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.resources.ResourceLoader;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.LinkedHashSet;

class IsolatePolyfills
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final PolyfillUsageFinder.Polyfills polyfills;
    private final Node jscompPolyfillsObject;
    private static final String POLYFILL_TEMP = "$jscomp$polyfillTmp";
    private final Node jscompLookupMethod = IR.name("$jscomp$lookupPolyfilledValue");
    private boolean usedPolyfillMethodLookup = false;
    private boolean isTempVarInitialized = false;
    private static final ImmutableSet<String> FILES_ALLOWED_UNQUALIFIED_POLYFILL_ACCESSES = ImmutableSet.of((Object)"src/com/google/javascript/jscomp/js/util/global.js", (Object)"src/com/google/javascript/jscomp/js/util/shouldpolyfill.js", (Object)"src/com/google/javascript/jscomp/js/es6/util/construct.js");

    IsolatePolyfills(AbstractCompiler compiler) {
        this(compiler, PolyfillUsageFinder.Polyfills.fromTable(ResourceLoader.loadTextResource(IsolatePolyfills.class, "js/polyfills.txt")));
    }

    @VisibleForTesting
    IsolatePolyfills(AbstractCompiler compiler, PolyfillUsageFinder.Polyfills polyfills) {
        this.compiler = compiler;
        this.polyfills = polyfills;
        boolean hasPropertyCollapsingRun = compiler.getOptions().getPropertyCollapseLevel().equals((Object)CompilerOptions.PropertyCollapseLevel.ALL);
        this.jscompPolyfillsObject = hasPropertyCollapsingRun ? IsolatePolyfills.createCollapsedName() : IsolatePolyfills.createJSCompPolyfillsAccess();
    }

    private static Node createCollapsedName() {
        Node collapsedName = IR.name("$jscomp$polyfills");
        collapsedName.putBooleanProp(Node.IS_CONSTANT_NAME, true);
        return collapsedName;
    }

    private static Node createJSCompPolyfillsAccess() {
        Node jscomp = IR.name("$jscomp");
        jscomp.putBooleanProp(Node.IS_CONSTANT_NAME, true);
        return IR.getprop(jscomp, "polyfills");
    }

    @Override
    public void process(Node externs, Node root) {
        ImmutableSet<String> injectedPolyfills = this.findAllInjectedPolyfills();
        ArrayList polyfillUsages = new ArrayList();
        new PolyfillUsageFinder(this.compiler, this.polyfills).traverseIncludingGuarded(root, polyfillUsages::add);
        LinkedHashSet<Node> visitedNodes = new LinkedHashSet<Node>();
        for (PolyfillUsageFinder.PolyfillUsage usage : polyfillUsages) {
            if (visitedNodes.contains(usage.node()) || usage.polyfill().library.isEmpty() || !injectedPolyfills.contains((Object)usage.polyfill().nativeSymbol)) continue;
            this.rewritePolyfill(usage);
            visitedNodes.add(usage.node());
        }
        this.cleanUpJscompLookupPolyfilledValue();
    }

    private ImmutableSet<String> findAllInjectedPolyfills() {
        final ImmutableSet.Builder actualPolyfills = ImmutableSet.builder();
        Node lastInjectedNode = this.compiler.getNodeForCodeInsertion(null);
        NodeTraversal.traverse(this.compiler, lastInjectedNode, new NodeTraversal.AbstractShallowCallback(){

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (IsolatePolyfills.this.isJSCompPolyfillCall(n)) {
                    String polyfilledSymbol = n.getSecondChild().getString();
                    actualPolyfills.add((Object)polyfilledSymbol);
                }
            }
        });
        return actualPolyfills.build();
    }

    private boolean isJSCompPolyfillCall(Node call) {
        if (!call.isCall()) {
            return false;
        }
        String jscompPolyfillName = this.compiler.getOptions().getPropertyCollapseLevel().equals((Object)CompilerOptions.PropertyCollapseLevel.ALL) ? "$jscomp$polyfill" : "$jscomp.polyfill";
        return call.getFirstChild().matchesQualifiedName(jscompPolyfillName);
    }

    private void rewritePolyfill(PolyfillUsageFinder.PolyfillUsage polyfillUsage) {
        boolean isGlobalClass;
        PolyfillUsageFinder.Polyfill polyfill = polyfillUsage.polyfill();
        if (this.compiler.getOptions().getOutputFeatureSet().contains(FeatureSet.valueOf(polyfill.nativeVersion))) {
            return;
        }
        Node polyfillAccess = polyfillUsage.node();
        Node parent = polyfillUsage.node().getParent();
        if (FILES_ALLOWED_UNQUALIFIED_POLYFILL_ACCESSES.contains((Object)polyfillAccess.getSourceFileName())) {
            return;
        }
        if (NodeUtil.isLValue(polyfillAccess) || parent.isAssign() && polyfillAccess.isFirstChildOf(parent)) {
            return;
        }
        String name = polyfillUsage.name();
        boolean bl = isGlobalClass = name.indexOf(46) == -1 && polyfill.kind.equals((Object)PolyfillUsageFinder.Polyfill.Kind.STATIC);
        if (isGlobalClass) {
            polyfillAccess.replaceWith(IR.getelem(this.jscompPolyfillsObject.cloneTree(), IR.string(name)).srcrefTree(polyfillAccess));
        } else if ((parent.isCall() || parent.isOptChainCall()) && polyfillAccess.isFirstChildOf(parent)) {
            this.rewritePolyfillInCall(polyfillAccess);
        } else {
            Node methodName = IR.string(polyfillAccess.getString()).srcref(polyfillAccess);
            Node receiver = polyfillAccess.removeFirstChild();
            polyfillAccess.replaceWith(this.createPolyfillMethodLookup(receiver, methodName, NodeUtil.isOptChainNode(polyfillAccess)).srcrefTree(polyfillAccess));
        }
        this.compiler.reportChangeToEnclosingScope(parent);
    }

    private void rewritePolyfillInCall(Node callee) {
        Node polyfilledMethod;
        Node thisNode;
        Node methodName = IR.string(callee.getString()).srcref(callee);
        Node receiver = callee.removeFirstChild();
        boolean isCalleeOptChain = NodeUtil.isOptChainNode(callee);
        boolean requiresTemp = this.compiler.getAstAnalyzer().mayEffectMutableState(receiver);
        if (requiresTemp) {
            thisNode = this.createTempName(callee);
            polyfilledMethod = IR.comma(IR.assign(thisNode.cloneTree(), receiver), this.createPolyfillMethodLookup(thisNode.cloneTree(), methodName, isCalleeOptChain));
        } else {
            thisNode = receiver;
            polyfilledMethod = this.createPolyfillMethodLookup(receiver.cloneTree(), methodName, isCalleeOptChain);
        }
        Node receiverDotCall = NodeUtil.isOptChainNode(callee) ? IR.startOptChainGetprop(polyfilledMethod, "call").srcrefTree(callee) : IR.getprop(polyfilledMethod, "call").srcrefTree(callee);
        callee.replaceWith(receiverDotCall);
        thisNode.insertAfter(receiverDotCall);
    }

    private Node createTempName(Node srcref) {
        if (!this.isTempVarInitialized) {
            this.isTempVarInitialized = true;
            Node decl = IR.var(IR.name(POLYFILL_TEMP)).srcrefTree(srcref);
            this.compiler.getNodeForCodeInsertion(null).addChildToFront(decl);
        }
        return IR.name(POLYFILL_TEMP).srcref(srcref);
    }

    private Node createPolyfillMethodLookup(Node receiver, Node methodName, boolean isOptChainNode) {
        this.usedPolyfillMethodLookup = true;
        Node call = isOptChainNode ? IR.call(this.jscompLookupMethod.cloneTree(), receiver, methodName, IR.trueNode()) : IR.call(this.jscompLookupMethod.cloneTree(), receiver, methodName);
        call.putBooleanProp(Node.FREE_CALL, true);
        return call;
    }

    private void cleanUpJscompLookupPolyfilledValue() {
        Node syntheticExternsRoot = this.compiler.getSynthesizedExternsInput().getAstRoot(this.compiler);
        Scope syntheticExternsScope = new SyntacticScopeCreator(this.compiler).createScope(syntheticExternsRoot, (Scope)null);
        Var externVar = (Var)Preconditions.checkNotNull((Object)((Var)syntheticExternsScope.getVar(this.jscompLookupMethod.getString())), (Object)"Failed to find synthetic $jscomp$lookupPolyfilledValue extern");
        NodeUtil.deleteNode(externVar.getParentNode(), this.compiler);
        if (this.usedPolyfillMethodLookup) {
            return;
        }
        Scope syntheticCodeScope = new SyntacticScopeCreator(this.compiler).createScope(this.compiler.getNodeForCodeInsertion(null), (Scope)null);
        Var syntheticVar = (Var)syntheticCodeScope.getVar(this.jscompLookupMethod.getString());
        if (syntheticVar != null) {
            NodeUtil.deleteNode(syntheticVar.getParentNode(), this.compiler);
        }
    }
}

