/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.javascript.jscomp.JsMessage;
import java.nio.charset.StandardCharsets;
import java.util.List;

public final class GoogleJsMessageIdGenerator
implements JsMessage.IdGenerator {
    private final String projectId;

    public GoogleJsMessageIdGenerator(String projectId) {
        this.projectId = projectId;
    }

    @Override
    public String generateId(String meaning, List<JsMessage.Part> messageParts) {
        Preconditions.checkState((meaning != null ? 1 : 0) != 0);
        StringBuilder sb = new StringBuilder();
        for (JsMessage.Part part : messageParts) {
            if (part.isPlaceholder()) {
                sb.append(part.getCanonicalPlaceholderName());
                continue;
            }
            sb.append(part.getString());
        }
        String tcValue = sb.toString();
        String projectScopedMeaning = (String)(Strings.isNullOrEmpty((String)this.projectId) ? "" : this.projectId + ": ") + meaning;
        return String.valueOf(MessageId.generateId(tcValue, projectScopedMeaning));
    }

    private static class MessageId {
        private MessageId() {
        }

        private static final long generateId(String message, String meaning) {
            long fp = FP.fingerprint(message);
            if (null != meaning && meaning.length() > 0) {
                long fp2 = FP.fingerprint(meaning);
                fp = fp2 + (fp << 1) + (long)(fp < 0L ? 1 : 0);
            }
            return fp & Long.MAX_VALUE;
        }
    }

    private static final class FP {
        private FP() {
        }

        private static long fingerprint(byte[] str, int start, int limit) {
            int hi = FP.hash32(str, start, limit, 0);
            int lo = FP.hash32(str, start, limit, 102072);
            if (hi == 0 && (lo == 0 || lo == 1)) {
                hi ^= 0x130F9BEF;
                lo ^= 0x94A0A928;
            }
            return (long)hi << 32 | (long)lo & 0xFFFFFFFFL;
        }

        private static long fingerprint(String str) {
            byte[] tmp = str.getBytes(StandardCharsets.UTF_8);
            return FP.fingerprint(tmp, 0, tmp.length);
        }

        private static int hash32(byte[] str, int start, int limit, int c) {
            int a = -1640531527;
            int b = -1640531527;
            int i = start;
            while (i + 12 <= limit) {
                a += (str[i + 0] & 0xFF) << 0 | (str[i + 1] & 0xFF) << 8 | (str[i + 2] & 0xFF) << 16 | (str[i + 3] & 0xFF) << 24;
                a -= (b += (str[i + 4] & 0xFF) << 0 | (str[i + 5] & 0xFF) << 8 | (str[i + 6] & 0xFF) << 16 | (str[i + 7] & 0xFF) << 24);
                a -= (c += (str[i + 8] & 0xFF) << 0 | (str[i + 9] & 0xFF) << 8 | (str[i + 10] & 0xFF) << 16 | (str[i + 11] & 0xFF) << 24);
                b -= c;
                b -= (a ^= c >>> 13);
                c -= a;
                c -= (b ^= a << 8);
                a -= b;
                a -= (c ^= b >>> 13);
                b -= c;
                b -= (a ^= c >>> 12);
                c -= a;
                c -= (b ^= a << 16);
                a -= b;
                a -= (c ^= b >>> 5);
                b -= c;
                b -= (a ^= c >>> 3);
                c -= a;
                c -= (b ^= a << 10);
                c ^= b >>> 15;
                i += 12;
            }
            c += limit - start;
            int tmp = limit - i;
            if (tmp == 11) {
                c += (str[i + 10] & 0xFF) << 24;
            }
            if (tmp >= 10) {
                c += (str[i + 9] & 0xFF) << 16;
            }
            if (tmp >= 9) {
                c += (str[i + 8] & 0xFF) << 8;
            }
            if (tmp >= 8) {
                b += (str[i + 7] & 0xFF) << 24;
            }
            if (tmp >= 7) {
                b += (str[i + 6] & 0xFF) << 16;
            }
            if (tmp >= 6) {
                b += (str[i + 5] & 0xFF) << 8;
            }
            if (tmp >= 5) {
                b += str[i + 4] & 0xFF;
            }
            if (tmp >= 4) {
                a += (str[i + 3] & 0xFF) << 24;
            }
            if (tmp >= 3) {
                a += (str[i + 2] & 0xFF) << 16;
            }
            if (tmp >= 2) {
                a += (str[i + 1] & 0xFF) << 8;
            }
            if (tmp >= 1) {
                a += str[i + 0] & 0xFF;
            }
            a -= b;
            a -= c;
            b -= c;
            b -= (a ^= c >>> 13);
            c -= a;
            c -= (b ^= a << 8);
            a -= b;
            a -= (c ^= b >>> 13);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 16);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 3);
            c -= a;
            c -= (b ^= a << 10);
            return c ^= b >>> 15;
        }
    }
}

