/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Table;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import org.jspecify.nullness.Nullable;

final class Es6RenameTypeReferences
extends NodeTraversal.AbstractPostOrderCallback {
    private final Table<Node, String, String> renameTable;

    Es6RenameTypeReferences(Table<Node, String, String> renameTable) {
        this.renameTable = renameTable;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo info = n.getJSDocInfo();
        if (info != null) {
            for (Node root : info.getTypeNodes()) {
                this.renameTypeNodeRecursive(t, root);
            }
        }
    }

    private void renameTypeNodeRecursive(NodeTraversal t, Node n) {
        if (n.isStringLit()) {
            this.renameTypeReference(t, n);
        }
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            this.renameTypeNodeRecursive(t, child);
        }
    }

    private void renameTypeReference(NodeTraversal t, Node n) {
        String rest;
        String rootName;
        Preconditions.checkState((boolean)n.isStringLit());
        String fullName = n.getString();
        int endPos = fullName.indexOf(46);
        if (endPos == -1) {
            rootName = fullName;
            rest = null;
        } else {
            rootName = fullName.substring(0, endPos);
            rest = fullName.substring(endPos);
        }
        this.renameReference(t, n, rootName, rest);
    }

    private void renameReference(NodeTraversal t, Node n, String oldName, @Nullable String rest) {
        for (Scope current = t.getScope(); current != null; current = current.getParent()) {
            Node currentRootNode = current.getRootNode();
            String newName = (String)this.renameTable.get((Object)currentRootNode, (Object)oldName);
            if (newName != null) {
                Preconditions.checkState((currentRootNode.isModuleBody() || currentRootNode.isScript() || NodeUtil.isFunctionBlock(currentRootNode) ? 1 : 0) != 0, (String)"Not a MODULE_BODY or SCRIPT or goog.loadModule root: %s", (Object)currentRootNode);
                String newFullName = rest == null ? newName : newName + rest;
                n.setString(newFullName);
                return;
            }
            if (!current.hasOwnSlot(oldName)) continue;
            return;
        }
    }
}

