/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.Platform;
import java.io.Serializable;

public final class DiagnosticType
implements Comparable<DiagnosticType>,
Serializable {
    private static final long serialVersionUID = 1L;
    public final String key;
    public final String format;
    public final CheckLevel level;

    public static DiagnosticType error(String name, String descriptionFormat) {
        return DiagnosticType.make(name, CheckLevel.ERROR, descriptionFormat);
    }

    public static DiagnosticType warning(String name, String descriptionFormat) {
        return DiagnosticType.make(name, CheckLevel.WARNING, descriptionFormat);
    }

    public static DiagnosticType disabled(String name, String descriptionFormat) {
        return DiagnosticType.make(name, CheckLevel.OFF, descriptionFormat);
    }

    public static DiagnosticType make(String name, CheckLevel level, String descriptionFormat) {
        return new DiagnosticType(name, level, descriptionFormat);
    }

    private DiagnosticType(String key, CheckLevel level, String format) {
        this.key = key;
        this.level = level;
        this.format = format;
    }

    String format(String ... arguments) {
        return Platform.formatMessage(this.format, arguments);
    }

    public boolean equals(Object type) {
        return type instanceof DiagnosticType && ((DiagnosticType)type).key.equals(this.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public int compareTo(DiagnosticType diagnosticType) {
        return this.key.compareTo(diagnosticType.key);
    }

    public String toString() {
        return this.key + ": " + this.format;
    }
}

