/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

class CreateSyntheticBlocks
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType UNMATCHED_START_MARKER = DiagnosticType.error("JSC_UNMATCHED_START_MARKER", "Unmatched {0}");
    static final DiagnosticType UNMATCHED_END_MARKER = DiagnosticType.error("JSC_UNMATCHED_END_MARKER", "Unmatched {1} - {0} not in the same block");
    static final DiagnosticType INVALID_MARKER_USAGE = DiagnosticType.error("JSC_INVALID_MARKER_USAGE", "Marker {0} can only be used in a simple call expression");
    private final AbstractCompiler compiler;
    private final String startMarkerName;
    private final String endMarkerName;
    private final Deque<Node> markerStack = new ArrayDeque<Node>();
    private final List<Marker> validMarkers = new ArrayList<Marker>();

    public CreateSyntheticBlocks(AbstractCompiler compiler, String startMarkerName, String endMarkerName) {
        this.compiler = compiler;
        this.startMarkerName = startMarkerName;
        this.endMarkerName = endMarkerName;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        for (Node node : this.markerStack) {
            this.compiler.report(JSError.make(node, UNMATCHED_START_MARKER, this.startMarkerName));
        }
        for (Marker marker : this.validMarkers) {
            this.addBlocks(marker);
        }
    }

    private void rewriteFunctionDeclaration(Node n) {
        Node oldNameNode = n.getFirstChild();
        Node fnNameNode = oldNameNode.cloneNode();
        Node var = IR.var(fnNameNode).srcref(n);
        oldNameNode.setString("");
        this.compiler.reportChangeToEnclosingScope(oldNameNode);
        Node parent = n.getParent();
        n.detach();
        parent.addChildToFront(var);
        this.compiler.reportChangeToEnclosingScope(var);
        fnNameNode.addChildToFront(n);
    }

    private void rewriteFunctionDeclarationsInBlock(Node block) {
        Preconditions.checkState((boolean)block.isBlock());
        Node next = null;
        Node current = block.getFirstChild();
        while (current != null) {
            next = current.getNext();
            if (NodeUtil.isFunctionDeclaration(current)) {
                this.rewriteFunctionDeclaration(current);
            }
            current = next;
        }
    }

    private void addBlocks(Marker marker) {
        Node outerBlock = IR.block().srcref(marker.startMarker);
        outerBlock.setIsSyntheticBlock(true);
        outerBlock.insertBefore(marker.startMarker);
        Node innerBlock = IR.block().srcref(marker.startMarker);
        innerBlock.setIsSyntheticBlock(true);
        this.moveSiblingExclusive(innerBlock, marker.startMarker, marker.endMarker);
        outerBlock.addChildToBack(outerBlock.getNext().detach());
        outerBlock.addChildToBack(innerBlock);
        outerBlock.addChildToBack(outerBlock.getNext().detach());
        this.rewriteFunctionDeclarationsInBlock(innerBlock);
        this.compiler.reportChangeToEnclosingScope(outerBlock);
    }

    private void moveSiblingExclusive(Node dest, Node start, Node end) {
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)end);
        while (start.getNext() != end) {
            Node child = start.getNext().detach();
            dest.addChildToBack(child);
        }
    }

    @Override
    public void visit(NodeTraversal unused, Node n, Node parent) {
        if (!n.isCall() || !n.getFirstChild().isName()) {
            return;
        }
        Node callTarget = n.getFirstChild();
        String callName = callTarget.getString();
        if (this.startMarkerName.equals(callName)) {
            if (!parent.isExprResult()) {
                this.compiler.report(JSError.make(n, INVALID_MARKER_USAGE, this.startMarkerName));
                return;
            }
            this.markerStack.push(parent);
            return;
        }
        if (!this.endMarkerName.equals(callName)) {
            return;
        }
        Node endMarkerNode = parent;
        if (!endMarkerNode.isExprResult()) {
            this.compiler.report(JSError.make(n, INVALID_MARKER_USAGE, this.endMarkerName));
            return;
        }
        if (this.markerStack.isEmpty()) {
            this.compiler.report(JSError.make(n, UNMATCHED_END_MARKER, this.startMarkerName, this.endMarkerName));
            return;
        }
        Node startMarkerNode = this.markerStack.pop();
        if (endMarkerNode.getParent() != startMarkerNode.getParent()) {
            this.compiler.report(JSError.make(n, UNMATCHED_END_MARKER, this.startMarkerName, this.endMarkerName));
            return;
        }
        this.validMarkers.add(new Marker(startMarkerNode, endMarkerNode));
    }

    private static class Marker {
        final Node startMarker;
        final Node endMarker;

        public Marker(Node startMarker, Node endMarker) {
            this.startMarker = startMarker;
            this.endMarker = endMarker;
        }
    }
}

