/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckConformance;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Requirement;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopedAliases;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.TemplateAstMatcher;
import com.google.javascript.jscomp.TypeMatchingStrategy;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.JsDocInfoParser;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Property;
import com.google.protobuf.ProtocolStringList;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jspecify.nullness.Nullable;

@GwtIncompatible(value="java.lang.reflect, java.util.regex")
public final class ConformanceRules {
    private static final AllowList ALL_TS_ALLOWLIST = ConformanceRules.createTsAllowlist();
    private static final QualifiedName GOOG_DOM = QualifiedName.of("goog.dom");
    private static final QualifiedName GOOG_DOM_TAGNAME = QualifiedName.of("goog.dom.TagName");

    private static AllowList createTsAllowlist() {
        try {
            return new AllowList((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)".*\\.closure\\.js"));
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    private ConformanceRules() {
    }

    private static @Nullable Pattern buildPattern(List<String> reqPatterns) throws CheckConformance.InvalidRequirementSpec {
        if (reqPatterns == null || reqPatterns.isEmpty()) {
            return null;
        }
        for (String reqPattern : reqPatterns) {
            try {
                Pattern.compile(reqPattern);
            }
            catch (PatternSyntaxException e) {
                throw new CheckConformance.InvalidRequirementSpec("invalid regex pattern", e);
            }
        }
        Pattern pattern = null;
        try {
            String jointRegExp = "(" + Joiner.on((String)"|").join(reqPatterns) + ")";
            pattern = Pattern.compile(jointRegExp);
        }
        catch (PatternSyntaxException e) {
            throw new RuntimeException("bad joined regexp", e);
        }
        return pattern;
    }

    private static class AllowList {
        final @Nullable ImmutableList<String> prefixes;
        final @Nullable Pattern regexp;
        final @Nullable Requirement.WhitelistEntry allowlistEntry;

        AllowList(List<String> prefixes, List<String> regexps) throws CheckConformance.InvalidRequirementSpec {
            this.prefixes = ImmutableList.copyOf(prefixes);
            this.regexp = ConformanceRules.buildPattern(regexps);
            this.allowlistEntry = null;
        }

        AllowList(Requirement.WhitelistEntry allowlistEntry) throws CheckConformance.InvalidRequirementSpec {
            this.prefixes = ImmutableList.copyOf((Collection)allowlistEntry.getPrefixList());
            this.regexp = ConformanceRules.buildPattern((List<String>)allowlistEntry.getRegexpList());
            this.allowlistEntry = allowlistEntry;
        }

        boolean matches(String path) {
            String tsPath;
            String string = tsPath = path.endsWith(".closure.js") ? path.substring(0, path.length() - ".closure.js".length()) + ".ts" : null;
            if (this.prefixes != null) {
                for (String prefix : this.prefixes) {
                    if (path.isEmpty() || !path.startsWith(prefix) && (tsPath == null || !tsPath.startsWith(prefix))) continue;
                    return true;
                }
            }
            return this.regexp != null && (this.regexp.matcher(path).find() || tsPath != null && this.regexp.matcher(tsPath).find());
        }
    }

    public static final class BanStaticThis
    extends AbstractTypeRestrictionRule {
        public BanStaticThis(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (!n.isThis()) {
                return ConformanceResult.CONFORMANCE;
            }
            Node enclosingFunction = NodeUtil.getEnclosingNonArrowFunction(n);
            if (enclosingFunction != null && BanStaticThis.isStaticMethod(enclosingFunction)) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }

        private static boolean isStaticMethod(Node n) {
            Preconditions.checkArgument((boolean)n.isFunction());
            Node parent = n.getParent();
            return parent != null && parent.isMemberFunctionDef() && parent.isStaticMember();
        }
    }

    public static final class BanExecCommand
    extends AbstractRule {
        private final ImmutableList<String> bannedAttrs;

        public BanExecCommand(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            this.bannedAttrs = (ImmutableList)requirement.getValueList().stream().map(v -> v.toLowerCase(Locale.ROOT)).collect(ImmutableList.toImmutableList());
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal traversal, Node node) {
            if (!this.isBannedProperty(node)) {
                return ConformanceResult.CONFORMANCE;
            }
            if (node.getChildCount() < 2) {
                return ConformanceResult.CONFORMANCE;
            }
            Node attr = node.getSecondChild();
            if (!attr.isStringLit()) {
                return ConformanceResult.VIOLATION;
            }
            String attrName = attr.getString();
            if (this.bannedAttrs.contains((Object)attrName.toLowerCase(Locale.ROOT))) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }

        private boolean isBannedProperty(Node node) {
            if (!node.isCall()) {
                return false;
            }
            Node target = node.getFirstChild();
            if (!target.isGetProp()) {
                return false;
            }
            String propertyName = target.getString();
            if (!propertyName.equals("execCommand")) {
                return false;
            }
            JSType type = target.getFirstChild().getJSType();
            if (type == null) {
                return false;
            }
            JSType documentType = this.compiler.getTypeRegistry().getGlobalType("Document");
            return documentType != null && type.restrictByNotNullOrUndefined().isSubtypeOf(documentType);
        }
    }

    public static final class BanSettingAttributes
    extends AbstractRule {
        private static final SecuritySensitiveAttributes BANNED_ATTRS = new SecuritySensitiveAttributes();
        private final ImmutableList<AttributeSettingRestriction> restrictions;

        public BanSettingAttributes(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (requirement.getValueList().isEmpty()) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            JSTypeRegistry registry = compiler.getTypeRegistry();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String value : requirement.getValueList()) {
                String type = ConformanceUtil.getClassFromDeclarationName(value);
                String property = ConformanceUtil.getPropertyFromDeclarationName(value);
                if (type == null || property == null) {
                    throw new CheckConformance.InvalidRequirementSpec("bad prop value");
                }
                builder.add((Object)new AttributeSettingRestriction(registry.getGlobalType(type), property));
            }
            this.restrictions = builder.build();
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal traversal, Node node) {
            if (node.isCall()) {
                return this.checkConformanceOnPropertyCall(traversal, node);
            }
            return ConformanceResult.CONFORMANCE;
        }

        private ConformanceResult checkConformanceOnPropertyCall(NodeTraversal traversal, Node node) {
            Optional<String> calledProperty = this.getBannedPropertyName(node);
            if (!calledProperty.isPresent()) {
                return ConformanceResult.CONFORMANCE;
            }
            if (node.getChildCount() < 3) {
                return ConformanceResult.CONFORMANCE;
            }
            return BANNED_ATTRS.checkConformanceForAttributeName(traversal, node.getSecondChild());
        }

        private Optional<String> getBannedPropertyName(Node node) {
            Node target = node.getFirstChild();
            if (!target.isGetProp()) {
                return Optional.absent();
            }
            JSType type = target.getFirstChild().getJSType();
            if (type == null) {
                return Optional.absent();
            }
            String propertyName = target.getString();
            for (AttributeSettingRestriction restricted : this.restrictions) {
                if (!propertyName.equals(restricted.property) || restricted.type == null || !type.isSubtypeOf(restricted.type)) continue;
                return Optional.of((Object)propertyName);
            }
            return Optional.absent();
        }

        private static class AttributeSettingRestriction {
            final JSType type;
            final String property;

            AttributeSettingRestriction(JSType type, String property) {
                this.type = type;
                this.property = property;
            }
        }
    }

    public static final class BanElementSetAttribute
    extends AbstractRule {
        private static final String ELEMENT_TYPE_NAME = "Element";
        private static final String SET_ATTRIBUTE = "setAttribute";
        private static final String SET_ATTRIBUTE_NS = "setAttributeNS";
        private static final String SET_ATTRIBUTE_NODE = "setAttributeNode";
        private static final String SET_ATTRIBUTE_NODE_NS = "setAttributeNodeNS";
        private static final ImmutableSet<String> BANNED_PROPERTIES = ImmutableSet.of((Object)"setAttribute", (Object)"setAttributeNS", (Object)"setAttributeNode", (Object)"setAttributeNodeNS");
        private boolean performGlobalNamespaceAnalysis = true;
        private GlobalNamespace globalNamespace;
        private static final int GLOBAL_NAMESPACE_ANALYSIS_LIMIT = 10000;
        private final JSType elementType;
        private final SecuritySensitiveAttributes securitySensitiveAttributes;
        private final ConformanceResult defaultDecisionForUncertainCases;

        public BanElementSetAttribute(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            this.securitySensitiveAttributes = new SecuritySensitiveAttributes((Collection<String>)requirement.getValueList(), this::getGlobalNamespace);
            this.defaultDecisionForUncertainCases = requirement.getReportLooseTypeViolations() ? ConformanceResult.VIOLATION : ConformanceResult.CONFORMANCE;
            this.elementType = compiler.getTypeRegistry().getGlobalType(ELEMENT_TYPE_NAME);
        }

        @Nullable GlobalNamespace getGlobalNamespace() {
            if (this.performGlobalNamespaceAnalysis && this.globalNamespace == null) {
                if (NodeUtil.countAstSizeUpToLimit(this.compiler.getJsRoot(), 10000) >= 10000) {
                    this.performGlobalNamespaceAnalysis = false;
                } else {
                    this.globalNamespace = new GlobalNamespace(this.compiler, this.compiler.getJsRoot());
                }
            }
            return this.globalNamespace;
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal traversal, Node node) {
            if (node.isCall()) {
                return this.checkConformanceOnPropertyCall(traversal, node);
            }
            if (node.isGetElem() && NodeUtil.isLValue(node)) {
                return this.checkConformanceOnGetElement(traversal, node);
            }
            return ConformanceResult.CONFORMANCE;
        }

        private ConformanceResult checkConformanceOnPropertyCall(NodeTraversal traversal, Node callNode) {
            Optional<String> calledProperty = this.getBannedPropertyName(callNode);
            if (!calledProperty.isPresent()) {
                return ConformanceResult.CONFORMANCE;
            }
            if (((String)calledProperty.get()).equals(SET_ATTRIBUTE)) {
                if (callNode.getChildCount() < 3) {
                    return ConformanceResult.CONFORMANCE;
                }
                if (this.requirement.getReportLooseTypeViolations()) {
                    return this.securitySensitiveAttributes.checkConformanceForAttributeName(traversal, callNode.getSecondChild());
                }
                return this.securitySensitiveAttributes.checkConformanceForAttributeNameWithHighConfidence(traversal, callNode.getSecondChild());
            }
            if (((String)calledProperty.get()).equals(SET_ATTRIBUTE_NS)) {
                if (callNode.getChildCount() < 4) {
                    return ConformanceResult.CONFORMANCE;
                }
                if (callNode.getSecondChild().isNull()) {
                    if (this.requirement.getReportLooseTypeViolations()) {
                        return this.securitySensitiveAttributes.checkConformanceForAttributeName(traversal, callNode.getChildAtIndex(2));
                    }
                    return this.securitySensitiveAttributes.checkConformanceForAttributeNameWithHighConfidence(traversal, callNode.getChildAtIndex(2));
                }
            }
            return this.defaultDecisionForUncertainCases;
        }

        private Optional<String> getBannedPropertyName(Node callNode) {
            Node target = callNode.getFirstChild();
            if (!target.isGetProp()) {
                return Optional.absent();
            }
            String propertyName = target.getString();
            if (!BANNED_PROPERTIES.contains((Object)propertyName)) {
                return Optional.absent();
            }
            JSType type = target.getFirstChild().getJSType();
            if (type == null) {
                return Optional.absent();
            }
            if (this.elementType != null && type.restrictByNotNullOrUndefined().isSubtypeOf(this.elementType)) {
                return Optional.of((Object)propertyName);
            }
            return Optional.absent();
        }

        private ConformanceResult checkConformanceOnGetElement(NodeTraversal traversal, Node getElementNode) {
            Node key = getElementNode.getSecondChild();
            String keyName = ConformanceUtil.inferStringValue(traversal.getScope(), key, this::getGlobalNamespace);
            if (keyName != null) {
                if ((this.securitySensitiveAttributes.contains(keyName.toLowerCase(Locale.ROOT)) || this.requirement.getReportLooseTypeViolations() && (keyName.equals("innerHTML") || keyName.equals("outerHTML"))) && this.hasElementType(getElementNode)) {
                    return ConformanceResult.VIOLATION;
                }
                return ConformanceResult.CONFORMANCE;
            }
            if (!this.requirement.getReportLooseTypeViolations()) {
                return ConformanceResult.CONFORMANCE;
            }
            JSType keyType = key.getJSType();
            if (keyType == null || ConformanceUtil.isXid(keyType)) {
                return ConformanceResult.CONFORMANCE;
            }
            if (this.hasElementType(getElementNode)) {
                if (keyType.isString()) {
                    return ConformanceResult.VIOLATION;
                }
                if (keyType.isUnionType()) {
                    for (JSType alternate : keyType.toMaybeUnionType().getAlternates()) {
                        if (!alternate.isString()) continue;
                        return ConformanceResult.VIOLATION;
                    }
                }
            }
            return ConformanceResult.CONFORMANCE;
        }

        private boolean hasElementType(Node getElementNode) {
            JSType objType = getElementNode.getFirstChild().getJSType();
            if (objType == null || this.elementType == null) {
                return false;
            }
            return !(objType = objType.restrictByNotNullOrUndefined()).isUnknownType() && !objType.isEmptyType() && objType.isSubtypeOf(this.elementType);
        }
    }

    public static final class SecuritySensitiveAttributes {
        @VisibleForTesting
        public static final ImmutableSet<String> ALL_BANNED_ATTRS = ImmutableSet.of((Object)"href", (Object)"rel", (Object)"src", (Object)"srcdoc", (Object)"action", (Object)"formaction", (Object[])new String[]{"sandbox", "cite", "poster", "icon", "codebase", "data"});
        private final ImmutableSet<String> bannedAtrrs;
        private final Supplier<GlobalNamespace> globalNamespaceSupplier;

        public SecuritySensitiveAttributes() {
            this((Collection<String>)ALL_BANNED_ATTRS, () -> null);
        }

        public SecuritySensitiveAttributes(Supplier<GlobalNamespace> globalNamespaceSupplier) {
            this((Collection<String>)ALL_BANNED_ATTRS, globalNamespaceSupplier);
        }

        public SecuritySensitiveAttributes(Collection<String> bannedAtrrs) {
            this(bannedAtrrs, () -> null);
        }

        public SecuritySensitiveAttributes(Collection<String> bannedAtrrs, Supplier<GlobalNamespace> globalNamespaceSupplier) {
            this.bannedAtrrs = (ImmutableSet)bannedAtrrs.stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(ImmutableSet.toImmutableSet());
            this.globalNamespaceSupplier = globalNamespaceSupplier;
        }

        public boolean contains(String attributeName) {
            return this.bannedAtrrs.contains((Object)attributeName);
        }

        public ConformanceResult checkConformanceForAttributeName(NodeTraversal traversal, Node attrName) {
            String literalName = ConformanceUtil.inferStringValue(traversal.getScope(), attrName, this.globalNamespaceSupplier);
            if (literalName == null) {
                return ConformanceUtil.isXid(attrName.getJSType()) ? ConformanceResult.CONFORMANCE : ConformanceResult.VIOLATION;
            }
            if (this.bannedAtrrs.contains((Object)(literalName = literalName.toLowerCase(Locale.ROOT))) || ConformanceUtil.isEventHandlerAttrName(literalName)) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }

        public ConformanceResult checkConformanceForAttributeNameWithHighConfidence(NodeTraversal traversal, Node attrName) {
            String literalName = ConformanceUtil.inferStringValue(traversal.getScope(), attrName, this.globalNamespaceSupplier);
            if (literalName == null) {
                return ConformanceResult.CONFORMANCE;
            }
            return this.contains(literalName.toLowerCase(Locale.ROOT)) ? ConformanceResult.VIOLATION : ConformanceResult.CONFORMANCE;
        }
    }

    public static final class BanCreateDom
    extends AbstractRule {
        private final List<String[]> bannedTagAttrs = new ArrayList<String[]>();
        private final JSType domHelperType;
        private final JSType classNameTypes;
        private static final ImmutableMultimap<String, String> ELEMENT_TAG_NAMES = ImmutableMultimap.builder().put((Object)"HTMLAnchorElement", (Object)"a").put((Object)"HTMLAppletElement", (Object)"applet").put((Object)"HTMLAreaElement", (Object)"area").put((Object)"HTMLAudioElement", (Object)"audio").put((Object)"HTMLBRElement", (Object)"br").put((Object)"HTMLBaseElement", (Object)"base").put((Object)"HTMLBaseFontElement", (Object)"basefont").put((Object)"HTMLBodyElement", (Object)"body").put((Object)"HTMLButtonElement", (Object)"button").put((Object)"HTMLCanvasElement", (Object)"canvas").put((Object)"HTMLDListElement", (Object)"dl").put((Object)"HTMLDataListElement", (Object)"datalist").put((Object)"HTMLDetailsElement", (Object)"details").put((Object)"HTMLDialogElement", (Object)"dialog").put((Object)"HTMLDirectoryElement", (Object)"dir").put((Object)"HTMLDivElement", (Object)"div").put((Object)"HTMLEmbedElement", (Object)"embed").put((Object)"HTMLFieldSetElement", (Object)"fieldset").put((Object)"HTMLFontElement", (Object)"font").put((Object)"HTMLFormElement", (Object)"form").put((Object)"HTMLFrameElement", (Object)"frame").put((Object)"HTMLFrameSetElement", (Object)"frameset").put((Object)"HTMLHRElement", (Object)"hr").put((Object)"HTMLHeadElement", (Object)"head").put((Object)"HTMLHeadingElement", (Object)"h1").put((Object)"HTMLHeadingElement", (Object)"h2").put((Object)"HTMLHeadingElement", (Object)"h3").put((Object)"HTMLHeadingElement", (Object)"h4").put((Object)"HTMLHeadingElement", (Object)"h5").put((Object)"HTMLHeadingElement", (Object)"h6").put((Object)"HTMLHtmlElement", (Object)"html").put((Object)"HTMLIFrameElement", (Object)"iframe").put((Object)"HTMLImageElement", (Object)"img").put((Object)"HTMLInputElement", (Object)"input").put((Object)"HTMLIsIndexElement", (Object)"isindex").put((Object)"HTMLLIElement", (Object)"li").put((Object)"HTMLLabelElement", (Object)"label").put((Object)"HTMLLegendElement", (Object)"legend").put((Object)"HTMLLinkElement", (Object)"link").put((Object)"HTMLMapElement", (Object)"map").put((Object)"HTMLMenuElement", (Object)"menu").put((Object)"HTMLMetaElement", (Object)"meta").put((Object)"HTMLMeterElement", (Object)"meter").put((Object)"HTMLModElement", (Object)"del").put((Object)"HTMLModElement", (Object)"ins").put((Object)"HTMLOListElement", (Object)"ol").put((Object)"HTMLObjectElement", (Object)"object").put((Object)"HTMLOptGroupElement", (Object)"optgroup").put((Object)"HTMLOptionElement", (Object)"option").put((Object)"HTMLOutputElement", (Object)"output").put((Object)"HTMLParagraphElement", (Object)"p").put((Object)"HTMLParamElement", (Object)"param").put((Object)"HTMLPreElement", (Object)"pre").put((Object)"HTMLProgressElement", (Object)"progress").put((Object)"HTMLQuoteElement", (Object)"blockquote").put((Object)"HTMLQuoteElement", (Object)"q").put((Object)"HTMLScriptElement", (Object)"script").put((Object)"HTMLSelectElement", (Object)"select").put((Object)"HTMLSourceElement", (Object)"source").put((Object)"HTMLSpanElement", (Object)"span").put((Object)"HTMLStyleElement", (Object)"style").put((Object)"HTMLTableCaptionElement", (Object)"caption").put((Object)"HTMLTableCellElement", (Object)"td").put((Object)"HTMLTableCellElement", (Object)"th").put((Object)"HTMLTableColElement", (Object)"col").put((Object)"HTMLTableColElement", (Object)"colgroup").put((Object)"HTMLTableElement", (Object)"table").put((Object)"HTMLTableRowElement", (Object)"tr").put((Object)"HTMLTableSectionElement", (Object)"tbody").put((Object)"HTMLTableSectionElement", (Object)"tfoot").put((Object)"HTMLTableSectionElement", (Object)"thead").put((Object)"HTMLTemplateElement", (Object)"template").put((Object)"HTMLTextAreaElement", (Object)"textarea").put((Object)"HTMLTitleElement", (Object)"title").put((Object)"HTMLTrackElement", (Object)"track").put((Object)"HTMLUListElement", (Object)"ul").put((Object)"HTMLVideoElement", (Object)"video").build();

        public BanCreateDom(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            for (String value : requirement.getValueList()) {
                String[] tagAttr = value.split("\\.");
                if (tagAttr.length != 2 || tagAttr[0].isEmpty() || tagAttr[1].isEmpty()) {
                    throw new CheckConformance.InvalidRequirementSpec("Values must be in the format tagname.attribute.");
                }
                tagAttr[0] = tagAttr[0].toLowerCase(Locale.ROOT);
                this.bannedTagAttrs.add(tagAttr);
            }
            if (this.bannedTagAttrs.isEmpty()) {
                throw new CheckConformance.InvalidRequirementSpec("Specify one or more values.");
            }
            this.domHelperType = compiler.getTypeRegistry().getGlobalType("goog.dom.DomHelper");
            this.classNameTypes = compiler.getTypeRegistry().createUnionType(compiler.getTypeRegistry().getNativeType(JSTypeNative.STRING_TYPE), compiler.getTypeRegistry().getNativeType(JSTypeNative.ARRAY_TYPE), compiler.getTypeRegistry().getNativeType(JSTypeNative.NULL_TYPE), compiler.getTypeRegistry().getNativeType(JSTypeNative.VOID_TYPE));
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            boolean isClassName;
            if (!this.isCreateDomCall(n)) {
                return ConformanceResult.CONFORMANCE;
            }
            if (n.getChildCount() < 3) {
                return ConformanceResult.CONFORMANCE;
            }
            ImmutableCollection<String> tagNames = this.getTagNames(n.getSecondChild());
            Node attrs = n.getChildAtIndex(2);
            JSType attrsType = attrs.getJSType();
            if (attrsType == null) {
                return ConformanceResult.CONFORMANCE;
            }
            boolean bl = isClassName = !attrsType.isUnknownType() && attrsType.isSubtypeOf(this.classNameTypes);
            if (attrs.isNull() || attrsType != null && attrsType.isVoidType()) {
                return ConformanceResult.CONFORMANCE;
            }
            for (String[] tagAttr : this.bannedTagAttrs) {
                if (tagNames != null && !tagNames.contains((Object)tagAttr[0]) && !tagAttr[0].equals("*")) continue;
                ConformanceResult violation = tagNames != null || tagAttr[0].equals("*") ? ConformanceResult.VIOLATION : (this.reportLooseTypeViolations ? ConformanceResult.POSSIBLE_VIOLATION : ConformanceResult.CONFORMANCE);
                if (isClassName) {
                    if (!tagAttr[1].equals("class")) continue;
                    return violation;
                }
                if (tagAttr[1].equals("textContent") && n.getChildCount() > 3 && violation != ConformanceResult.CONFORMANCE) {
                    return violation;
                }
                if (!attrs.isObjectLit()) {
                    return this.reportLooseTypeViolations ? ConformanceResult.POSSIBLE_VIOLATION : ConformanceResult.CONFORMANCE;
                }
                Node prop = NodeUtil.getFirstPropMatchingKey(attrs, tagAttr[1]);
                if (prop != null) {
                    if (NodeUtil.isSomeCompileTimeConstStringValue(prop)) continue;
                    return violation;
                }
                for (Node attr = attrs.getFirstChild(); attr != null; attr = attr.getNext()) {
                    if (!attr.isComputedProp()) continue;
                    return this.reportLooseTypeViolations ? ConformanceResult.POSSIBLE_VIOLATION_DUE_TO_LOOSE_TYPES : ConformanceResult.CONFORMANCE;
                }
            }
            return ConformanceResult.CONFORMANCE;
        }

        private @Nullable ImmutableCollection<String> getTagNames(Node tag) {
            if (tag.isStringLit()) {
                return ImmutableSet.of((Object)tag.getString().toLowerCase(Locale.ROOT));
            }
            if (tag.isGetProp() && GOOG_DOM_TAGNAME.matches(tag.getFirstChild())) {
                return ImmutableSet.of((Object)tag.getString().toLowerCase(Locale.ROOT));
            }
            JSType type = tag.getJSType();
            if (type == null || !type.isTemplatizedType()) {
                return null;
            }
            ObjectType typeAsObj = type.toMaybeObjectType();
            if (typeAsObj.getRawType().getDisplayName().equals("goog.dom.TagName")) {
                JSType tagType = (JSType)Iterables.getOnlyElement(typeAsObj.getTemplateTypes());
                return ELEMENT_TAG_NAMES.get((Object)tagType.getDisplayName());
            }
            return null;
        }

        private boolean isCreateDomCall(Node n) {
            if (!n.isCall()) {
                return false;
            }
            Node target = n.getFirstChild();
            if (!target.isGetProp()) {
                return false;
            }
            if (!"createDom".equals(target.getString())) {
                return false;
            }
            Node srcObj = target.getFirstChild();
            if (GOOG_DOM.matches(srcObj)) {
                return true;
            }
            JSType type = srcObj.getJSType();
            if (type == null) {
                return false;
            }
            return type.equals(this.domHelperType);
        }
    }

    public static final class BanCreateElement
    extends AbstractRule {
        private final Set<String> bannedTags = new LinkedHashSet<String>();
        private final JSType domHelperType;
        private final JSType documentType;

        public BanCreateElement(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            for (String value : requirement.getValueList()) {
                this.bannedTags.add(Ascii.toLowerCase((String)value));
            }
            if (this.bannedTags.isEmpty()) {
                throw new CheckConformance.InvalidRequirementSpec("Specify one or more values.");
            }
            this.domHelperType = compiler.getTypeRegistry().getGlobalType("goog.dom.DomHelper");
            this.documentType = compiler.getTypeRegistry().getGlobalType("Document");
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            Node tag;
            if (n.isCall() && (tag = n.getSecondChild()) != null && tag.isStringLit() && this.bannedTags.contains(Ascii.toLowerCase((String)tag.getString()))) {
                return this.checkCreateElement(n);
            }
            return ConformanceResult.CONFORMANCE;
        }

        private ConformanceResult checkCreateElement(Node n) {
            Node target = n.getFirstChild();
            if (!target.isGetProp()) {
                return ConformanceResult.CONFORMANCE;
            }
            String functionName = target.getString();
            if (!"createElement".equals(functionName) && !"createDom".equals(functionName)) {
                return ConformanceResult.CONFORMANCE;
            }
            Node srcObj = target.getFirstChild();
            if (GOOG_DOM.matches(srcObj)) {
                return ConformanceResult.VIOLATION;
            }
            JSType type = srcObj.getJSType();
            if (type == null || ConformanceUtil.isLooseType(type)) {
                return this.reportLooseTypeViolations ? ConformanceResult.POSSIBLE_VIOLATION_DUE_TO_LOOSE_TYPES : ConformanceResult.CONFORMANCE;
            }
            if (this.domHelperType != null && this.domHelperType.isSubtypeOf(type) || this.documentType != null && this.documentType.isSubtypeOf(type)) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    public static final class BannedModsRegex
    extends AbstractRule {
        private final Pattern bannedModsRegex;

        public BannedModsRegex(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            ProtocolStringList bannedModsRegexList = requirement.getValueList();
            if (requirement.getValueCount() == 0) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            this.bannedModsRegex = ConformanceRules.buildPattern((List<String>)bannedModsRegexList);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            JSDocInfo docInfo = n.getJSDocInfo();
            if (docInfo == null || !docInfo.hasMods()) {
                return ConformanceResult.CONFORMANCE;
            }
            if (this.bannedModsRegex.matcher(docInfo.getMods()).find()) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }

        @Override
        public final CheckConformance.Precondition getPrecondition() {
            return Node::isScript;
        }
    }

    public static final class BannedEnhance
    extends AbstractRule {
        private final ImmutableSet<String> bannedEnhancedNamespaces;

        public BannedEnhance(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (requirement.getValueCount() == 0) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            this.bannedEnhancedNamespaces = ImmutableSet.copyOf((Collection)requirement.getValueList());
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            JSDocInfo docInfo = n.getJSDocInfo();
            if (docInfo == null || !docInfo.hasEnhance()) {
                return ConformanceResult.CONFORMANCE;
            }
            for (String banned : this.bannedEnhancedNamespaces) {
                if (!docInfo.getEnhance().equals(banned)) continue;
                return new ConformanceResult(ConformanceLevel.VIOLATION, "The enhanced namespace \"" + banned + "\"");
            }
            return ConformanceResult.CONFORMANCE;
        }

        @Override
        public final CheckConformance.Precondition getPrecondition() {
            return Node::isScript;
        }
    }

    public static final class BanGlobalVars
    extends AbstractRule {
        private final ImmutableSet<String> allowlistedNames;

        public BanGlobalVars(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            this.allowlistedNames = ImmutableSet.copyOf((Collection)requirement.getValueList());
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (t.inGlobalScope() && NodeUtil.isDeclaration(n) && !n.getBooleanProp(Node.IS_NAMESPACE) && !this.isAllowlisted(n)) {
                Node enclosingScript = NodeUtil.getEnclosingScript(n);
                if (enclosingScript != null && (enclosingScript.getBooleanProp(Node.GOOG_MODULE) || enclosingScript.getBooleanProp(Node.ES6_MODULE) || enclosingScript.getInputId().equals(this.compiler.getSyntheticCodeInputId()))) {
                    return ConformanceResult.CONFORMANCE;
                }
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }

        private boolean isAllowlisted(Node n) {
            if (n.isFromExterns()) {
                return true;
            }
            if (n.isFunction()) {
                return this.isAllowlistedName(n.getFirstChild().getString());
            }
            if (NodeUtil.isNameDeclaration(n)) {
                boolean[] allowlisted = new boolean[]{true};
                NodeUtil.visitLhsNodesInNode(n, name -> {
                    if (!this.isAllowlistedName(name.getString())) {
                        allowlisted[0] = false;
                    }
                });
                return allowlisted[0];
            }
            return false;
        }

        private boolean isAllowlistedName(String name) {
            if (this.allowlistedNames.contains((Object)name)) {
                return true;
            }
            return name.equals("$jscomp") || name.startsWith("$jscomp$compprop") || ClosureRewriteModule.isModuleContent(name) || ClosureRewriteModule.isModuleExport(name) || ScopedAliases.isScopedAliases(name);
        }
    }

    public static final class StrictBanUnresolvedType
    extends AbstractTypeRestrictionRule {
        public StrictBanUnresolvedType(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            String nonConformingPart = BanUnresolvedType.getNonConformingPart(n.getJSType());
            if (nonConformingPart != null && !this.isTypeImmediatelyTightened(n)) {
                return new ConformanceResult(ConformanceLevel.VIOLATION, "Reference to type '" + nonConformingPart + "' never resolved.");
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    public static final class BanUnresolvedType
    extends AbstractTypeRestrictionRule {
        public BanUnresolvedType(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            Node target;
            JSType type;
            String nonConformingPart;
            if (n.isGetProp() && (nonConformingPart = BanUnresolvedType.getNonConformingPart(type = (target = n.getFirstChild()).getJSType())) != null && !this.isTypeImmediatelyTightened(n)) {
                return new ConformanceResult(ConformanceLevel.VIOLATION, "Reference to type '" + nonConformingPart + "' never resolved.");
            }
            return ConformanceResult.CONFORMANCE;
        }

        private static @Nullable String getNonConformingPart(JSType type) {
            if (type == null) {
                return null;
            }
            if (type.isUnionType()) {
                ArrayList<String> nonConformingParts = null;
                for (JSType part : type.getUnionMembers()) {
                    String nonConformingPart = BanUnresolvedType.getNonConformingPart(part);
                    if (nonConformingPart == null) continue;
                    nonConformingParts = nonConformingParts != null ? nonConformingParts : new ArrayList<String>();
                    nonConformingParts.add(nonConformingPart);
                }
                if (nonConformingParts != null) {
                    return Joiner.on((char)'|').join(nonConformingParts);
                }
            } else if (type.isNoResolvedType()) {
                ObjectType noResolvedType = type.toObjectType();
                return noResolvedType.getReferenceName();
            }
            return null;
        }
    }

    public static final class BanUnknownTypedClassPropsReferences
    extends AbstractTypeRestrictionRule {
        public BanUnknownTypedClassPropsReferences(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected boolean tsIsAllowlisted() {
            return true;
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node getprop) {
            if (getprop.isGetProp() && BanUnknownTypedClassPropsReferences.isUnknown(getprop) && this.isUsed(getprop) && !this.isTypeImmediatelyTightened(getprop) && this.isCheckablePropertySource(getprop.getFirstChild()) && !BanUnknownTypedClassPropsReferences.isTemplateType(getprop) && !this.isDeclaredUnknown(getprop)) {
                String propName = getprop.getString();
                String typeName = getprop.getFirstChild().getJSType().toString();
                return new ConformanceResult(ConformanceLevel.VIOLATION, "The property \"" + propName + "\" on type \"" + typeName + "\"");
            }
            return ConformanceResult.CONFORMANCE;
        }

        private boolean isCheckablePropertySource(Node n) {
            return BanUnknownTypedClassPropsReferences.isKnown(n) && !BanUnknownTypedClassPropsReferences.isTop(n) && this.isClassType(n) && !this.isNativeObjectType(n) && !this.isAllowlistedType(n);
        }

        private boolean isClassType(Node n) {
            ObjectType type = n.getJSType().restrictByNotNullOrUndefined().toMaybeObjectType();
            if (type == null || !type.isInstanceType()) {
                return false;
            }
            FunctionType ctor = type.getConstructor();
            if (ctor == null) {
                return false;
            }
            JSDocInfo info = ctor.getJSDocInfo();
            Node source = ctor.getSource();
            return info != null && info.isConstructorOrInterface() || source != null && source.isClass();
        }

        private boolean isDeclaredUnknown(Node n) {
            Node target = n.getFirstChild();
            ObjectType targetType = target.getJSType().restrictByNotNullOrUndefined().toMaybeObjectType();
            if (targetType == null) {
                return false;
            }
            JSDocInfo info = targetType.getPropertyJSDocInfo(n.getString());
            if (info == null || !info.hasType()) {
                return false;
            }
            JSTypeExpression expr = info.getType();
            Node typeExprNode = expr.getRoot();
            if (typeExprNode.getToken() == Token.QMARK && !typeExprNode.hasChildren()) {
                return true;
            }
            if (typeExprNode.getToken() == Token.PIPE) {
                for (Node child = typeExprNode.getFirstChild(); child != null; child = child.getNext()) {
                    if (child.getToken() != Token.QMARK) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static final class BanUnknownDirectThisPropsReferences
    extends AbstractTypeRestrictionRule {
        public BanUnknownDirectThisPropsReferences(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (n.isGetProp() && BanUnknownDirectThisPropsReferences.isKnownThis(n.getFirstChild()) && BanUnknownDirectThisPropsReferences.isUnknown(n) && !BanUnknownDirectThisPropsReferences.isTemplateType(n) && this.isUsed(n) && !this.isTypeImmediatelyTightened(n) && !BanUnknownDirectThisPropsReferences.isExplicitlyUnknown(n)) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }

        private static boolean isKnownThis(Node n) {
            return n.isThis() && !BanUnknownDirectThisPropsReferences.isUnknown(n);
        }

        private static boolean isExplicitlyUnknown(Node n) {
            ObjectType owner = ObjectType.cast(n.getFirstChild().getJSType());
            Property prop = owner != null ? owner.getSlot(n.getString()) : null;
            return prop != null && !prop.isTypeInferred();
        }
    }

    public static final class BanUnknownThis
    extends AbstractTypeRestrictionRule {
        private final Set<Node> reports = Sets.newIdentityHashSet();

        public BanUnknownThis(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected boolean tsIsAllowlisted() {
            return true;
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            Node root;
            JSType type;
            if (n.isThis() && (type = n.getJSType()) != null && type.isUnknownType() && !this.isTypeImmediatelyTightened(n) && !this.reports.contains(root = t.getScopeRoot())) {
                this.reports.add(root);
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    public static final class BanNullDeref
    extends AbstractTypeRestrictionRule {
        public BanNullDeref(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            boolean violation;
            switch (n.getToken()) {
                case GETPROP: 
                case GETELEM: 
                case NEW: 
                case CALL: {
                    violation = this.report(n.getFirstChild());
                    break;
                }
                case IN: {
                    violation = this.report(n.getLastChild());
                    break;
                }
                default: {
                    violation = false;
                }
            }
            return violation ? ConformanceResult.VIOLATION : ConformanceResult.CONFORMANCE;
        }

        boolean report(Node n) {
            return n.getJSType() != null && BanNullDeref.isKnown(n) && this.invalidDeref(n) && !this.isAllowlistedType(n);
        }

        private boolean invalidDeref(Node n) {
            JSType type = n.getJSType();
            return !type.isAllType() && (type.isNullable() || type.isVoidable());
        }
    }

    public static final class BanThrowOfNonErrorTypes
    extends AbstractRule {
        final JSType errorObjType;

        public BanThrowOfNonErrorTypes(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            this.errorObjType = compiler.getTypeRegistry().getGlobalType("Error");
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            JSType thrown;
            if (!(this.errorObjType == null || !n.isThrow() || (thrown = n.getFirstChild().getJSType()) == null || thrown.isUnknownType() || thrown.isAllType() || thrown.isEmptyType() || thrown.isSubtypeOf(this.errorObjType))) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    public static class RequireUseStrict
    extends AbstractRule {
        public RequireUseStrict(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (!requirement.getValueList().isEmpty()) {
                throw new CheckConformance.InvalidRequirementSpec("invalid value");
            }
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            return n.isScript() && !n.isUseStrict() ? ConformanceResult.VIOLATION : ConformanceResult.CONFORMANCE;
        }
    }

    public static final class BanForOf
    extends AbstractRule {
        public BanForOf(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (n.isForOf() || n.isForAwaitOf()) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    static class CustomRuleProxy
    implements CheckConformance.Rule {
        final CheckConformance.Rule customRule;
        private static final TypeToken<CheckConformance.Rule> RULE_TYPE = new TypeToken<CheckConformance.Rule>(){};
        private static final TypeToken<AbstractCompiler> COMPILER_TYPE = new TypeToken<AbstractCompiler>(){};
        private static final TypeToken<Requirement> REQUIREMENT_TYPE = new TypeToken<Requirement>(){};

        CustomRuleProxy(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            if (!requirement.hasJavaClass()) {
                throw new CheckConformance.InvalidRequirementSpec("missing java_class");
            }
            this.customRule = this.createRule(compiler, requirement);
        }

        @Override
        public void check(NodeTraversal t, Node n) {
            this.customRule.check(t, n);
        }

        private CheckConformance.Rule createRule(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            try {
                CheckConformance.Rule rule;
                Class<CheckConformance.Rule> custom = this.getRuleClass(requirement.getJavaClass());
                Constructor<?> ctor = this.getRuleConstructor(custom);
                try {
                    rule = (CheckConformance.Rule)ctor.newInstance(compiler, requirement);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof CheckConformance.InvalidRequirementSpec) {
                        throw (CheckConformance.InvalidRequirementSpec)cause;
                    }
                    throw new RuntimeException(cause);
                }
                return rule;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }

        private Constructor<?> getRuleConstructor(Class<CheckConformance.Rule> cls) throws CheckConformance.InvalidRequirementSpec {
            for (Constructor<?> ctor : cls.getConstructors()) {
                Class<?>[] paramClasses = ctor.getParameterTypes();
                if (paramClasses.length != 2) continue;
                TypeToken param1 = TypeToken.of(paramClasses[0]);
                TypeToken param2 = TypeToken.of(paramClasses[1]);
                if (!param1.isSupertypeOf(COMPILER_TYPE) || !param2.isSupertypeOf(REQUIREMENT_TYPE)) continue;
                return ctor;
            }
            throw new CheckConformance.InvalidRequirementSpec("No valid class constructors found.");
        }

        private Class<CheckConformance.Rule> getRuleClass(String className) throws CheckConformance.InvalidRequirementSpec {
            Class<CheckConformance.Rule> customClass;
            try {
                customClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new CheckConformance.InvalidRequirementSpec("JavaClass not found.", e);
            }
            if (RULE_TYPE.isSupertypeOf(TypeToken.of(customClass))) {
                Class<CheckConformance.Rule> ruleClass = customClass;
                return ruleClass;
            }
            throw new CheckConformance.InvalidRequirementSpec("JavaClass is not a rule.");
        }
    }

    static class BannedCodePattern
    extends AbstractRule {
        private final ImmutableList<TemplateAstMatcher> restrictions;

        BannedCodePattern(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (requirement.getValueCount() == 0) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String value : requirement.getValueList()) {
                Node parseRoot = new JsAst(SourceFile.fromCode("<template>", value)).getAstRoot(compiler);
                if (!parseRoot.hasOneChild() || !parseRoot.getFirstChild().isFunction()) {
                    throw new CheckConformance.InvalidRequirementSpec("invalid conformance template: " + value);
                }
                Node templateRoot = parseRoot.getFirstChild();
                TemplateAstMatcher astMatcher = new TemplateAstMatcher(compiler, templateRoot, this.typeMatchingStrategy);
                builder.add((Object)astMatcher);
            }
            this.restrictions = builder.build();
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            boolean possibleViolation = false;
            for (int i = 0; i < this.restrictions.size(); ++i) {
                TemplateAstMatcher matcher = (TemplateAstMatcher)this.restrictions.get(i);
                if (!matcher.matches(n)) continue;
                if (matcher.isLooseMatch()) {
                    possibleViolation = true;
                    continue;
                }
                return ConformanceResult.VIOLATION;
            }
            return possibleViolation && this.reportLooseTypeViolations ? ConformanceResult.POSSIBLE_VIOLATION_DUE_TO_LOOSE_TYPES : ConformanceResult.CONFORMANCE;
        }
    }

    static class RestrictedPropertyWrite
    extends AbstractRule {
        private final ImmutableList<Restriction> restrictions;

        RestrictedPropertyWrite(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (requirement.getValueCount() == 0) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            JSTypeRegistry registry = compiler.getTypeRegistry();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String value : requirement.getValueList()) {
                String type = ConformanceUtil.getClassFromDeclarationName(ConformanceUtil.removeTypeDecl(value));
                String property = ConformanceUtil.getPropertyFromDeclarationName(ConformanceUtil.removeTypeDecl(value));
                String restrictedDecl = ConformanceUtil.getTypeFromValue(value);
                if (type == null || property == null || restrictedDecl == null) {
                    throw new CheckConformance.InvalidRequirementSpec("bad prop value");
                }
                JSType restrictedType = ConformanceUtil.evaluateTypeString(compiler, restrictedDecl);
                builder.add((Object)new Restriction(registry.getGlobalType(type), property, restrictedType));
            }
            this.restrictions = builder.build();
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (n.isGetProp() && NodeUtil.isLhsOfAssign(n)) {
                JSType rhsType = n.getNext().getJSType();
                JSType targetType = n.getFirstChild().getJSType();
                if (rhsType != null && targetType != null) {
                    JSType targetNotNullType = null;
                    for (Restriction r : this.restrictions) {
                        if (!n.getString().equals(r.property) || rhsType.isSubtypeOf(r.restrictedType)) continue;
                        if (ConformanceUtil.isLooseType(targetType)) {
                            if (!this.reportLooseTypeViolations) continue;
                            return ConformanceResult.POSSIBLE_VIOLATION_DUE_TO_LOOSE_TYPES;
                        }
                        if (targetNotNullType == null) {
                            targetNotNullType = targetType.restrictByNotNullOrUndefined();
                        }
                        if (!targetNotNullType.isSubtypeOf(r.type)) continue;
                        return ConformanceResult.VIOLATION;
                    }
                }
            }
            return ConformanceResult.CONFORMANCE;
        }

        private static class Restriction {
            final JSType type;
            final String property;
            final JSType restrictedType;

            Restriction(JSType type, String property, JSType restrictedType) {
                this.type = type;
                this.property = property;
                this.restrictedType = restrictedType;
            }
        }
    }

    static class RestrictedMethodCall
    extends AbstractRule {
        private final ImmutableList<Restriction> restrictions;

        RestrictedMethodCall(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (requirement.getValueCount() == 0) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            JSTypeRegistry registry = compiler.getTypeRegistry();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String value : requirement.getValueList()) {
                String type = ConformanceUtil.getClassFromDeclarationName(ConformanceUtil.removeTypeDecl(value));
                String property = ConformanceUtil.getPropertyFromDeclarationName(ConformanceUtil.removeTypeDecl(value));
                String restrictedDecl = ConformanceUtil.getTypeFromValue(value);
                if (type == null || property == null || restrictedDecl == null) {
                    throw new CheckConformance.InvalidRequirementSpec("bad prop value");
                }
                FunctionType restrictedCallType = ConformanceUtil.evaluateTypeString(compiler, restrictedDecl).toMaybeFunctionType();
                if (restrictedCallType == null) {
                    throw new CheckConformance.InvalidRequirementSpec("invalid conformance type");
                }
                builder.add((Object)new Restriction(registry.getGlobalType(type), property, restrictedCallType));
            }
            this.restrictions = builder.build();
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (!n.isGetProp() || !ConformanceUtil.isCallTarget(n)) {
                return ConformanceResult.CONFORMANCE;
            }
            for (int i = 0; i < this.restrictions.size(); ++i) {
                Restriction r = (Restriction)this.restrictions.get(i);
                ConformanceResult result = ConformanceResult.CONFORMANCE;
                if (this.matchesProp(n, r)) {
                    result = this.checkConformance(t, n, r, false);
                } else if (n.getString().equals("call") && this.matchesProp(n.getFirstChild(), r)) {
                    result = this.checkConformance(t, n, r, true);
                }
                if (result.level == ConformanceLevel.CONFORMANCE) continue;
                return result;
            }
            return ConformanceResult.CONFORMANCE;
        }

        private ConformanceResult checkConformance(NodeTraversal t, Node n, Restriction r, boolean isCallInvocation) {
            Node lhs;
            JSTypeRegistry registry = t.getCompiler().getTypeRegistry();
            JSType methodClassType = r.type;
            Node node = lhs = isCallInvocation ? n.getFirstFirstChild() : n.getFirstChild();
            if (methodClassType != null && lhs.getJSType() != null) {
                JSType targetType = lhs.getJSType().restrictByNotNullOrUndefined();
                if (ConformanceUtil.isLooseType(targetType) || targetType.equals(registry.getNativeType(JSTypeNative.OBJECT_TYPE))) {
                    if (this.reportLooseTypeViolations && !ConformanceUtil.validateCall(this.compiler, n.getParent(), r.restrictedCallType, isCallInvocation)) {
                        return ConformanceResult.POSSIBLE_VIOLATION_DUE_TO_LOOSE_TYPES;
                    }
                } else if (targetType.isSubtypeOf(methodClassType) && !ConformanceUtil.validateCall(this.compiler, n.getParent(), r.restrictedCallType, isCallInvocation)) {
                    return ConformanceResult.VIOLATION;
                }
            }
            return ConformanceResult.CONFORMANCE;
        }

        private boolean matchesProp(Node n, Restriction r) {
            return n.isGetProp() && n.getString().equals(r.property);
        }

        private static class Restriction {
            final JSType type;
            final String property;
            final FunctionType restrictedCallType;

            Restriction(JSType type, String property, FunctionType restrictedCallType) {
                this.type = type;
                this.property = property;
                this.restrictedCallType = restrictedCallType;
            }
        }
    }

    static class RestrictedNameCall
    extends AbstractRule {
        private final ImmutableList<Restriction> restrictions;

        RestrictedNameCall(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (requirement.getValueCount() == 0) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String value : requirement.getValueList()) {
                Node name = NodeUtil.newQName(compiler, RestrictedNameCall.getNameFromValue(value));
                String restrictedDecl = ConformanceUtil.getTypeFromValue(value);
                if (name == null || restrictedDecl == null) {
                    throw new CheckConformance.InvalidRequirementSpec("bad prop value");
                }
                FunctionType restrictedCallType = ConformanceUtil.evaluateTypeString(compiler, restrictedDecl).toMaybeFunctionType();
                if (restrictedCallType == null) {
                    throw new CheckConformance.InvalidRequirementSpec("invalid conformance type");
                }
                builder.add((Object)new Restriction(name, restrictedCallType));
            }
            this.restrictions = builder.build();
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (ConformanceUtil.isCallTarget(n) && n.isQualifiedName()) {
                for (int i = 0; i < this.restrictions.size(); ++i) {
                    Restriction r = (Restriction)this.restrictions.get(i);
                    if (!(n.matchesQualifiedName(r.name) ? !ConformanceUtil.validateCall(this.compiler, n.getParent(), r.restrictedCallType, false) : n.isGetProp() && n.getString().equals("call") && n.getFirstChild().matchesQualifiedName(r.name) && !ConformanceUtil.validateCall(this.compiler, n.getParent(), r.restrictedCallType, true))) continue;
                    return ConformanceResult.VIOLATION;
                }
            }
            return ConformanceResult.CONFORMANCE;
        }

        private static @Nullable String getNameFromValue(String specName) {
            int index = specName.indexOf(58);
            if (index < 1) {
                return null;
            }
            return specName.substring(0, index);
        }

        private static class Restriction {
            final Node name;
            final FunctionType restrictedCallType;

            Restriction(Node name, FunctionType restrictedCallType) {
                this.name = name;
                this.restrictedCallType = restrictedCallType;
            }
        }
    }

    private static class ConformanceUtil {
        private ConformanceUtil() {
        }

        static boolean isCallTarget(Node n) {
            Node parent = n.getParent();
            return (parent.isCall() || parent.isNew()) && parent.getFirstChild() == n;
        }

        static boolean isLooseType(JSType type) {
            return type.isUnknownType() || type.isNoResolvedType() || type.isAllType();
        }

        static JSType evaluateTypeString(AbstractCompiler compiler, String expression) throws CheckConformance.InvalidRequirementSpec {
            Node typeNodes = JsDocInfoParser.parseTypeString(expression);
            if (typeNodes == null) {
                throw new CheckConformance.InvalidRequirementSpec("bad type expression");
            }
            JSTypeExpression typeExpr = new JSTypeExpression(typeNodes, "conformance");
            return compiler.getTypeRegistry().evaluateTypeExpressionInGlobalScope(typeExpr);
        }

        static boolean validateCall(AbstractCompiler compiler, Node callOrNew, FunctionType functionType, boolean isCallInvocation) {
            Preconditions.checkState((callOrNew.isCall() || callOrNew.isNew() ? 1 : 0) != 0);
            return ConformanceUtil.validateParameterList(compiler, callOrNew, functionType, isCallInvocation) && ConformanceUtil.validateThis(callOrNew, functionType, isCallInvocation);
        }

        private static boolean validateThis(Node callOrNew, FunctionType functionType, boolean isCallInvocation) {
            if (callOrNew.isNew()) {
                return true;
            }
            JSType thisType = functionType.getTypeOfThis();
            if (thisType == null || thisType.isUnknownType()) {
                return true;
            }
            Node thisNode = isCallInvocation ? callOrNew.getSecondChild() : callOrNew.getFirstFirstChild();
            JSType thisNodeType = thisNode.getJSType().restrictByNotNullOrUndefined();
            return thisNodeType.isSubtypeOf(thisType);
        }

        private static boolean validateParameterList(AbstractCompiler compiler, Node callOrNew, FunctionType functionType, boolean isCallInvocation) {
            Node arg = callOrNew.getSecondChild();
            if (isCallInvocation && arg != null) {
                arg = arg.getNext();
            }
            ImmutableList.Builder argumentTypes = ImmutableList.builder();
            while (arg != null) {
                JSType argType = arg.getJSType();
                if (argType == null) {
                    argType = compiler.getTypeRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
                }
                argumentTypes.add((Object)argType);
                arg = arg.getNext();
            }
            return functionType.acceptsArguments((List<? extends JSType>)argumentTypes.build());
        }

        private static @Nullable String getPropertyFromDeclarationName(String specName) {
            String[] parts = specName.split("\\.prototype\\.");
            Preconditions.checkState((parts.length == 1 || parts.length == 2 ? 1 : 0) != 0);
            if (parts.length == 2) {
                return parts[1];
            }
            return null;
        }

        private static @Nullable String getClassFromDeclarationName(String specName) {
            String tmp = specName;
            String[] parts = tmp.split("\\.prototype\\.");
            Preconditions.checkState((parts.length == 1 || parts.length == 2 ? 1 : 0) != 0);
            if (parts.length == 2) {
                return parts[0];
            }
            return null;
        }

        private static String removeTypeDecl(String specName) throws CheckConformance.InvalidRequirementSpec {
            int index = specName.indexOf(58);
            if (index < 1) {
                throw new CheckConformance.InvalidRequirementSpec("value should be in the form NAME:TYPE");
            }
            return specName.substring(0, index);
        }

        private static @Nullable String getTypeFromValue(String specName) {
            int index = specName.indexOf(58);
            if (index < 1) {
                return null;
            }
            return specName.substring(index + 1);
        }

        private static boolean isAnnotatedAsConst(JSDocInfo jsdoc) {
            return jsdoc != null && jsdoc.isConstant();
        }

        private static @Nullable String getValueFromGlobalName(@Nullable Scope scope, GlobalNamespace gns, String qualifiedName) {
            GlobalNamespace.Name gn = gns.getOwnSlot(qualifiedName);
            if (gn == null || gn.getGlobalSets() != 1 || gn.getTotalSets() != 1 || !ConformanceUtil.isAnnotatedAsConst(gn.getJSDocInfo())) {
                return null;
            }
            return ConformanceUtil.inferStringValue(scope, NodeUtil.getRValueOfLValue(gn.getDeclaration().getNode()), () -> gns);
        }

        private static @Nullable String inferStringValue(@Nullable Scope scope, Node node, Supplier<GlobalNamespace> globalNamespaceSupplier) {
            if (node == null) {
                return null;
            }
            switch (node.getToken()) {
                case STRING_KEY: 
                case STRINGLIT: 
                case TEMPLATELIT: 
                case TEMPLATELIT_STRING: {
                    return NodeUtil.getStringValue(node);
                }
                case NAME: {
                    if (scope == null) {
                        return null;
                    }
                    String name = node.getString();
                    Var var = (Var)scope.getVar(name);
                    if (var == null) {
                        return null;
                    }
                    if (!var.isConst() && !ConformanceUtil.isAnnotatedAsConst(var.getJSDocInfo())) {
                        return null;
                    }
                    Node initialValue = var.getInitialValue();
                    return ConformanceUtil.inferStringValue((Scope)var.getScope(), initialValue, globalNamespaceSupplier);
                }
                case GETPROP: {
                    JSType type = node.getJSType();
                    if (type == null) {
                        return null;
                    }
                    if (type.isEnumElementType()) {
                        Node enumSource = type.toMaybeEnumElementType().getEnumType().getSource();
                        if (enumSource == null) {
                            return null;
                        }
                        if (!enumSource.isObjectLit() && !enumSource.isClassMembers()) {
                            return null;
                        }
                        return ConformanceUtil.inferStringValue(null, NodeUtil.getFirstPropMatchingKey(enumSource, node.getString()), globalNamespaceSupplier);
                    }
                    if (type.isString()) {
                        GlobalNamespace gns = globalNamespaceSupplier.get();
                        if (gns == null) {
                            return null;
                        }
                        return ConformanceUtil.getValueFromGlobalName(scope, gns, node.getQualifiedName());
                    }
                    return null;
                }
            }
            return null;
        }

        private static boolean isXid(JSType type) {
            if (type == null) {
                return false;
            }
            EnumElementType enumElTy = type.toMaybeEnumElementType();
            return enumElTy != null && enumElTy.getEnumType().getReferenceName().equals("enum{xid.String}");
        }

        private static boolean isEventHandlerAttrName(String attr) {
            return !attr.equals("on") && attr.startsWith("on");
        }
    }

    static final class BannedStringRegex
    extends AbstractRule {
        private final Pattern stringPattern;

        public BannedStringRegex(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            Pattern stringRegex;
            if (requirement.getValueCount() == 0) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String value : requirement.getValueList()) {
                if (value.trim().isEmpty()) {
                    throw new CheckConformance.InvalidRequirementSpec("empty strings or whitespace are not allowed");
                }
                builder.add((Object)value);
            }
            ImmutableList values = builder.build();
            if (values.isEmpty()) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            this.stringPattern = stringRegex = ConformanceRules.buildPattern((List<String>)values);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal traversal, Node node) {
            if (node == null) {
                return ConformanceResult.CONFORMANCE;
            }
            if (node.isStringLit() ? this.stringPattern.matcher(node.getString()).matches() : node.isTemplateLitString() && this.stringPattern.matcher(node.getCookedString()).matches()) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    static final class BannedProperty
    extends AbstractRule {
        private final JSTypeRegistry registry;
        private final ImmutableSetMultimap<String, JSType> props;
        private final RequirementPrecondition requirementPrecondition;

        BannedProperty(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (requirement.getValueCount() == 0) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            switch (requirement.getType()) {
                case BANNED_PROPERTY: {
                    this.requirementPrecondition = RequirementPrecondition.BANNED_PROPERTY;
                    break;
                }
                case BANNED_PROPERTY_READ: {
                    this.requirementPrecondition = RequirementPrecondition.BANNED_PROPERTY_READ;
                    break;
                }
                case BANNED_PROPERTY_WRITE: {
                    this.requirementPrecondition = RequirementPrecondition.BANNED_PROPERTY_WRITE;
                    break;
                }
                case BANNED_PROPERTY_NON_CONSTANT_WRITE: {
                    this.requirementPrecondition = RequirementPrecondition.BANNED_PROPERTY_NON_CONSTANT_WRITE;
                    break;
                }
                case BANNED_PROPERTY_CALL: {
                    this.requirementPrecondition = RequirementPrecondition.BANNED_PROPERTY_CALL;
                    break;
                }
                default: {
                    throw new AssertionError((Object)requirement.getType());
                }
            }
            this.registry = compiler.getTypeRegistry();
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (String value : requirement.getValueList()) {
                String typename = ConformanceUtil.getClassFromDeclarationName(value);
                String property = ConformanceUtil.getPropertyFromDeclarationName(value);
                if (typename == null || property == null) {
                    throw new CheckConformance.InvalidRequirementSpec("bad prop value");
                }
                JSType type = this.registry.getGlobalType(typename);
                if (type == null) {
                    type = this.registry.resolveViaClosureNamespace(typename);
                }
                if (type == null || type.isUnknownType() || type.isEmptyType()) continue;
                builder.put((Object)property, (Object)type);
            }
            this.props = builder.build();
        }

        @Override
        public final CheckConformance.Precondition getPrecondition() {
            return this.requirementPrecondition;
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            ImmutableSet checkTypes = this.props.get((Object)this.extractName(n));
            if (checkTypes.isEmpty()) {
                return ConformanceResult.CONFORMANCE;
            }
            JSType foundType = this.extractType(n);
            if (foundType == null) {
                return ConformanceResult.CONFORMANCE;
            }
            foundType = foundType.restrictByNotNullOrUndefined();
            for (JSType checkType : checkTypes) {
                ConformanceResult result = this.matchTypes(foundType, checkType);
                if (result.level == ConformanceLevel.CONFORMANCE) continue;
                return result;
            }
            return ConformanceResult.CONFORMANCE;
        }

        private ConformanceResult matchTypes(JSType foundType, JSType checkType) {
            ObjectType foundObj = foundType.toMaybeObjectType();
            if (foundObj != null) {
                if (foundObj.isFunctionPrototypeType()) {
                    FunctionType ownerFun = foundObj.getOwnerFunction();
                    if (ownerFun.isConstructor()) {
                        foundType = ownerFun.getInstanceType();
                    }
                } else if (foundObj.isTemplatizedType()) {
                    foundType = foundObj.getRawType();
                }
            }
            if (foundType.isUnknownType() || foundType.isTemplateType() || foundType.isEmptyType() || foundType.isAllType() || foundType.equals(this.registry.getNativeType(JSTypeNative.OBJECT_TYPE))) {
                if (this.reportLooseTypeViolations) {
                    return ConformanceResult.POSSIBLE_VIOLATION_DUE_TO_LOOSE_TYPES;
                }
            } else {
                if (foundType.isSubtypeOf(checkType)) {
                    return ConformanceResult.VIOLATION;
                }
                if (checkType.isSubtypeWithoutStructuralTyping(foundType)) {
                    if (this.matchesPrototype(checkType, foundType)) {
                        return ConformanceResult.VIOLATION;
                    }
                    if (this.reportLooseTypeViolations) {
                        return ConformanceResult.POSSIBLE_VIOLATION_DUE_TO_LOOSE_TYPES;
                    }
                }
            }
            return ConformanceResult.CONFORMANCE;
        }

        private boolean matchesPrototype(JSType type, JSType maybePrototype) {
            ObjectType methodClassObjectType = type.toMaybeObjectType();
            return methodClassObjectType != null && methodClassObjectType.getImplicitPrototype().equals(maybePrototype);
        }

        private @Nullable JSType extractType(Node n) {
            switch (n.getToken()) {
                case GETPROP: 
                case GETELEM: {
                    return n.getFirstChild().getJSType();
                }
                case STRING_KEY: 
                case COMPUTED_PROP: {
                    Node parent = n.getParent();
                    switch (parent.getToken()) {
                        case OBJECT_PATTERN: 
                        case OBJECTLIT: {
                            return parent.getJSType();
                        }
                        case CLASS_MEMBERS: {
                            return null;
                        }
                    }
                    throw new AssertionError();
                }
            }
            return null;
        }

        private @Nullable String extractName(Node n) {
            switch (n.getToken()) {
                case GETPROP: 
                case STRING_KEY: {
                    return n.getString();
                }
                case GETELEM: {
                    Node string = n.getSecondChild();
                    return string.isStringLit() ? string.getString() : null;
                }
                case COMPUTED_PROP: {
                    Node string = n.getFirstChild();
                    return string.isStringLit() ? string.getString() : null;
                }
            }
            return null;
        }

        private static enum RequirementPrecondition implements CheckConformance.Precondition
        {
            BANNED_PROPERTY{

                @Override
                public boolean shouldCheck(Node n) {
                    switch (n.getToken()) {
                        case GETPROP: 
                        case STRING_KEY: 
                        case GETELEM: 
                        case COMPUTED_PROP: {
                            return true;
                        }
                    }
                    return false;
                }
            }
            ,
            BANNED_PROPERTY_WRITE{

                @Override
                public boolean shouldCheck(Node n) {
                    return NodeUtil.isLValue(n);
                }
            }
            ,
            BANNED_PROPERTY_NON_CONSTANT_WRITE{

                @Override
                public boolean shouldCheck(Node n) {
                    if (!NodeUtil.isLValue(n)) {
                        return false;
                    }
                    return !NodeUtil.isLhsOfAssign(n) || !NodeUtil.isLiteralValue(n.getNext(), false) && !NodeUtil.isSomeCompileTimeConstStringValue(n.getNext());
                }
            }
            ,
            BANNED_PROPERTY_READ{

                @Override
                public boolean shouldCheck(Node n) {
                    return !NodeUtil.isLValue(n) && NodeUtil.isExpressionResultUsed(n);
                }
            }
            ,
            BANNED_PROPERTY_CALL{

                @Override
                public boolean shouldCheck(Node n) {
                    return ConformanceUtil.isCallTarget(n);
                }
            };

        }
    }

    static final class BannedName
    extends AbstractRule {
        private final Requirement.Type requirementType;
        private final ImmutableList<Node> qualifiedNames;
        private final ImmutableSet<String> shortNames;
        private static final CheckConformance.Precondition IS_CANDIDATE_NODE = n -> {
            switch (n.getToken()) {
                case GETPROP: {
                    return n.getFirstChild().isQualifiedName();
                }
                case NAME: {
                    return !n.getString().isEmpty();
                }
            }
            return false;
        };

        BannedName(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (requirement.getValueCount() == 0) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            this.requirementType = requirement.getType();
            ImmutableList.Builder qualifiedBuilder = ImmutableList.builder();
            ImmutableSet.Builder shortBuilder = ImmutableSet.builder();
            for (String name : requirement.getValueList()) {
                Node qualifiedName = NodeUtil.newQName(compiler, name);
                qualifiedBuilder.add((Object)qualifiedName);
                shortBuilder.add((Object)qualifiedName.getString());
            }
            this.qualifiedNames = qualifiedBuilder.build();
            this.shortNames = shortBuilder.build();
        }

        @Override
        public final CheckConformance.Precondition getPrecondition() {
            return IS_CANDIDATE_NODE;
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (this.requirementType == Requirement.Type.BANNED_NAME_CALL && !ConformanceUtil.isCallTarget(n)) {
                return ConformanceResult.CONFORMANCE;
            }
            if (!this.shortNames.contains((Object)n.getString())) {
                return ConformanceResult.CONFORMANCE;
            }
            if (NodeUtil.isInSyntheticScript(n) || !BannedName.isRootOfQualifiedNameGlobal(t, n)) {
                return ConformanceResult.CONFORMANCE;
            }
            for (int i = this.qualifiedNames.size() - 1; i >= 0; --i) {
                if (!n.matchesQualifiedName((Node)this.qualifiedNames.get(i))) continue;
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }

        private static boolean isRootOfQualifiedNameGlobal(NodeTraversal t, Node n) {
            String rootName = NodeUtil.getRootOfQualifiedName(n).getQualifiedName();
            Var v = (Var)t.getScope().getVar(rootName);
            return v != null && v.isGlobal();
        }
    }

    static class BannedDependencyRegex
    extends AbstractRule {
        private final @Nullable Pattern pathRegexp;

        BannedDependencyRegex(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            ProtocolStringList pathRegexpList = requirement.getValueList();
            if (pathRegexpList.isEmpty()) {
                throw new CheckConformance.InvalidRequirementSpec("missing value (no banned dependency regexps)");
            }
            this.pathRegexp = ConformanceRules.buildPattern((List<String>)pathRegexpList);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (n.isScript()) {
                String srcFile = n.getSourceFileName();
                if (this.pathRegexp != null && this.pathRegexp.matcher(srcFile).find()) {
                    return ConformanceResult.VIOLATION;
                }
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    static class BannedDependency
    extends AbstractRule {
        private final List<String> paths;

        BannedDependency(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            this.paths = requirement.getValueList();
            if (this.paths.isEmpty()) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (n.isScript()) {
                String srcFile = n.getSourceFileName();
                for (int i = 0; i < this.paths.size(); ++i) {
                    String path = this.paths.get(i);
                    if (!srcFile.startsWith(path)) continue;
                    return ConformanceResult.VIOLATION;
                }
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    static class InferredConstCheck
    extends AbstractRule {
        public InferredConstCheck(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            JSDocInfo jsDoc = n.getJSDocInfo();
            if (jsDoc != null && jsDoc.hasConstAnnotation() && jsDoc.getType() == null) {
                JSType type;
                if (n.isAssign()) {
                    n = n.getFirstChild();
                }
                if ((type = n.getJSType()) != null && type.isUnknownType() && !NodeUtil.isNamespaceDecl(n)) {
                    return ConformanceResult.VIOLATION;
                }
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    static abstract class AbstractTypeRestrictionRule
    extends AbstractRule {
        private final JSType nativeObjectType;
        private final JSType allowlistedTypes;
        private final CodingConvention.AssertionFunctionLookup assertionFunctions;

        public AbstractTypeRestrictionRule(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            this.nativeObjectType = compiler.getTypeRegistry().getNativeType(JSTypeNative.OBJECT_TYPE);
            ProtocolStringList allowlistedTypeNames = requirement.getValueList();
            this.allowlistedTypes = this.union((List<String>)allowlistedTypeNames);
            this.assertionFunctions = CodingConvention.AssertionFunctionLookup.of(compiler.getCodingConvention().getAssertionFunctions());
        }

        protected boolean isAllowlistedType(Node n) {
            JSType targetType;
            return this.allowlistedTypes != null && n.getJSType() != null && (targetType = n.getJSType().restrictByNotNullOrUndefined()).isSubtypeOf(this.allowlistedTypes);
        }

        protected static boolean isKnown(Node n) {
            return !AbstractTypeRestrictionRule.isUnknown(n) && !AbstractTypeRestrictionRule.isBottom(n) && !AbstractTypeRestrictionRule.isTemplateType(n);
        }

        protected boolean isNativeObjectType(Node n) {
            JSType type = n.getJSType().restrictByNotNullOrUndefined();
            return type.equals(this.nativeObjectType);
        }

        protected static boolean isTop(Node n) {
            JSType type = n.getJSType();
            return type != null && type.isAllType();
        }

        protected static boolean isUnknown(Node n) {
            JSType type = n.getJSType();
            return type == null || type.isUnknownType();
        }

        protected static boolean isTemplateType(Node n) {
            JSType type = n.getJSType();
            if (type.isUnionType()) {
                for (JSType member : type.getUnionMembers()) {
                    if (!member.isTemplateType()) continue;
                    return true;
                }
            }
            return type.isTemplateType();
        }

        private static boolean isBottom(Node n) {
            JSType type = n.getJSType().restrictByNotNullOrUndefined();
            return type.isEmptyType();
        }

        protected @Nullable JSType union(List<String> typeNames) {
            JSTypeRegistry registry = this.compiler.getTypeRegistry();
            ArrayList<JSType> types = new ArrayList<JSType>();
            for (String typeName : typeNames) {
                JSType type = registry.getGlobalType(typeName);
                if (type == null) continue;
                types.add(type);
            }
            if (types.isEmpty()) {
                return null;
            }
            return registry.createUnionType(types);
        }

        protected boolean isAssertionCall(Node n) {
            if (n.isCall() && n.getFirstChild().isQualifiedName()) {
                Node target = n.getFirstChild();
                return this.assertionFunctions.lookupByCallee(target) != null;
            }
            return false;
        }

        protected boolean isTypeImmediatelyTightened(Node n) {
            return this.isAssertionCall(n.getParent()) || n.getParent().isTypeOf() || n.getJSTypeBeforeCast() != null;
        }

        protected boolean isUsed(Node n) {
            if (n.getParent().isName() || NodeUtil.isLhsByDestructuring(n)) {
                return false;
            }
            if (NodeUtil.isAssignmentOp(n.getParent())) {
                return NodeUtil.isExpressionResultUsed(n.getParent());
            }
            return NodeUtil.isExpressionResultUsed(n);
        }
    }

    static final class NoOp
    extends AbstractRule {
        NoOp(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            return ConformanceResult.CONFORMANCE;
        }
    }

    public static abstract class AbstractRule
    implements CheckConformance.Rule {
        final AbstractCompiler compiler;
        final String message;
        final Requirement.Severity severity;
        final ImmutableList<AllowList> allowlists;
        final @Nullable AllowList onlyApplyTo;
        final boolean reportLooseTypeViolations;
        final TypeMatchingStrategy typeMatchingStrategy;
        final Requirement requirement;

        public AbstractRule(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            AllowList allowlist;
            if (!requirement.hasErrorMessage()) {
                throw new CheckConformance.InvalidRequirementSpec("missing message");
            }
            this.compiler = compiler;
            Object message = requirement.getErrorMessage();
            if (requirement.getConfigFileCount() > 0) {
                message = (String)message + "\n  defined in " + Joiner.on((String)"\n  extended by ").join((Iterable)requirement.getConfigFileList());
            }
            this.message = message;
            this.severity = requirement.getSeverity() == Requirement.Severity.UNSPECIFIED ? Requirement.Severity.WARNING : requirement.getSeverity();
            ImmutableList.Builder allowlistsBuilder = new ImmutableList.Builder();
            for (Requirement.WhitelistEntry entry : requirement.getWhitelistEntryList()) {
                allowlistsBuilder.add((Object)new AllowList(entry));
            }
            for (Requirement.WhitelistEntry entry : requirement.getAllowlistEntryList()) {
                allowlistsBuilder.add((Object)new AllowList(entry));
            }
            if (this.tsIsAllowlisted()) {
                allowlistsBuilder.add((Object)ALL_TS_ALLOWLIST);
            }
            if (requirement.getWhitelistCount() > 0 || requirement.getWhitelistRegexpCount() > 0) {
                allowlist = new AllowList((List<String>)requirement.getWhitelistList(), (List<String>)requirement.getWhitelistRegexpList());
                allowlistsBuilder.add((Object)allowlist);
            }
            if (requirement.getAllowlistCount() > 0 || requirement.getAllowlistRegexpCount() > 0) {
                allowlist = new AllowList((List<String>)requirement.getAllowlistList(), (List<String>)requirement.getAllowlistRegexpList());
                allowlistsBuilder.add((Object)allowlist);
            }
            this.allowlists = allowlistsBuilder.build();
            this.onlyApplyTo = requirement.getOnlyApplyToCount() > 0 || requirement.getOnlyApplyToRegexpCount() > 0 ? new AllowList((List<String>)requirement.getOnlyApplyToList(), (List<String>)requirement.getOnlyApplyToRegexpList()) : null;
            this.reportLooseTypeViolations = requirement.getReportLooseTypeViolations();
            this.typeMatchingStrategy = AbstractRule.getTypeMatchingStrategy(requirement);
            this.requirement = requirement;
        }

        protected boolean tsIsAllowlisted() {
            return false;
        }

        private static TypeMatchingStrategy getTypeMatchingStrategy(Requirement requirement) {
            switch (requirement.getTypeMatchingStrategy()) {
                case LOOSE: {
                    return TypeMatchingStrategy.LOOSE;
                }
                case STRICT_NULLABILITY: {
                    return TypeMatchingStrategy.STRICT_NULLABILITY;
                }
                case SUBTYPES: {
                    return TypeMatchingStrategy.SUBTYPES;
                }
                case EXACT: {
                    return TypeMatchingStrategy.EXACT;
                }
            }
            throw new IllegalStateException("Unknown TypeMatchingStrategy");
        }

        protected abstract ConformanceResult checkConformance(NodeTraversal var1, Node var2);

        private @Nullable AllowList findAllowListForPath(String path) {
            Optional<Pattern> pathRegex = this.compiler.getOptions().getConformanceRemoveRegexFromPath();
            if (pathRegex.isPresent()) {
                path = ((Pattern)pathRegex.get()).matcher(path).replaceFirst("");
            }
            for (AllowList allowlist : this.allowlists) {
                if (!allowlist.matches(path)) continue;
                return allowlist;
            }
            return null;
        }

        @Override
        public final void check(NodeTraversal t, Node n) {
            ConformanceResult result = this.checkConformance(t, n);
            if (result.level != ConformanceLevel.CONFORMANCE) {
                this.report(n, result);
            }
        }

        protected void report(Node n, ConformanceResult result) {
            DiagnosticType msg = this.severity == Requirement.Severity.ERROR ? CheckConformance.CONFORMANCE_ERROR : (result.level == ConformanceLevel.VIOLATION ? CheckConformance.CONFORMANCE_VIOLATION : CheckConformance.CONFORMANCE_POSSIBLE_VIOLATION);
            String separator = result.note.isEmpty() ? "" : "\n";
            JSError err = JSError.make(this.requirement, n, msg, this.message, separator, result.note);
            String path = NodeUtil.getSourceName(n);
            AllowList allowlist = path != null ? this.findAllowListForPath(path) : null;
            boolean shouldReport = this.compiler.getErrorManager().shouldReportConformanceViolation(this.requirement, (Optional<Requirement.WhitelistEntry>)(allowlist != null ? Optional.fromNullable((Object)allowlist.allowlistEntry) : Optional.absent()), err);
            if (shouldReport && allowlist == null && (this.onlyApplyTo == null || this.onlyApplyTo.matches(path))) {
                this.compiler.report(err);
            }
        }
    }

    public static enum ConformanceLevel {
        CONFORMANCE,
        POSSIBLE_VIOLATION,
        VIOLATION;

    }

    public static class ConformanceResult {
        public final ConformanceLevel level;
        public final String note;
        public static final ConformanceResult CONFORMANCE = new ConformanceResult(ConformanceLevel.CONFORMANCE);
        public static final ConformanceResult POSSIBLE_VIOLATION = new ConformanceResult(ConformanceLevel.POSSIBLE_VIOLATION);
        private static final ConformanceResult POSSIBLE_VIOLATION_DUE_TO_LOOSE_TYPES = new ConformanceResult(ConformanceLevel.POSSIBLE_VIOLATION, "The type information available for this expression is too loose to ensure conformance.");
        public static final ConformanceResult VIOLATION = new ConformanceResult(ConformanceLevel.VIOLATION);

        ConformanceResult(ConformanceLevel level) {
            this(level, "");
        }

        ConformanceResult(ConformanceLevel level, String note) {
            this.level = level;
            this.note = note;
        }
    }
}

