/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import com.google.common.io.BaseEncoding;
import com.google.debugging.sourcemap.SourceMapConsumerV3;
import com.google.debugging.sourcemap.proto.Mapping;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AccessorSummary;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodeChangeHandler;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerExecutor;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerOptionsPreprocessor;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ComposeWarningsGuard;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.CustomPassExecutionTime;
import com.google.javascript.jscomp.DefaultPassConfig;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.DotFormatter;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.FindModuleDependencies;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.IdGenerator;
import com.google.javascript.jscomp.IndexProvider;
import com.google.javascript.jscomp.J2clSuppressWarningsGuard;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.JSChunkGraph;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.LoggerErrorManager;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.ModuleIdentifier;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PerformanceTracker;
import com.google.javascript.jscomp.PhaseOptimizer;
import com.google.javascript.jscomp.Platform;
import com.google.javascript.jscomp.PrebuildAst;
import com.google.javascript.jscomp.PrebuildDependencyInfo;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.PrintStreamErrorReportGenerator;
import com.google.javascript.jscomp.RecentChange;
import com.google.javascript.jscomp.ReferenceCollector;
import com.google.javascript.jscomp.Region;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.RewriteJsonToModule;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.SortingErrorManager;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceFileMapping;
import com.google.javascript.jscomp.SourceInformationAnnotator;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.SourceMapInput;
import com.google.javascript.jscomp.SourceMapResolver;
import com.google.javascript.jscomp.SuppressDocWarningsGuard;
import com.google.javascript.jscomp.SymbolTable;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.ThreadSafeDelegatingErrorManager;
import com.google.javascript.jscomp.Timeline;
import com.google.javascript.jscomp.Tracer;
import com.google.javascript.jscomp.TypeMismatch;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedScopeCreator;
import com.google.javascript.jscomp.UniqueIdSupplier;
import com.google.javascript.jscomp.ValidityCheck;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.WarningsGuard;
import com.google.javascript.jscomp.base.format.SimpleFormat;
import com.google.javascript.jscomp.colors.ColorRegistry;
import com.google.javascript.jscomp.deps.BrowserModuleResolver;
import com.google.javascript.jscomp.deps.BrowserWithTransformedPrefixesModuleResolver;
import com.google.javascript.jscomp.deps.JsFileRegexParser;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.deps.NodeModuleResolver;
import com.google.javascript.jscomp.deps.SortedDependencies;
import com.google.javascript.jscomp.deps.WebpackModuleResolver;
import com.google.javascript.jscomp.diagnostic.LogFile;
import com.google.javascript.jscomp.instrumentation.CoverageInstrumentationPass;
import com.google.javascript.jscomp.modules.ModuleMap;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.parsing.parser.trees.Comment;
import com.google.javascript.jscomp.resources.ResourceLoader;
import com.google.javascript.jscomp.serialization.ColorPool;
import com.google.javascript.jscomp.serialization.SerializationOptions;
import com.google.javascript.jscomp.serialization.SerializeTypedAstPass;
import com.google.javascript.jscomp.serialization.TypedAstDeserializer;
import com.google.javascript.jscomp.type.ChainableReverseAbstractInterpreter;
import com.google.javascript.jscomp.type.ClosureReverseAbstractInterpreter;
import com.google.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.javascript.jscomp.type.SemanticReverseAbstractInterpreter;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jspecify.nullness.Nullable;

public class Compiler
extends AbstractCompiler
implements ErrorHandler,
SourceFileMapping {
    static final DiagnosticType MODULE_DEPENDENCY_ERROR = DiagnosticType.error("JSC_MODULE_DEPENDENCY_ERROR", "Bad dependency: {0} -> {1}. Modules must be listed in dependency order.");
    static final DiagnosticType MISSING_ENTRY_ERROR = DiagnosticType.error("JSC_MISSING_ENTRY_ERROR", "required entry point \"{0}\" never provided");
    static final DiagnosticType MISSING_MODULE_ERROR = DiagnosticType.error("JSC_MISSING_MODULE_ERROR", "unknown module \"{0}\" specified in entry point spec");
    private @Nullable CompilerOptions options = null;
    private @Nullable PassConfig passes = null;
    private final ArrayList<CompilerInput> externs = new ArrayList();
    private JSChunkGraph chunkGraph;
    private ModuleLoader moduleLoader;
    private final Map<String, CompilerInput.ModuleType> moduleTypesByName;
    private ErrorManager errorManager;
    private WarningsGuard warningsGuard;
    private final LinkedHashSet<String> injectedLibraries = new LinkedHashSet();
    private @Nullable Node lastInjectedLibrary;
    private Node externsRoot;
    private Node jsRoot;
    private Node externAndJsRoot;
    private @Nullable String lastJsSource = null;
    private FeatureSet allowableFeatures;
    private final Map<InputId, CompilerInput> inputsById = new ConcurrentHashMap<InputId, CompilerInput>();
    private final Map<String, Node> scriptNodeByFilename = new ConcurrentHashMap<String, Node>();
    private ImmutableMap<String, String> inputPathByWebpackId;
    private StaticScope transpilationNamespace;
    private final ConcurrentHashMap<String, SourceFile> sourceMapOriginalSources = new ConcurrentHashMap();
    ConcurrentHashMap<String, SourceMapInput> inputSourceMaps = new ConcurrentHashMap();
    private Map<String, List<Comment>> commentsPerFile = new ConcurrentHashMap<String, List<Comment>>();
    private SourceMap sourceMap;
    private @Nullable String externExports = null;
    private UniqueIdSupplier uniqueIdSupplier = new UniqueIdSupplier();
    private int uniqueNameId = 0;
    private boolean hasRegExpGlobalReferences = true;
    private boolean runJ2clPasses = false;
    CodingConvention defaultCodingConvention = new ClosureCodingConvention();
    private @Nullable JSTypeRegistry typeRegistry;
    private @Nullable ColorRegistry colorRegistry;
    private volatile @Nullable Config parserConfig = null;
    private volatile @Nullable Config externsParserConfig = null;
    private @Nullable ReverseAbstractInterpreter abstractInterpreter;
    private @Nullable TypeValidator typeValidator;
    private @Nullable PhaseOptimizer phaseOptimizer = null;
    public PerformanceTracker tracker;
    private ImmutableMap<String, Supplier<Node>> runtimeLibraryTypedAsts;
    private Set<String> forwardDeclaredTypes = new LinkedHashSet<String>();
    private boolean typeCheckingHasRun = false;
    private final ErrorReporter oldErrorReporter = RhinoErrorReporter.forOldRhino(this);
    private final CompilerExecutor compilerExecutor = this.createCompilerExecutor();
    public static final Logger logger = Logger.getLogger("com.google.javascript.jscomp");
    private final PrintStream outStream;
    private String lastPassName;
    private @Nullable ImmutableSet<String> externProperties = null;
    private @Nullable AccessorSummary accessorSummary = null;
    private static final Joiner pathJoiner = Joiner.on((String)Platform.getFileSeperator());
    private int changeStamp = 1;
    private final Timeline<Node> changeTimeline = new Timeline();
    private final ResolvedSourceMap resolvedSourceMap = new ResolvedSourceMap();
    private @Nullable ConcurrentMap<SourceFile, Supplier<Node>> typedAstFilesystem;
    private static final DiagnosticType EMPTY_MODULE_LIST_ERROR = DiagnosticType.error("JSC_EMPTY_MODULE_LIST_ERROR", "At least one module must be provided");
    private static final DiagnosticType EMPTY_ROOT_MODULE_ERROR = DiagnosticType.error("JSC_EMPTY_ROOT_MODULE_ERROR", "Root module ''{0}'' must contain at least one source code input");
    static final DiagnosticType DUPLICATE_INPUT = DiagnosticType.error("JSC_DUPLICATE_INPUT", "Duplicate input: {0}");
    static final DiagnosticType DUPLICATE_EXTERN_INPUT = DiagnosticType.error("JSC_DUPLICATE_EXTERN_INPUT", "Duplicate extern input: {0}");
    private final PassFactory validityCheck = PassFactory.builder().setName("validityCheck").setRunInFixedPointLoop(true).setInternalFactory(ValidityCheck::new).setCondition(o -> {
        throw new IllegalStateException("Unexpected");
    }).build();
    private @Nullable TypedScopeCreator typedScopeCreator;
    private @Nullable TypedScope topScope = null;
    private boolean preferRegexParser = false;
    private static final String SYNTHETIC_FILE_NAME_PREFIX = " [synthetic:";
    private static final InputId SYNTHETIC_CODE_INPUT_ID = new InputId(" [synthetic:input] ");
    @VisibleForTesting
    final SourceFile SYNTHETIC_EXTERNS_FILE = SourceFile.fromCode(" [synthetic:externs] ", "", StaticSourceFile.SourceKind.EXTERN);
    private @Nullable CompilerInput syntheticExternsInput;
    protected final RecentChange recentChange = new RecentChange();
    private final List<CodeChangeHandler> codeChangeHandlers = new ArrayList<CodeChangeHandler>();
    private final Map<Class<?>, IndexProvider<?>> indexProvidersByType = new LinkedHashMap();
    private IdGenerator crossModuleIdGenerator = new IdGenerator();
    private @Nullable Set<String> cssNames = null;
    private @Nullable VariableMap variableMap = null;
    private @Nullable VariableMap propertyMap = null;
    private @Nullable VariableMap stringMap = null;
    private @Nullable VariableMap instrumentationMapping = null;
    private @Nullable String idGeneratorMap = null;
    private boolean transpiledFiles = false;
    private final LinkedHashSet<String> exportedNames = new LinkedHashSet();
    private ModuleMetadataMap moduleMetadataMap;
    private ModuleMap moduleMap;

    public Compiler() {
        this((PrintStream)null);
    }

    public Compiler(@Nullable PrintStream outStream) {
        this.addChangeHandler(this.recentChange);
        this.outStream = outStream;
        this.moduleTypesByName = new LinkedHashMap<String, CompilerInput.ModuleType>();
    }

    public Compiler(ErrorManager errorManager) {
        this();
        this.setErrorManager(errorManager);
    }

    public void setErrorManager(ErrorManager errorManager) {
        Preconditions.checkNotNull((Object)errorManager, (Object)"the error manager cannot be null");
        this.errorManager = new ThreadSafeDelegatingErrorManager(errorManager);
    }

    private MessageFormatter createMessageFormatter() {
        boolean colorize = this.options.shouldColorizeErrorOutput();
        return this.options.errorFormat.toFormatter(this, colorize);
    }

    private void initExperimentalForceTranspileOptions(CompilerOptions options) {
        FeatureSet featureSet = options.getOutputFeatureSet();
        if (Objects.equals(featureSet, FeatureSet.ES5) || Objects.equals(featureSet, FeatureSet.ES3)) {
            return;
        }
        for (CompilerOptions.ExperimentalForceTranspile experimentalForceTranspile : options.getExperimentalForceTranspiles()) {
            switch (experimentalForceTranspile) {
                case LET_CONST: {
                    options.setOutputFeatureSet(options.getOutputFeatureSet().without(FeatureSet.Feature.LET_DECLARATIONS, FeatureSet.Feature.CONST_DECLARATIONS, FeatureSet.Feature.FOR_OF, FeatureSet.Feature.ARRAY_DESTRUCTURING, FeatureSet.Feature.OBJECT_DESTRUCTURING));
                }
                case CLASS: {
                    options.setOutputFeatureSet(options.getOutputFeatureSet().without(FeatureSet.Feature.CLASSES, FeatureSet.Feature.CLASS_EXTENDS, FeatureSet.Feature.CLASS_GETTER_SETTER, FeatureSet.Feature.PUBLIC_CLASS_FIELDS, FeatureSet.Feature.CLASS_STATIC_BLOCK, FeatureSet.Feature.NEW_TARGET));
                    break;
                }
                case ALL_EXCEPT_ASYNC_AWAIT: {
                    options.setOutputFeatureSet(FeatureSet.ES5.with(FeatureSet.Feature.ASYNC_FUNCTIONS, FeatureSet.Feature.ASYNC_GENERATORS));
                }
            }
        }
    }

    public void initOptions(CompilerOptions options) {
        this.options = options;
        this.allowableFeatures = options.getLanguageIn().toFeatureSet();
        this.initExperimentalForceTranspileOptions(options);
        if (this.errorManager == null) {
            if (this.outStream == null) {
                this.setErrorManager(new LoggerErrorManager(this.createMessageFormatter(), logger));
            } else {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                builder.add((Object)new PrintStreamErrorReportGenerator(this.createMessageFormatter(), this.outStream, options.summaryDetailLevel));
                builder.addAll(options.getExtraReportGenerators());
                this.setErrorManager(new SortingErrorManager((Set<SortingErrorManager.ErrorReportGenerator>)builder.build()));
            }
        }
        this.moduleLoader = ModuleLoader.EMPTY;
        this.reconcileOptionsWithGuards();
        if (!options.isTypecheckingEnabled()) {
            options.setUseTypesForLocalOptimization(false);
            options.setUseTypesForOptimization(false);
        }
        if (options.assumeForwardDeclaredForMissingTypes) {
            this.forwardDeclaredTypes = new AbstractSet<String>(){

                @Override
                public boolean contains(Object o) {
                    return true;
                }

                @Override
                public boolean add(String e) {
                    return false;
                }

                @Override
                public Iterator<String> iterator() {
                    return Collections.emptyIterator();
                }

                @Override
                public int size() {
                    return 0;
                }
            };
        }
        this.initWarningsGuard(options.getWarningsGuard());
        if (this.isDebugLoggingEnabled()) {
            options.setPrintConfig(true);
        }
        boolean bl = this.preferRegexParser = this.preferRegexParser || options.getDependencyOptions().shouldPrune();
        if (options.getMergedPrecompiledLibraries() && options.getDependencyOptions().needsManagement()) {
            throw new IllegalArgumentException("Using precompiled libraries (i.e. TypedAST) is incompatible with flags that automatically order/prune dependencies: " + options.getDependencyOptions());
        }
    }

    public void printConfig() {
        if (this.isDebugLoggingEnabled()) {
            this.logToFile("externs.log", this.externs::toString);
            this.logToFile("inputs.json", () -> Iterables.toString(this.chunkGraph.getAllInputs()));
            this.logToFile("options.log", () -> this.options.toString());
            this.logToFile("warningsGuard.log", () -> this.warningsGuard.toString());
        } else {
            PrintStream err = System.err;
            err.println("==== Externs ====");
            err.println(this.externs);
            err.println("==== Inputs ====");
            err.println(Iterables.toString(this.chunkGraph.getAllInputs()));
            err.println("==== CompilerOptions ====");
            err.println(this.options);
            err.println("==== WarningsGuard ====");
            err.println(this.warningsGuard);
        }
    }

    private void logToFile(String logFileName, Supplier<String> logStringSupplier) {
        try (LogFile log = this.createOrReopenLog(this.getClass(), logFileName, new String[0]);){
            log.log(logStringSupplier);
        }
    }

    private void initWarningsGuard(WarningsGuard warningsGuard) {
        ImmutableList.Builder guards = ImmutableList.builder();
        guards.add((Object)new J2clSuppressWarningsGuard()).add((Object)new SuppressDocWarningsGuard(this, (Map<String, DiagnosticGroup>)DiagnosticGroups.getRegisteredGroups())).add((Object)warningsGuard);
        this.warningsGuard = new ComposeWarningsGuard((List<WarningsGuard>)guards.build());
    }

    protected void reconcileOptionsWithGuards() {
        if (this.options.enables(DiagnosticGroups.CHECK_TYPES)) {
            this.options.checkTypes = true;
        } else if (this.options.disables(DiagnosticGroups.CHECK_TYPES)) {
            this.options.checkTypes = false;
        } else if (!this.options.checkTypes) {
            this.options.setWarningLevel(DiagnosticGroup.forType(RhinoErrorReporter.TYPE_PARSE_ERROR), CheckLevel.OFF);
        }
        if (!this.options.checkTypes) {
            this.options.setWarningLevel(DiagnosticGroups.BOUNDED_GENERICS, CheckLevel.OFF);
        }
        if (!this.options.checkSymbols && !this.options.enables(DiagnosticGroups.CHECK_VARIABLES)) {
            this.options.setWarningLevel(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.OFF);
        }
        if (this.options.skipNonTranspilationPasses && !this.options.enables(DiagnosticGroups.CHECK_VARIABLES)) {
            this.options.setWarningLevel(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.OFF);
        }
        if (this.options.skipNonTranspilationPasses && !this.options.enables(DiagnosticGroups.MISSING_PROVIDE)) {
            this.options.setWarningLevel(DiagnosticGroups.MISSING_PROVIDE, CheckLevel.OFF);
        }
    }

    @Override
    @Nullable Supplier<Node> getTypedAstDeserializer(SourceFile file) {
        if (this.typedAstFilesystem == null) {
            return null;
        }
        Supplier ast = (Supplier)this.typedAstFilesystem.remove(file);
        Preconditions.checkState((ast != null || file.getName().startsWith(SYNTHETIC_FILE_NAME_PREFIX) ? 1 : 0) != 0, (String)"TypedAST filesystem initialized, but missing requested file: %s", (Object)file);
        return ast;
    }

    @GwtIncompatible
    public final void initWithTypedAstFilesystem(List<SourceFile> externs, List<SourceFile> sources, CompilerOptions options, InputStream typedAstListStream) {
        ImmutableSet files = ImmutableSet.builder().addAll(externs).addAll(sources).build();
        options.setMergedPrecompiledLibraries(true);
        this.initOptions(options);
        this.init(externs, sources, options);
        this.mergeAndDeserializeTypedAsts((ImmutableSet<SourceFile>)files, typedAstListStream, options);
    }

    @GwtIncompatible
    public void initChunksWithTypedAstFilesystem(List<SourceFile> externs, List<JSChunk> chunks, CompilerOptions options, InputStream typedAstListStream) {
        ImmutableSet.Builder filesBuilder = ImmutableSet.builder();
        filesBuilder.addAll(externs);
        for (JSChunk chunk : chunks) {
            for (CompilerInput input : chunk.getInputs()) {
                filesBuilder.add((Object)input.getSourceFile());
            }
        }
        ImmutableSet files = filesBuilder.build();
        options.setMergedPrecompiledLibraries(true);
        this.initOptions(options);
        this.initChunks(externs, chunks, options);
        this.mergeAndDeserializeTypedAsts((ImmutableSet<SourceFile>)files, typedAstListStream, options);
    }

    @GwtIncompatible
    private void mergeAndDeserializeTypedAsts(ImmutableSet<SourceFile> requiredInputFiles, InputStream typedAstListStream, CompilerOptions options) {
        Preconditions.checkState((this.typedAstFilesystem == null ? 1 : 0) != 0);
        this.maybeSetTracker();
        this.setLifeCycleStage(AbstractCompiler.LifeCycleStage.COLORS_AND_SIMPLIFIED_JSDOC);
        boolean deserializeTypes = options.requiresTypesForOptimization();
        TypedAstDeserializer.DeserializedAst astData = this.runInCompilerThread(() -> {
            Tracer tracer = this.newTracer("deserializeTypedAst");
            try {
                TypedAstDeserializer.DeserializedAst deserializedAst = TypedAstDeserializer.deserializeFullAst(this, this.SYNTHETIC_EXTERNS_FILE, requiredInputFiles, typedAstListStream, deserializeTypes, options.resolveSourceMapAnnotations, options.parseInlineSourceMaps);
                return deserializedAst;
            }
            finally {
                this.stopTracer(tracer, "deserializeTypedAst");
            }
        });
        this.typedAstFilesystem = astData.getFilesystem();
        this.externProperties = astData.getExternProperties();
        this.colorRegistry = (ColorRegistry)astData.getColorRegistry().orNull();
        this.setTypeCheckingHasRun(deserializeTypes);
        this.getSynthesizedExternsInput();
        this.runInCompilerThread(() -> {
            this.parseForCompilationInternal();
            return null;
        });
    }

    @Override
    @GwtIncompatible
    public void initRuntimeLibraryTypedAsts(Optional<ColorPool.Builder> colorPoolBuilder) {
        Preconditions.checkState((this.runtimeLibraryTypedAsts == null ? 1 : 0) != 0);
        String path = String.join((CharSequence)"", "/runtime_libs.typedast");
        TypedAstDeserializer.DeserializedAst astData = TypedAstDeserializer.deserializeRuntimeLibraries(this, this.SYNTHETIC_EXTERNS_FILE, colorPoolBuilder, Compiler.class.getResourceAsStream(path), this.getOptions().resolveSourceMapAnnotations, this.getOptions().parseInlineSourceMaps);
        LinkedHashMap<String, Supplier> runtimeLibraryTypedAsts = new LinkedHashMap<String, Supplier>();
        for (Map.Entry library : astData.getFilesystem().entrySet()) {
            runtimeLibraryTypedAsts.computeIfAbsent(((SourceFile)library.getKey()).getName(), f -> (Supplier)library.getValue());
        }
        this.runtimeLibraryTypedAsts = ImmutableMap.copyOf(runtimeLibraryTypedAsts);
    }

    public final void init(List<SourceFile> externs, List<SourceFile> sources, CompilerOptions options) {
        JSChunk chunk = new JSChunk("$strong$");
        for (SourceFile source : sources) {
            chunk.add(new CompilerInput(source, false));
        }
        ArrayList<JSChunk> chunks = new ArrayList<JSChunk>(1);
        chunks.add(chunk);
        this.initChunks(externs, chunks, options);
        this.addFilesToSourceMap(sources);
    }

    public void initChunks(List<SourceFile> externs, List<JSChunk> chunks, CompilerOptions options) {
        this.initOptions(options);
        this.checkFirstModule(chunks);
        this.externs.clear();
        for (SourceFile file : externs) {
            this.externs.add(new CompilerInput(file, true));
        }
        try {
            this.chunkGraph = new JSChunkGraph(chunks);
        }
        catch (JSChunkGraph.ChunkDependenceException e) {
            this.report(JSError.make(MODULE_DEPENDENCY_ERROR, e.getChunk().getName(), e.getDependentChunk().getName()));
            return;
        }
        this.fillEmptyModules(this.getChunks());
        this.commentsPerFile = new ConcurrentHashMap<String, List<Comment>>(this.chunkGraph.getInputCount());
        this.initBasedOnOptions();
        this.initInputsByIdMap();
        this.initAST();
        if (this.isDebugLoggingEnabled() || options.printConfig) {
            this.printConfig();
        }
        try (LogFile chunkGraphLog = this.createOrReopenLog(this.getClass(), "chunk_graph.dot", new String[0]);){
            chunkGraphLog.log(DotFormatter.toDot(this.chunkGraph.toGraphvizGraph()));
        }
    }

    public void initBasedOnOptions() {
        this.inputSourceMaps.putAll((Map<String, SourceMapInput>)this.options.inputSourceMaps);
        if (this.options.shouldGatherSourceMapInfo()) {
            this.sourceMap = this.options.sourceMapFormat.getInstance();
            this.sourceMap.setPrefixMappings(this.options.sourceMapLocationMappings);
            if (this.options.applyInputSourceMaps) {
                this.sourceMap.setSourceFileMapping(this);
                if (this.options.sourceMapIncludeSourcesContent) {
                    for (SourceMapInput inputSourceMap : this.inputSourceMaps.values()) {
                        this.addSourceMapSourceFiles(inputSourceMap);
                    }
                }
            }
        }
    }

    private void checkFirstModule(List<JSChunk> chunks) {
        if (chunks.isEmpty()) {
            this.report(JSError.make(EMPTY_MODULE_LIST_ERROR, new String[0]));
        } else if (chunks.get(0).getInputs().isEmpty() && chunks.size() > 1) {
            this.report(JSError.make(EMPTY_ROOT_MODULE_ERROR, chunks.get(0).getName()));
        }
    }

    public static String joinPathParts(String ... pathParts) {
        return pathJoiner.join((Object[])pathParts);
    }

    private void fillEmptyModules(Iterable<JSChunk> chunks) {
        for (JSChunk chunk : chunks) {
            if (chunk.getName().equals("$weak$") || !chunk.getInputs().isEmpty()) continue;
            CompilerInput input = new CompilerInput(SourceFile.fromCode(Compiler.createFillFileName(chunk.getName()), ""));
            input.setCompiler(this);
            chunk.add(input);
        }
    }

    public void rebuildInputsFromModules() {
        this.initInputsByIdMap();
    }

    void initInputsByIdMap() {
        this.inputsById.clear();
        for (CompilerInput input : this.externs) {
            CompilerInput previous = this.putCompilerInput(input);
            if (previous == null) continue;
            this.report(JSError.make(DUPLICATE_EXTERN_INPUT, input.getName()));
        }
        boolean hasZone = false;
        for (CompilerInput input : this.chunkGraph.getAllInputs()) {
            CompilerInput previous;
            if (input.getName().endsWith("packages/zone.js/lib/zone.closure.js")) {
                hasZone = true;
            }
            if ((previous = this.putCompilerInput(input)) == null) continue;
            this.report(JSError.make(DUPLICATE_INPUT, input.getName()));
        }
        if (hasZone && !this.options.allowsZoneJsWithAsyncFunctionsInOutput() && this.options.getOutputFeatureSet().contains(FeatureSet.Feature.ASYNC_FUNCTIONS)) {
            throw new UnsupportedOperationException("ZoneJS is incompatible with language level ES2017 or higher (See go/ngissue/31730)\nPlease set `--language_out=ECMASCRIPT_2016` (or older) in your flags.");
        }
    }

    private void initAST() {
        this.jsRoot = IR.root(new Node[0]);
        this.externsRoot = IR.root(new Node[0]);
        this.externAndJsRoot = IR.root(this.externsRoot, this.jsRoot);
    }

    public Result compile(SourceFile extern, SourceFile input, CompilerOptions options) {
        return this.compile((List<SourceFile>)ImmutableList.of((Object)extern), (List<SourceFile>)ImmutableList.of((Object)input), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result compile(List<SourceFile> externs, List<SourceFile> inputs, CompilerOptions options) {
        Preconditions.checkState((this.jsRoot == null ? 1 : 0) != 0);
        try {
            this.init(externs, inputs, options);
            if (!this.hasErrors()) {
                this.parseForCompilation();
            }
            if (!this.hasErrors()) {
                if (options.getInstrumentForCoverageOnly()) {
                    this.instrumentForCoverage();
                } else {
                    this.stage1Passes();
                    if (!this.hasErrors()) {
                        this.stage2Passes();
                        if (!this.hasErrors()) {
                            this.stage3Passes();
                        }
                    }
                }
                this.performPostCompilationTasks();
            }
        }
        finally {
            this.generateReport();
        }
        return this.getResult();
    }

    public void generateReport() {
        Tracer t = this.newTracer("generateReport");
        this.errorManager.generateReport();
        this.stopTracer(t, "generateReport");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result compileChunks(List<SourceFile> externs, List<JSChunk> chunks, CompilerOptions options) {
        Preconditions.checkState((this.jsRoot == null ? 1 : 0) != 0);
        try {
            this.initChunks(externs, chunks, options);
            if (!this.hasErrors()) {
                this.parseForCompilation();
            }
            if (!this.hasErrors()) {
                if (options.getInstrumentForCoverageOnly()) {
                    this.instrumentForCoverage();
                } else {
                    this.stage1Passes();
                    if (!this.hasErrors()) {
                        this.stage2Passes();
                        if (!this.hasErrors()) {
                            this.stage3Passes();
                        }
                    }
                }
                this.performPostCompilationTasks();
            }
        }
        finally {
            this.generateReport();
        }
        return this.getResult();
    }

    public void stage1Passes() {
        Preconditions.checkState((this.chunkGraph != null ? 1 : 0) != 0, (Object)"No inputs. Did you call init() or initChunks()?");
        Preconditions.checkState((!this.hasErrors() ? 1 : 0) != 0);
        Preconditions.checkState((!this.options.getInstrumentForCoverageOnly() ? 1 : 0) != 0);
        this.runInCompilerThread(() -> {
            this.performChecks();
            return null;
        });
    }

    public void stage2Passes() {
        Preconditions.checkState((this.chunkGraph != null ? 1 : 0) != 0, (Object)"No inputs. Did you call init() or initChunks()?");
        Preconditions.checkState((!this.hasErrors() ? 1 : 0) != 0);
        Preconditions.checkState((!this.options.getInstrumentForCoverageOnly() ? 1 : 0) != 0);
        JSChunk weakModule = this.chunkGraph.getChunkByName("$weak$");
        if (weakModule != null) {
            for (CompilerInput i : this.chunkGraph.getAllInputs()) {
                if (!i.getSourceFile().isWeak()) continue;
                Preconditions.checkState((i.getChunk() == weakModule ? 1 : 0) != 0, (Object)"Expected all weak files to be in the weak module.");
            }
        }
        this.runInCompilerThread(() -> {
            if (this.options.shouldOptimize()) {
                this.performTranspilationAndOptimizations();
            }
            return null;
        });
    }

    public void stage3Passes() {
        Preconditions.checkState((this.chunkGraph != null ? 1 : 0) != 0, (Object)"No inputs. Did you call init() or initChunks()?");
        Preconditions.checkState((!this.hasErrors() ? 1 : 0) != 0);
        Preconditions.checkState((!this.options.getInstrumentForCoverageOnly() ? 1 : 0) != 0);
        this.runInCompilerThread(() -> {
            if (this.options.shouldOptimize()) {
                this.performFinalizations();
            }
            return null;
        });
    }

    public void disableThreads() {
        this.compilerExecutor.disableThreads();
    }

    public void setTimeout(int timeout) {
        this.compilerExecutor.setTimeout(timeout);
    }

    public <T> T runInCompilerThread(Callable<T> callable) {
        return this.compilerExecutor.runInCompilerThread(callable, this.options != null && this.options.getTracerMode().isOn());
    }

    private void performChecks() {
        if (this.options.skipNonTranspilationPasses) {
            this.whitespaceOnlyPasses();
            if (this.options.needsTranspilationFrom(this.options.getLanguageIn().toFeatureSet())) {
                this.transpileAndDontCheck();
            }
        } else {
            this.check();
        }
    }

    public void performPostCompilationTasks() {
        this.runInCompilerThread(() -> {
            this.performPostCompilationTasksInternal();
            return null;
        });
    }

    private void performPostCompilationTasksInternal() {
        if (this.options.devMode == CompilerOptions.DevMode.START_AND_END) {
            this.runValidityCheck();
        }
        if (this.tracker != null) {
            if (this.options.getTracerOutput() == null) {
                this.tracker.outputTracerReport(this.outStream);
            } else {
                try (PrintStream out = new PrintStream(Files.newOutputStream(this.options.getTracerOutput(), new OpenOption[0]));){
                    this.tracker.outputTracerReport(out);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void instrumentForCoverage() {
        Preconditions.checkState((this.chunkGraph != null ? 1 : 0) != 0, (Object)"No inputs. Did you call init() or initChunks()?");
        Preconditions.checkState((!this.hasErrors() ? 1 : 0) != 0);
        this.runInCompilerThread(() -> {
            Preconditions.checkState((boolean)this.options.getInstrumentForCoverageOnly());
            Preconditions.checkState((!this.hasErrors() ? 1 : 0) != 0);
            if (this.options.getInstrumentForCoverageOption() != CompilerOptions.InstrumentOption.NONE) {
                this.instrumentForCoverageInternal(this.options.getInstrumentForCoverageOption());
            }
            return null;
        });
    }

    private void instrumentForCoverageInternal(CompilerOptions.InstrumentOption instrumentForCoverageOption) {
        Tracer tracer = this.newTracer("instrumentationPass");
        this.process(new CoverageInstrumentationPass(this, CoverageInstrumentationPass.CoverageReach.ALL, instrumentForCoverageOption, this.options.getProductionInstrumentationArrayName()));
        this.stopTracer(tracer, "instrumentationPass");
    }

    public void parseForCompilation() {
        Preconditions.checkState((this.typedAstFilesystem == null ? 1 : 0) != 0, (Object)"Unnecessary if initWithTypedAstFilesystem was called");
        this.runInCompilerThread(() -> {
            this.parseForCompilationInternal();
            return null;
        });
    }

    private void parseForCompilationInternal() {
        CompilerOptionsPreprocessor.preprocess(this.options);
        this.maybeSetTracker();
        this.parseInputs();
    }

    public void parse() {
        this.parseInputs();
    }

    public Node parse(SourceFile file) {
        this.initCompilerOptionsIfTesting();
        logger.finest("Parsing: " + file.getName());
        return new JsAst(file).getAstRoot(this);
    }

    PassConfig getPassConfig() {
        if (this.passes == null) {
            this.passes = this.createPassConfigInternal();
        }
        return this.passes;
    }

    protected PassConfig createPassConfigInternal() {
        return new DefaultPassConfig(this.options);
    }

    public void setPassConfig(PassConfig passes) {
        Preconditions.checkNotNull((Object)passes);
        Preconditions.checkState((this.passes == null ? 1 : 0) != 0, (Object)"setPassConfig was already called");
        this.passes = passes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void whitespaceOnlyPasses() {
        this.runCustomPasses(CustomPassExecutionTime.BEFORE_CHECKS);
        Tracer t = this.newTracer("runWhitespaceOnlyPasses");
        try {
            for (PassFactory pf : this.getPassConfig().getWhitespaceOnlyPasses().build()) {
                pf.create(this).process(this.externsRoot, this.jsRoot);
            }
        }
        finally {
            this.stopTracer(t, "runWhitespaceOnlyPasses");
        }
    }

    private void markTranspiledFiles() {
        for (Node child = this.jsRoot.getFirstChild(); child != null; child = child.getNext()) {
            Preconditions.checkState((boolean)child.isScript());
            FeatureSet featureSet = NodeUtil.getFeatureSetOfScript(child);
            if (this.options.getOutputFeatureSet().contains(featureSet)) continue;
            this.setTranspiledFiles(true);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transpileAndDontCheck() {
        Tracer t = this.newTracer("runTranspileOnlyPasses");
        this.markTranspiledFiles();
        try {
            for (PassFactory pf : this.getPassConfig().getTranspileOnlyPasses().build()) {
                if (this.hasErrors()) {
                    return;
                }
                this.beforePass(pf.getName());
                pf.create(this).process(this.externsRoot, this.jsRoot);
                this.afterPass(pf.getName());
            }
        }
        finally {
            this.stopTracer(t, "runTranspileOnlyPasses");
        }
    }

    private PhaseOptimizer createPhaseOptimizer() {
        PhaseOptimizer phaseOptimizer = new PhaseOptimizer(this, this.tracker);
        if (this.options.devMode == CompilerOptions.DevMode.EVERY_PASS) {
            phaseOptimizer.setValidityCheck(this.validityCheck);
        }
        if (this.options.getCheckDeterminism()) {
            phaseOptimizer.setPrintAstHashcodes(true);
        }
        return phaseOptimizer;
    }

    void check() {
        this.runCustomPasses(CustomPassExecutionTime.BEFORE_CHECKS);
        this.phaseOptimizer = this.createPhaseOptimizer();
        this.phaseOptimizer.consume((List<PassFactory>)this.getPassConfig().getChecks().build());
        this.phaseOptimizer.process(this.externsRoot, this.jsRoot);
        if (this.hasErrors()) {
            return;
        }
        this.runCustomPasses(CustomPassExecutionTime.BEFORE_OPTIMIZATIONS);
        this.phaseOptimizer = null;
    }

    @Override
    void setExternExports(String externExports) {
        this.externExports = externExports;
    }

    @Override
    void process(CompilerPass p) {
        p.process(this.externsRoot, this.jsRoot);
    }

    private void runValidityCheck() {
        this.validityCheck.create(this).process(this.externsRoot, this.jsRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCustomPasses(CustomPassExecutionTime executionTime) {
        if (this.options.customPasses != null) {
            Tracer t = this.newTracer("runCustomPasses");
            try {
                for (CompilerPass p : this.options.customPasses.get((Object)executionTime)) {
                    this.process(p);
                }
            }
            finally {
                this.stopTracer(t, "runCustomPasses");
            }
        }
    }

    @Override
    final void beforePass(String passName) {
        super.beforePass(passName);
    }

    @Override
    final void afterPass(String passName) {
        super.afterPass(passName);
        this.maybePrintSourceAfterEachPass(passName);
    }

    private void maybePrintSourceAfterEachPass(String passName) {
        if (!this.options.printSourceAfterEachPass) {
            return;
        }
        String currentJsSource = this.getCurrentJsSource();
        if (currentJsSource.equals(this.lastJsSource)) {
            return;
        }
        if (this.isDebugLoggingEnabled()) {
            try (LogFile log = this.createOrReopenIndexedLog(this.getClass(), "source_after_pass", passName);){
                log.log(currentJsSource);
            }
        } else {
            System.err.println();
            System.err.println("// " + passName + " yields:");
            System.err.println("// ************************************");
            System.err.println(currentJsSource);
            System.err.println("// ************************************");
        }
        this.lastJsSource = currentJsSource;
    }

    final String getCurrentJsSource() {
        this.resetAndIntitializeSourceMap();
        List<String> fileNameRegexList = this.options.filesToPrintAfterEachPassRegexList;
        List<String> chunkNameRegexList = this.options.chunksToPrintAfterEachPassRegexList;
        LinkedHashSet<String> qnameSet = new LinkedHashSet<String>(this.options.qnameUsesToPrintAfterEachPassList);
        StringBuilder builder = new StringBuilder();
        if (fileNameRegexList.isEmpty() && chunkNameRegexList.isEmpty() && qnameSet.isEmpty()) {
            return this.toSource();
        }
        if (!fileNameRegexList.isEmpty()) {
            Preconditions.checkNotNull((Object)this.externsRoot);
            Preconditions.checkNotNull((Object)this.jsRoot);
            for (Node r : ImmutableList.of((Object)this.externsRoot, (Object)this.jsRoot)) {
                block1: for (Node fileNode = r.getFirstChild(); fileNode != null; fileNode = fileNode.getNext()) {
                    Iterator fileName = fileNode.getSourceFileName();
                    for (String regex : fileNameRegexList) {
                        if (!((String)((Object)fileName)).matches(regex)) continue;
                        String source = "// " + fileName + "\n" + this.toSource(fileNode);
                        builder.append(source);
                        continue block1;
                    }
                }
            }
            if (builder.length() == 0) {
                builder.append("// No files matched any of: ").append(fileNameRegexList);
            }
        }
        if (!chunkNameRegexList.isEmpty()) {
            Iterable chunks = (Iterable)Preconditions.checkNotNull(this.getChunks());
            ArrayList<String> unmatchedChunkNames = new ArrayList<String>();
            ChunkGraphAwareLicenseTracker lt = new ChunkGraphAwareLicenseTracker(this);
            for (JSChunk jsChunk : chunks) {
                String chunkName = jsChunk.getName();
                lt.setCurrentChunkContext(jsChunk);
                for (String regex : chunkNameRegexList) {
                    if (!chunkName.matches(regex)) continue;
                    String source = "// module '" + chunkName + "'\n" + this.toSource(lt, jsChunk);
                    builder.append(source);
                    break;
                }
                unmatchedChunkNames.add(chunkName);
            }
            if (builder.length() == 0) {
                builder.append("// No chunks were matched:\n");
                for (String chunkName : unmatchedChunkNames) {
                    builder.append("// ").append(chunkName).append("\n");
                }
            }
        }
        if (!qnameSet.isEmpty()) {
            LinkedHashMultimap originalToNewQNameMap = LinkedHashMultimap.create();
            Stream<Node> statementStream = this.getTopLevelStatements(this.jsRoot).filter(arg_0 -> Compiler.lambda$getCurrentJsSource$15(qnameSet, (Multimap)originalToNewQNameMap, arg_0));
            builder.append("//\n");
            builder.append("// closure-compiler: Printing all of the top-level statements\n");
            builder.append("// that contain references to these qualified names.\n");
            builder.append("//\n");
            for (String qname : qnameSet) {
                builder.append(SimpleFormat.format("// '%s'\n", qname));
                for (String newName : originalToNewQNameMap.get((Object)qname)) {
                    builder.append(SimpleFormat.format("// '%s' (originally '%s')\n", newName, qname));
                }
            }
            builder.append("//\n");
            statementStream.forEach(statement -> builder.append(SimpleFormat.format("// %s\n", statement.getLocation())).append(this.toSource((Node)statement)).append("\n"));
        }
        return builder.toString();
    }

    private Stream<Node> getTopLevelStatements(Node root) {
        final Stream.Builder builder = Stream.builder();
        NodeTraversal.traverse(this, root, new NodeTraversal.AbstractPreOrderCallback(){

            @Override
            public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
                if (NodeUtil.isStatement(n)) {
                    builder.add(n);
                    return false;
                }
                return true;
            }
        });
        return builder.build();
    }

    @Override
    public final @Nullable Node getScriptNode(String filename) {
        return this.scriptNodeByFilename.get(Preconditions.checkNotNull((Object)filename));
    }

    Tracer newTracer(String passName) {
        String comment = passName + (this.recentChange.hasCodeChanged() ? " on recently changed AST" : "");
        if (this.options.getTracerMode().isOn() && this.tracker != null) {
            this.tracker.recordPassStart(passName, true);
        }
        return new Tracer("Compiler", comment);
    }

    void stopTracer(Tracer t, String passName) {
        long result = t.stop();
        if (this.options.getTracerMode().isOn() && this.tracker != null) {
            this.tracker.recordPassStop(passName, result);
        }
    }

    public Result getResult() {
        return new Result(this.getErrors(), this.getWarnings(), this.variableMap, this.propertyMap, null, this.stringMap, this.instrumentationMapping, this.sourceMap, this.externExports, this.cssNames, this.idGeneratorMap, this.transpiledFiles);
    }

    public ImmutableList<JSError> getErrors() {
        return this.errorManager == null ? ImmutableList.of() : this.errorManager.getErrors();
    }

    public ImmutableList<JSError> getWarnings() {
        return this.errorManager == null ? ImmutableList.of() : this.errorManager.getWarnings();
    }

    @Override
    public Node getRoot() {
        return this.externAndJsRoot;
    }

    @Override
    FeatureSet getAllowableFeatures() {
        return this.allowableFeatures;
    }

    @Override
    void setAllowableFeatures(FeatureSet allowableFeatures) {
        this.allowableFeatures = allowableFeatures;
    }

    @Override
    void markFeatureNotAllowed(FeatureSet.Feature feature) {
        this.allowableFeatures = this.allowableFeatures.without(feature, new FeatureSet.Feature[0]);
    }

    @Override
    void markFeatureSetNotAllowed(FeatureSet featureSet) {
        this.allowableFeatures = this.allowableFeatures.without(featureSet);
    }

    @Override
    UniqueIdSupplier getUniqueIdSupplier() {
        return this.uniqueIdSupplier;
    }

    @Deprecated
    private int nextUniqueNameId() {
        return this.uniqueNameId++;
    }

    @Deprecated
    @VisibleForTesting
    void resetUniqueNameId() {
        this.uniqueNameId = 0;
    }

    @Deprecated
    com.google.common.base.Supplier<String> getUniqueNameIdSupplier() {
        return () -> String.valueOf(this.nextUniqueNameId());
    }

    @Override
    boolean areNodesEqualForInlining(Node n1, Node n2) {
        if (this.options.shouldAmbiguateProperties() || this.options.shouldDisambiguateProperties()) {
            return n1.isEquivalentToTyped(n2);
        }
        return n1.isEquivalentTo(n2);
    }

    @Override
    public @Nullable CompilerInput getInput(InputId id) {
        if (id == null) {
            return null;
        }
        return this.inputsById.get(id);
    }

    private CompilerInput putCompilerInput(CompilerInput input) {
        input.setCompiler(this);
        return this.inputsById.put(input.getInputId(), input);
    }

    @Override
    @Nullable JSChunkGraph getChunkGraph() {
        return this.chunkGraph;
    }

    public @Nullable Iterable<JSChunk> getChunks() {
        return this.chunkGraph != null ? this.chunkGraph.getAllChunks() : null;
    }

    @Override
    public void clearJSTypeRegistry() {
        this.typeRegistry = null;
        this.typeValidator = null;
        this.abstractInterpreter = null;
    }

    @Override
    public boolean isTypeRegistryCleared() {
        return this.typeCheckingHasRun && this.typeRegistry == null;
    }

    @Override
    public JSTypeRegistry getTypeRegistry() {
        if (this.typeRegistry == null) {
            Preconditions.checkState((!this.hasTypeCheckingRun() ? 1 : 0) != 0, (Object)"Attempted to re-initialize JSTypeRegistry after it had been cleared");
            this.typeRegistry = new JSTypeRegistry(this.oldErrorReporter, this.forwardDeclaredTypes);
        }
        return this.typeRegistry;
    }

    @Override
    public ColorRegistry getColorRegistry() {
        return (ColorRegistry)Preconditions.checkNotNull((Object)this.colorRegistry, (Object)"Color registry has not been initialized yet");
    }

    @Override
    public void setColorRegistry(ColorRegistry colorRegistry) {
        Preconditions.checkState((this.runtimeLibraryTypedAsts != null ? 1 : 0) != 0);
        this.colorRegistry = colorRegistry;
    }

    @Override
    public void forwardDeclareType(String typeName) {
        this.forwardDeclaredTypes.add(typeName);
    }

    @Override
    void setTypeCheckingHasRun(boolean hasRun) {
        this.typeCheckingHasRun = hasRun;
    }

    @Override
    public boolean hasTypeCheckingRun() {
        return this.typeCheckingHasRun;
    }

    @Override
    public boolean hasOptimizationColors() {
        return this.colorRegistry != null;
    }

    @Override
    public ScopeCreator getTypedScopeCreator() {
        if (this.typedScopeCreator == null) {
            Preconditions.checkState((!this.hasTypeCheckingRun() ? 1 : 0) != 0, (Object)"Attempted to re-initialize TypedScopeCreator after it had been cleared");
            this.typedScopeCreator = new TypedScopeCreator(this);
        }
        return this.typedScopeCreator;
    }

    @Override
    void clearTypedScopeCreator() {
        this.typedScopeCreator = null;
    }

    DefaultPassConfig ensureDefaultPassConfig() {
        PassConfig passes = this.getPassConfig().getBasePassConfig();
        Preconditions.checkState((boolean)(passes instanceof DefaultPassConfig), (Object)"PassConfigs must eventually delegate to the DefaultPassConfig");
        return (DefaultPassConfig)passes;
    }

    public SymbolTable buildKnownSymbolTable() {
        SymbolTable symbolTable = new SymbolTable(this, this.getTypeRegistry());
        if (this.typedScopeCreator != null) {
            symbolTable.addScopes(this.typedScopeCreator.getAllMemoizedScopes());
            symbolTable.addSymbolsFrom(this.typedScopeCreator);
        } else {
            symbolTable.findScopes(this.externsRoot, this.jsRoot);
        }
        GlobalNamespace globalNamespace = new GlobalNamespace(this, this.externsRoot, this.jsRoot);
        symbolTable.addSymbolsFrom(globalNamespace);
        ReferenceCollector refCollector = new ReferenceCollector(this, ReferenceCollector.DO_NOTHING_BEHAVIOR, new SyntacticScopeCreator(this));
        refCollector.process(this.getRoot());
        symbolTable.addSymbolsFrom(refCollector);
        PreprocessorSymbolTable preprocessorSymbolTable = this.ensureDefaultPassConfig().getPreprocessorSymbolTable();
        if (preprocessorSymbolTable != null) {
            symbolTable.addSymbolsFrom(preprocessorSymbolTable);
        }
        symbolTable.flattenGoogModuleExports();
        symbolTable.fillNamespaceReferences();
        symbolTable.fillPropertyScopes();
        symbolTable.fillThisReferences(this.externsRoot, this.jsRoot);
        symbolTable.fillPropertySymbols(this.externsRoot, this.jsRoot);
        symbolTable.fillSuperReferences(this.externsRoot, this.jsRoot);
        symbolTable.fillJSDocInfo(this.externsRoot, this.jsRoot);
        symbolTable.fillSymbolVisibility(this.externsRoot, this.jsRoot);
        symbolTable.fillGoogProvideModuleRequires(this.externsRoot, this.jsRoot);
        symbolTable.removeGeneratedSymbols();
        return symbolTable;
    }

    @Override
    public @Nullable TypedScope getTopScope() {
        return this.topScope;
    }

    @Override
    void setTopScope(@Nullable TypedScope x) {
        Preconditions.checkState((x == null || x.getParent() == null ? 1 : 0) != 0, (Object)x);
        this.topScope = x;
    }

    @Override
    public ReverseAbstractInterpreter getReverseAbstractInterpreter() {
        if (this.abstractInterpreter == null) {
            ChainableReverseAbstractInterpreter interpreter = new SemanticReverseAbstractInterpreter(this.getTypeRegistry());
            if (this.options.closurePass) {
                interpreter = new ClosureReverseAbstractInterpreter(this.getTypeRegistry()).append(interpreter).getFirst();
            }
            this.abstractInterpreter = interpreter;
        }
        return this.abstractInterpreter;
    }

    @Override
    TypeValidator getTypeValidator() {
        if (this.typeValidator == null) {
            Preconditions.checkState((!this.hasTypeCheckingRun() ? 1 : 0) != 0, (Object)"Attempted to re-initialize TypeValidator after it had been cleared");
            this.typeValidator = new TypeValidator(this);
        }
        return this.typeValidator;
    }

    @Override
    public Iterable<TypeMismatch> getTypeMismatches() {
        if (this.typeCheckingHasRun) {
            return this.getTypeValidator().getMismatches();
        }
        throw new RuntimeException("Can't ask for type mismatches before type checking.");
    }

    @Override
    StaticScope getTranspilationNamespace() {
        if (this.transpilationNamespace == null) {
            GlobalNamespace gn = new GlobalNamespace(this, this.getExternsRoot(), this.getJsRoot());
            gn.setShouldTraverseScriptPredicate(script -> script.isFromExterns() || script.isFirstChildOf(this.getJsRoot()));
            gn.getNameForest();
            this.transpilationNamespace = gn;
        }
        return this.transpilationNamespace;
    }

    public void maybeSetTracker() {
        if (!this.options.getTracerMode().isOn() || this.tracker != null) {
            return;
        }
        this.tracker = new PerformanceTracker(this.externsRoot, this.jsRoot, this.options.getTracerMode());
        this.addChangeHandler(this.tracker.getCodeChangeHandler());
    }

    void initializeModuleLoader() {
        ModuleLoader.ModuleResolverFactory moduleResolverFactory = null;
        switch (this.options.getModuleResolutionMode()) {
            case BROWSER: {
                moduleResolverFactory = BrowserModuleResolver.FACTORY;
                break;
            }
            case NODE: {
                moduleResolverFactory = new NodeModuleResolver.Factory(this.processJsonInputs(this.chunkGraph.getAllInputs()));
                break;
            }
            case WEBPACK: {
                moduleResolverFactory = new WebpackModuleResolver.Factory((Map<String, String>)this.inputPathByWebpackId);
                break;
            }
            case BROWSER_WITH_TRANSFORMED_PREFIXES: {
                moduleResolverFactory = new BrowserWithTransformedPrefixesModuleResolver.Factory(this.options.getBrowserResolverPrefixReplacements());
            }
        }
        this.moduleLoader = ModuleLoader.builder().setModuleRoots(this.options.moduleRoots).setInputs(this.chunkGraph.getAllInputs()).setFactory(moduleResolverFactory).setPathResolver(ModuleLoader.PathResolver.RELATIVE).setPathEscaper(this.options.getPathEscaper()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable Node parseInputs() {
        boolean devMode = this.options.devMode != CompilerOptions.DevMode.OFF;
        this.externsRoot.detachChildren();
        this.jsRoot.detachChildren();
        this.scriptNodeByFilename.clear();
        Tracer tracer = this.newTracer("parseInputs");
        this.beforePass("parseInputs");
        try {
            Object object;
            if (this.options.numParallelThreads > 1) {
                new PrebuildAst(this, this.options.numParallelThreads).prebuild(this.externs);
            }
            for (CompilerInput compilerInput : this.externs) {
                Node node = (Node)Preconditions.checkNotNull((Object)compilerInput.getAstRoot(this));
                if (this.hasErrors()) {
                    Node node2 = null;
                    return node2;
                }
                this.externsRoot.addChildToBack(node);
                this.scriptNodeByFilename.put(compilerInput.getSourceFile().getName(), node);
            }
            if (this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES) || this.options.getProcessCommonJSModules()) {
                this.initializeModuleLoader();
            } else {
                this.moduleLoader = ModuleLoader.EMPTY;
            }
            if (this.options.getDependencyOptions().needsManagement()) {
                this.findModulesFromEntryPoints(this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES), this.options.getProcessCommonJSModules());
            } else if (this.options.needsTranspilationFrom(FeatureSet.ES2015_MODULES) || this.options.getProcessCommonJSModules()) {
                if (this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES)) {
                    this.parsePotentialModules(this.chunkGraph.getAllInputs());
                }
                LinkedHashMap<String, CompilerInput> inputModuleIdentifiers = new LinkedHashMap<String, CompilerInput>();
                for (CompilerInput compilerInput : this.chunkGraph.getAllInputs()) {
                    if (!compilerInput.getKnownProvides().isEmpty()) continue;
                    ModuleLoader.ModulePath modPath = this.moduleLoader.resolve(compilerInput.getSourceFile().getName());
                    inputModuleIdentifiers.put(modPath.toModuleName(), compilerInput);
                }
                LinkedHashMap<String, CompilerInput> linkedHashMap = new LinkedHashMap<String, CompilerInput>();
                for (CompilerInput input : this.chunkGraph.getAllInputs()) {
                    for (String require : input.getKnownRequiredSymbols()) {
                        if (!inputModuleIdentifiers.containsKey(require) || linkedHashMap.containsKey(require)) continue;
                        linkedHashMap.put(require, (CompilerInput)inputModuleIdentifiers.get(require));
                    }
                }
                for (CompilerInput input : linkedHashMap.values()) {
                    input.setJsModuleType(CompilerInput.ModuleType.IMPORTED_SCRIPT);
                }
            }
            if (this.moduleLoader != null) {
                this.moduleLoader.setErrorHandler(this);
            }
            this.orderInputs();
            if (this.hasErrors()) {
                object = null;
                return object;
            }
            if (this.options.numParallelThreads > 1) {
                new PrebuildAst(this, this.options.numParallelThreads).prebuild(this.chunkGraph.getAllInputs());
            }
            for (CompilerInput compilerInput : this.chunkGraph.getAllInputs()) {
                Node node = (Node)Preconditions.checkNotNull((Object)compilerInput.getAstRoot(this));
                if (devMode) {
                    this.runValidityCheck();
                    if (this.hasErrors()) {
                        CompilerInput input;
                        input = null;
                        return input;
                    }
                }
                if (this.options.shouldGatherSourceMapInfo() || this.options.getExternExportsPath() != null || !this.options.replaceStringsFunctionDescriptions.isEmpty()) {
                    SourceInformationAnnotator sia = CompilerOptions.DevMode.OFF.equals((Object)this.options.devMode) ? SourceInformationAnnotator.create() : SourceInformationAnnotator.createWithAnnotationChecks(compilerInput.getName());
                    NodeTraversal.traverse(this, node, sia);
                }
                if (NodeUtil.isFromTypeSummary(node)) {
                    compilerInput.setIsExtern();
                    this.externsRoot.addChildToBack(node);
                } else {
                    this.jsRoot.addChildToBack(node);
                }
                this.scriptNodeByFilename.put(compilerInput.getSourceFile().getName(), node);
            }
            if (this.hasErrors()) {
                object = null;
                return object;
            }
            if (this.typedAstFilesystem != null) {
                Preconditions.checkState((this.typedAstFilesystem.size() == 1 || this.typedAstFilesystem.isEmpty() ? 1 : 0) != 0, (Object)this.typedAstFilesystem.size());
            }
            object = this.externAndJsRoot;
            return object;
        }
        finally {
            this.afterPass("parseInputs");
            this.stopTracer(tracer, "parseInputs");
        }
    }

    @Override
    boolean preferRegexParser() {
        return this.preferRegexParser;
    }

    void setPreferRegexParser(boolean preferRegexParser) {
        this.preferRegexParser = preferRegexParser;
    }

    void orderInputsWithLargeStack() {
        this.runInCompilerThread(() -> {
            Tracer tracer = this.newTracer("orderInputsWithLargeStack");
            try {
                this.orderInputs();
            }
            finally {
                this.stopTracer(tracer, "orderInputsWithLargeStack");
            }
            return null;
        });
    }

    void orderInputs() {
        this.maybeDoThreadedParsing();
        ImmutableList originalInputs = ImmutableList.copyOf(this.chunkGraph.getAllInputs());
        this.markExterns((ImmutableList<CompilerInput>)originalInputs);
        boolean staleInputs = false;
        if (this.options.getDependencyOptions().needsManagement()) {
            try {
                this.chunkGraph.manageDependencies(this, this.options.getDependencyOptions());
                staleInputs = true;
            }
            catch (SortedDependencies.MissingProvideException e) {
                this.report(JSError.make(MISSING_ENTRY_ERROR, e.getMessage()));
            }
            catch (JSChunkGraph.MissingChunkException e) {
                this.report(JSError.make(MISSING_MODULE_ERROR, e.getMessage()));
            }
        }
        this.hoistExterns((ImmutableList<CompilerInput>)originalInputs);
        this.fillEmptyModules(this.getChunks());
        this.hoistNoCompileFiles();
        if (staleInputs) {
            this.repartitionInputs();
        }
    }

    private void findModulesFromEntryPoints(boolean supportEs6Modules, boolean supportCommonJSModules) {
        this.maybeDoThreadedParsing();
        ArrayList<CompilerInput> entryPoints = new ArrayList<CompilerInput>();
        LinkedHashMap<String, CompilerInput> inputsByProvide = new LinkedHashMap<String, CompilerInput>();
        LinkedHashMap<String, CompilerInput> inputsByIdentifier = new LinkedHashMap<String, CompilerInput>();
        for (CompilerInput input : this.chunkGraph.getAllInputs()) {
            Iterable provides = Iterables.filter(input.getProvides(), p -> !p.startsWith("module$"));
            if (!this.options.getDependencyOptions().shouldDropMoochers() && Iterables.isEmpty((Iterable)provides)) {
                entryPoints.add(input);
            }
            inputsByIdentifier.put(ModuleIdentifier.forFile(input.getPath().toString()).toString(), input);
            for (String provide : provides) {
                inputsByProvide.put(provide, input);
            }
        }
        for (ModuleIdentifier moduleIdentifier : this.options.getDependencyOptions().getEntryPoints()) {
            CompilerInput input = (CompilerInput)inputsByProvide.get(moduleIdentifier.toString());
            if (input == null) {
                input = (CompilerInput)inputsByIdentifier.get(moduleIdentifier.toString());
            }
            if (input == null) continue;
            entryPoints.add(input);
        }
        LinkedHashSet<CompilerInput> workingInputSet = new LinkedHashSet<CompilerInput>();
        for (CompilerInput input : this.chunkGraph.getAllInputs()) {
            workingInputSet.add(input);
        }
        for (CompilerInput entryPoint : entryPoints) {
            this.findModulesFromInput(entryPoint, false, workingInputSet, inputsByIdentifier, inputsByProvide, supportEs6Modules, supportCommonJSModules);
        }
    }

    private void findModulesFromInput(CompilerInput input, boolean wasImportedByModule, Set<CompilerInput> inputs, Map<String, CompilerInput> inputsByIdentifier, Map<String, CompilerInput> inputsByProvide, boolean supportEs6Modules, boolean supportCommonJSModules) {
        if (!inputs.remove(input)) {
            if (wasImportedByModule && input.getJsModuleType() == CompilerInput.ModuleType.NONE) {
                input.setJsModuleType(CompilerInput.ModuleType.IMPORTED_SCRIPT);
            }
            return;
        }
        FindModuleDependencies findDeps = new FindModuleDependencies(this, supportEs6Modules, supportCommonJSModules, this.inputPathByWebpackId);
        findDeps.process((Node)Preconditions.checkNotNull((Object)input.getAstRoot(this)));
        if (wasImportedByModule && input.getJsModuleType() == CompilerInput.ModuleType.NONE) {
            input.setJsModuleType(CompilerInput.ModuleType.IMPORTED_SCRIPT);
        }
        this.moduleTypesByName.put(input.getPath().toModuleName(), input.getJsModuleType());
        Iterable allDeps = Iterables.concat(input.getRequiredSymbols(), input.getDynamicRequires(), input.getTypeRequires());
        for (String requiredNamespace : allDeps) {
            CompilerInput requiredInput = null;
            boolean requiredByModuleImport = false;
            if (inputsByProvide.containsKey(requiredNamespace)) {
                requiredInput = inputsByProvide.get(requiredNamespace);
            } else if (inputsByIdentifier.containsKey(requiredNamespace)) {
                requiredByModuleImport = true;
                requiredInput = inputsByIdentifier.get(requiredNamespace);
            }
            if (requiredInput == null) continue;
            this.findModulesFromInput(requiredInput, requiredByModuleImport, inputs, inputsByIdentifier, inputsByProvide, supportEs6Modules, supportCommonJSModules);
        }
    }

    void hoistExterns(ImmutableList<CompilerInput> originalInputs) {
        boolean staleInputs = false;
        for (CompilerInput input : originalInputs) {
            if (!this.hoistIfExtern(input)) continue;
            staleInputs = true;
        }
        if (staleInputs) {
            this.repartitionInputs();
        }
    }

    private boolean hoistIfExtern(CompilerInput input) {
        if (input.getHasExternsAnnotation()) {
            Node root = input.getAstRoot(this);
            this.externsRoot.addChildToBack(root);
            this.scriptNodeByFilename.put(input.getSourceFile().getName(), root);
            JSChunk chunk = input.getChunk();
            if (chunk != null) {
                chunk.remove(input);
            }
            this.externs.add(input);
            return true;
        }
        return false;
    }

    private void markExterns(ImmutableList<CompilerInput> originalInputs) {
        for (CompilerInput input : originalInputs) {
            if (!input.getHasExternsAnnotation()) continue;
            input.setIsExtern();
        }
    }

    void hoistNoCompileFiles() {
        boolean staleInputs = false;
        this.maybeDoThreadedParsing();
        for (CompilerInput input : ImmutableList.copyOf(this.chunkGraph.getAllInputs())) {
            if (!input.getHasNoCompileAnnotation()) continue;
            input.getChunk().remove(input);
            staleInputs = true;
        }
        if (staleInputs) {
            this.repartitionInputs();
        }
    }

    private void maybeDoThreadedParsing() {
        if (this.options.numParallelThreads > 1) {
            new PrebuildDependencyInfo(this.options.numParallelThreads).prebuild(this.chunkGraph.getAllInputs());
        }
    }

    private void repartitionInputs() {
        this.fillEmptyModules(this.getChunks());
        this.rebuildInputsFromModules();
    }

    Map<String, String> processJsonInputs(Iterable<CompilerInput> inputsToProcess) {
        RewriteJsonToModule rewriteJson = new RewriteJsonToModule(this);
        for (CompilerInput input : inputsToProcess) {
            if (!input.getSourceFile().getName().endsWith(".json")) continue;
            input.setCompiler(this);
            try {
                input.getSourceFile().setCodeDeprecated("(" + input.getSourceFile().getCode() + ")");
            }
            catch (IOException e) {
                continue;
            }
            Node root = (Node)Preconditions.checkNotNull((Object)input.getAstRoot(this));
            input.setJsModuleType(CompilerInput.ModuleType.JSON);
            rewriteJson.process(null, root);
        }
        return rewriteJson.getPackageJsonMainEntries();
    }

    private void parsePotentialModules(Iterable<CompilerInput> inputsToProcess) {
        ArrayList<CompilerInput> filteredInputs = new ArrayList<CompilerInput>();
        for (CompilerInput input : inputsToProcess) {
            if (this.options.getDependencyOptions().shouldPrune() && JsFileRegexParser.isSupported() && !input.isEs6Module()) continue;
            filteredInputs.add(input);
        }
        if (this.options.numParallelThreads > 1) {
            new PrebuildAst(this, this.options.numParallelThreads).prebuild(filteredInputs);
        }
        for (CompilerInput input : filteredInputs) {
            input.setCompiler(this);
            input.getRequires();
            input.setJsModuleType(CompilerInput.ModuleType.ES6);
        }
    }

    protected CompilerOptions newCompilerOptions() {
        return new CompilerOptions();
    }

    void initCompilerOptionsIfTesting() {
        if (this.options == null) {
            this.initOptions(this.newCompilerOptions());
            this.options.setLanguage(CompilerOptions.LanguageMode.UNSUPPORTED);
        }
    }

    @Override
    public Node parseSyntheticCode(String fileName, String js) {
        this.initCompilerOptionsIfTesting();
        SourceFile source = SourceFile.fromCode(SYNTHETIC_FILE_NAME_PREFIX + fileName + "] ", js);
        this.addFilesToSourceMap((Iterable<SourceFile>)ImmutableList.of((Object)source));
        return this.parseCodeHelper(source);
    }

    @Override
    @VisibleForTesting
    Node parseTestCode(String js) {
        this.initCompilerOptionsIfTesting();
        this.initBasedOnOptions();
        return this.parseCodeHelper(SourceFile.fromCode("testcode", js));
    }

    @Override
    @VisibleForTesting
    Node parseTestCode(ImmutableList<String> code) {
        this.initCompilerOptionsIfTesting();
        this.initBasedOnOptions();
        return this.parseCodeHelper(Streams.mapWithIndex((Stream)code.stream(), (value, index) -> SourceFile.fromCode("testcode" + index, value)).collect(Collectors.toList()));
    }

    private Node parseCodeHelper(SourceFile src) {
        CompilerInput input = new CompilerInput(src);
        this.putCompilerInput(input);
        Node root = input.getAstRoot(this);
        this.scriptNodeByFilename.put(input.getSourceFile().getName(), root);
        return (Node)Preconditions.checkNotNull((Object)root);
    }

    private Node parseCodeHelper(List<SourceFile> srcs) {
        Node root = IR.root(new Node[0]);
        for (SourceFile src : srcs) {
            root.addChildToBack(this.parseCodeHelper(src));
        }
        return root;
    }

    @Override
    ErrorReporter getDefaultErrorReporter() {
        return this.oldErrorReporter;
    }

    @Override
    public String toSource() {
        return this.runInCompilerThread(() -> {
            Tracer tracer = this.newTracer("toSource");
            try {
                CodeBuilder cb = new CodeBuilder();
                SingleBinaryLicenseTracker lt = new SingleBinaryLicenseTracker(this);
                if (this.jsRoot != null) {
                    Node scriptNode;
                    int i = 0;
                    if (this.options.shouldPrintExterns()) {
                        for (scriptNode = this.externsRoot.getFirstChild(); scriptNode != null; scriptNode = scriptNode.getNext()) {
                            this.toSource(cb, lt, i++, scriptNode);
                        }
                    }
                    for (scriptNode = this.jsRoot.getFirstChild(); scriptNode != null; scriptNode = scriptNode.getNext()) {
                        this.toSource(cb, lt, i++, scriptNode);
                    }
                }
                String string = cb.toString();
                return string;
            }
            finally {
                this.stopTracer(tracer, "toSource");
            }
        });
    }

    public String toSource(JSChunk chunk) {
        return this.toSource(new ScriptNodeLicensesOnlyTracker(this), chunk);
    }

    public String toSource(CodePrinter.LicenseTracker licenseTracker, JSChunk chunk) {
        return this.runInCompilerThread(() -> {
            ImmutableList<CompilerInput> inputs = chunk.getInputs();
            int numInputs = inputs.size();
            if (numInputs == 0) {
                return "";
            }
            CodeBuilder cb = new CodeBuilder();
            for (int i = 0; i < numInputs; ++i) {
                Node scriptNode = ((CompilerInput)inputs.get(i)).getAstRoot(this);
                if (scriptNode == null) {
                    throw new IllegalArgumentException("Bad module: " + chunk.getName());
                }
                this.toSource(cb, licenseTracker, i, scriptNode);
            }
            return cb.toString();
        });
    }

    public void toSource(CodeBuilder cb, CodePrinter.LicenseTracker licenseTracker, int inputSeqNum, Node root) {
        this.runInCompilerThread(() -> {
            boolean hasSemiColon;
            if (this.options.printInputDelimiter) {
                if (cb.getLength() > 0 && !cb.endsWith("\n")) {
                    cb.append("\n");
                }
                Preconditions.checkState((boolean)root.isScript());
                String delimiter = this.options.inputDelimiter;
                String inputName = root.getInputId().getIdName();
                String sourceName = root.getSourceFileName();
                Preconditions.checkState((sourceName != null ? 1 : 0) != 0);
                Preconditions.checkState((!sourceName.isEmpty() ? 1 : 0) != 0);
                delimiter = delimiter.replace("%name%", inputName).replace("%num%", String.valueOf(inputSeqNum)).replace("%n%", "\n");
                cb.append(delimiter).append("\n");
            }
            CodePrinter.SourceAndMappings sourceAndMappings = this.toSourceAndMappings(root, inputSeqNum == 0, licenseTracker);
            String code = sourceAndMappings.source;
            for (String license : licenseTracker.emitLicenses()) {
                cb.append("/*\n").append(license).append("*/\n");
            }
            if (code.isEmpty()) {
                return null;
            }
            if (this.options.shouldGatherSourceMapInfo()) {
                this.sourceMap.setStartingPosition(cb.getLineIndex(), cb.getColumnIndex());
            }
            cb.append(code);
            int length = code.length();
            char lastChar = code.charAt(length - 1);
            char secondLastChar = length >= 2 ? code.charAt(length - 2) : (char)'\u0000';
            boolean bl = hasSemiColon = lastChar == ';' || lastChar == '\n' && secondLastChar == ';';
            if (!hasSemiColon) {
                cb.append(";");
            }
            if (this.options.shouldGatherSourceMapInfo()) {
                for (SourceMap.Mapping mapping : sourceAndMappings.mappings) {
                    this.sourceMap.addMapping(mapping);
                }
            }
            return null;
        });
    }

    @Override
    public String toSource(Node n) {
        this.initCompilerOptionsIfTesting();
        StringBuilder sb = new StringBuilder();
        ScriptNodeLicensesOnlyTracker lt = new ScriptNodeLicensesOnlyTracker(this);
        String code = this.toSourceAndMappings((Node)n, (boolean)false, (CodePrinter.LicenseTracker)lt).source;
        for (String license : lt.emitLicenses()) {
            sb.append("/*\n").append(license).append("*/\n");
        }
        sb.append(code);
        return sb.toString();
    }

    private CodePrinter.SourceAndMappings toSourceAndMappings(Node n, boolean firstOutput, CodePrinter.LicenseTracker licenseTracker) {
        CodePrinter.Builder builder = new CodePrinter.Builder(n);
        builder.setCompilerOptions(this.options);
        builder.setTagAsTypeSummary(this.options.shouldGenerateTypedExterns());
        builder.setTagAsStrict(firstOutput && this.options.shouldEmitUseStrict());
        builder.setLicenseTracker(licenseTracker);
        return builder.buildWithSourceMappings();
    }

    public static @Nullable String getLicenseForFile(AbstractCompiler compiler, @Nullable String fileName) {
        if (fileName == null) {
            return null;
        }
        Node licenseRoot = compiler.getScriptNode(fileName);
        if (licenseRoot == null) {
            return null;
        }
        JSDocInfo docInfo = licenseRoot.getJSDocInfo();
        if (docInfo == null) {
            return null;
        }
        return docInfo.getLicense();
    }

    public String[] toSourceArray(CodePrinter.LicenseTracker licenseTracker, JSChunk chunk) {
        return this.runInCompilerThread(() -> {
            ImmutableList<CompilerInput> inputs = chunk.getInputs();
            int numInputs = inputs.size();
            if (numInputs == 0) {
                return new String[0];
            }
            String[] sources = new String[numInputs];
            CodeBuilder cb = new CodeBuilder();
            for (int i = 0; i < numInputs; ++i) {
                Node scriptNode = ((CompilerInput)inputs.get(i)).getAstRoot(this);
                if (scriptNode == null) {
                    throw new IllegalArgumentException("Bad module input: " + ((CompilerInput)inputs.get(i)).getName());
                }
                cb.reset();
                this.toSource(cb, licenseTracker, i, scriptNode);
                sources[i] = cb.toString();
            }
            return sources;
        });
    }

    void performTranspilationAndOptimizations() {
        Preconditions.checkState((boolean)this.options.shouldOptimize());
        ImmutableList<PassFactory> optimizations = this.getPassConfig().getOptimizations().build();
        if (optimizations.isEmpty()) {
            return;
        }
        this.markTranspiledFiles();
        this.phaseOptimizer = this.createPhaseOptimizer();
        this.phaseOptimizer.consume((List<PassFactory>)optimizations);
        this.phaseOptimizer.process(this.externsRoot, this.jsRoot);
        this.phaseOptimizer = null;
    }

    void performFinalizations() {
        ImmutableList<PassFactory> finalizations = this.getPassConfig().getFinalizations().build();
        if (finalizations.isEmpty()) {
            return;
        }
        this.phaseOptimizer = this.createPhaseOptimizer();
        this.phaseOptimizer.consume((List<PassFactory>)finalizations);
        this.phaseOptimizer.process(this.externsRoot, this.jsRoot);
        this.phaseOptimizer = null;
    }

    ControlFlowGraph<Node> computeCFG() {
        logger.fine("Computing Control Flow Graph");
        Tracer tracer = this.newTracer("computeCFG");
        ControlFlowGraph<Node> cfg = ControlFlowAnalysis.builder().setCompiler(this).setCfgRoot(this.jsRoot).setTraverseFunctions(true).computeCfg();
        this.stopTracer(tracer, "computeCFG");
        return cfg;
    }

    @Override
    void addChangeHandler(CodeChangeHandler handler) {
        this.codeChangeHandlers.add(handler);
    }

    @Override
    void removeChangeHandler(CodeChangeHandler handler) {
        this.codeChangeHandlers.remove(handler);
    }

    @Override
    void addIndexProvider(IndexProvider<?> indexProvider) {
        Class<?> type = indexProvider.getType();
        if (this.indexProvidersByType.put(type, indexProvider) != null) {
            throw new IllegalStateException("A provider is already registered for index of type " + type.getSimpleName());
        }
    }

    @Override
    <T> T getIndex(Class<T> key) {
        IndexProvider<?> indexProvider = this.indexProvidersByType.get(key);
        if (indexProvider == null) {
            return null;
        }
        return (T)indexProvider.get();
    }

    protected Node getExternsRoot() {
        return this.externsRoot;
    }

    @Override
    protected Node getJsRoot() {
        return this.jsRoot;
    }

    @VisibleForTesting
    void setPhaseOptimizer(PhaseOptimizer po) {
        this.phaseOptimizer = po;
    }

    @Override
    public int getChangeStamp() {
        return this.changeStamp;
    }

    @Override
    List<Node> getChangedScopeNodesForPass(String passName) {
        List<Node> changedScopeNodes = this.changeTimeline.getSince(passName);
        this.changeTimeline.mark(passName);
        return changedScopeNodes;
    }

    @Override
    public void incrementChangeStamp() {
        ++this.changeStamp;
    }

    private Node getChangeScopeForNode(Node n) {
        if (n.isScript()) {
            return n;
        }
        Node enclosingScopeNode = NodeUtil.getEnclosingChangeScopeRoot(n.getParent());
        if (enclosingScopeNode == null) {
            throw new IllegalStateException("An enclosing scope is required for change reports but node " + n + " doesn't have one.");
        }
        return enclosingScopeNode;
    }

    private void recordChange(Node n) {
        if (n.isDeleted()) {
            return;
        }
        n.setChangeTime(this.changeStamp);
        ++this.changeStamp;
        this.changeTimeline.add(n);
    }

    @Override
    boolean hasScopeChanged(Node n) {
        if (this.phaseOptimizer == null) {
            return true;
        }
        return this.phaseOptimizer.hasScopeChanged(n);
    }

    @Override
    public void reportChangeToChangeScope(Node changeScopeRoot) {
        Preconditions.checkState((changeScopeRoot.isScript() || changeScopeRoot.isFunction() ? 1 : 0) != 0);
        this.recordChange(changeScopeRoot);
        this.notifyChangeHandlers();
    }

    @Override
    public void reportFunctionDeleted(Node n) {
        Preconditions.checkState((boolean)n.isFunction());
        n.setDeleted(true);
        this.changeTimeline.remove(n);
    }

    @Override
    public void reportDisambiguatePropertiesSummary(Supplier<String> summarySupplier) {
        if (this.tracker != null) {
            this.tracker.setDisambiguatePropertiesSummary(summarySupplier.get());
        }
    }

    @Override
    public void reportAmbiguatePropertiesSummary(Supplier<String> summarySupplier) {
        if (this.tracker != null) {
            this.tracker.setAmbiguatePropertiesSummary(summarySupplier.get());
        }
    }

    @Override
    public void reportChangeToEnclosingScope(Node n) {
        this.recordChange(this.getChangeScopeForNode(n));
        this.notifyChangeHandlers();
    }

    private void notifyChangeHandlers() {
        for (CodeChangeHandler handler : this.codeChangeHandlers) {
            handler.reportChange();
        }
    }

    @Override
    public CodingConvention getCodingConvention() {
        CodingConvention convention = this.options.getCodingConvention();
        convention = convention != null ? convention : this.defaultCodingConvention;
        return convention;
    }

    private Config.LanguageMode getParserConfigLanguageMode(CompilerOptions.LanguageMode languageMode) {
        switch (languageMode) {
            case ECMASCRIPT3: {
                return Config.LanguageMode.ECMASCRIPT3;
            }
            case ECMASCRIPT5: 
            case ECMASCRIPT5_STRICT: {
                return Config.LanguageMode.ECMASCRIPT5;
            }
            case ECMASCRIPT_2015: {
                return Config.LanguageMode.ECMASCRIPT_2015;
            }
            case ECMASCRIPT_2016: {
                return Config.LanguageMode.ECMASCRIPT_2016;
            }
            case ECMASCRIPT_2017: {
                return Config.LanguageMode.ECMASCRIPT_2017;
            }
            case ECMASCRIPT_2018: {
                return Config.LanguageMode.ECMASCRIPT_2018;
            }
            case ECMASCRIPT_2019: {
                return Config.LanguageMode.ECMASCRIPT_2019;
            }
            case ECMASCRIPT_2020: {
                return Config.LanguageMode.ECMASCRIPT_2020;
            }
            case ECMASCRIPT_2021: {
                return Config.LanguageMode.ECMASCRIPT_2021;
            }
            case ECMASCRIPT_NEXT: {
                return Config.LanguageMode.ES_NEXT;
            }
            case UNSTABLE: {
                return Config.LanguageMode.UNSTABLE;
            }
            case UNSUPPORTED: {
                return Config.LanguageMode.UNSUPPORTED;
            }
        }
        throw new IllegalStateException("Unexpected language mode: " + this.options.getLanguageIn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Config getParserConfig(AbstractCompiler.ConfigContext context) {
        if (this.parserConfig == null || this.externsParserConfig == null) {
            Compiler compiler = this;
            synchronized (compiler) {
                if (this.parserConfig == null) {
                    Config.LanguageMode configLanguageMode = this.getParserConfigLanguageMode(this.options.getLanguageIn());
                    Config.StrictMode strictMode = this.options.expectStrictModeInput() ? Config.StrictMode.STRICT : Config.StrictMode.SLOPPY;
                    this.parserConfig = this.createConfig(configLanguageMode, strictMode);
                    this.externsParserConfig = configLanguageMode.equals((Object)Config.LanguageMode.ECMASCRIPT3) ? this.createConfig(Config.LanguageMode.ECMASCRIPT5, strictMode) : this.parserConfig;
                }
            }
        }
        if (context == AbstractCompiler.ConfigContext.EXTERNS) {
            return this.externsParserConfig;
        }
        return this.parserConfig;
    }

    protected Config createConfig(Config.LanguageMode mode, Config.StrictMode strictMode) {
        return ParserRunner.createConfig(mode, this.options.isParseJsDocDocumentation(), this.options.canContinueAfterErrors() ? Config.RunMode.KEEP_GOING : Config.RunMode.STOP_AFTER_ERROR, this.options.extraAnnotationNames, this.options.parseInlineSourceMaps, strictMode);
    }

    public DiagnosticGroups getDiagnosticGroups() {
        return new DiagnosticGroups();
    }

    @Override
    public void report(JSError error) {
        CheckLevel newLevel;
        CheckLevel level = error.getDefaultLevel();
        if (this.warningsGuard != null && (newLevel = this.warningsGuard.level(error)) != null) {
            level = newLevel;
        }
        if (level.isOn()) {
            this.initCompilerOptionsIfTesting();
            if (this.getOptions().errorHandler != null) {
                this.getOptions().errorHandler.report(level, error);
            }
            this.errorManager.report(level, error);
        }
    }

    @Override
    public void report(CheckLevel ignoredLevel, JSError error) {
        this.report(error);
    }

    @Override
    public CheckLevel getErrorLevel(JSError error) {
        Preconditions.checkNotNull((Object)this.options);
        return this.warningsGuard.level(error);
    }

    @Override
    void throwInternalError(String message, Throwable cause) {
        throw new RuntimeException("INTERNAL COMPILER ERROR.\nPlease report this problem.\n\n" + message, cause);
    }

    public int getErrorCount() {
        return this.errorManager.getErrorCount();
    }

    public int getWarningCount() {
        return this.errorManager.getWarningCount();
    }

    @Override
    boolean hasHaltingErrors() {
        return !this.getOptions().canContinueAfterErrors() && this.errorManager.hasHaltingErrors();
    }

    public boolean hasErrors() {
        return this.hasHaltingErrors();
    }

    @Override
    @Nullable SourceFile getSourceFileByName(String sourceName) {
        if (sourceName != null) {
            CompilerInput input = this.inputsById.get(new InputId(sourceName));
            if (input != null) {
                return input.getSourceFile();
            }
            return this.sourceMapOriginalSources.get(sourceName);
        }
        return null;
    }

    public @Nullable CharSequence getSourceFileContentByName(String sourceName) {
        SourceFile file = this.getSourceFileByName(sourceName);
        Preconditions.checkNotNull((Object)file);
        try {
            return file.getCode();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void addInputSourceMap(String sourceFileName, SourceMapInput inputSourceMap) {
        this.inputSourceMaps.put(sourceFileName, inputSourceMap);
        if (this.options.sourceMapIncludeSourcesContent && this.sourceMap != null) {
            this.addSourceMapSourceFiles(inputSourceMap);
        }
    }

    @Override
    public @Nullable String getBase64SourceMapContents(String sourceFileName) {
        String sourceMappingURL;
        SourceMapInput sourceMapInput = this.inputSourceMaps.getOrDefault(sourceFileName, null);
        String string = sourceMappingURL = sourceMapInput != null ? sourceMapInput.getOriginalPath() : null;
        if (sourceMappingURL != null && sourceMappingURL.endsWith(".inline.map")) {
            String unencoded = sourceMapInput.getRawSourceMapContents();
            return BaseEncoding.base64().encode(unencoded.getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    private synchronized void addSourceMapSourceFiles(SourceMapInput inputSourceMap) {
        SourceMapConsumerV3 consumer = inputSourceMap.getSourceMap(this.errorManager);
        if (consumer == null) {
            return;
        }
        Collection<String> sourcesContent = consumer.getOriginalSourcesContent();
        if (sourcesContent == null) {
            return;
        }
        Iterator<String> content = sourcesContent.iterator();
        Iterator<String> sources = consumer.getOriginalSources().iterator();
        while (sources.hasNext() && content.hasNext()) {
            String code = content.next();
            SourceFile source = SourceMapResolver.getRelativePath(inputSourceMap.getOriginalPath(), sources.next());
            if (source == null) continue;
            this.sourceMap.addSourceFile(source.getName(), code);
        }
        if (sources.hasNext() || content.hasNext()) {
            throw new RuntimeException("Source map's \"sources\" and \"sourcesContent\" lengths do not match.");
        }
    }

    @Override
    public @Nullable Mapping.OriginalMapping getSourceMapping(String sourceName, int lineNumber, int columnNumber) {
        String relativePath;
        if (sourceName == null) {
            return null;
        }
        SourceMapInput sourceMap = this.inputSourceMaps.get(sourceName);
        if (sourceMap == null) {
            return null;
        }
        SourceMapConsumerV3 consumer = sourceMap.getSourceMap(this.errorManager);
        if (consumer == null) {
            return null;
        }
        Mapping.OriginalMapping result = consumer.getMappingForLine(lineNumber, columnNumber + 1);
        if (result == null) {
            return null;
        }
        String sourceMapOriginalPath = sourceMap.getOriginalPath();
        String resultOriginalPath = result.getOriginalFile();
        if (sourceMapOriginalPath.equals(this.resolvedSourceMap.originalPath) && resultOriginalPath.equals(this.resolvedSourceMap.sourceMapPath)) {
            relativePath = this.resolvedSourceMap.relativePath;
        } else {
            relativePath = Compiler.resolveSibling(sourceMapOriginalPath, resultOriginalPath);
            SourceFile source = this.getSourceFileByName(relativePath);
            if (source == null && !Strings.isNullOrEmpty((String)resultOriginalPath) && (source = SourceMapResolver.getRelativePath(sourceMap.getOriginalPath(), result.getOriginalFile())) != null) {
                this.sourceMapOriginalSources.putIfAbsent(relativePath, source);
            }
            this.resolvedSourceMap.originalPath = sourceMapOriginalPath;
            this.resolvedSourceMap.sourceMapPath = resultOriginalPath;
            this.resolvedSourceMap.relativePath = relativePath;
        }
        return result.toBuilder().setOriginalFile(relativePath).setColumnPosition(result.getColumnPosition() - 1).build();
    }

    @Override
    public @Nullable String getSourceLine(String sourceName, int lineNumber) {
        if (lineNumber < 1) {
            return null;
        }
        SourceFile input = this.getSourceFileByName(sourceName);
        if (input != null) {
            return input.getLine(lineNumber);
        }
        return null;
    }

    @Override
    public @Nullable Region getSourceLines(String sourceName, int lineNumber, int length) {
        if (lineNumber < 1) {
            return null;
        }
        SourceFile input = this.getSourceFileByName(sourceName);
        if (input != null) {
            return input.getLines(lineNumber, length);
        }
        return null;
    }

    @Override
    public @Nullable Region getSourceRegion(String sourceName, int lineNumber) {
        if (lineNumber < 1) {
            return null;
        }
        SourceFile input = this.getSourceFileByName(sourceName);
        if (input != null) {
            return input.getRegion(lineNumber);
        }
        return null;
    }

    @Override
    protected Node getNodeForCodeInsertion(@Nullable JSChunk chunk) {
        if (this.inputsById.containsKey(SYNTHETIC_CODE_INPUT_ID)) {
            return this.inputsById.get(SYNTHETIC_CODE_INPUT_ID).getAstRoot(this);
        }
        if (chunk == null) {
            if (this.chunkGraph == null || Iterables.isEmpty(this.chunkGraph.getAllInputs())) {
                throw new IllegalStateException("No inputs");
            }
            CompilerInput firstInput = (CompilerInput)Iterables.getFirst(this.chunkGraph.getAllInputs(), null);
            return Compiler.checkNotModule(firstInput.getAstRoot(this), "Cannot insert code into a module", new Object[0]);
        }
        ImmutableList<CompilerInput> moduleInputs = chunk.getInputs();
        if (!moduleInputs.isEmpty()) {
            return Compiler.checkNotModule(((CompilerInput)moduleInputs.get(0)).getAstRoot(this), "Cannot insert code into a module", new Object[0]);
        }
        throw new IllegalStateException("Root module has no inputs");
    }

    public SourceMap getSourceMap() {
        return this.sourceMap;
    }

    @Override
    public void setVariableMap(VariableMap variableMap) {
        this.variableMap = variableMap;
    }

    VariableMap getVariableMap() {
        return this.variableMap;
    }

    @Override
    public void setPropertyMap(VariableMap propertyMap) {
        this.propertyMap = propertyMap;
    }

    VariableMap getPropertyMap() {
        return this.propertyMap;
    }

    @Override
    public void setStringMap(VariableMap stringMap) {
        this.stringMap = stringMap;
    }

    @Override
    public void setCssNames(Set<String> cssNames) {
        this.cssNames = cssNames;
    }

    @Override
    public void setIdGeneratorMap(String serializedIdMappings) {
        this.idGeneratorMap = serializedIdMappings;
    }

    @Override
    public boolean getTranspiledFiles() {
        return this.transpiledFiles;
    }

    public void setTranspiledFiles(boolean transpiledFiles) {
        this.transpiledFiles = transpiledFiles;
    }

    @Override
    public IdGenerator getCrossModuleIdGenerator() {
        return this.crossModuleIdGenerator;
    }

    @Override
    public void setAnonymousFunctionNameMap(VariableMap functionMap) {
    }

    VariableMap getStringMap() {
        return this.stringMap;
    }

    @Override
    public void setInstrumentationMapping(VariableMap instrumentationMapping) {
        this.instrumentationMapping = instrumentationMapping;
    }

    public VariableMap getInstrumentationMapping() {
        return this.instrumentationMapping;
    }

    @Override
    public void addExportedNames(Set<String> exportedNames) {
        this.exportedNames.addAll(exportedNames);
    }

    @Override
    public Set<String> getExportedNames() {
        return this.exportedNames;
    }

    @Override
    public CompilerOptions getOptions() {
        return this.options;
    }

    public static void setLoggingLevel(Level level) {
        logger.setLevel(level);
    }

    public String getAstDotGraph() throws IOException {
        if (this.jsRoot != null) {
            ControlFlowGraph<Node> cfg = ControlFlowAnalysis.builder().setCompiler(this).setCfgRoot(this.jsRoot).setTraverseFunctions(true).computeCfg();
            return DotFormatter.toDot(this.jsRoot, cfg);
        }
        return "";
    }

    @Override
    public ErrorManager getErrorManager() {
        if (this.options == null) {
            this.initOptions(new CompilerOptions());
        }
        return this.errorManager;
    }

    @Override
    Iterable<CompilerInput> getInputsInOrder() {
        return this.chunkGraph.getAllInputs();
    }

    @Override
    int getNumberOfInputs() {
        return this.chunkGraph != null ? this.chunkGraph.getInputCount() : 1;
    }

    public Map<InputId, CompilerInput> getInputsById() {
        return Collections.unmodifiableMap(this.inputsById);
    }

    List<CompilerInput> getExternsInOrder() {
        return Collections.unmodifiableList(this.externs);
    }

    @VisibleForTesting
    @Nullable List<CompilerInput> getInputsForTesting() {
        return this.chunkGraph != null ? ImmutableList.copyOf(this.chunkGraph.getAllInputs()) : null;
    }

    @VisibleForTesting
    List<CompilerInput> getExternsForTesting() {
        return this.externs;
    }

    @Override
    boolean hasRegExpGlobalReferences() {
        return this.hasRegExpGlobalReferences;
    }

    @Override
    void setHasRegExpGlobalReferences(boolean references) {
        this.hasRegExpGlobalReferences = references;
    }

    @Override
    void setRunJ2clPasses(boolean runJ2clPasses) {
        this.runJ2clPasses = runJ2clPasses;
    }

    @Override
    boolean runJ2clPasses() {
        return this.runJ2clPasses;
    }

    @Override
    CompilerInput getSynthesizedExternsInput() {
        if (this.syntheticExternsInput != null) {
            return this.syntheticExternsInput;
        }
        CompilerInput input = new CompilerInput(this.SYNTHETIC_EXTERNS_FILE, true);
        Node root = (Node)Preconditions.checkNotNull((Object)input.getAstRoot(this));
        this.putCompilerInput(input);
        this.syntheticExternsInput = input;
        this.externsRoot.addChildToFront(root);
        this.externs.add(0, input);
        this.scriptNodeByFilename.put(input.getSourceFile().getName(), root);
        return input;
    }

    @Override
    InputId getSyntheticCodeInputId() {
        return SYNTHETIC_CODE_INPUT_ID;
    }

    @Override
    void initializeSyntheticCodeInput() {
        Preconditions.checkState((!this.inputsById.containsKey(SYNTHETIC_CODE_INPUT_ID) ? 1 : 0) != 0, (Object)"Already initialized synthetic input");
        JsAst ast = new JsAst(SourceFile.fromCode(SYNTHETIC_CODE_INPUT_ID.getIdName(), ""));
        if (this.inputsById.containsKey(ast.getInputId())) {
            throw new IllegalStateException("Conflicting synthetic id name");
        }
        CompilerInput input = new CompilerInput(ast, false);
        this.jsRoot.addChildToFront((Node)Preconditions.checkNotNull((Object)ast.getAstRoot(this)));
        JSChunk firstChunk = (JSChunk)Iterables.getFirst(this.getChunks(), null);
        if (firstChunk.getName().equals("$strong$")) {
            firstChunk.add(input);
        }
        input.setChunk(firstChunk);
        this.putCompilerInput(input);
        this.commentsPerFile.put(SYNTHETIC_CODE_INPUT_ID.getIdName(), (List<Comment>)ImmutableList.of());
        this.reportChangeToChangeScope(ast.getAstRoot(this));
    }

    @Override
    void removeSyntheticCodeInput() {
        this.removeSyntheticCodeInput(false);
    }

    @Override
    void mergeSyntheticCodeInput() {
        this.removeSyntheticCodeInput(true);
    }

    private void removeSyntheticCodeInput(boolean mergeContentIntoFirstInput) {
        Preconditions.checkState((boolean)this.inputsById.containsKey(SYNTHETIC_CODE_INPUT_ID), (Object)"Never initialized the synthetic input");
        CompilerInput input = this.inputsById.get(SYNTHETIC_CODE_INPUT_ID);
        Node astRoot = input.getAstRoot(this);
        Preconditions.checkState((boolean)astRoot.isFirstChildOf(this.jsRoot));
        Preconditions.checkState((boolean)SYNTHETIC_CODE_INPUT_ID.equals(input.getInputId()));
        if (mergeContentIntoFirstInput && astRoot.hasChildren()) {
            Node next = astRoot.getNext();
            Preconditions.checkNotNull((Object)next, (Object)"Must provide at least one source");
            Compiler.checkNotModule(next, "Cannot remove synthetic code input until modules are rewritten: %s", next);
            next.addChildrenToFront(astRoot.removeChildren());
            this.reportChangeToChangeScope(next);
        }
        astRoot.detach();
        this.reportChangeToChangeScope(astRoot);
        astRoot.setDeleted(true);
        NodeUtil.markFunctionsDeleted(astRoot, this);
        input.getChunk().remove(input);
        this.inputsById.remove(input.getInputId());
    }

    @Override
    String getLastPassName() {
        return this.lastPassName;
    }

    @Override
    void setExternProperties(ImmutableSet<String> externProperties) {
        this.externProperties = externProperties;
    }

    @Override
    public ImmutableSet<String> getExternProperties() {
        return this.externProperties;
    }

    @Override
    AccessorSummary getAccessorSummary() {
        return this.accessorSummary;
    }

    @Override
    public void setAccessorSummary(AccessorSummary summary) {
        this.accessorSummary = (AccessorSummary)Preconditions.checkNotNull((Object)summary);
    }

    @Override
    protected Node ensureLibraryInjected(String resourceName, boolean force) {
        Node ast;
        boolean shouldInject;
        boolean bl = shouldInject = force || !this.options.skipNonTranspilationPasses && !this.options.preventLibraryInjection;
        if (this.injectedLibraries.contains(resourceName) || !shouldInject) {
            return this.lastInjectedLibrary;
        }
        Preconditions.checkState((!this.getLifeCycleStage().isNormalized() ? 1 : 0) != 0, (Object)"runtime library injected after normalization");
        String path = String.join((CharSequence)"", "src/com/google/javascript/jscomp/js/", resourceName, ".js");
        if (this.getLifeCycleStage().hasColorAndSimplifiedJSDoc()) {
            Preconditions.checkNotNull(this.runtimeLibraryTypedAsts, (Object)"Must call initRuntimeLibraryTypedAsts before calling ensureLibraryInjected during optimizations");
            Supplier typedAstSupplier = (Supplier)Preconditions.checkNotNull((Object)((Supplier)this.runtimeLibraryTypedAsts.get((Object)path)), (String)String.join((CharSequence)"", "Missing precompiled .typedast for '%s'. If this file is newly added, ", "you may need to regenerate runtime_libs.typedast.textproto", ""), (Object)path);
            ast = (Node)typedAstSupplier.get();
        } else {
            Preconditions.checkState((!this.hasTypeCheckingRun() ? 1 : 0) != 0, (Object)"runtime library injected after type checking but before optimization colors");
            String originalCode = ResourceLoader.loadTextResource(Compiler.class, "js/" + resourceName + ".js");
            SourceFile source = SourceFile.fromCode(path, originalCode);
            this.addFilesToSourceMap((Iterable<SourceFile>)ImmutableList.of((Object)source));
            ast = this.parseCodeHelper(source);
        }
        Node node = ast.getFirstChild();
        while (node != null && node.isExprResult() && node.getFirstChild().isStringLit()) {
            String directive = node.getFirstChild().getString();
            List words = Splitter.on((char)' ').limit(2).splitToList((CharSequence)directive);
            switch ((String)words.get(0)) {
                case "use": {
                    break;
                }
                case "require": {
                    this.ensureLibraryInjected((String)words.get(1), force);
                    break;
                }
                default: {
                    throw new RuntimeException("Bad directive: " + directive);
                }
            }
            node.detach();
            node = ast.getFirstChild();
        }
        Node lastChild = ast.getLastChild();
        for (Node child = ast.getFirstChild(); child != null; child = child.getNext()) {
            NodeUtil.markNewScopesChanged(child, this);
        }
        Node firstChild = ast.removeChildren();
        if (firstChild == null) {
            return this.lastInjectedLibrary;
        }
        Node parent = this.getNodeForCodeInsertion(null);
        if (this.lastInjectedLibrary == null) {
            parent.addChildrenToFront(firstChild);
        } else {
            parent.addChildrenAfter(firstChild, this.lastInjectedLibrary);
        }
        this.lastInjectedLibrary = lastChild;
        this.injectedLibraries.add(resourceName);
        this.reportChangeToEnclosingScope(parent);
        return lastChild;
    }

    @Override
    void addComments(String filename, List<Comment> comments) {
        if (!this.getOptions().preservesDetailedSourceInfo()) {
            throw new UnsupportedOperationException("addComments may only be called in IDE mode.");
        }
        this.commentsPerFile.put(filename, comments);
    }

    @Override
    public List<Comment> getComments(String filename) {
        if (!this.getOptions().preservesDetailedSourceInfo()) {
            throw new UnsupportedOperationException("getComments may only be called in IDE mode.");
        }
        return this.commentsPerFile.get(filename);
    }

    @Override
    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    private synchronized void addFilesToSourceMap(Iterable<SourceFile> files) {
        if (this.getOptions().sourceMapIncludeSourcesContent && this.getSourceMap() != null) {
            for (SourceFile file : files) {
                try {
                    this.getSourceMap().addSourceFile(file.getName(), file.getCode());
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot read code of a source map's source file.", e);
                }
            }
        }
    }

    public void initWebpackMap(ImmutableMap<String, String> inputPathByWebpackId) {
        this.inputPathByWebpackId = inputPathByWebpackId;
    }

    protected CompilerExecutor createCompilerExecutor() {
        return new CompilerExecutor();
    }

    protected CompilerExecutor getCompilerExecutor() {
        return this.compilerExecutor;
    }

    protected void restoreFromState(CompilerState compilerState) {
        this.allowableFeatures = compilerState.allowableFeatures;
        this.scriptNodeByFilename.clear();
        this.typeCheckingHasRun = compilerState.typeCheckingHasRun;
        this.injectedLibraries.clear();
        this.injectedLibraries.addAll(compilerState.injectedLibraries);
        this.hasRegExpGlobalReferences = compilerState.hasRegExpGlobalReferences;
        AbstractCompiler.LifeCycleStage stage = compilerState.lifeCycleStage == AbstractCompiler.LifeCycleStage.RAW ? AbstractCompiler.LifeCycleStage.COLORS_AND_SIMPLIFIED_JSDOC : compilerState.lifeCycleStage;
        this.setLifeCycleStage(stage);
        this.getOptions().setMergedPrecompiledLibraries(compilerState.mergedPrecompiledLibraries);
        this.chunkGraph = compilerState.chunkGraph;
        this.uniqueNameId = compilerState.uniqueNameId;
        this.uniqueIdSupplier = compilerState.uniqueIdSupplier;
        this.exportedNames.clear();
        this.exportedNames.addAll(compilerState.exportedNames);
        this.cssNames = compilerState.cssNames;
        this.variableMap = null;
        this.propertyMap = null;
        this.stringMap = compilerState.stringMap;
        this.idGeneratorMap = compilerState.idGeneratorMap;
        this.transpiledFiles = compilerState.transpiledFiles;
        this.crossModuleIdGenerator = compilerState.crossModuleIdGenerator;
        this.runJ2clPasses = compilerState.runJ2clPasses;
        this.changeStamp = 1;
        this.accessorSummary = compilerState.accessorSummary;
        this.instrumentationMapping = compilerState.instrumentationMappping;
    }

    private static final ImmutableListMultimap<JSChunk, InputId> mapJSModulesToInputIds(Iterable<JSChunk> jsModules) {
        ImmutableListMultimap.Builder jsmoduleToInputId = ImmutableListMultimap.builder();
        for (JSChunk jsModule : jsModules) {
            jsmoduleToInputId.putAll((Object)jsModule, (Iterable)jsModule.getInputs().stream().map(CompilerInput::getInputId).collect(ImmutableList.toImmutableList()));
        }
        return jsmoduleToInputId.build();
    }

    @GwtIncompatible(value="ObjectOutputStream")
    public void saveState(OutputStream outputStream) throws IOException {
        this.runInCompilerThread(() -> {
            Tracer tracer = this.newTracer("serializeCompilerState");
            GZIPOutputStream gzipStream = new GZIPOutputStream(outputStream);
            new ObjectOutputStream(gzipStream).writeObject(this.getCompilerState());
            this.stopTracer(tracer, "serializeCompilerState");
            tracer = this.newTracer("serializeTypedAst");
            SerializeTypedAstPass.createFromOutputStream(this, gzipStream, this.getOptions().shouldSerializeExtraDebugInfo() ? SerializationOptions.INCLUDE_DEBUG_INFO : SerializationOptions.SKIP_DEBUG_INFO).process(this.externsRoot, this.jsRoot);
            this.stopTracer(tracer, "serializeTypedAst");
            gzipStream.finish();
            return null;
        });
    }

    protected CompilerState getCompilerState() {
        return new CompilerState(this);
    }

    @GwtIncompatible(value="ClassNotFoundException")
    public void restoreState(InputStream inputStream) throws IOException, ClassNotFoundException {
        this.initWarningsGuard(this.options.getWarningsGuard());
        this.maybeSetTracker();
        this.runInCompilerThread(() -> {
            Tracer tracer = this.newTracer("deserializeCompilerState");
            logger.fine("Deserializing the CompilerState");
            try {
                this.deserializeCompilerState(new GZIPInputStream(inputStream));
                Object var3_3 = null;
                return var3_3;
            }
            finally {
                logger.fine("Finished deserializing CompilerState");
                this.stopTracer(tracer, "deserializeCompilerState");
            }
        });
        if (this.tracker != null) {
            this.tracker.updateAfterDeserialize(this.jsRoot);
        }
    }

    @GwtIncompatible(value="ObjectInputStream")
    private void deserializeCompilerState(InputStream inputStream) throws IOException, ClassNotFoundException {
        CompilerState compilerState = (CompilerState)new ObjectInputStream(inputStream).readObject();
        Preconditions.checkNotNull((Object)this.chunkGraph, (Object)"Did you forget to call .init or .initChunks before restoreState?");
        ImmutableMap.Builder externFilesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder codeFilesBuilder = ImmutableMap.builder();
        ImmutableSet.Builder allInputFiles = ImmutableSet.builder();
        for (CompilerInput input : this.chunkGraph.getAllInputs()) {
            allInputFiles.add((Object)input.getSourceFile());
            codeFilesBuilder.put((Object)input.getInputId().getIdName(), (Object)input.getSourceFile());
        }
        for (CompilerInput extern : this.externs) {
            allInputFiles.add((Object)extern.getSourceFile());
            externFilesBuilder.put((Object)extern.getInputId().getIdName(), (Object)extern.getSourceFile());
        }
        TypedAstDeserializer.DeserializedAst deserializedAst = TypedAstDeserializer.deserializeFullAst(this, this.SYNTHETIC_EXTERNS_FILE, (ImmutableSet<SourceFile>)allInputFiles.build(), inputStream, compilerState.typeCheckingHasRun, this.getOptions().resolveSourceMapAnnotations, this.getOptions().parseInlineSourceMaps);
        this.restoreFromState(compilerState);
        this.externProperties = deserializedAst.getExternProperties();
        this.externAndJsRoot = IR.root(IR.root(new Node[0]), IR.root(new Node[0]));
        this.externsRoot = this.externAndJsRoot.getFirstChild();
        this.jsRoot = this.externAndJsRoot.getLastChild();
        this.inputsById.clear();
        this.externs.clear();
        this.colorRegistry = (ColorRegistry)deserializedAst.getColorRegistry().orNull();
        this.typedAstFilesystem = deserializedAst.getFilesystem();
        ImmutableMap externFiles = externFilesBuilder.buildOrThrow();
        ImmutableMap codeFiles = codeFilesBuilder.buildOrThrow();
        for (InputId extern : compilerState.externs) {
            if (extern.getIdName().equals(this.SYNTHETIC_EXTERNS_FILE.getName())) {
                this.getSynthesizedExternsInput();
                continue;
            }
            SourceFile externFile = (SourceFile)externFiles.get((Object)extern.getIdName());
            if (externFile == null) {
                externFile = (SourceFile)Preconditions.checkNotNull((Object)((SourceFile)codeFiles.get((Object)extern.getIdName())), (String)"Missing %s", (Object)extern);
            }
            CompilerInput input = new CompilerInput(externFile, true);
            Node script = input.getAstRoot(this);
            this.externsRoot.addChildToBack(script);
            this.putCompilerInput(input);
            this.scriptNodeByFilename.put(externFile.getName(), script);
            this.externs.add(input);
        }
        for (JSChunk deserializedModule : this.getChunks()) {
            for (InputId inputId : compilerState.moduleToInputList.get((Object)deserializedModule)) {
                SourceFile src = (SourceFile)codeFiles.get((Object)inputId.getIdName());
                if (src == null) {
                    Preconditions.checkState((boolean)Compiler.isFillFileName(inputId.getIdName()), (String)"Missing %s", (Object)inputId);
                    continue;
                }
                CompilerInput input = new CompilerInput(src);
                Node script = input.getAstRoot(this);
                this.jsRoot.addChildToBack(script);
                this.scriptNodeByFilename.put(src.getName(), script);
                this.putCompilerInput(input);
                deserializedModule.add(input);
            }
        }
        this.typedAstFilesystem = null;
        this.lastInjectedLibrary = compilerState.lastInjectedLibraryIndexInFirstScript != -1 ? this.jsRoot.getFirstChild().getChildAtIndex(compilerState.lastInjectedLibraryIndexInFirstScript) : null;
    }

    @Override
    @Nullable CompilerInput.ModuleType getModuleTypeByName(String moduleName) {
        return this.moduleTypesByName.get(moduleName);
    }

    @Override
    public ModuleMetadataMap getModuleMetadataMap() {
        return this.moduleMetadataMap;
    }

    @Override
    public void setModuleMetadataMap(ModuleMetadataMap moduleMetadataMap) {
        this.moduleMetadataMap = moduleMetadataMap;
    }

    @Override
    public ModuleMap getModuleMap() {
        return this.moduleMap;
    }

    @Override
    public void setModuleMap(ModuleMap moduleMap) {
        this.moduleMap = moduleMap;
    }

    private static String resolveSibling(String fromPath, String toPath) {
        if (toPath.startsWith("/")) {
            return toPath;
        }
        ArrayList<String> fromPathParts = new ArrayList<String>(Arrays.asList(fromPath.split("/")));
        ArrayList<String> toPathParts = new ArrayList<String>(Arrays.asList(toPath.split("/")));
        if (!fromPathParts.isEmpty()) {
            fromPathParts.remove(fromPathParts.size() - 1);
        }
        while (!fromPathParts.isEmpty() && !toPathParts.isEmpty()) {
            if (((String)toPathParts.get(0)).equals(".")) {
                toPathParts.remove(0);
                continue;
            }
            if (!((String)toPathParts.get(0)).equals("..")) break;
            toPathParts.remove(0);
            fromPathParts.remove(fromPathParts.size() - 1);
        }
        fromPathParts.addAll(toPathParts);
        return String.join((CharSequence)"/", fromPathParts);
    }

    public void resetAndIntitializeSourceMap() {
        if (this.sourceMap == null) {
            return;
        }
        this.sourceMap.reset();
        if (this.options.sourceMapIncludeSourcesContent) {
            Iterable<JSChunk> allModules;
            if (this.options.applyInputSourceMaps) {
                for (SourceMapInput inputSourceMap : this.inputSourceMaps.values()) {
                    this.addSourceMapSourceFiles(inputSourceMap);
                }
            }
            if ((allModules = this.getChunks()) != null) {
                ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
                for (JSChunk chunk : allModules) {
                    for (CompilerInput input : chunk.getInputs()) {
                        sourceFiles.add(input.getSourceFile());
                    }
                }
                this.addFilesToSourceMap(sourceFiles);
            }
        }
    }

    private static Node checkNotModule(Node script, String msg, Object ... args) {
        Preconditions.checkArgument((boolean)script.isScript(), (Object)script);
        if (!script.hasOneChild()) {
            return script;
        }
        Preconditions.checkState((!script.getFirstChild().isModuleBody() ? 1 : 0) != 0, (String)msg, (Object[])args);
        return script;
    }

    private static /* synthetic */ boolean lambda$getCurrentJsSource$15(Set qnameSet, Multimap originalToNewQNameMap, Node statement) {
        return NodeUtil.has(statement, (Predicate<Node>)((Predicate)n -> {
            Preconditions.checkNotNull((Object)n);
            if (!n.isQualifiedName()) {
                return false;
            }
            String qname = n.getQualifiedName();
            if (qnameSet.contains(qname)) {
                return true;
            }
            String originalQname = n.getOriginalQualifiedName();
            if (originalQname != null && qnameSet.contains(originalQname)) {
                originalToNewQNameMap.put((Object)originalQname, (Object)qname);
                return true;
            }
            return false;
        }), (Predicate<Node>)((Predicate)node -> true));
    }

    private static class ResolvedSourceMap {
        public String originalPath;
        public String sourceMapPath;
        public String relativePath;

        private ResolvedSourceMap() {
        }
    }

    public static class ChunkGraphAwareLicenseTracker
    implements CodePrinter.LicenseTracker {
        private final AbstractCompiler compiler;
        private final Map<JSChunk, Set<String>> licensesFromChunks = new LinkedHashMap<JSChunk, Set<String>>();
        private boolean haveInitializedCurrentChunkLicenses = false;
        private final Set<String> currentChunkLicencesInTDeps = new LinkedHashSet<String>();
        private String lastSeenFile = "";
        private final Set<String> licensesNewInCurrentFile = new LinkedHashSet<String>();
        private Set<String> licensesNewInCurrentChunk = new LinkedHashSet<String>();
        private LogFile log = LogFile.createNoOp();
        private JSChunk currentChunk;

        public ChunkGraphAwareLicenseTracker(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        public void setLogFile(LogFile file) {
            this.log = file;
        }

        public void setCurrentChunkContext(JSChunk chunk) {
            this.log.log("Initializing licenses from deps for chunk %s", chunk);
            this.currentChunk = chunk;
            this.currentChunkLicencesInTDeps.clear();
            this.licensesNewInCurrentFile.clear();
            this.haveInitializedCurrentChunkLicenses = false;
            if (this.licensesFromChunks.containsKey(chunk)) {
                throw new IllegalStateException("Visiting a chunk more than once is not allowed.");
            }
            this.licensesNewInCurrentChunk = new LinkedHashSet<String>();
            this.licensesFromChunks.put(chunk, this.licensesNewInCurrentChunk);
        }

        @Override
        public void trackLicensesForNode(Node node) {
            String license;
            if (node.isRoot() || node.isScript()) {
                return;
            }
            String sourceFile = node.getSourceFileName();
            if (sourceFile == null) {
                return;
            }
            if (this.lastSeenFile.equals(sourceFile)) {
                return;
            }
            this.lastSeenFile = sourceFile;
            if (!this.haveInitializedCurrentChunkLicenses) {
                for (JSChunk depChunk : this.currentChunk.getAllDependencies()) {
                    this.log.log("Chunk %s depends on chunk %s", this.currentChunk, depChunk);
                    if (!this.licensesFromChunks.containsKey(depChunk)) {
                        throw new IllegalStateException("Module aware license analysis error - analysis out of order.");
                    }
                    this.currentChunkLicencesInTDeps.addAll((Collection<String>)this.licensesFromChunks.get(depChunk));
                }
                this.haveInitializedCurrentChunkLicenses = true;
            }
            if ((license = Compiler.getLicenseForFile(this.compiler, node.getSourceFileName())) == null) {
                return;
            }
            if (this.currentChunkLicencesInTDeps.contains(license)) {
                return;
            }
            if (this.licensesNewInCurrentChunk.contains(license)) {
                return;
            }
            boolean newlyAddedLicense = this.licensesNewInCurrentFile.add(license);
            if (!newlyAddedLicense) {
                this.log.log("Chunk %s already depends on license\n==================\n%s\n==================\n\n", this.currentChunk, license);
            } else {
                this.log.log("Chunk %s has new license:\n==================\n%s\n==================\n\n", this.currentChunk, license);
            }
        }

        @Override
        public ImmutableSet<String> emitLicenses() {
            ImmutableSet licensesNewInFile = ImmutableSet.copyOf(this.licensesNewInCurrentFile);
            this.licensesNewInCurrentChunk.addAll((Collection<String>)licensesNewInFile);
            this.licensesNewInCurrentFile.clear();
            return licensesNewInFile;
        }
    }

    public static class ScriptNodeLicensesOnlyTracker
    extends SeenSetLicenseTracker {
        public ScriptNodeLicensesOnlyTracker(AbstractCompiler compiler) {
            super(compiler);
        }

        @Override
        protected boolean shouldUseLicenseInfo(Node node) {
            return node.isRoot() || node.isScript();
        }
    }

    public static class CodeBuilder {
        private final StringBuilder sb = new StringBuilder();
        private int lineCount = 0;
        private int colCount = 0;

        void reset() {
            this.sb.setLength(0);
        }

        @CanIgnoreReturnValue
        CodeBuilder append(String str) {
            int index;
            this.sb.append(str);
            int lastIndex = index = -1;
            while ((index = str.indexOf(10, index + 1)) >= 0) {
                ++this.lineCount;
                lastIndex = index;
            }
            this.colCount = lastIndex == -1 ? (this.colCount += str.length()) : str.length() - (lastIndex + 1);
            return this;
        }

        public String toString() {
            return this.sb.toString();
        }

        public int getLength() {
            return this.sb.length();
        }

        int getLineIndex() {
            return this.lineCount;
        }

        int getColumnIndex() {
            return this.colCount;
        }

        boolean endsWith(String suffix) {
            return this.sb.length() > suffix.length() && suffix.equals(this.sb.substring(this.sb.length() - suffix.length()));
        }
    }

    protected static class CompilerState
    implements Serializable {
        private final FeatureSet allowableFeatures;
        private final boolean typeCheckingHasRun;
        private final boolean hasRegExpGlobalReferences;
        private final AbstractCompiler.LifeCycleStage lifeCycleStage;
        private final boolean mergedPrecompiledLibraries;
        private final JSChunkGraph chunkGraph;
        private final int uniqueNameId;
        private final UniqueIdSupplier uniqueIdSupplier;
        private final LinkedHashSet<String> exportedNames;
        private final Set<String> cssNames;
        private final String idGeneratorMap;
        private final boolean transpiledFiles;
        private final IdGenerator crossModuleIdGenerator;
        private final boolean runJ2clPasses;
        private final ImmutableList<InputId> externs;
        private final ImmutableListMultimap<JSChunk, InputId> moduleToInputList;
        private final LinkedHashSet<String> injectedLibraries;
        private final int lastInjectedLibraryIndexInFirstScript;
        private final AccessorSummary accessorSummary;
        private final VariableMap stringMap;
        private final VariableMap instrumentationMappping;

        CompilerState(Compiler compiler) {
            this.allowableFeatures = (FeatureSet)Preconditions.checkNotNull((Object)compiler.allowableFeatures);
            this.typeCheckingHasRun = compiler.typeCheckingHasRun;
            this.hasRegExpGlobalReferences = compiler.hasRegExpGlobalReferences;
            this.lifeCycleStage = compiler.getLifeCycleStage();
            this.mergedPrecompiledLibraries = compiler.options.getMergedPrecompiledLibraries();
            this.chunkGraph = compiler.chunkGraph;
            this.uniqueNameId = compiler.uniqueNameId;
            this.uniqueIdSupplier = compiler.uniqueIdSupplier;
            this.exportedNames = compiler.exportedNames;
            this.cssNames = compiler.cssNames;
            this.idGeneratorMap = compiler.idGeneratorMap;
            this.transpiledFiles = compiler.transpiledFiles;
            this.crossModuleIdGenerator = compiler.crossModuleIdGenerator;
            this.runJ2clPasses = compiler.runJ2clPasses;
            this.externs = (ImmutableList)compiler.externs.stream().map(CompilerInput::getInputId).collect(ImmutableList.toImmutableList());
            this.moduleToInputList = Compiler.mapJSModulesToInputIds(compiler.chunkGraph.getAllChunks());
            this.injectedLibraries = compiler.injectedLibraries;
            this.lastInjectedLibraryIndexInFirstScript = compiler.lastInjectedLibrary != null ? compiler.jsRoot.getFirstChild().getIndexOfChild(compiler.lastInjectedLibrary) : -1;
            this.accessorSummary = compiler.accessorSummary;
            this.stringMap = compiler.getStringMap();
            this.instrumentationMappping = compiler.getInstrumentationMapping();
        }
    }

    public static final class SingleBinaryLicenseTracker
    extends SeenSetLicenseTracker {
        SingleBinaryLicenseTracker(AbstractCompiler compiler) {
            super(compiler);
        }

        @Override
        protected boolean shouldUseLicenseInfo(Node node) {
            return !node.isRoot() && !node.isScript();
        }
    }

    private static abstract class SeenSetLicenseTracker
    implements CodePrinter.LicenseTracker {
        private final AbstractCompiler compiler;
        private final Set<String> globallyUniqueLicenses = new LinkedHashSet<String>();
        private final Set<String> currentlySeenLicenses = new LinkedHashSet<String>();
        private String lastSeenFile = "";

        public SeenSetLicenseTracker(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        protected boolean shouldUseLicenseInfo(Node node) {
            return !node.isRoot() && !node.isScript();
        }

        @Override
        public void trackLicensesForNode(Node node) {
            if (!this.shouldUseLicenseInfo(node)) {
                return;
            }
            String file = node.getSourceFileName();
            if (file == null) {
                return;
            }
            if (file.equals(this.lastSeenFile)) {
                return;
            }
            this.lastSeenFile = file;
            String license = Compiler.getLicenseForFile(this.compiler, file);
            if (license == null) {
                return;
            }
            if (this.globallyUniqueLicenses.contains(license)) {
                return;
            }
            this.currentlySeenLicenses.add(license);
        }

        @Override
        public ImmutableSet<String> emitLicenses() {
            ImmutableSet rv = ImmutableSet.copyOf(this.currentlySeenLicenses);
            this.globallyUniqueLicenses.addAll(this.currentlySeenLicenses);
            this.currentlySeenLicenses.clear();
            return rv;
        }
    }

    public static class ExternalSourceLoader {
        public SourceFile loadSource(String filename) {
            throw new RuntimeException("Cannot load without a valid loader.");
        }
    }
}

