/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Predicate;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.base.Tri;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.GraphReachability;
import com.google.javascript.rhino.Node;

class CheckUnreachableCode
extends NodeTraversal.AbstractCfgCallback {
    static final DiagnosticType UNREACHABLE_CODE = DiagnosticType.warning("JSC_UNREACHABLE_CODE", "unreachable code");
    private final AbstractCompiler compiler;
    private static final Predicate<GraphReachability.EdgeTuple<Node, ControlFlowGraph.Branch>> REACHABLE = input -> {
        Tri val;
        ControlFlowGraph.Branch branch = (ControlFlowGraph.Branch)((Object)((Object)input.edge));
        if (!branch.isConditional()) {
            return true;
        }
        Node predecessor = (Node)input.sourceNode;
        Node condition = NodeUtil.getConditionExpression(predecessor);
        if (condition != null && (val = NodeUtil.getBooleanValue(condition)) != Tri.UNKNOWN) {
            return val.toBoolean(true) == (branch == ControlFlowGraph.Branch.ON_TRUE);
        }
        return true;
    };

    CheckUnreachableCode(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void enterScopeWithCfg(NodeTraversal t) {
        if (NodeUtil.isValidCfgRoot(t.getScopeRoot())) {
            this.initScope(this.getControlFlowGraph(this.compiler));
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        ControlFlowGraph<Node> cfg = this.getControlFlowGraph(this.compiler);
        DiGraph.DiGraphNode gNode = cfg.getNode((Object)n);
        if (gNode != null && gNode.getAnnotation() != GraphReachability.REACHABLE && n.getLineno() != -1 && !n.isEmpty() && !n.isBreak()) {
            this.compiler.report(JSError.make(n, UNREACHABLE_CODE, new String[0]));
            new GraphReachability(cfg).recompute(n);
            return false;
        }
        return true;
    }

    private void initScope(ControlFlowGraph<Node> controlFlowGraph) {
        new GraphReachability<Node, ControlFlowGraph.Branch>(controlFlowGraph, REACHABLE).compute((Node)controlFlowGraph.getEntry().getValue());
    }
}

