/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.nullness.Nullable;

class AngularPass
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    final AbstractCompiler compiler;
    private final List<NodeContext> injectables = new ArrayList<NodeContext>();
    public static final String INJECT_PROPERTY_NAME = "$inject";
    static final DiagnosticType INJECT_IN_NON_GLOBAL_OR_BLOCK_ERROR = DiagnosticType.error("JSC_INJECT_IN_NON_GLOBAL_OR_BLOCK_ERROR", "@ngInject only applies to functions defined in blocks or global scope.");
    static final DiagnosticType INJECT_NON_FUNCTION_ERROR = DiagnosticType.error("JSC_INJECT_NON_FUNCTION_ERROR", "@ngInject can only be used when defining a function or assigning a function expression.");
    static final DiagnosticType INJECTED_FUNCTION_HAS_DESTRUCTURED_PARAM = DiagnosticType.error("JSC_INJECTED_FUNCTION_HAS_DESTRUCTURED_PARAM", "@ngInject cannot be used on functions containing destructured parameter.");
    static final DiagnosticType INJECTED_FUNCTION_HAS_DEFAULT_VALUE = DiagnosticType.error("JSC_INJECTED_FUNCTION_HAS_DEFAULT_VALUE", "@ngInject cannot be used on functions containing default value.");
    static final DiagnosticType INJECTED_FUNCTION_ON_NON_QNAME = DiagnosticType.error("JSC_INJECTED_FUNCTION_ON_NON_QNAME", "@ngInject can only be used on qualified names.");

    public AngularPass(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        for (NodeContext entry : this.injectables) {
            String name = entry.getName();
            Node fn = entry.getFunctionNode();
            List<Node> dependencies = this.createDependenciesList(fn);
            if (dependencies.isEmpty()) continue;
            Node dependenciesArray = IR.arraylit(dependencies);
            Node statement = IR.exprResult(IR.assign(IR.getelem(NodeUtil.newQName(this.compiler, name), IR.string(INJECT_PROPERTY_NAME)), dependenciesArray));
            statement.srcrefTree(entry.getNode());
            statement.setOriginalName(name);
            JSDocInfo.Builder newPropertyDoc = JSDocInfo.builder();
            newPropertyDoc.recordVisibility(JSDocInfo.Visibility.PUBLIC);
            statement.getFirstChild().setJSDocInfo(newPropertyDoc.build());
            Node insertionPoint = entry.getTarget();
            Node next = insertionPoint.getNext();
            while (next != null && NodeUtil.isExprCall(next) && this.compiler.getCodingConvention().getClassesDefinedByCall(next.getFirstChild()) != null) {
                insertionPoint = next;
                next = insertionPoint.getNext();
            }
            statement.insertAfter(insertionPoint);
            this.compiler.reportChangeToEnclosingScope(statement);
        }
    }

    private List<Node> createDependenciesList(Node n) {
        Preconditions.checkArgument((boolean)n.isFunction());
        Node params = NodeUtil.getFunctionParameters(n);
        if (params != null) {
            return this.createStringsFromParamList(params);
        }
        return new ArrayList<Node>();
    }

    private List<Node> createStringsFromParamList(Node params) {
        ArrayList<Node> names = new ArrayList<Node>();
        for (Node param = params.getFirstChild(); param != null; param = param.getNext()) {
            if (param.isName()) {
                names.add(IR.string(param.getString()).srcref(param));
                continue;
            }
            if (param.isDestructuringPattern()) {
                this.compiler.report(JSError.make(param, INJECTED_FUNCTION_HAS_DESTRUCTURED_PARAM, new String[0]));
                return new ArrayList<Node>();
            }
            if (!param.isDefaultValue()) continue;
            this.compiler.report(JSError.make(param, INJECTED_FUNCTION_HAS_DEFAULT_VALUE, new String[0]));
            return new ArrayList<Node>();
        }
        return names;
    }

    @Override
    public void visit(NodeTraversal unused, Node n, Node parent) {
        JSDocInfo docInfo = n.getJSDocInfo();
        if (docInfo != null && docInfo.isNgInject()) {
            this.addNode(n);
        }
    }

    private void addNode(Node n) {
        Node injectAfter = null;
        Node fn = null;
        Object name = null;
        switch (n.getToken()) {
            case ASSIGN: {
                if (!n.getFirstChild().isQualifiedName()) {
                    this.compiler.report(JSError.make(n, INJECTED_FUNCTION_ON_NON_QNAME, new String[0]));
                    return;
                }
                name = n.getFirstChild().getQualifiedName();
                fn = n;
                while (fn.isAssign()) {
                    fn = fn.getLastChild();
                }
                injectAfter = n.getParent();
                break;
            }
            case FUNCTION: {
                name = NodeUtil.getName(n);
                fn = n;
                injectAfter = n;
                if (!n.getParent().isAssign() || !n.getParent().getJSDocInfo().isNgInject()) break;
                return;
            }
            case VAR: 
            case LET: 
            case CONST: {
                name = n.getFirstChild().getString();
                fn = AngularPass.getDeclarationRValue(n);
                injectAfter = n;
                break;
            }
            case MEMBER_FUNCTION_DEF: {
                Node parent = n.getParent();
                if (!parent.isClassMembers()) break;
                Node classNode = parent.getParent();
                String midPart = n.isStaticMember() ? "." : ".prototype.";
                name = NodeUtil.getName(classNode) + midPart + n.getString();
                if (NodeUtil.isEs6ConstructorMemberFunctionDef(n)) {
                    name = NodeUtil.getName(classNode);
                }
                fn = n.getFirstChild();
                injectAfter = NodeUtil.getEnclosingStatement(classNode);
                break;
            }
        }
        if (fn == null || !fn.isFunction()) {
            this.compiler.report(JSError.make(n, INJECT_NON_FUNCTION_ERROR, new String[0]));
            return;
        }
        if (injectAfter.getParent().isExport()) {
            injectAfter = injectAfter.getParent();
        }
        if (!NodeUtil.isStatementBlock(injectAfter.getParent())) {
            this.compiler.report(JSError.make(n, INJECT_IN_NON_GLOBAL_OR_BLOCK_ERROR, new String[0]));
            return;
        }
        Preconditions.checkNotNull((Object)name);
        this.injectables.add(new NodeContext((String)name, n, fn, injectAfter));
    }

    private static @Nullable Node getDeclarationRValue(Node n) {
        Preconditions.checkNotNull((Object)n);
        Preconditions.checkArgument((boolean)NodeUtil.isNameDeclaration(n));
        n = n.getFirstFirstChild();
        if (n == null) {
            return null;
        }
        while (n.isAssign()) {
            n = n.getLastChild();
        }
        return n;
    }

    static class NodeContext {
        private final String name;
        private final Node node;
        private final Node functionNode;
        private final Node target;

        public NodeContext(String name, Node node, Node functionNode, Node target) {
            this.name = name;
            this.node = node;
            this.functionNode = functionNode;
            this.target = target;
        }

        public String getName() {
            return this.name;
        }

        public Node getNode() {
            return this.node;
        }

        public Node getFunctionNode() {
            return this.functionNode;
        }

        public Node getTarget() {
            return this.target;
        }
    }
}

