/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.Map;

@Immutable
final class AccessorSummary
implements Serializable {
    private final ImmutableMap<String, PropertyAccessKind> accessors;

    static AccessorSummary create(Map<String, PropertyAccessKind> accessors) {
        return new AccessorSummary((ImmutableMap<String, PropertyAccessKind>)ImmutableMap.copyOf(accessors));
    }

    private AccessorSummary(ImmutableMap<String, PropertyAccessKind> accessors) {
        this.accessors = accessors;
    }

    public ImmutableMap<String, PropertyAccessKind> getAccessors() {
        return this.accessors;
    }

    public PropertyAccessKind getKind(String name) {
        return (PropertyAccessKind)((Object)this.accessors.getOrDefault((Object)name, (Object)PropertyAccessKind.NORMAL));
    }

    public static enum PropertyAccessKind {
        NORMAL(0),
        GETTER_ONLY(1),
        SETTER_ONLY(2),
        GETTER_AND_SETTER(3);

        final byte flags;

        private PropertyAccessKind(int flags) {
            this.flags = (byte)flags;
        }

        boolean hasGetter() {
            return (this.flags & 1) != 0;
        }

        boolean hasSetter() {
            return (this.flags & 2) != 0;
        }

        boolean hasGetterOrSetter() {
            return (this.flags & 3) != 0;
        }

        PropertyAccessKind unionWith(PropertyAccessKind other) {
            int combinedFlags = this.flags | other.flags;
            switch (combinedFlags) {
                case 0: {
                    return NORMAL;
                }
                case 1: {
                    return GETTER_ONLY;
                }
                case 2: {
                    return SETTER_ONLY;
                }
                case 3: {
                    return GETTER_AND_SETTER;
                }
            }
            throw new IllegalStateException("unexpected value: " + combinedFlags);
        }
    }
}

