/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticTypedRef;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.StaticTypedSlot;
import java.util.Objects;
import org.jspecify.nullness.Nullable;

public final class Property
implements StaticTypedSlot,
StaticTypedRef {
    private static final long serialVersionUID = 1L;
    private final String name;
    private JSType type;
    private final boolean inferred;
    private Node propertyNode;
    private @Nullable JSDocInfo docInfo = null;

    Property(String name, JSType type, boolean inferred, Node propertyNode) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.type = (JSType)Preconditions.checkNotNull((Object)type, (String)"Null type specified for %s", (Object)name);
        this.inferred = inferred;
        this.propertyNode = propertyNode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Node getNode() {
        return this.propertyNode;
    }

    @Override
    public @Nullable StaticSourceFile getSourceFile() {
        return this.propertyNode == null ? null : this.propertyNode.getStaticSourceFile();
    }

    @Override
    public Property getSymbol() {
        return this;
    }

    @Override
    public @Nullable Property getDeclaration() {
        return this.propertyNode == null ? null : this;
    }

    @Override
    public JSType getType() {
        return this.type;
    }

    @Override
    public boolean isTypeInferred() {
        return this.inferred;
    }

    boolean isFromExterns() {
        return this.propertyNode == null ? false : this.propertyNode.isFromExterns();
    }

    void setType(JSType type) {
        this.type = (JSType)Preconditions.checkNotNull((Object)type, (String)"Null type specified for property %s", (Object)this.name);
    }

    @Override
    public JSDocInfo getJSDocInfo() {
        return this.docInfo;
    }

    void setJSDocInfo(JSDocInfo info) {
        this.docInfo = info;
    }

    public void setNode(Node n) {
        this.propertyNode = n;
    }

    public String toString() {
        return "Property {  name: " + this.name + ", type:" + this.type + ", inferred: " + this.inferred + "}";
    }

    @Override
    public StaticTypedScope getScope() {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public static final class OwnedProperty {
        private final ObjectType owner;
        private final Property value;

        public OwnedProperty(ObjectType owner, Property value) {
            this.owner = owner;
            this.value = value;
        }

        public ObjectType getOwner() {
            return this.owner;
        }

        public Property getValue() {
            return this.value;
        }

        public ObjectType getOwnerInstanceType() {
            return this.owner.isFunctionPrototypeType() ? this.owner.getOwnerFunction().getInstanceType() : this.owner;
        }

        public boolean isOwnedByInterface() {
            return this.owner.isFunctionPrototypeType() ? this.owner.getOwnerFunction().isInterface() : this.owner.isInterface();
        }
    }
}

