/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.serialization;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.serialization.StringPoolProto;
import com.google.javascript.jscomp.serialization.Wtf8;
import com.google.protobuf.ByteString;
import java.util.LinkedHashMap;

@Immutable
public final class StringPool {
    private final int maxLength;
    private final ImmutableList<String> pool;
    private static final StringPool EMPTY = StringPool.builder().build();

    public static StringPool fromProto(StringPoolProto proto) {
        Wtf8.Decoder decoder = Wtf8.decoder(proto.getMaxLength());
        ImmutableList.Builder pool = ImmutableList.builder();
        pool.add((Object)"");
        for (ByteString s : proto.getStringsList()) {
            pool.add((Object)decoder.decode(s));
        }
        return new StringPool(proto.getMaxLength(), (ImmutableList<String>)pool.build());
    }

    public static StringPool empty() {
        return EMPTY;
    }

    private StringPool(int maxLength, ImmutableList<String> pool) {
        this.maxLength = maxLength;
        this.pool = pool;
        Preconditions.checkState((boolean)((String)pool.get(0)).isEmpty());
    }

    public String get(int offset) {
        return (String)this.pool.get(offset);
    }

    public StringPoolProto toProto() {
        StringPoolProto.Builder builder = StringPoolProto.newBuilder().setMaxLength(this.maxLength);
        this.pool.stream().skip(1L).map(Wtf8::encodeToWtf8).forEachOrdered(builder::addStrings);
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int maxLength = 0;
        private final LinkedHashMap<String, Integer> pool = new LinkedHashMap();

        private Builder() {
            this.put("");
        }

        public int put(String string) {
            Preconditions.checkNotNull((Object)string);
            if (string.length() > this.maxLength) {
                this.maxLength = string.length();
            }
            return this.pool.computeIfAbsent(string, unused -> this.pool.size());
        }

        @CanIgnoreReturnValue
        public Builder putAnd(String string) {
            this.put(string);
            return this;
        }

        public StringPool build() {
            return new StringPool(this.maxLength, (ImmutableList<String>)ImmutableList.copyOf(this.pool.keySet()));
        }
    }
}

