/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.serialization;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.serialization.JsdocTag;
import com.google.javascript.jscomp.serialization.MalformedTypedAstException;
import com.google.javascript.jscomp.serialization.OptimizationJsdoc;
import com.google.javascript.jscomp.serialization.StringPool;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.Iterator;
import java.util.TreeSet;
import org.jspecify.nullness.Nullable;

public final class JSDocSerializer {
    private static final SourceFile SYNTHETIC_SOURCE = SourceFile.fromCode("JSDocSerializer_placeholder_source", "");
    private static final String PLACEHOLDER_TYPE_NAME = "JSDocSerializer_placeholder_type";
    private static final JSTypeExpression placeholderType = JSDocSerializer.createPlaceholderType();

    private JSDocSerializer() {
    }

    public static JSDocInfo convertJSDocInfoForOptimizations(JSDocInfo jsdoc) {
        StringPool.Builder stringPool = StringPool.builder();
        return JSDocSerializer.deserializeJsdoc(JSDocSerializer.serializeJsdoc(jsdoc, stringPool), stringPool.build());
    }

    static @Nullable OptimizationJsdoc serializeJsdoc(JSDocInfo jsdoc, StringPool.Builder stringPool) {
        if (jsdoc == null) {
            return null;
        }
        OptimizationJsdoc.Builder builder = OptimizationJsdoc.newBuilder();
        if (jsdoc.hasFileOverview()) {
            builder.addKind(JsdocTag.JSDOC_FILEOVERVIEW);
        }
        if (jsdoc.getLicense() != null) {
            builder.setLicenseTextPointer(stringPool.put(jsdoc.getLicense()));
        }
        if (jsdoc.isNoInline()) {
            builder.addKind(JsdocTag.JSDOC_NO_INLINE);
        }
        if (jsdoc.isNoCollapse()) {
            builder.addKind(JsdocTag.JSDOC_NO_COLLAPSE);
        }
        if (jsdoc.isProvideGoog()) {
            builder.addKind(JsdocTag.JSDOC_PROVIDE_GOOG);
        }
        if (jsdoc.isProvideAlreadyProvided()) {
            builder.addKind(JsdocTag.JSDOC_PROVIDE_ALREADY_PROVIDED);
        }
        if (jsdoc.isTypeSummary()) {
            builder.addKind(JsdocTag.JSDOC_TYPE_SUMMARY_FILE);
        }
        if (jsdoc.isPureOrBreakMyCode()) {
            builder.addKind(JsdocTag.JSDOC_PURE_OR_BREAK_MY_CODE);
        }
        if (jsdoc.isCollapsibleOrBreakMyCode()) {
            builder.addKind(JsdocTag.JSDOC_COLLAPSIBLE_OR_BREAK_MY_CODE);
        }
        if (jsdoc.hasThisType()) {
            builder.addKind(JsdocTag.JSDOC_THIS);
        }
        if (jsdoc.hasEnumParameterType()) {
            builder.addKind(JsdocTag.JSDOC_ENUM);
        }
        if (jsdoc.isDefine()) {
            builder.addKind(JsdocTag.JSDOC_DEFINE);
        }
        if (jsdoc.hasConstAnnotation()) {
            builder.addKind(JsdocTag.JSDOC_CONST);
        }
        if (jsdoc.isAnyIdGenerator()) {
            builder.addKind(JSDocSerializer.serializeIdGenerator(jsdoc));
        }
        if (jsdoc.isNoSideEffects()) {
            builder.addKind(JsdocTag.JSDOC_NO_SIDE_EFFECTS);
        }
        if (jsdoc.hasModifies()) {
            Iterator<String> iterator = jsdoc.getModifies().iterator();
            block7: while (iterator.hasNext()) {
                String modifies;
                switch (modifies = iterator.next()) {
                    case "this": {
                        builder.addKind(JsdocTag.JSDOC_MODIFIES_THIS);
                        continue block7;
                    }
                }
                builder.addKind(JsdocTag.JSDOC_MODIFIES_ARGUMENTS);
            }
        }
        if (!jsdoc.getThrowsAnnotations().isEmpty()) {
            builder.addKind(JsdocTag.JSDOC_THROWS);
        }
        if (jsdoc.isConstructor()) {
            builder.addKind(JsdocTag.JSDOC_CONSTRUCTOR);
        }
        if (jsdoc.isInterface()) {
            builder.addKind(JsdocTag.JSDOC_INTERFACE);
        }
        if (jsdoc.getSuppressions().contains("partialAlias")) {
            builder.addKind(JsdocTag.JSDOC_SUPPRESS_PARTIAL_ALIAS);
        }
        if (jsdoc.isAbstract()) {
            builder.addKind(JsdocTag.JSDOC_ABSTRACT);
        }
        if (jsdoc.isHidden()) {
            builder.addKind(JsdocTag.JSDOC_HIDDEN);
        }
        if (jsdoc.getDescription() != null) {
            builder.setDescriptionPointer(stringPool.put(jsdoc.getDescription()));
        }
        if (jsdoc.getAlternateMessageId() != null) {
            builder.setAlternateMessageIdPointer(stringPool.put(jsdoc.getAlternateMessageId()));
        }
        if (jsdoc.getMeaning() != null) {
            builder.setMeaningPointer(stringPool.put(jsdoc.getMeaning()));
        }
        if (jsdoc.getSuppressions().contains("messageConventions")) {
            builder.addKind(JsdocTag.JSDOC_SUPPRESS_MESSAGE_CONVENTION);
        }
        OptimizationJsdoc result = builder.build();
        if (OptimizationJsdoc.getDefaultInstance().equals(result)) {
            return null;
        }
        return (OptimizationJsdoc)Preconditions.checkNotNull((Object)result);
    }

    private static JsdocTag serializeIdGenerator(JSDocInfo doc) {
        if (doc.isConsistentIdGenerator()) {
            return JsdocTag.JSDOC_ID_GENERATOR_CONSISTENT;
        }
        if (doc.isStableIdGenerator()) {
            return JsdocTag.JSDOC_ID_GENERATOR_STABLE;
        }
        if (doc.isXidGenerator()) {
            return JsdocTag.JSDOC_ID_GENERATOR_XID;
        }
        if (doc.isMappedIdGenerator()) {
            return JsdocTag.JSDOC_ID_GENERATOR_MAPPED;
        }
        if (doc.isIdGenerator()) {
            return JsdocTag.JSDOC_ID_GENERATOR_INCONSISTENT;
        }
        throw new IllegalStateException("Failed to identify idGenerator inside JSDoc: " + doc);
    }

    private static JSTypeExpression createPlaceholderType() {
        Node name = IR.string(PLACEHOLDER_TYPE_NAME);
        Node bang = new Node(Token.BANG, name);
        name.setStaticSourceFile(SYNTHETIC_SOURCE);
        bang.setStaticSourceFile(SYNTHETIC_SOURCE);
        return new JSTypeExpression(bang, SYNTHETIC_SOURCE.getName());
    }

    static @Nullable JSDocInfo deserializeJsdoc(OptimizationJsdoc serializedJsdoc, StringPool stringPool) {
        if (serializedJsdoc == null) {
            return null;
        }
        JSDocInfo.Builder builder = JSDocInfo.builder();
        if (serializedJsdoc.getLicenseTextPointer() != 0) {
            builder.addLicense(stringPool.get(serializedJsdoc.getLicenseTextPointer()));
        }
        if (serializedJsdoc.getMeaningPointer() != 0) {
            builder.recordMeaning(stringPool.get(serializedJsdoc.getMeaningPointer()));
        }
        if (serializedJsdoc.getDescriptionPointer() != 0) {
            builder.recordDescription(stringPool.get(serializedJsdoc.getDescriptionPointer()));
        }
        if (serializedJsdoc.getAlternateMessageIdPointer() != 0) {
            builder.recordAlternateMessageId(stringPool.get(serializedJsdoc.getAlternateMessageIdPointer()));
        }
        TreeSet<String> modifies = null;
        TreeSet<String> suppressions = null;
        block30: for (int i = 0; i < serializedJsdoc.getKindCount(); ++i) {
            JsdocTag tag = serializedJsdoc.getKindList().get(i);
            switch (tag) {
                case JSDOC_CONST: {
                    builder.recordConstancy();
                    continue block30;
                }
                case JSDOC_ENUM: {
                    builder.recordEnumParameterType(placeholderType);
                    continue block30;
                }
                case JSDOC_THIS: {
                    builder.recordThisType(placeholderType);
                    continue block30;
                }
                case JSDOC_NO_COLLAPSE: {
                    builder.recordNoCollapse();
                    continue block30;
                }
                case JSDOC_NO_INLINE: {
                    builder.recordNoInline();
                    continue block30;
                }
                case JSDOC_PROVIDE_GOOG: {
                    builder.recordProvideGoog();
                    continue block30;
                }
                case JSDOC_PROVIDE_ALREADY_PROVIDED: {
                    builder.recordProvideAlreadyProvided();
                    continue block30;
                }
                case JSDOC_TYPE_SUMMARY_FILE: {
                    builder.recordTypeSummary();
                    continue block30;
                }
                case JSDOC_PURE_OR_BREAK_MY_CODE: {
                    builder.recordPureOrBreakMyCode();
                    continue block30;
                }
                case JSDOC_COLLAPSIBLE_OR_BREAK_MY_CODE: {
                    builder.recordCollapsibleOrBreakMyCode();
                    continue block30;
                }
                case JSDOC_DEFINE: {
                    builder.recordDefineType(placeholderType);
                    continue block30;
                }
                case JSDOC_NO_SIDE_EFFECTS: {
                    builder.recordNoSideEffects();
                    continue block30;
                }
                case JSDOC_MODIFIES_THIS: {
                    modifies = modifies != null ? modifies : new TreeSet<String>();
                    modifies.add("this");
                    continue block30;
                }
                case JSDOC_MODIFIES_ARGUMENTS: {
                    modifies = modifies != null ? modifies : new TreeSet();
                    modifies.add("arguments");
                    continue block30;
                }
                case JSDOC_THROWS: {
                    builder.recordThrowsAnnotation("{!JSDocSerializer_placeholder_type}");
                    continue block30;
                }
                case JSDOC_CONSTRUCTOR: {
                    builder.recordConstructor();
                    continue block30;
                }
                case JSDOC_INTERFACE: {
                    builder.recordInterface();
                    continue block30;
                }
                case JSDOC_SUPPRESS_PARTIAL_ALIAS: {
                    suppressions = suppressions != null ? suppressions : new TreeSet<String>();
                    suppressions.add("partialAlias");
                    continue block30;
                }
                case JSDOC_ID_GENERATOR_CONSISTENT: {
                    builder.recordConsistentIdGenerator();
                    continue block30;
                }
                case JSDOC_ID_GENERATOR_STABLE: {
                    builder.recordStableIdGenerator();
                    continue block30;
                }
                case JSDOC_ID_GENERATOR_MAPPED: {
                    builder.recordMappedIdGenerator();
                    continue block30;
                }
                case JSDOC_ID_GENERATOR_XID: {
                    builder.recordXidGenerator();
                    continue block30;
                }
                case JSDOC_ID_GENERATOR_INCONSISTENT: {
                    builder.recordIdGenerator();
                    continue block30;
                }
                case JSDOC_ABSTRACT: {
                    builder.recordAbstract();
                    continue block30;
                }
                case JSDOC_HIDDEN: {
                    builder.recordHiddenness();
                    continue block30;
                }
                case JSDOC_SUPPRESS_MESSAGE_CONVENTION: {
                    suppressions = suppressions != null ? suppressions : new TreeSet();
                    suppressions.add("messageConventions");
                    continue block30;
                }
                case JSDOC_FILEOVERVIEW: {
                    builder.recordFileOverview("");
                    continue block30;
                }
                case JSDOC_UNSPECIFIED: 
                case UNRECOGNIZED: {
                    throw new MalformedTypedAstException((Object)("Unsupported JSDoc tag can't be deserialized: " + tag));
                }
            }
        }
        if (modifies != null) {
            builder.recordModifies(modifies);
        }
        if (suppressions != null) {
            builder.recordSuppressions(suppressions);
        }
        return builder.build();
    }
}

