/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.instrumentation.reporter;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.io.CharStreams;
import com.google.debugging.sourcemap.Base64VLQ;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.javascript.jscomp.instrumentation.reporter.proto.FileProfile;
import com.google.javascript.jscomp.instrumentation.reporter.proto.InstrumentationPoint;
import com.google.javascript.jscomp.instrumentation.reporter.proto.InstrumentationPointStats;
import com.google.javascript.jscomp.instrumentation.reporter.proto.ReportProfile;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ReportDecoder {
    private ReportDecoder() {
    }

    public static Map<String, InstrumentationPoint> parseMappingFromFile(String mappingFilePath) throws IOException {
        String fileContent = CharStreams.toString((Readable)Files.newBufferedReader(Paths.get(mappingFilePath, new String[0]), StandardCharsets.UTF_8));
        return ReportDecoder.parseMapping(fileContent);
    }

    public static Map<String, InstrumentationPoint> parseMapping(String mappingFileContent) {
        LinkedHashMap<String, InstrumentationPoint> mapping = new LinkedHashMap<String, InstrumentationPoint>();
        List linesOfFile = Splitter.on((char)'\n').omitEmptyStrings().splitToList((CharSequence)mappingFileContent);
        Preconditions.checkState((linesOfFile.size() >= 3 ? 1 : 0) != 0, (String)"Malformed report %s", (Object)linesOfFile);
        String fileNamesLine = ((String)linesOfFile.get(0)).trim();
        String functionNamesLine = ((String)linesOfFile.get(1)).trim();
        String typesLine = ((String)linesOfFile.get(2)).trim();
        Preconditions.checkState((boolean)fileNamesLine.startsWith("FileNames:"));
        Preconditions.checkState((boolean)functionNamesLine.startsWith("FunctionNames:"));
        Preconditions.checkState((boolean)typesLine.startsWith("Types:"));
        String fileNamesAsJsonArray = fileNamesLine.substring(fileNamesLine.indexOf(":") + 1);
        String functionNamesAsJsonArray = functionNamesLine.substring(functionNamesLine.indexOf(":") + 1);
        String typesAsJsonArray = typesLine.substring(typesLine.indexOf(":") + 1);
        Type stringListType = new TypeToken<List<String>>(){}.getType();
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        List localFileNames = (List)gson.fromJson(fileNamesAsJsonArray, stringListType);
        List functionNames = (List)gson.fromJson(functionNamesAsJsonArray, stringListType);
        List typesAsStringList = (List)gson.fromJson(typesAsJsonArray, stringListType);
        List types = typesAsStringList.stream().map(InstrumentationPoint.Type::valueOf).collect(Collectors.toList());
        for (int i = 3; i < linesOfFile.size(); ++i) {
            String lineItem = (String)linesOfFile.get(i);
            String id = lineItem.substring(0, lineItem.indexOf(58));
            String encodedDetails = lineItem.substring(lineItem.indexOf(58) + 1);
            StringCharIterator encodedDetailsAsCharIt = new StringCharIterator(encodedDetails);
            InstrumentationPoint temp = InstrumentationPoint.newBuilder().setFileName((String)localFileNames.get(Base64VLQ.decode(encodedDetailsAsCharIt))).setFunctionName((String)functionNames.get(Base64VLQ.decode(encodedDetailsAsCharIt))).setType((InstrumentationPoint.Type)((Object)types.get(Base64VLQ.decode(encodedDetailsAsCharIt)))).setLineNumber(Base64VLQ.decode(encodedDetailsAsCharIt)).setColumnNumber(Base64VLQ.decode(encodedDetailsAsCharIt)).build();
            mapping.putIfAbsent(id, temp);
        }
        return mapping;
    }

    public static ReportProfile decodeReport(Map<String, InstrumentationPoint> mapping, Map<String, Long> frequencies) {
        Stream<InstrumentationPointStats> instrumentationPoints = mapping.entrySet().stream().map(entry -> InstrumentationPointStats.newBuilder().setPoint((InstrumentationPoint)entry.getValue()).setTimesExecuted(frequencies.getOrDefault(entry.getKey(), 0L)).build());
        return ReportDecoder.createReportProfile(instrumentationPoints);
    }

    public static ReportProfile createProfileOfStaticallyUsedCode(Map<String, InstrumentationPoint> mapping, String fileContent, String instrumentationArrayName) {
        Matcher matcher = Pattern.compile(instrumentationArrayName + "\\.push\\(['\"](.*?)['\"]\\)").matcher(fileContent);
        HashSet<String> encodedPoints = new HashSet<String>();
        while (matcher.find()) {
            encodedPoints.add(matcher.group(1));
        }
        Stream<InstrumentationPointStats> instrumentationPoints = mapping.entrySet().stream().map(entry -> InstrumentationPointStats.newBuilder().setPoint((InstrumentationPoint)entry.getValue()).setTimesExecuted(0L).setPointPresence(encodedPoints.contains(entry.getKey()) ? InstrumentationPointStats.Presence.PRESENT : InstrumentationPointStats.Presence.STATICALLY_REMOVED).build());
        return ReportDecoder.createReportProfile(instrumentationPoints);
    }

    public static ReportProfile mergeProfiles(List<ReportProfile> profiles) {
        HashMap<InstrumentationPoint, Long> frequencies = new HashMap<InstrumentationPoint, Long>();
        HashMap<InstrumentationPoint, InstrumentationPointStats.Presence> presences = new HashMap<InstrumentationPoint, InstrumentationPointStats.Presence>();
        for (ReportProfile profile : profiles) {
            for (FileProfile fileProfile : profile.getFileProfileList()) {
                for (InstrumentationPointStats pointStats : fileProfile.getInstrumentationPointsStatsList()) {
                    frequencies.compute(pointStats.getPoint(), (p, existing) -> (existing == null ? 0L : existing) + pointStats.getTimesExecuted());
                    presences.compute(pointStats.getPoint(), (p, existing) -> pointStats.getPointPresence() == InstrumentationPointStats.Presence.PRESENT || existing == InstrumentationPointStats.Presence.PRESENCE_UNKNOWN || existing == null ? pointStats.getPointPresence() : existing);
                }
            }
        }
        Stream<InstrumentationPointStats> finalPoints = frequencies.entrySet().stream().map(entry -> InstrumentationPointStats.newBuilder().setPoint((InstrumentationPoint)entry.getKey()).setTimesExecuted((Long)entry.getValue()).setPointPresence((InstrumentationPointStats.Presence)((Object)((Object)presences.get(entry.getKey())))).build());
        return ReportDecoder.createReportProfile(finalPoints);
    }

    private static ReportProfile createReportProfile(Stream<InstrumentationPointStats> instrumentationPoints) {
        List fileProfiles = instrumentationPoints.sorted(Comparator.comparing(pointStats -> pointStats.getPoint().getFileName()).thenComparingInt(pointStats -> pointStats.getPoint().getLineNumber())).collect(Collectors.groupingBy(pointStats -> pointStats.getPoint().getFileName())).entrySet().stream().map(entry -> FileProfile.newBuilder().setFileName((String)entry.getKey()).addAllInstrumentationPointsStats((Iterable)entry.getValue()).build()).sorted(Comparator.comparing(FileProfile::getFileName)).collect(Collectors.toList());
        return ReportProfile.newBuilder().addAllFileProfile(fileProfiles).build();
    }

    private static class StringCharIterator
    implements Base64VLQ.CharIterator {
        final String content;
        final int length;
        int current = 0;

        StringCharIterator(String content) {
            this.content = content;
            this.length = content.length();
        }

        @Override
        public char next() {
            return this.content.charAt(this.current++);
        }

        @Override
        public boolean hasNext() {
            return this.current < this.length;
        }
    }
}

