/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.GraphNode;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class LowestCommonAncestorFinder<N, E> {
    private final DiGraph<N, E> graph;
    private final LinkedHashMap<DiGraph.DiGraphNode<N, E>, Color> searchColoring = new LinkedHashMap();
    private final ArrayDeque<DiGraph.DiGraphNode<N, E>> searchQueue = new ArrayDeque();

    public LowestCommonAncestorFinder(DiGraph<N, E> graph) {
        this.graph = graph;
    }

    public ImmutableSet<N> findAll(Set<N> roots) {
        Preconditions.checkArgument((roots.size() <= 31 ? 1 : 0) != 0, (Object)"Too many roots.");
        Preconditions.checkState((boolean)this.searchColoring.isEmpty());
        Color allColor = Color.create((1 << roots.size()) - 1);
        int bitForRoot = 1;
        for (N root : roots) {
            GraphNode rootNode = this.graph.getNode((Object)root);
            Preconditions.checkNotNull((Object)rootNode, (String)"Root not present in graph: %s", root);
            Color color2 = Color.create(bitForRoot);
            this.searchColoring.merge((DiGraph.DiGraphNode<N, E>)rootNode, color2, Color::mix);
            this.paintAncestors((DiGraph.DiGraphNode<N, E>)rootNode, color2);
            bitForRoot <<= 1;
        }
        this.searchColoring.forEach((node, color) -> {
            if (color.equals(allColor)) {
                this.paintAncestors((DiGraph.DiGraphNode<N, E>)node, Color.NOT_LOWEST);
            }
        });
        ImmutableSet.Builder results = ImmutableSet.builder();
        this.searchColoring.forEach((node, color) -> {
            if (color.equals(allColor)) {
                results.add(node.getValue());
            }
        });
        this.searchColoring.clear();
        this.searchQueue.clear();
        return results.build();
    }

    private void paintAncestors(DiGraph.DiGraphNode<N, E> root, Color color) {
        Preconditions.checkState((boolean)this.searchQueue.isEmpty());
        this.searchQueue.addLast(root);
        while (!this.searchQueue.isEmpty()) {
            DiGraph.DiGraphNode<N, E> curr = this.searchQueue.removeFirst();
            List<DiGraph.DiGraphEdge<N, E>> parentEdges = curr.getInEdges();
            for (DiGraph.DiGraphEdge<N, E> parentEdge : parentEdges) {
                Color oldColor;
                DiGraph.DiGraphNode<N, E> parent = parentEdge.getSource();
                if (parent.equals(root) || (oldColor = this.searchColoring.getOrDefault(parent, Color.BLANK)).contains(color)) continue;
                this.searchQueue.addLast(parent);
                this.searchColoring.put(parent, oldColor.mix(color));
            }
        }
    }

    @Immutable
    private static final class Color {
        private static final Color[] COMMON_COLOR_CACHE = new Color[64];
        static final Color BLANK;
        static final Color NOT_LOWEST;
        final int bitset;

        static Color create(int bitset) {
            if (bitset < 0) {
                Preconditions.checkArgument((bitset == -1 ? 1 : 0) != 0);
                return NOT_LOWEST;
            }
            if (bitset < COMMON_COLOR_CACHE.length) {
                return COMMON_COLOR_CACHE[bitset];
            }
            return new Color(bitset);
        }

        private Color(int bitset) {
            this.bitset = bitset;
        }

        Color mix(Color other) {
            if (this.bitset == other.bitset) {
                return this;
            }
            return Color.create(this.bitset | other.bitset);
        }

        public boolean contains(Color other) {
            return (this.bitset & other.bitset) == other.bitset;
        }

        public boolean equals(Object other) {
            return this.bitset == ((Color)other).bitset;
        }

        public int hashCode() {
            return this.bitset;
        }

        static {
            Arrays.setAll(COMMON_COLOR_CACHE, Color::new);
            BLANK = (Color)Preconditions.checkNotNull((Object)COMMON_COLOR_CACHE[0]);
            NOT_LOWEST = new Color(-1);
        }
    }

    @FunctionalInterface
    public static interface Factory<N, E> {
        public LowestCommonAncestorFinder<N, E> create(DiGraph<N, E> var1);
    }
}

