/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.graph.AdjacencyGraph;
import com.google.javascript.jscomp.graph.Annotatable;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.SubGraph;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;

public abstract class Graph<N, E>
implements AdjacencyGraph<N, E> {
    private Deque<GraphAnnotationState> nodeAnnotationStack;
    private Deque<GraphAnnotationState> edgeAnnotationStack;

    public abstract void connect(N var1, E var2, N var3);

    public abstract void disconnect(N var1, N var2);

    public final void connectIfNotFound(N n1, E edge, N n2) {
        if (!this.isConnected(n1, edge, n2)) {
            this.connect(n1, edge, n2);
        }
    }

    public abstract GraphNode<N, E> createNode(N var1);

    @Override
    public abstract Collection<? extends GraphNode<N, E>> getNodes();

    @Override
    public abstract int getNodeCount();

    public abstract List<? extends GraphEdge<N, E>> getEdges();

    public abstract List<? extends GraphEdge<N, E>> getEdges(N var1, N var2);

    public abstract int getNodeDegree(N var1);

    @Override
    public int getWeight(N value) {
        return this.getNodeDegree(value);
    }

    public abstract List<GraphNode<N, E>> getNeighborNodes(N var1);

    public abstract GraphEdge<N, E> getFirstEdge(N var1, N var2);

    public final boolean hasNode(N n) {
        return this.getNode(n) != null;
    }

    public abstract boolean isConnected(N var1, N var2);

    public abstract boolean isConnected(N var1, E var2, N var3);

    <T extends GraphNode<N, E>> T getNodeOrFail(N val) {
        GraphNode node = this.getNode(val);
        if (node == null) {
            throw new IllegalArgumentException(val + " does not exist in graph");
        }
        return (T)node;
    }

    @Override
    public final void clearNodeAnnotations() {
        for (GraphNode<N, E> n : this.getNodes()) {
            n.setAnnotation(null);
        }
    }

    public final void clearEdgeAnnotations() {
        for (GraphEdge<N, E> e : this.getEdges()) {
            e.setAnnotation(null);
        }
    }

    public final void pushNodeAnnotations() {
        if (this.nodeAnnotationStack == null) {
            this.nodeAnnotationStack = new ArrayDeque<GraphAnnotationState>();
        }
        Graph.pushAnnotations(this.nodeAnnotationStack, this.getNodes());
    }

    public final void popNodeAnnotations() {
        Preconditions.checkNotNull(this.nodeAnnotationStack, (Object)"Popping node annotations without pushing.");
        Graph.popAnnotations(this.nodeAnnotationStack);
    }

    public final void pushEdgeAnnotations() {
        if (this.edgeAnnotationStack == null) {
            this.edgeAnnotationStack = new ArrayDeque<GraphAnnotationState>();
        }
        Graph.pushAnnotations(this.edgeAnnotationStack, this.getEdges());
    }

    public final void popEdgeAnnotations() {
        Preconditions.checkNotNull(this.edgeAnnotationStack, (Object)"Popping edge annotations without pushing.");
        Graph.popAnnotations(this.edgeAnnotationStack);
    }

    private static void pushAnnotations(Deque<GraphAnnotationState> stack, Collection<? extends Annotatable> haveAnnotations) {
        stack.push(new GraphAnnotationState(haveAnnotations.size()));
        for (Annotatable annotatable : haveAnnotations) {
            stack.peek().add(new AnnotationState(annotatable, (Annotation)annotatable.getAnnotation()));
            annotatable.setAnnotation(null);
        }
    }

    private static void popAnnotations(Deque<GraphAnnotationState> stack) {
        for (AnnotationState as : stack.pop()) {
            as.first.setAnnotation(as.second);
        }
    }

    static class SimpleSubGraph<N, E>
    implements SubGraph<N, E> {
        private final Graph<N, E> graph;
        private final List<GraphNode<N, E>> nodes = new ArrayList<GraphNode<N, E>>();

        SimpleSubGraph(Graph<N, E> graph) {
            this.graph = graph;
        }

        @Override
        public boolean isIndependentOf(N value) {
            GraphNode node = this.graph.getNode(value);
            for (GraphNode<N, E> n : this.nodes) {
                if (!this.graph.getNeighborNodes(n.getValue()).contains(node)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void addNode(N value) {
            this.nodes.add(this.graph.getNodeOrFail(value));
        }
    }

    public static interface GraphEdge<N, E>
    extends Annotatable {
        public E getValue();

        public GraphNode<N, E> getNodeA();

        public GraphNode<N, E> getNodeB();
    }

    private static class GraphAnnotationState
    extends ArrayList<AnnotationState> {
        private static final long serialVersionUID = 1L;

        public GraphAnnotationState(int size) {
            super(size);
        }
    }

    private static final class AnnotationState {
        private final Annotatable first;
        private final Annotation second;

        public AnnotationState(Annotatable annotatable, Annotation annotation) {
            this.first = annotatable;
            this.second = annotation;
        }
    }
}

