/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.DoNotCall;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.disambiguate.PropertyClustering;
import java.util.BitSet;
import java.util.LinkedHashMap;
import org.jspecify.nullness.Nullable;

final class ColorGraphNode {
    private final Color color;
    private final LinkedHashMap<PropertyClustering, PropAssociation> associatedProps = new LinkedHashMap();
    private final int index;
    private final BitSet subtypeIndices = new BitSet();

    static ColorGraphNode create(Color single, int index) {
        Preconditions.checkNotNull((Object)single);
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0);
        return new ColorGraphNode(single, index);
    }

    @VisibleForTesting
    static ColorGraphNode createForTesting(int index) {
        Preconditions.checkArgument((index < 0 ? 1 : 0) != 0);
        return new ColorGraphNode(null, index);
    }

    private ColorGraphNode(@Nullable Color single, int index) {
        this.index = index;
        this.color = single;
    }

    Color getColor() {
        return (Color)Preconditions.checkNotNull((Object)this.color);
    }

    int getIndex() {
        return this.index;
    }

    LinkedHashMap<PropertyClustering, PropAssociation> getAssociatedProps() {
        return this.associatedProps;
    }

    BitSet getSubtypeIndices() {
        return this.subtypeIndices;
    }

    @DoNotCall
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("index", this.index).add("color", (Object)this.color).toString();
    }

    static enum PropAssociation {
        AST,
        TYPE_SYSTEM,
        SUPERTYPE;

    }
}

