/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefaultNameGenerator;
import com.google.javascript.jscomp.GatherGetterAndSetterProperties;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.ColorRegistry;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.disambiguate.ColorGraphBuilder;
import com.google.javascript.jscomp.disambiguate.ColorGraphNode;
import com.google.javascript.jscomp.disambiguate.ColorGraphNodeFactory;
import com.google.javascript.jscomp.graph.AdjacencyGraph;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.GraphColoring;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.jscomp.graph.LowestCommonAncestorFinder;
import com.google.javascript.jscomp.graph.SubGraph;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jspecify.nullness.Nullable;

public class AmbiguateProperties
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(AmbiguateProperties.class.getName());
    private final AbstractCompiler compiler;
    private final List<Node> stringNodesToRename = new ArrayList<Node>();
    private final char[] reservedFirstCharacters;
    private final char[] reservedNonFirstCharacters;
    private final Map<String, Property> propertyMap = new LinkedHashMap<String, Property>();
    private final ImmutableSet<String> externedNames;
    private final Set<String> quotedNames = new HashSet<String>();
    private final ColorRegistry colorRegistry;
    private @Nullable Map<String, String> renamingMap = null;
    private @Nullable ColorGraphNodeFactory graphNodeFactory = null;
    private static final Comparator<Property> FREQUENCY_COMPARATOR = (p1, p2) -> {
        if (p1.numOccurrences != p2.numOccurrences) {
            return p2.numOccurrences - p1.numOccurrences;
        }
        return p1.oldName.compareTo(p2.oldName);
    };

    public AmbiguateProperties(AbstractCompiler compiler, char[] reservedFirstCharacters, char[] reservedNonFirstCharacters, Set<String> externProperties) {
        Preconditions.checkState((boolean)compiler.getLifeCycleStage().isNormalized());
        this.compiler = compiler;
        this.reservedFirstCharacters = reservedFirstCharacters;
        this.reservedNonFirstCharacters = reservedNonFirstCharacters;
        this.externedNames = ImmutableSet.builder().add((Object)"prototype").addAll(externProperties).build();
        this.colorRegistry = compiler.getColorRegistry();
    }

    static AmbiguateProperties makePassForTesting(AbstractCompiler compiler, char[] reservedFirstCharacters, char[] reservedNonFirstCharacters, Set<String> externProperties) {
        AmbiguateProperties ap = new AmbiguateProperties(compiler, reservedFirstCharacters, reservedNonFirstCharacters, externProperties);
        ap.renamingMap = new HashMap<String, String>();
        return ap;
    }

    Map<String, String> getRenamingMap() {
        Preconditions.checkNotNull(this.renamingMap);
        return this.renamingMap;
    }

    @Override
    public void process(Node externs, Node root) {
        this.graphNodeFactory = ColorGraphNodeFactory.createFactory(this.colorRegistry);
        NodeTraversal.traverse(this.compiler, root, new ProcessPropertiesAndConstructors());
        ColorGraphBuilder graphBuilder = new ColorGraphBuilder(this.graphNodeFactory, LowestCommonAncestorFinder::new, this.colorRegistry);
        graphBuilder.addAll((Collection<ColorGraphNode>)this.graphNodeFactory.getAllKnownTypes());
        LinkedDirectedGraph<ColorGraphNode, Object> colorGraph = graphBuilder.build();
        for (ColorGraphNode node : this.graphNodeFactory.getAllKnownTypes()) {
            node.getSubtypeIndices().set(node.getIndex());
        }
        FixedPointGraphTraversal.newReverseTraversal((subtype, e, supertype) -> {
            if (subtype.getSubtypeIndices().size() > supertype.getSubtypeIndices().size()) {
                supertype.getSubtypeIndices().or(subtype.getSubtypeIndices());
                return true;
            }
            int startSize = supertype.getSubtypeIndices().cardinality();
            supertype.getSubtypeIndices().or(subtype.getSubtypeIndices());
            return supertype.getSubtypeIndices().cardinality() > startSize;
        }).computeFixedPoint(colorGraph);
        for (Property prop : this.propertyMap.values()) {
            if (prop.relatedColorsSeeds == null) continue;
            for (ColorGraphNode color : prop.relatedColorsSeeds.keySet()) {
                prop.relatedColors.or(color.getSubtypeIndices());
            }
            prop.relatedColorsSeeds = null;
        }
        ImmutableSet.Builder reservedNames = ImmutableSet.builder().addAll(this.externedNames).addAll(this.quotedNames);
        int numRenamedPropertyNames = 0;
        int numSkippedPropertyNames = 0;
        ArrayList<PropertyGraphNode> nodes = new ArrayList<PropertyGraphNode>(this.propertyMap.size());
        for (Property prop : this.propertyMap.values()) {
            if (prop.skipAmbiguating) {
                ++numSkippedPropertyNames;
                reservedNames.add((Object)prop.oldName);
                continue;
            }
            ++numRenamedPropertyNames;
            nodes.add(new PropertyGraphNode(prop));
        }
        PropertyGraph propertyGraph = new PropertyGraph(nodes);
        GraphColoring.GreedyGraphColoring<Property, Void> coloring = new GraphColoring.GreedyGraphColoring<Property, Void>(propertyGraph, FREQUENCY_COMPARATOR);
        int numNewPropertyNames = ((GraphColoring)coloring).color();
        DefaultNameGenerator nameGen = new DefaultNameGenerator((Set<String>)reservedNames.build(), "", this.reservedFirstCharacters, this.reservedNonFirstCharacters);
        String[] colorMap = new String[numNewPropertyNames];
        for (int i = 0; i < numNewPropertyNames; ++i) {
            colorMap[i] = nameGen.generateNextName();
        }
        for (PropertyGraphNode node : propertyGraph.getNodes()) {
            node.getValue().newName = colorMap[node.getAnnotation().hashCode()];
            if (this.renamingMap == null) continue;
            this.renamingMap.put(node.getValue().oldName, node.getValue().newName);
        }
        for (Node n : this.stringNodesToRename) {
            String oldName = n.getString();
            Property p = this.propertyMap.get(oldName);
            if (p == null || p.newName == null) continue;
            Preconditions.checkState((boolean)oldName.equals(p.oldName));
            if (p.newName.equals(oldName)) continue;
            n.setString(p.newName);
            this.compiler.reportChangeToEnclosingScope(n);
        }
        GatherGetterAndSetterProperties.update(this.compiler, externs, root);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Collapsed " + numRenamedPropertyNames + " properties into " + numNewPropertyNames + " and skipped renaming " + numSkippedPropertyNames + " properties.");
        }
    }

    private Property getProperty(String name) {
        return this.propertyMap.computeIfAbsent(name, x$0 -> new Property((String)x$0));
    }

    private Color getColor(Node n) {
        Color type = n.getColor();
        if (type == null) {
            return StandardColors.UNKNOWN;
        }
        return type;
    }

    private class Property {
        final String oldName;
        String newName;
        int numOccurrences;
        boolean skipAmbiguating;
        @Nullable IdentityHashMap<ColorGraphNode, Integer> relatedColorsSeeds = null;
        final BitSet relatedColors = new BitSet();

        Property(String name) {
            this.oldName = name;
        }

        void addRelatedColor(Color color) {
            if (this.skipAmbiguating) {
                return;
            }
            ++this.numOccurrences;
            if (color.isInvalidating() || color.getPropertiesKeepOriginalName()) {
                this.skipAmbiguating = true;
                return;
            }
            if (this.relatedColorsSeeds == null) {
                this.relatedColorsSeeds = new IdentityHashMap();
            }
            ColorGraphNode newColorGraphNode = AmbiguateProperties.this.graphNodeFactory.createNode(color);
            this.relatedColorsSeeds.put(newColorGraphNode, 0);
        }
    }

    private class ProcessPropertiesAndConstructors
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessPropertiesAndConstructors() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case GETPROP: 
                case OPTCHAIN_GETPROP: {
                    this.processGetProp(n);
                    return;
                }
                case CALL: {
                    this.processCall(n);
                    return;
                }
                case NAME: {
                    if (NodeUtil.isNameDeclaration(parent) || parent.isFunction()) {
                        AmbiguateProperties.this.graphNodeFactory.createNode(AmbiguateProperties.this.getColor(n));
                    }
                    return;
                }
                case OBJECTLIT: 
                case OBJECT_PATTERN: {
                    this.processObjectLitOrPattern(n);
                    return;
                }
                case GETELEM: {
                    this.processGetElem(n);
                    return;
                }
                case CLASS: {
                    this.processClass(n);
                    return;
                }
            }
        }

        private void processGetProp(Node getProp) {
            Color type = AmbiguateProperties.this.getColor(getProp.getFirstChild());
            this.maybeMarkCandidate(getProp, type);
            if (NodeUtil.isLhsOfAssign(getProp) || NodeUtil.isStatement(getProp.getParent())) {
                AmbiguateProperties.this.graphNodeFactory.createNode(type);
            }
        }

        private void processCall(Node call) {
            Node target = call.getFirstChild();
            if (!target.isQualifiedName()) {
                return;
            }
            if (AmbiguateProperties.this.compiler.getCodingConvention().isPropertyRenameFunction(target)) {
                Node propName = call.getSecondChild();
                if (propName == null || !propName.isStringLit()) {
                    return;
                }
                Property p = AmbiguateProperties.this.getProperty(propName.getString());
                p.skipAmbiguating = true;
            } else if (NodeUtil.isObjectDefinePropertiesDefinition(call)) {
                Node typeObj = call.getSecondChild();
                Color type = AmbiguateProperties.this.getColor(typeObj);
                Node objectLiteral = typeObj.getNext();
                if (!objectLiteral.isObjectLit()) {
                    return;
                }
                for (Node key = objectLiteral.getFirstChild(); key != null; key = key.getNext()) {
                    this.processObjectProperty(objectLiteral, key, type);
                }
            }
        }

        private void processObjectProperty(Node objectLit, Node key, Color type) {
            Preconditions.checkArgument((objectLit.isObjectLit() || objectLit.isObjectPattern() ? 1 : 0) != 0, (Object)objectLit);
            switch (key.getToken()) {
                case COMPUTED_PROP: {
                    if (!key.getFirstChild().isStringLit()) break;
                    AmbiguateProperties.this.quotedNames.add(key.getFirstChild().getString());
                    break;
                }
                case MEMBER_FUNCTION_DEF: 
                case GETTER_DEF: 
                case SETTER_DEF: 
                case STRING_KEY: {
                    if (key.isQuotedString()) {
                        AmbiguateProperties.this.quotedNames.add(key.getString());
                        break;
                    }
                    this.maybeMarkCandidate(key, type);
                    break;
                }
                case OBJECT_REST: 
                case OBJECT_SPREAD: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected child of " + objectLit.getToken() + ": " + key.toStringTree());
                }
            }
        }

        private void processObjectLitOrPattern(Node objectLit) {
            if (objectLit.getParent().isCall() && NodeUtil.isObjectDefinePropertiesDefinition(objectLit.getParent())) {
                return;
            }
            Color type = AmbiguateProperties.this.getColor(objectLit);
            for (Node key = objectLit.getFirstChild(); key != null; key = key.getNext()) {
                this.processObjectProperty(objectLit, key, type);
            }
        }

        private void processGetElem(Node n) {
            Node child = n.getLastChild();
            if (child.isStringLit()) {
                AmbiguateProperties.this.quotedNames.add(child.getString());
            }
        }

        private void processClass(Node classNode) {
            Color classConstructorType = AmbiguateProperties.this.getColor(classNode);
            AmbiguateProperties.this.graphNodeFactory.createNode(classConstructorType);
            ImmutableSet<Color> possiblePrototypes = classConstructorType.getPrototypes();
            Color classPrototype = possiblePrototypes.isEmpty() ? StandardColors.UNKNOWN : Color.createUnion(possiblePrototypes);
            for (Node member = NodeUtil.getClassMembers(classNode).getFirstChild(); member != null; member = member.getNext()) {
                Color memberOwnerColor;
                if (member.isQuotedString()) {
                    AmbiguateProperties.this.quotedNames.add(member.getString());
                    continue;
                }
                if (member.isComputedProp() || member.isComputedFieldDef()) {
                    if (!member.getFirstChild().isStringLit()) continue;
                    AmbiguateProperties.this.quotedNames.add(member.getFirstChild().getString());
                    continue;
                }
                if (NodeUtil.isEs6ConstructorMemberFunctionDef(member)) continue;
                if (member.isStaticMember()) {
                    memberOwnerColor = classConstructorType;
                } else if (member.isMemberFieldDef()) {
                    ImmutableSet<Color> possibleInstances = classConstructorType.getInstanceColors();
                    memberOwnerColor = possibleInstances.isEmpty() ? StandardColors.UNKNOWN : Color.createUnion(possibleInstances);
                } else {
                    Preconditions.checkState((member.isMemberFunctionDef() || member.isGetterDef() || member.isSetterDef() ? 1 : 0) != 0);
                    memberOwnerColor = classPrototype;
                }
                this.maybeMarkCandidate(member, memberOwnerColor);
            }
        }

        private void maybeMarkCandidate(Node n, Color type) {
            String name = n.getString();
            if (!AmbiguateProperties.this.externedNames.contains((Object)name)) {
                AmbiguateProperties.this.stringNodesToRename.add(n);
                this.recordProperty(name, type);
            }
        }

        private Property recordProperty(String name, Color color) {
            Property prop = AmbiguateProperties.this.getProperty(name);
            prop.addRelatedColor(color);
            return prop;
        }
    }

    static class PropertyGraphNode
    implements GraphNode<Property, Void> {
        Property property;
        protected Annotation annotation;

        PropertyGraphNode(Property property) {
            this.property = property;
        }

        @Override
        public Property getValue() {
            return this.property;
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            return (A)this.annotation;
        }

        @Override
        public void setAnnotation(@Nullable Annotation data) {
            this.annotation = data;
        }
    }

    static class PropertySubGraph
    implements SubGraph<Property, Void> {
        final BitSet relatedTypes = new BitSet();

        PropertySubGraph() {
        }

        @Override
        public boolean isIndependentOf(Property prop) {
            return !this.relatedTypes.intersects(prop.relatedColors);
        }

        @Override
        public void addNode(Property prop) {
            this.relatedTypes.or(prop.relatedColors);
        }
    }

    static class PropertyGraph
    implements AdjacencyGraph<Property, Void> {
        private final ArrayList<PropertyGraphNode> nodes;

        PropertyGraph(ArrayList<PropertyGraphNode> nodes) {
            this.nodes = nodes;
        }

        public List<PropertyGraphNode> getNodes() {
            return this.nodes;
        }

        @Override
        public int getNodeCount() {
            return this.nodes.size();
        }

        @Override
        public GraphNode<Property, Void> getNode(Property property) {
            throw new RuntimeException("PropertyGraph#getNode is never called.");
        }

        @Override
        public SubGraph<Property, Void> newSubGraph() {
            return new PropertySubGraph();
        }

        @Override
        public void clearNodeAnnotations() {
            for (PropertyGraphNode node : this.nodes) {
                node.setAnnotation(null);
            }
        }

        @Override
        public int getWeight(Property value) {
            return value.numOccurrences;
        }
    }
}

