/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.deps.ModuleResolver;
import com.google.javascript.jscomp.deps.NodeModuleResolver;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.nullness.Nullable;

public class WebpackModuleResolver
extends NodeModuleResolver {
    private final ImmutableMap<String, String> modulesById;

    public WebpackModuleResolver(ImmutableSet<String> modulePaths, ImmutableList<String> moduleRootPaths, Map<String, String> modulesById, ErrorHandler errorHandler, ModuleLoader.PathEscaper pathEscaper) {
        super(modulePaths, moduleRootPaths, null, errorHandler, pathEscaper);
        this.modulesById = ImmutableMap.copyOf(modulesById);
    }

    @Override
    public @Nullable String resolveJsModule(String scriptAddress, String moduleAddress, String sourcename, int lineno, int colno) {
        String loadAddress = (String)this.modulesById.get((Object)moduleAddress);
        if (loadAddress == null) {
            return super.resolveJsModule(scriptAddress, moduleAddress, sourcename, lineno, colno);
        }
        return loadAddress;
    }

    public static final class Factory
    implements ModuleLoader.ModuleResolverFactory {
        private final Map<String, String> lookupMap;

        public Factory(Map<String, String> lookupMap) {
            this.lookupMap = lookupMap;
        }

        @Override
        public ModuleResolver create(ImmutableSet<String> modulePaths, ImmutableList<String> moduleRootPaths, ErrorHandler errorHandler, ModuleLoader.PathEscaper pathEscaper) {
            HashMap<String, String> normalizedPathsById = new HashMap<String, String>();
            for (Map.Entry<String, String> moduleEntry : this.lookupMap.entrySet()) {
                Object canonicalizedPath = ModuleLoader.normalize(pathEscaper.escape(moduleEntry.getValue()), moduleRootPaths);
                if (ModuleLoader.isAmbiguousIdentifier((String)canonicalizedPath)) {
                    canonicalizedPath = "/" + (String)canonicalizedPath;
                }
                normalizedPathsById.put(moduleEntry.getKey(), (String)canonicalizedPath);
            }
            return new WebpackModuleResolver(modulePaths, moduleRootPaths, normalizedPathsById, errorHandler, pathEscaper);
        }
    }
}

