/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.deps.ModuleResolver;
import org.jspecify.nullness.Nullable;

public class BrowserModuleResolver
extends ModuleResolver {
    public static final ModuleLoader.ModuleResolverFactory FACTORY = BrowserModuleResolver::new;

    public BrowserModuleResolver(ImmutableSet<String> modulePaths, ImmutableList<String> moduleRootPaths, ErrorHandler errorHandler, ModuleLoader.PathEscaper pathEscaper) {
        super(modulePaths, moduleRootPaths, errorHandler, pathEscaper);
    }

    @Override
    public @Nullable String resolveJsModule(String scriptAddress, String moduleAddress, String sourcename, int lineno, int colno) {
        if (ModuleLoader.isAmbiguousIdentifier(moduleAddress)) {
            this.errorHandler.report(CheckLevel.WARNING, JSError.make(sourcename, lineno, colno, ModuleLoader.INVALID_MODULE_PATH, moduleAddress, ModuleLoader.ResolutionMode.BROWSER.toString()));
            return null;
        }
        String loadAddress = this.locate(scriptAddress, moduleAddress);
        if (loadAddress == null) {
            this.errorHandler.report(CheckLevel.WARNING, JSError.make(sourcename, lineno, colno, ModuleLoader.LOAD_WARNING, moduleAddress));
        }
        return loadAddress;
    }
}

