/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.bundle;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.javascript.jscomp.bundle.Source;

@GwtIncompatible
public class CachedTransformer
implements Source.Transformer {
    private static final String DEFAULT_CACHE_SPEC = "maximumSize=10000";
    private final LoadingCache<Source, Source> cache;

    public CachedTransformer(Source.Transformer delegate, CacheBuilder<? super Source, ? super Source> builder) {
        this.cache = builder.build(CacheLoader.from(delegate::transform));
    }

    public CachedTransformer(Source.Transformer delegate, String spec) {
        this(delegate, (CacheBuilder<? super Source, ? super Source>)CacheBuilder.from((String)spec));
    }

    public CachedTransformer(Source.Transformer delegate) {
        this(delegate, DEFAULT_CACHE_SPEC);
    }

    @Override
    public Source transform(Source input) {
        return (Source)this.cache.getUnchecked((Object)input);
    }
}

