/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.base;

import com.google.common.base.Preconditions;

public final class JSCompDoubles {
    private static final double POW_2_32 = Math.pow(2.0, 32.0);
    private static final double POW_2_53 = Math.pow(2.0, 53.0);

    public static boolean isExactInt32(double x) {
        return !Double.isNaN(x) && (double)((int)x) == x;
    }

    public static boolean isExactInt64(double x) {
        return !Double.isNaN(x) && (double)((long)x) == x;
    }

    public static boolean isMathematicalInteger(double x) {
        return x % 1.0 == 0.0;
    }

    public static boolean isAtLeastIntegerPrecision(double x) {
        return Math.abs(x) < POW_2_53;
    }

    public static boolean isNegative(double x) {
        Preconditions.checkState((!Double.isNaN(x) ? 1 : 0) != 0);
        return Double.compare(0.0, x) > 0;
    }

    public static boolean isPositive(double x) {
        return !JSCompDoubles.isNegative(x);
    }

    public static boolean isEitherZero(double x) {
        return x == 0.0;
    }

    public static int ecmascriptToInt32(double number) {
        if (JSCompDoubles.isExactInt32(number)) {
            return (int)number;
        }
        if (Double.isNaN(number) || Double.isInfinite(number)) {
            return 0;
        }
        double posInt = number >= 0.0 ? Math.floor(number) : Math.ceil(number);
        long int32bit = (long)(posInt % POW_2_32);
        return (int)int32bit;
    }

    public static int ecmascriptToUint32(double number) {
        return JSCompDoubles.ecmascriptToInt32(number);
    }

    private JSCompDoubles() {
        throw new AssertionError();
    }
}

