/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.GraphReachability;
import com.google.javascript.rhino.Node;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class UnreachableCodeElimination
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(UnreachableCodeElimination.class.getName());
    private final AbstractCompiler compiler;
    private boolean codeChanged;

    UnreachableCodeElimination(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node toplevel) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        NodeTraversal.traverse(this.compiler, this.compiler.getJsRoot(), new EliminationInChangedFunctionsPass());
    }

    private class EliminationPass
    implements NodeTraversal.Callback {
        private final ControlFlowGraph<Node> cfg;

        private EliminationPass(ControlFlowGraph<Node> cfg) {
            this.cfg = cfg;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            if (parent == null) {
                return true;
            }
            if (n.isExport()) {
                return false;
            }
            if (parent.isFunction()) {
                return n.isFirstChildOf(parent);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (parent == null || n.isFunction() || n.isScript()) {
                return;
            }
            DiGraph.DiGraphNode gNode = this.cfg.getNode((Object)n);
            if (gNode == null) {
                return;
            }
            if (gNode.getAnnotation() != GraphReachability.REACHABLE || !UnreachableCodeElimination.this.compiler.getAstAnalyzer().mayHaveSideEffects(n)) {
                this.removeDeadExprStatementSafely(n);
                return;
            }
            this.tryRemoveUnconditionalBranching(n);
        }

        private void tryRemoveUnconditionalBranching(Node n) {
            if (n == null) {
                return;
            }
            DiGraph.DiGraphNode gNode = this.cfg.getNode((Object)n);
            if (gNode == null) {
                return;
            }
            switch (n.getToken()) {
                case RETURN: {
                    if (n.hasChildren()) break;
                }
                case BREAK: 
                case CONTINUE: {
                    List outEdges = gNode.getOutEdges();
                    if (outEdges.size() != 1 || n.getNext() != null && !n.getNext().isFunction()) break;
                    Preconditions.checkState((outEdges.get(0).getValue() == ControlFlowGraph.Branch.UNCOND ? 1 : 0) != 0);
                    Node fallThrough = this.computeFollowing(n);
                    Node nextCfgNode = (Node)outEdges.get(0).getDestination().getValue();
                    if (nextCfgNode != fallThrough || this.inFinally(n.getParent(), n)) break;
                    this.removeNode(n);
                    break;
                }
            }
        }

        private boolean inFinally(Node parent, Node child) {
            if (parent == null || parent.isFunction()) {
                return false;
            }
            if (NodeUtil.isTryFinallyNode(parent, child)) {
                return true;
            }
            return this.inFinally(parent.getParent(), parent);
        }

        private Node computeFollowing(Node n) {
            Node next = ControlFlowAnalysis.computeFollowNode(n);
            while (next != null && next.isBlock()) {
                if (next.hasChildren()) {
                    next = next.getFirstChild();
                    continue;
                }
                next = this.computeFollowing(next);
            }
            return next;
        }

        private void removeDeadExprStatementSafely(Node n) {
            Node parent = n.getParent();
            if (n.isEmpty() || n.isBlock() && !n.hasChildren()) {
                return;
            }
            if (NodeUtil.isEnhancedFor(parent)) {
                return;
            }
            switch (n.getToken()) {
                case DO: 
                case EXPORT: {
                    return;
                }
                case BLOCK: {
                    if (!parent.isTry() || !NodeUtil.isTryCatchNodeContainer(n)) break;
                    return;
                }
                case CATCH: {
                    Node tryNode = parent.getParent();
                    NodeUtil.maybeAddFinally(tryNode);
                    break;
                }
            }
            if (n.isVar() && !n.getFirstChild().hasChildren()) {
                return;
            }
            this.removeNode(n);
        }

        private void removeNode(Node n) {
            UnreachableCodeElimination.this.codeChanged = true;
            NodeUtil.redeclareVarsInsideBranch(n);
            UnreachableCodeElimination.this.compiler.reportChangeToEnclosingScope(n);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Removing " + n);
            }
            NodeUtil.removeChild(n.getParent(), n);
            NodeUtil.markFunctionsDeleted(n, UnreachableCodeElimination.this.compiler);
        }
    }

    private final class EliminationInChangedFunctionsPass
    extends NodeTraversal.AbstractChangedScopeCallback {
        private EliminationInChangedFunctionsPass() {
        }

        @Override
        public void enterChangedScopeRoot(AbstractCompiler compiler, Node root) {
            ControlFlowGraph<Node> cfg = ControlFlowAnalysis.builder().setCompiler(compiler).setCfgRoot(root).computeCfg();
            new GraphReachability(cfg).compute((Node)cfg.getEntry().getValue());
            if (root.isFunction()) {
                root = root.getLastChild();
            }
            do {
                UnreachableCodeElimination.this.codeChanged = false;
                NodeTraversal.traverse(compiler, root, new EliminationPass(cfg));
            } while (UnreachableCodeElimination.this.codeChanged);
        }
    }
}

