/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractVar;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.StaticTypedRef;
import com.google.javascript.rhino.jstype.StaticTypedSlot;

public class TypedVar
extends AbstractVar<TypedScope, TypedVar>
implements StaticTypedSlot,
StaticTypedRef {
    private JSType type;
    private boolean markedEscaped = false;
    private boolean markedAssignedExactlyOnce = false;
    private final boolean typeInferred;
    private static final ImmutableSet<Token> NAME_NODE_TYPES = Sets.immutableEnumSet((Enum)Token.NAME, (Enum[])new Token[]{Token.THIS, Token.IMPORT_STAR, Token.EXPR_RESULT, Token.EXPORT, Token.GETPROP, Token.FUNCTION, Token.STRING_KEY, Token.SETTER_DEF, Token.GETTER_DEF, Token.MEMBER_FUNCTION_DEF, Token.MODULE_BODY});

    TypedVar(boolean inferred, String name, Node nameNode, JSType type, TypedScope scope, int index, CompilerInput input) {
        super(name, nameNode, scope, index, input, null);
        if (nameNode != null) {
            Preconditions.checkArgument((boolean)NAME_NODE_TYPES.contains((Object)nameNode.getToken()), (String)"Invalid name node token %s", (Object)((Object)nameNode.getToken()));
        }
        this.type = type;
        this.typeInferred = inferred;
    }

    @Override
    public JSType getType() {
        return this.type;
    }

    void setType(JSType type) {
        this.type = type;
    }

    void resolveType(ErrorReporter errorReporter) {
        if (this.type != null) {
            this.type = this.type.resolve(errorReporter);
        }
    }

    @Override
    public boolean isTypeInferred() {
        return this.typeInferred;
    }

    public String getInputName() {
        if (this.getInput() == null) {
            return "<non-file>";
        }
        return this.getInput().getName();
    }

    public String toString() {
        return "Var " + this.getName() + "{" + this.type + "}";
    }

    void markEscaped() {
        this.markedEscaped = true;
    }

    boolean isMarkedEscaped() {
        return this.markedEscaped;
    }

    void markAssignedExactlyOnce() {
        this.markedAssignedExactlyOnce = true;
    }

    boolean isMarkedAssignedExactlyOnce() {
        return this.markedAssignedExactlyOnce;
    }
}

