/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

class SubstituteEs6Syntax
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private boolean objectLiteralShorthandWasAdded = false;

    public SubstituteEs6Syntax(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case FUNCTION: {
                if (!n.isArrowFunction()) break;
                this.maybeSimplifyArrowFunctionBody(n, n.getLastChild());
                break;
            }
            case STRING_KEY: {
                if (!n.getFirstChild().isName() || !n.getFirstChild().getString().equals(n.getString())) break;
                n.setShorthandProperty(true);
                this.objectLiteralShorthandWasAdded = true;
                break;
            }
            case SCRIPT: {
                if (!this.objectLiteralShorthandWasAdded) break;
                NodeUtil.addFeatureToScript(n, FeatureSet.Feature.EXTENDED_OBJECT_LITERALS, this.compiler);
                this.objectLiteralShorthandWasAdded = false;
                break;
            }
        }
    }

    private void maybeSimplifyArrowFunctionBody(Node arrowFunction, Node body) {
        Preconditions.checkArgument((boolean)arrowFunction.isArrowFunction());
        if (!(body.isBlock() && body.hasOneChild() && body.getFirstChild().isReturn())) {
            return;
        }
        Node returnValue = body.getFirstChild().removeFirstChild();
        Node replacement = returnValue != null ? returnValue : IR.name("undefined");
        body.replaceWith(replacement);
        this.compiler.reportChangeToEnclosingScope(replacement);
    }
}

