/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;

final class StaticSuperPropReplacer
implements NodeTraversal.Callback {
    private final AbstractCompiler compiler;
    private final Deque<Optional<Node>> superclasses = new ArrayDeque<Optional<Node>>();

    StaticSuperPropReplacer(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    void replaceAll(Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (!n.isFunction()) {
            return true;
        }
        if (parent.isStaticMember() && parent.getParent().isClassMembers()) {
            Node classNode = parent.getGrandparent();
            Node superclassNode = classNode.getSecondChild();
            if (superclassNode.isEmpty()) {
                this.superclasses.push(Optional.empty());
            } else {
                this.superclasses.push(Optional.of(superclassNode));
            }
        } else if (!n.isArrowFunction()) {
            this.superclasses.push(Optional.empty());
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isSuper()) {
            this.tryReplaceSuper(n);
        } else if (n.isFunction() && !n.isArrowFunction()) {
            this.superclasses.pop();
        }
    }

    private void tryReplaceSuper(Node superNode) {
        Preconditions.checkState((!this.superclasses.isEmpty() ? 1 : 0) != 0, (Object)"`super` cannot appear outside a function");
        Optional<Node> currentSuperclass = this.superclasses.peek();
        if (currentSuperclass.isEmpty() || !currentSuperclass.get().isQualifiedName()) {
            return;
        }
        Node fullyQualifiedSuperRef = currentSuperclass.get().cloneTree();
        superNode.replaceWith(fullyQualifiedSuperRef);
        this.compiler.reportChangeToEnclosingScope(fullyQualifiedSuperRef);
    }
}

