/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolyfillUsageFinder;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.resources.ResourceLoader;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jspecify.nullness.Nullable;

public class RewritePolyfills
implements CompilerPass {
    static final DiagnosticType INSUFFICIENT_OUTPUT_VERSION_ERROR = DiagnosticType.disabled("JSC_INSUFFICIENT_OUTPUT_VERSION", "Built-in ''{0}'' not supported in output version {1}");
    private static final QualifiedName JSCOMP_POLYFILL = QualifiedName.of("$jscomp.polyfill");
    private final AbstractCompiler compiler;
    private final PolyfillUsageFinder.Polyfills polyfills;
    private final boolean injectPolyfills;
    private final boolean isolatePolyfills;
    private Set<String> libraries;

    public RewritePolyfills(AbstractCompiler compiler, boolean injectPolyfills, boolean isolatePolyfills) {
        this(compiler, PolyfillUsageFinder.Polyfills.fromTable(ResourceLoader.loadTextResource(RewritePolyfills.class, "js/polyfills.txt")), injectPolyfills, isolatePolyfills);
    }

    @VisibleForTesting
    RewritePolyfills(AbstractCompiler compiler, PolyfillUsageFinder.Polyfills polyfills, boolean injectPolyfills, boolean isolatePolyfills) {
        this.compiler = compiler;
        this.polyfills = polyfills;
        this.injectPolyfills = injectPolyfills;
        this.isolatePolyfills = isolatePolyfills;
    }

    @Override
    public void process(Node externs, Node root) {
        if (this.isolatePolyfills) {
            Node jscompLookupMethodDecl = IR.var(IR.name("$jscomp$lookupPolyfilledValue"));
            Node synthesizedExternsAstRoot = this.compiler.getSynthesizedExternsInput().getAstRoot(this.compiler);
            jscompLookupMethodDecl.srcrefTree(synthesizedExternsAstRoot);
            synthesizedExternsAstRoot.addChildToBack(jscompLookupMethodDecl);
            this.compiler.reportChangeToEnclosingScope(jscompLookupMethodDecl);
        }
        if (!this.injectPolyfills) {
            return;
        }
        this.libraries = new LinkedHashSet<String>();
        new PolyfillUsageFinder(this.compiler, this.polyfills).traverseExcludingGuarded(root, this::inject);
        if (this.libraries.isEmpty()) {
            return;
        }
        Node lastNode = null;
        for (String library : this.libraries) {
            lastNode = this.compiler.ensureLibraryInjected(library, false);
        }
        if (lastNode != null) {
            Node parent = lastNode.getParent();
            this.removeUnneededPolyfills(parent, lastNode.getNext());
            this.compiler.reportChangeToEnclosingScope(parent);
        }
    }

    private void removeUnneededPolyfills(Node parent, Node runtimeEnd) {
        Node node = parent.getFirstChild();
        FeatureSet outputFeatureSet = this.compiler.getOptions().getOutputFeatureSet();
        while (node != null && node != runtimeEnd) {
            Node next = node.getNext();
            FeatureSet polyfillSupportedFeatureSet = this.getPolyfillSupportedFeatureSet(node);
            if (polyfillSupportedFeatureSet != null && outputFeatureSet.contains(polyfillSupportedFeatureSet)) {
                NodeUtil.removeChild(parent, node);
                NodeUtil.markFunctionsDeleted(node, this.compiler);
            }
            node = next;
        }
    }

    private @Nullable FeatureSet getPolyfillSupportedFeatureSet(Node maybePolyfill) {
        Node call;
        Node name;
        FeatureSet polyfillSupportFeatureSet = null;
        if (NodeUtil.isExprCall(maybePolyfill) && JSCOMP_POLYFILL.matches(name = (call = maybePolyfill.getFirstChild()).getFirstChild())) {
            String nativeVersionStr = name.getNext().getNext().getNext().getString();
            polyfillSupportFeatureSet = FeatureSet.valueOf(nativeVersionStr);
            polyfillSupportFeatureSet = polyfillSupportFeatureSet.without(FeatureSet.Feature.REGEXP_FLAG_S, FeatureSet.Feature.REGEXP_LOOKBEHIND, FeatureSet.Feature.REGEXP_NAMED_GROUPS, FeatureSet.Feature.REGEXP_UNICODE_PROPERTY_ESCAPE);
        }
        return polyfillSupportFeatureSet;
    }

    private void inject(PolyfillUsageFinder.PolyfillUsage polyfillUsage) {
        PolyfillUsageFinder.Polyfill polyfill = polyfillUsage.polyfill();
        FeatureSet outputFeatureSet = this.compiler.getOptions().getOutputFeatureSet();
        FeatureSet featuresRequiredByPolyfill = FeatureSet.valueOf(polyfill.polyfillVersion);
        if (polyfill.kind.equals((Object)PolyfillUsageFinder.Polyfill.Kind.STATIC) && !outputFeatureSet.contains(featuresRequiredByPolyfill)) {
            this.compiler.report(JSError.make(polyfillUsage.node(), INSUFFICIENT_OUTPUT_VERSION_ERROR, polyfillUsage.name(), outputFeatureSet.version()));
        }
        if (!outputFeatureSet.contains(FeatureSet.valueOf(polyfill.nativeVersion)) && !polyfill.library.isEmpty()) {
            this.libraries.add(polyfill.library);
        }
    }
}

