/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Predicate;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptionalChainRewriter;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.UniqueIdSupplier;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.function.Function;

final class RewriteOptionalChainingOperator
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Function<CompilerInput, OptionalChainRewriter.TmpVarNameCreator> getTmpVarNameCreatorForInput;

    RewriteOptionalChainingOperator(AbstractCompiler compiler) {
        this.compiler = compiler;
        UniqueIdSupplier uniqueIdSupplier = compiler.getUniqueIdSupplier();
        this.getTmpVarNameCreatorForInput = input -> () -> "$jscomp$optchain$tmp" + uniqueIdSupplier.getUniqueId((CompilerInput)input);
    }

    RewriteOptionalChainingOperator(AbstractCompiler compiler, OptionalChainRewriter.TmpVarNameCreator tmpVarNameCreator) {
        this.compiler = compiler;
        this.getTmpVarNameCreatorForInput = input -> tmpVarNameCreator;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseRoots(this.compiler, new ArrowRewriteCallBack(), externs, root);
        NodeTraversal.traverseRoots(this.compiler, new TranspilationCallback(), externs, root);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, FeatureSet.Feature.OPTIONAL_CHAINING, new FeatureSet.Feature[0]);
    }

    private class ArrowRewriteCallBack
    implements NodeTraversal.Callback {
        private ArrowRewriteCallBack() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (n.isScript()) {
                FeatureSet scriptFeatures = NodeUtil.getFeatureSetOfScript(n);
                return scriptFeatures == null || scriptFeatures.contains(FeatureSet.Feature.OPTIONAL_CHAINING);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!NodeUtil.isEndOfFullOptChain(n)) {
                return;
            }
            Node arrowOrBlock = NodeUtil.getEnclosingNode(n, (Predicate<Node>)((Predicate)node -> node.isArrowFunction() || node.isBlock()));
            if (arrowOrBlock != null && arrowOrBlock.isArrowFunction() && !NodeUtil.getFunctionBody(arrowOrBlock).isBlock()) {
                Node returnValue = NodeUtil.getFunctionBody(arrowOrBlock);
                Node body = IR.block(IR.returnNode(returnValue.detach()));
                body.srcrefTreeIfMissing(returnValue);
                arrowOrBlock.addChildToBack(body);
                RewriteOptionalChainingOperator.this.compiler.reportChangeToEnclosingScope(body);
            }
        }
    }

    private class TranspilationCallback
    implements NodeTraversal.Callback {
        private final OptionalChainRewriter.Builder rewriterBuilder;
        private final ArrayList<OptionalChainRewriter> optChains;

        private TranspilationCallback() {
            this.rewriterBuilder = OptionalChainRewriter.builder(RewriteOptionalChainingOperator.this.compiler);
            this.optChains = new ArrayList();
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (n.isScript()) {
                this.rewriterBuilder.setTmpVarNameCreator(RewriteOptionalChainingOperator.this.getTmpVarNameCreatorForInput.apply(t.getInput()));
                FeatureSet scriptFeatures = NodeUtil.getFeatureSetOfScript(n);
                return scriptFeatures == null || scriptFeatures.contains(FeatureSet.Feature.OPTIONAL_CHAINING);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (NodeUtil.isEndOfFullOptChain(n)) {
                this.optChains.add(this.rewriterBuilder.build(n));
            } else if (n.isScript() && !this.optChains.isEmpty()) {
                for (OptionalChainRewriter optChain : this.optChains) {
                    optChain.rewrite();
                }
                this.optChains.clear();
            }
        }
    }
}

