/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractVar;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SynthesizeExplicitConstructors;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.TranspilationUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jspecify.nullness.Nullable;

public final class RewriteClassMembers
implements NodeTraversal.ScopedCallback,
CompilerPass {
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final SynthesizeExplicitConstructors ctorCreator;
    private final Deque<ClassRecord> classStack;

    public RewriteClassMembers(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.ctorCreator = new SynthesizeExplicitConstructors(compiler);
        this.classStack = new ArrayDeque<ClassRecord>();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, FeatureSet.Feature.PUBLIC_CLASS_FIELDS, FeatureSet.Feature.CLASS_STATIC_BLOCK);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case SCRIPT: {
                FeatureSet scriptFeatures = NodeUtil.getFeatureSetOfScript(n);
                return scriptFeatures == null || scriptFeatures.contains(FeatureSet.Feature.PUBLIC_CLASS_FIELDS) || scriptFeatures.contains(FeatureSet.Feature.CLASS_STATIC_BLOCK);
            }
            case CLASS: {
                Node classNameNode = NodeUtil.getNameNode(n);
                if (classNameNode == null) {
                    t.report(n, TranspilationUtil.CANNOT_CONVERT_YET, "Anonymous classes with ES2022 features");
                    return false;
                }
                Node classInsertionPoint = this.getStatementDeclaringClass(n, classNameNode);
                if (classInsertionPoint == null) {
                    t.report(n, TranspilationUtil.CANNOT_CONVERT_YET, "Class in a non-extractable location with ES2022 features");
                    return false;
                }
                if (!n.getFirstChild().isEmpty() && !classNameNode.matchesQualifiedName(n.getFirstChild())) {
                    t.report(n, TranspilationUtil.CANNOT_CONVERT_YET, "Classes with possible name shadowing");
                    return false;
                }
                this.classStack.push(new ClassRecord(n, classNameNode.getQualifiedName(), classInsertionPoint));
                break;
            }
            case COMPUTED_FIELD_DEF: {
                Preconditions.checkState((!this.classStack.isEmpty() ? 1 : 0) != 0);
                t.report(n, TranspilationUtil.CANNOT_CONVERT_YET, "Computed fields");
                this.classStack.peek().cannotConvert = true;
                return false;
            }
            case MEMBER_FIELD_DEF: {
                Preconditions.checkState((!this.classStack.isEmpty() ? 1 : 0) != 0);
                if (NodeUtil.referencesEnclosingReceiver(n)) {
                    t.report(n, TranspilationUtil.CANNOT_CONVERT_YET, "Member references this or super");
                    this.classStack.peek().cannotConvert = true;
                    break;
                }
                this.classStack.peek().enterField(n);
                break;
            }
            case BLOCK: {
                if (!NodeUtil.isClassStaticBlock(n)) break;
                if (NodeUtil.referencesEnclosingReceiver(n)) {
                    t.report(n, TranspilationUtil.CANNOT_CONVERT_YET, "Member references this or super");
                    this.classStack.peek().cannotConvert = true;
                    break;
                }
                Preconditions.checkState((!this.classStack.isEmpty() ? 1 : 0) != 0);
                this.classStack.peek().recordStaticBlock(n);
                break;
            }
            case NAME: {
                for (ClassRecord record : this.classStack) {
                    record.potentiallyRecordNameInRhs(n);
                }
                break;
            }
        }
        return true;
    }

    @Override
    public void enterScope(NodeTraversal t) {
        Node scopeRoot = t.getScopeRoot();
        if (NodeUtil.isFunctionBlock(scopeRoot) && NodeUtil.isEs6Constructor(scopeRoot.getParent())) {
            this.classStack.peek().recordConstructorScope(t.getScope());
        }
    }

    @Override
    public void exitScope(NodeTraversal t) {
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case CLASS: {
                this.visitClass(t);
                return;
            }
            case MEMBER_FIELD_DEF: {
                this.classStack.peek().exitField();
                return;
            }
        }
    }

    private void visitClass(NodeTraversal t) {
        ClassRecord currClassRecord = this.classStack.pop();
        if (currClassRecord.cannotConvert) {
            return;
        }
        this.rewriteInstanceMembers(t, currClassRecord);
        this.rewriteStaticMembers(t, currClassRecord);
    }

    private void rewriteInstanceMembers(NodeTraversal t, ClassRecord record) {
        Deque<Node> instanceMembers = record.instanceMembers;
        if (instanceMembers.isEmpty()) {
            return;
        }
        this.ctorCreator.synthesizeClassConstructorIfMissing(t, record.classNode);
        Node ctor = NodeUtil.getEs6ClassConstructorMemberFunctionDef(record.classNode);
        Node ctorBlock = ctor.getFirstChild().getLastChild();
        Node insertionPoint = this.findInitialInstanceInsertionPoint(ctorBlock);
        ImmutableSet<String> ctorDefinedNames = record.getConstructorDefinedNames();
        while (!instanceMembers.isEmpty()) {
            Node instanceMember = instanceMembers.pop();
            Preconditions.checkState((boolean)instanceMember.isMemberFieldDef());
            for (Node nameInRhs : record.referencedNamesByMember.get((Object)instanceMember)) {
                String name = nameInRhs.getString();
                if (!ctorDefinedNames.contains((Object)name)) continue;
                t.report(nameInRhs, TranspilationUtil.CANNOT_CONVERT_YET, "Initializer referencing identifier '" + name + "' declared in constructor");
                return;
            }
            Node thisNode = this.astFactory.createThisForEs6ClassMember(instanceMember);
            Node transpiledNode = this.convNonCompFieldToGetProp(thisNode, instanceMember.detach());
            if (insertionPoint == ctorBlock) {
                ctorBlock.addChildToFront(transpiledNode);
            } else {
                transpiledNode.insertAfter(insertionPoint);
            }
            t.reportCodeChange();
            t.reportCodeChange(ctorBlock);
        }
    }

    private void rewriteStaticMembers(NodeTraversal t, ClassRecord record) {
        Deque<Node> staticMembers = record.staticMembers;
        while (!staticMembers.isEmpty()) {
            Node transpiledNode;
            Node staticMember = staticMembers.pop();
            Node nameToUse = this.astFactory.createQNameWithUnknownType(record.classNameString).srcrefTree(staticMember);
            switch (staticMember.getToken()) {
                case BLOCK: {
                    if (!NodeUtil.getVarsDeclaredInBranch(staticMember).isEmpty()) {
                        t.report(staticMember, TranspilationUtil.CANNOT_CONVERT_YET, "Var in static block");
                    }
                    transpiledNode = staticMember.detach();
                    break;
                }
                case MEMBER_FIELD_DEF: {
                    transpiledNode = this.convNonCompFieldToGetProp(nameToUse, staticMember.detach());
                    break;
                }
                default: {
                    throw new IllegalStateException(String.valueOf(staticMember));
                }
            }
            transpiledNode.insertAfter(record.classInsertionPoint);
            t.reportCodeChange();
        }
    }

    private Node convNonCompFieldToGetProp(Node receiver, Node noncomputedField) {
        Preconditions.checkArgument((boolean)noncomputedField.isMemberFieldDef());
        Preconditions.checkArgument((noncomputedField.getParent() == null ? 1 : 0) != 0, (Object)noncomputedField);
        Preconditions.checkArgument((receiver.getParent() == null ? 1 : 0) != 0, (Object)receiver);
        Node getProp = this.astFactory.createGetProp(receiver, noncomputedField.getString(), AstFactory.type(noncomputedField));
        Node fieldValue = noncomputedField.getFirstChild();
        Node result = fieldValue != null ? this.astFactory.createAssignStatement(getProp, fieldValue.detach()) : this.astFactory.exprResult(getProp);
        result.srcrefTreeIfMissing(noncomputedField);
        return result;
    }

    private Node findInitialInstanceInsertionPoint(Node ctorBlock) {
        if (NodeUtil.referencesSuper(ctorBlock)) {
            for (Node stmt = ctorBlock.getFirstChild(); stmt != null; stmt = stmt.getNext()) {
                if (!NodeUtil.isExprCall(stmt) || !stmt.getFirstFirstChild().isSuper()) continue;
                return stmt;
            }
        }
        return ctorBlock;
    }

    private @Nullable Node getStatementDeclaringClass(Node classNode, Node classNameNode) {
        if (NodeUtil.isClassDeclaration(classNode)) {
            Preconditions.checkState((boolean)NodeUtil.isStatement(classNode));
            return classNode;
        }
        Node parent = classNode.getParent();
        if (parent.isName()) {
            Preconditions.checkState((parent == classNameNode ? 1 : 0) != 0);
            Preconditions.checkState((boolean)NodeUtil.isStatement(classNameNode.getParent()));
            return classNameNode.getParent();
        }
        if (parent.isAssign() && parent.getFirstChild() == classNameNode && parent.getParent().isExprResult()) {
            Preconditions.checkState((boolean)NodeUtil.isStatement(classNameNode.getGrandparent()));
            return classNameNode.getGrandparent();
        }
        return null;
    }

    private static final class ClassRecord {
        @Nullable Node currentMember;
        boolean cannotConvert;
        final Deque<Node> instanceMembers = new ArrayDeque<Node>();
        final Deque<Node> staticMembers = new ArrayDeque<Node>();
        final SetMultimap<Node, Node> referencedNamesByMember = MultimapBuilder.linkedHashKeys().hashSetValues().build();
        ImmutableSet<Var> constructorVars = ImmutableSet.of();
        final Node classNode;
        final String classNameString;
        final Node classInsertionPoint;

        ClassRecord(Node classNode, String classNameString, Node classInsertionPoint) {
            this.classNode = classNode;
            this.classNameString = classNameString;
            this.classInsertionPoint = classInsertionPoint;
        }

        void enterField(Node field) {
            Preconditions.checkArgument((field.isComputedFieldDef() || field.isMemberFieldDef() ? 1 : 0) != 0);
            if (field.isStaticMember()) {
                this.staticMembers.push(field);
            } else {
                this.instanceMembers.push(field);
            }
            this.currentMember = field;
        }

        void exitField() {
            this.currentMember = null;
        }

        void recordStaticBlock(Node block) {
            Preconditions.checkArgument((boolean)NodeUtil.isClassStaticBlock(block));
            this.staticMembers.push(block);
        }

        void potentiallyRecordNameInRhs(Node nameNode) {
            Preconditions.checkArgument((boolean)nameNode.isName());
            if (this.currentMember == null) {
                return;
            }
            Preconditions.checkState((boolean)this.currentMember.isMemberFieldDef());
            this.referencedNamesByMember.put((Object)this.currentMember, (Object)nameNode);
        }

        void recordConstructorScope(Scope s) {
            Preconditions.checkArgument((boolean)s.isFunctionBlockScope(), (Object)s);
            Preconditions.checkState((boolean)this.constructorVars.isEmpty(), this.constructorVars);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.addAll(s.getAllSymbols());
            Scope argsScope = s.getParent();
            builder.addAll(argsScope.getAllSymbols());
            this.constructorVars = builder.build();
        }

        ImmutableSet<String> getConstructorDefinedNames() {
            return (ImmutableSet)this.constructorVars.stream().map(AbstractVar::getName).collect(ImmutableSet.toImmutableSet());
        }
    }
}

