/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.javascript.jscomp.CompilerInput;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@GwtIncompatible(value="com.google.common.util.concurrent")
class PrebuildDependencyInfo {
    private final int numParallelThreads;

    PrebuildDependencyInfo(int numParalleThreads) {
        this.numParallelThreads = numParalleThreads;
    }

    void prebuild(Iterable<CompilerInput> allInputs) {
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(null, r, "jscompiler-PrebuildDependencyInfo", 0x4000000L);
                t.setDaemon(true);
                return t;
            }
        };
        ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(this.numParallelThreads, this.numParallelThreads, Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)poolExecutor);
        ArrayList<ListenableFuture> futureList = new ArrayList<ListenableFuture>(Iterables.size(allInputs));
        for (CompilerInput input : allInputs) {
            futureList.add(executorService.submit(input::getDependencyInfo));
        }
        poolExecutor.shutdown();
        try {
            Futures.allAsList(futureList).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

