/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolymerClassDefinition;
import com.google.javascript.jscomp.PolymerPass;
import com.google.javascript.jscomp.PolymerPassErrors;
import com.google.javascript.jscomp.base.format.SimpleFormat;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.Token;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.nullness.Nullable;

final class PolymerPassStaticUtils {
    private static final String VIRTUAL_FILE = "<PolymerPassStaticUtils.java>";
    private static final QualifiedName POLYMER_DOT_ELEMENT = QualifiedName.of("Polymer.Element");

    @VisibleForTesting
    public static boolean isPolymerCall(Node call) {
        if (call == null || !call.isCall()) {
            return false;
        }
        Node name = call.getFirstChild();
        return name.matchesName("Polymer") || "Polymer".equals(name.getOriginalQualifiedName()) || name.isGetProp() && name.getString().equals("Polymer");
    }

    @VisibleForTesting
    public static boolean isPolymerClass(Node cls) {
        if (cls == null || !cls.isClass()) {
            return false;
        }
        JSDocInfo info = NodeUtil.getBestJSDocInfo(cls);
        if (info != null && info.isPolymer()) {
            return true;
        }
        Node heritage = cls.getSecondChild();
        return !heritage.isEmpty() && (POLYMER_DOT_ELEMENT.matches(heritage) || heritage.matchesName("PolymerElement") || "PolymerElement".equals(heritage.getOriginalQualifiedName()) || heritage.isGetProp() && heritage.getString().equals("PolymerElement"));
    }

    static void switchDollarSignPropsToBrackets(Node def, final AbstractCompiler compiler) {
        Preconditions.checkState((def.isObjectLit() || def.isClassMembers() ? 1 : 0) != 0);
        for (Node keyNode = def.getFirstChild(); keyNode != null; keyNode = keyNode.getNext()) {
            Node value = keyNode.getFirstChild();
            if (value == null || !value.isFunction()) continue;
            NodeUtil.visitPostOrder(value.getLastChild(), new NodeUtil.Visitor(){

                @Override
                public void visit(Node n) {
                    if (!n.isGetProp()) {
                        return;
                    }
                    Node dollarSign = n.getFirstChild();
                    if (!dollarSign.isGetProp() || !dollarSign.getString().equals("$")) {
                        return;
                    }
                    if (n.getParent().isCall() && n.getParent().hasOneChild()) {
                        return;
                    }
                    Node key = IR.string(n.getString()).clonePropsFrom(n).srcref(n);
                    Node getelem = IR.getelem(dollarSign.detach(), key).clonePropsFrom(n).srcref(n);
                    n.replaceWith(getelem);
                    compiler.reportChangeToEnclosingScope(getelem);
                }
            });
        }
    }

    static void quoteListenerAndHostAttributeKeys(Node objLit, AbstractCompiler compiler) {
        Preconditions.checkState((boolean)objLit.isObjectLit());
        for (Node keyNode = objLit.getFirstChild(); keyNode != null; keyNode = keyNode.getNext()) {
            if (keyNode.isComputedProp() || !keyNode.getString().equals("listeners") && !keyNode.getString().equals("hostAttributes")) continue;
            for (Node keyToQuote = keyNode.getFirstFirstChild(); keyToQuote != null; keyToQuote = keyToQuote.getNext()) {
                if (keyToQuote.isQuotedString()) continue;
                keyToQuote.setQuotedString();
                compiler.reportChangeToEnclosingScope(keyToQuote);
            }
        }
    }

    static ImmutableList<PolymerPass.MemberDefinition> extractProperties(Node descriptor, PolymerClassDefinition.DefinitionType defType, AbstractCompiler compiler, @Nullable Node constructor) {
        Node properties = descriptor;
        if (defType == PolymerClassDefinition.DefinitionType.ObjectLiteral) {
            properties = NodeUtil.getFirstPropMatchingKey(descriptor, "properties");
        }
        if (properties == null) {
            return ImmutableList.of();
        }
        HashMap<String, JSDocInfo> constructorPropertyJsDoc = new HashMap<String, JSDocInfo>();
        if (constructor != null) {
            PolymerPassStaticUtils.collectConstructorPropertyJsDoc(constructor, constructorPropertyJsDoc);
        }
        ImmutableList.Builder members = ImmutableList.builder();
        for (Node keyNode = properties.getFirstChild(); keyNode != null; keyNode = keyNode.getNext()) {
            JSDocInfo bestJsDoc;
            JSDocInfo constructorJsDoc = (JSDocInfo)constructorPropertyJsDoc.get(keyNode.getString());
            JSDocInfo propertiesConfigJsDoc = NodeUtil.getBestJSDocInfo(keyNode);
            if (constructorJsDoc != null) {
                bestJsDoc = constructorJsDoc;
                if (propertiesConfigJsDoc != null) {
                    compiler.report(JSError.make(keyNode, PolymerPassErrors.POLYMER_MISPLACED_PROPERTY_JSDOC, new String[0]));
                }
            } else {
                bestJsDoc = propertiesConfigJsDoc;
            }
            members.add((Object)new PolymerPass.MemberDefinition(bestJsDoc, keyNode, keyNode.getFirstChild()));
        }
        return members.build();
    }

    private static void collectConstructorPropertyJsDoc(Node node, Map<String, JSDocInfo> map) {
        Preconditions.checkNotNull((Object)node);
        for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
            if (child.isGetProp() && child.getFirstChild().isThis()) {
                map.put(child.getString(), NodeUtil.getBestJSDocInfo(child));
                continue;
            }
            PolymerPassStaticUtils.collectConstructorPropertyJsDoc(child, map);
        }
    }

    static @Nullable JSTypeExpression getTypeFromProperty(PolymerPass.MemberDefinition property, AbstractCompiler compiler) {
        Node typeNode;
        String typeString;
        Node typeValue;
        if (property.info != null && property.info.hasType()) {
            return property.info.getType().copy();
        }
        if (property.value.isObjectLit()) {
            typeValue = NodeUtil.getFirstPropMatchingKey(property.value, "type");
            if (typeValue == null || !typeValue.isName()) {
                compiler.report(JSError.make(property.name, PolymerPassErrors.POLYMER_INVALID_PROPERTY, new String[0]));
                return null;
            }
        } else {
            typeValue = property.value.isName() ? property.value : null;
        }
        if (typeValue == null) {
            compiler.report(JSError.make(property.value, PolymerPassErrors.POLYMER_INVALID_PROPERTY, new String[0]));
            return null;
        }
        switch (typeString = typeValue.getString()) {
            case "Boolean": 
            case "String": 
            case "Number": {
                typeNode = IR.string(Ascii.toLowerCase((String)typeString));
                break;
            }
            case "Array": 
            case "Function": 
            case "Object": 
            case "Date": {
                typeNode = new Node(Token.BANG, IR.string(typeString));
                break;
            }
            default: {
                compiler.report(JSError.make(property.value, PolymerPassErrors.POLYMER_INVALID_PROPERTY, new String[0]));
                typeNode = new Node(Token.QMARK);
            }
        }
        typeNode.srcrefTree(typeValue);
        return new JSTypeExpression(typeNode, VIRTUAL_FILE);
    }

    public static String getPolymerElementType(PolymerClassDefinition cls) {
        String nativeElementName = cls.nativeBaseElement == null ? "" : CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, cls.nativeBaseElement);
        return SimpleFormat.format("Polymer%sElement", nativeElementName);
    }

    private PolymerPassStaticUtils() {
    }
}

