/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.RewriteLogicalAssignmentOperatorsHelper;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jspecify.nullness.Nullable;

final class Normalize
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final boolean assertOnChange;

    Normalize(AbstractCompiler compiler, boolean assertOnChange) {
        this.compiler = compiler;
        this.assertOnChange = assertOnChange;
        this.astFactory = compiler.createAstFactory();
    }

    static void normalizeSyntheticCode(AbstractCompiler compiler, Node js, String prefix) {
        NodeTraversal.traverse(compiler, js, new NormalizeStatements(compiler, false));
        NodeTraversal.traverse(compiler, js, new MakeDeclaredNamesUnique(new MakeDeclaredNamesUnique.BoilerplateRenamer(compiler.getCodingConvention(), compiler.getUniqueNameIdSupplier(), prefix)));
    }

    static Node parseAndNormalizeTestCode(AbstractCompiler compiler, String code) {
        Node js = compiler.parseTestCode(code);
        NodeTraversal.traverse(compiler, js, new NormalizeStatements(compiler, false));
        return js;
    }

    private void reportCodeChange(String changeDescription, Node n) {
        if (this.assertOnChange) {
            throw new IllegalStateException("Normalize constraints violated:\n" + changeDescription);
        }
        this.compiler.reportChangeToEnclosingScope(n);
    }

    @Override
    public void process(Node externs, Node root) {
        MakeDeclaredNamesUnique renamer = new MakeDeclaredNamesUnique();
        NodeTraversal.traverseRoots(this.compiler, renamer, externs, root);
        NodeTraversal.traverseRoots(this.compiler, new NormalizeStatements(this.compiler, this.assertOnChange), externs, root);
        this.removeDuplicateDeclarations(externs, root);
        new PropagateConstantAnnotationsOverVars(this.compiler, this.assertOnChange).process(externs, root);
        if (!this.compiler.getLifeCycleStage().isNormalized()) {
            this.compiler.setLifeCycleStage(AbstractCompiler.LifeCycleStage.NORMALIZED);
        }
    }

    private void removeDuplicateDeclarations(Node externs, Node root) {
        NodeTraversal.builder().setCompiler(this.compiler).setCallback(new ScopeTicklingCallback()).setScopeCreator(new SyntacticScopeCreator(this.compiler, new DuplicateDeclarationHandler())).traverseRoots(externs, root);
    }

    private static final class ScopeTicklingCallback
    implements NodeTraversal.ScopedCallback {
        private ScopeTicklingCallback() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            t.getScope();
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }
    }

    private final class DuplicateDeclarationHandler
    implements SyntacticScopeCreator.RedeclarationHandler {
        private final Set<Var> hasOkDuplicateDeclaration = new HashSet<Var>();

        private DuplicateDeclarationHandler() {
        }

        @Override
        public void onRedeclaration(Scope s, String name, Node n, CompilerInput input) {
            Preconditions.checkState((boolean)n.isName());
            Node parent = n.getParent();
            Var v = (Var)s.getVar(name);
            if (s.isGlobal() && v.isExtern() && !input.isExtern() && this.hasOkDuplicateDeclaration.add(v)) {
                return;
            }
            if (parent.isFunction()) {
                if (v.getParentNode().isVar()) {
                    s.undeclare(v);
                    s.declare(name, n, v.getInput());
                    this.replaceVarWithAssignment(v.getNameNode(), v.getParentNode(), v.getParentNode().getParent());
                }
            } else if (parent.isVar()) {
                Preconditions.checkState((boolean)parent.hasOneChild());
                this.replaceVarWithAssignment(n, parent, parent.getParent());
            }
        }

        private void replaceVarWithAssignment(Node n, Node parent, Node grandparent) {
            if (n.hasChildren()) {
                n.detach();
                Node value = n.getFirstChild();
                value.detach();
                Node replacement = Normalize.this.astFactory.createAssign(n, value);
                replacement.setJSDocInfo(parent.getJSDocInfo());
                replacement.srcrefIfMissing(parent);
                Node statement = NodeUtil.newExpr(replacement);
                parent.replaceWith(statement);
                Normalize.this.reportCodeChange("Duplicate VAR declaration", statement);
            } else {
                Preconditions.checkState((boolean)NodeUtil.isStatementBlock(grandparent), (Object)grandparent);
                parent.detach();
                Normalize.this.reportCodeChange("Duplicate VAR declaration", grandparent);
            }
        }
    }

    static class NormalizeStatements
    implements NodeTraversal.Callback {
        private final AbstractCompiler compiler;
        private final AstFactory astFactory;
        private final boolean assertOnChange;
        private final RewriteLogicalAssignmentOperatorsHelper rewriteLogicalAssignmentOperatorsHelper;

        NormalizeStatements(AbstractCompiler compiler, boolean assertOnChange) {
            this.compiler = compiler;
            this.assertOnChange = assertOnChange;
            this.astFactory = compiler.createAstFactory();
            this.rewriteLogicalAssignmentOperatorsHelper = new RewriteLogicalAssignmentOperatorsHelper(compiler, this.astFactory, compiler.getUniqueIdSupplier());
        }

        private void reportCodeChange(String changeDescription, Node n) {
            if (this.assertOnChange) {
                throw new IllegalStateException("Normalize constraints violated:\n" + changeDescription);
            }
            this.compiler.reportChangeToEnclosingScope(n);
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            this.doStatementNormalizations(n);
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case WHILE: {
                    Node expr = n.getFirstChild();
                    n.setToken(Token.FOR);
                    Node empty = IR.empty();
                    empty.srcrefIfMissing(n);
                    empty.insertBefore(expr);
                    empty.cloneNode().insertAfter(expr);
                    this.reportCodeChange("WHILE node", n);
                    break;
                }
                case FUNCTION: {
                    if (!NormalizeStatements.visitFunction(n, this.compiler)) break;
                    this.reportCodeChange("Function declaration", n);
                    break;
                }
                case EXPORT: {
                    this.splitExportDeclaration(n);
                    break;
                }
                case NAME: 
                case GETPROP: 
                case OPTCHAIN_GETPROP: 
                case GETTER_DEF: 
                case SETTER_DEF: {
                    this.annotateConstantsByConvention(n);
                    break;
                }
                case ASSIGN_OR: 
                case ASSIGN_AND: 
                case ASSIGN_COALESCE: {
                    this.rewriteLogicalAssignmentOperatorsHelper.visitLogicalAssignmentOperator(t, n);
                    break;
                }
            }
        }

        private void annotateConstantsByConvention(Node n) {
            Preconditions.checkState((n.isName() || n.isOptChainGetProp() || n.isGetProp() || n.isStringKey() || n.isGetterDef() || n.isSetterDef() ? 1 : 0) != 0);
            if (this.compiler.getLifeCycleStage().isNormalizedObfuscated()) {
                return;
            }
            boolean isGetprop = NodeUtil.isNormalOrOptChainGetProp(n);
            if (!(n.isName() || NodeUtil.mayBeObjectLitKey(n) || isGetprop)) {
                return;
            }
            if (!n.getBooleanProp(Node.IS_CONSTANT_NAME) && NodeUtil.isConstantByConvention(this.compiler.getCodingConvention(), n)) {
                Preconditions.checkState((!this.assertOnChange ? 1 : 0) != 0, (String)"Unexpected const change: %s", (Object)n);
                n.putBooleanProp(Node.IS_CONSTANT_NAME, true);
            }
        }

        private void splitExportDeclaration(Node n) {
            if (n.getBooleanProp(Node.EXPORT_DEFAULT)) {
                return;
            }
            Node c = n.getFirstChild();
            if (NodeUtil.isDeclaration(c)) {
                c.detach();
                Node exportSpecs = new Node(Token.EXPORT_SPECS).srcref(n);
                n.addChildToFront(exportSpecs);
                if (c.isClass() || c.isFunction()) {
                    Node name2 = c.getFirstChild();
                    c.insertBefore(n);
                    this.addNameNodeToExportSpecs(exportSpecs, name2);
                } else {
                    NodeUtil.visitLhsNodesInNode(c, name -> this.addNameNodeToExportSpecs(exportSpecs, (Node)name));
                    Node child = c.getFirstChild();
                    while (child != null) {
                        Node next = child.getNext();
                        child.detach();
                        Node newDeclaration = new Node(c.getToken(), child).srcref(n);
                        newDeclaration.insertBefore(n);
                        child = next;
                    }
                }
                this.compiler.reportChangeToEnclosingScope(n.getParent());
            }
        }

        private void addNameNodeToExportSpecs(Node exportSpecs, Node name) {
            Node exportSpec = new Node(Token.EXPORT_SPEC).srcref(name);
            exportSpec.addChildToFront(name.cloneNode());
            exportSpec.addChildToFront(name.cloneNode());
            exportSpecs.addChildToBack(exportSpec);
        }

        static boolean visitFunction(Node n, AbstractCompiler compiler) {
            Preconditions.checkState((boolean)n.isFunction(), (Object)n);
            if (n.isFunction() && !NodeUtil.getFunctionBody(n).isBlock()) {
                Node returnValue = NodeUtil.getFunctionBody(n);
                Node body = IR.block(IR.returnNode(returnValue.detach()));
                body.srcrefTreeIfMissing(returnValue);
                n.addChildToBack(body);
                compiler.reportChangeToEnclosingScope(body);
            }
            return false;
        }

        private void doStatementNormalizations(Node n) {
            if (n.isLabel()) {
                this.normalizeLabels(n);
            }
            if (NodeUtil.isStatementBlock(n) || n.isLabel()) {
                this.extractForInitializer(n, null, null);
            }
            if (NodeUtil.isStatementBlock(n)) {
                this.splitVarDeclarations(n);
            }
            if (n.isFunction()) {
                this.moveNamedFunctions(n.getLastChild());
            }
            if (NodeUtil.isCompoundAssignmentOp(n) && !NodeUtil.isLogicalAssignmentOp(n)) {
                this.normalizeAssignShorthand(n);
            }
        }

        private void normalizeLabels(Node n) {
            Preconditions.checkArgument((boolean)n.isLabel());
            Node last = n.getLastChild();
            switch (last.getToken()) {
                case WHILE: 
                case LABEL: 
                case BLOCK: 
                case FOR: 
                case FOR_IN: 
                case FOR_OF: 
                case FOR_AWAIT_OF: 
                case DO: {
                    return;
                }
            }
            Node block = IR.block();
            block.srcrefIfMissing(last);
            last.replaceWith(block);
            block.addChildToFront(last);
            this.reportCodeChange("LABEL normalization", n);
        }

        private void extractForInitializer(Node n, @Nullable Node before, @Nullable Node beforeParent) {
            Node c = n.getFirstChild();
            while (c != null) {
                Node next = c.getNext();
                Node insertBefore = before == null ? c : before;
                Node insertBeforeParent = before == null ? n : beforeParent;
                switch (c.getToken()) {
                    case LABEL: {
                        this.extractForInitializer(c, insertBefore, insertBeforeParent);
                        break;
                    }
                    case FOR_IN: 
                    case FOR_OF: 
                    case FOR_AWAIT_OF: {
                        Node first = c.getFirstChild();
                        if (!first.isVar()) break;
                        Node lhs = first.getFirstChild();
                        if (lhs.isDestructuringLhs()) {
                            NodeUtil.visitLhsNodesInNode(lhs, name -> {
                                Preconditions.checkState((boolean)name.isName(), (String)"lhs in destructuring declaration should be a simple name. (%s)", (Object)name);
                                Node newName = IR.name(name.getString()).srcref((Node)name);
                                Node newVar = IR.var(newName).srcref((Node)name);
                                newVar.insertBefore(insertBefore);
                            });
                            Node destructuringPattern = lhs.removeFirstChild();
                            first.replaceWith(destructuringPattern);
                        } else {
                            Node newStatement = first;
                            Node name2 = newStatement.getFirstChild().cloneNode();
                            first.replaceWith(name2);
                            newStatement.insertBefore(insertBefore);
                        }
                        this.reportCodeChange("FOR-IN var declaration", n);
                        break;
                    }
                    case FOR: {
                        Node init;
                        if (c.getFirstChild().isEmpty() || (init = c.getFirstChild()).isLet() || init.isConst() || init.isClass() || init.isFunction()) break;
                        Node empty = IR.empty();
                        empty.srcrefIfMissing(c);
                        init.replaceWith(empty);
                        Node newStatement = init.isVar() ? init : NodeUtil.newExpr(init);
                        newStatement.insertBefore(insertBefore);
                        this.reportCodeChange("FOR initializer", n);
                        break;
                    }
                }
                c = next;
            }
        }

        private void splitVarDeclarations(Node n) {
            Node c = n.getFirstChild();
            while (c != null) {
                Node next = c.getNext();
                if (NodeUtil.isNameDeclaration(c)) {
                    if (this.assertOnChange && !c.hasChildren()) {
                        throw new IllegalStateException("Empty VAR node.");
                    }
                    while (c.getFirstChild() != c.getLastChild()) {
                        Node name = c.getFirstChild();
                        name.detach();
                        Node newVar = new Node(c.getToken(), name).srcref(n);
                        newVar.insertBefore(c);
                        this.reportCodeChange("VAR with multiple children", n);
                    }
                }
                c = next;
            }
        }

        private void moveNamedFunctions(Node functionBody) {
            Node current;
            Preconditions.checkState((boolean)functionBody.getParent().isFunction());
            Node insertAfter = null;
            for (current = functionBody.getFirstChild(); current != null && NodeUtil.isFunctionDeclaration(current); current = current.getNext()) {
                insertAfter = current;
            }
            while (current != null) {
                Node next = current.getNext();
                if (NodeUtil.isFunctionDeclaration(current)) {
                    current.detach();
                    insertAfter = NormalizeStatements.addToFront(functionBody, current, insertAfter);
                    this.reportCodeChange("Move function declaration not at top of function", functionBody);
                }
                current = next;
            }
        }

        private void normalizeAssignShorthand(Node shorthand) {
            if (!shorthand.getFirstChild().isName()) {
                return;
            }
            Node name = shorthand.getFirstChild();
            shorthand.setToken(NodeUtil.getOpFromAssignmentOp(shorthand));
            Node insertPoint = IR.empty();
            shorthand.replaceWith(insertPoint);
            Node assign = this.astFactory.createAssign(name.cloneNode().srcref(name), shorthand).srcref(shorthand);
            assign.setJSDocInfo(shorthand.getJSDocInfo());
            shorthand.setJSDocInfo(null);
            insertPoint.replaceWith(assign);
            this.compiler.reportChangeToEnclosingScope(assign);
        }

        private static Node addToFront(Node parent, Node newChild, Node after) {
            if (after == null) {
                parent.addChildToFront(newChild);
            } else {
                newChild.insertAfter(after);
            }
            return newChild;
        }
    }

    static class VerifyConstants
    extends NodeTraversal.AbstractPostOrderCallback
    implements CompilerPass {
        private final AbstractCompiler compiler;
        private final boolean checkUserDeclarations;
        private final Map<String, Boolean> constantMap = new HashMap<String, Boolean>();

        VerifyConstants(AbstractCompiler compiler, boolean checkUserDeclarations) {
            this.compiler = compiler;
            this.checkUserDeclarations = checkUserDeclarations;
        }

        @Override
        public void process(Node externs, Node root) {
            Node externsAndJs = root.getParent();
            Preconditions.checkState((externsAndJs != null ? 1 : 0) != 0);
            Preconditions.checkState((boolean)externsAndJs.hasChild(externs));
            NodeTraversal.traverseRoots(this.compiler, this, externs, root);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName()) {
                Boolean value;
                String name = n.getString();
                if (n.getString().isEmpty()) {
                    return;
                }
                boolean isConst = n.getBooleanProp(Node.IS_CONSTANT_NAME);
                if (this.checkUserDeclarations) {
                    boolean expectedConst = false;
                    CodingConvention convention = this.compiler.getCodingConvention();
                    if (NodeUtil.isConstantName(n) || NodeUtil.isConstantByConvention(convention, n)) {
                        expectedConst = true;
                    } else {
                        expectedConst = false;
                        JSDocInfo info = null;
                        Var var = (Var)t.getScope().getVar(n.getString());
                        if (var != null) {
                            info = var.getJSDocInfo();
                        }
                        expectedConst = info != null && info.isConstant();
                    }
                    if (expectedConst) {
                        Preconditions.checkState((expectedConst == isConst ? 1 : 0) != 0, (String)"The name %s is not annotated as constant.", (Object)name);
                    } else {
                        Preconditions.checkState((expectedConst == isConst ? 1 : 0) != 0, (String)"The name %s should not be annotated as constant.", (Object)name);
                    }
                }
                if ((value = this.constantMap.get(name)) == null) {
                    this.constantMap.put(name, isConst);
                } else if (value != isConst) {
                    throw new IllegalStateException("The name " + name + " is not consistently annotated as constant. Expected " + ImmutableMap.copyOf(this.constantMap));
                }
            }
        }
    }

    static class PropagateConstantAnnotationsOverVars
    extends NodeTraversal.AbstractPostOrderCallback
    implements CompilerPass {
        private final AbstractCompiler compiler;
        private final boolean assertOnChange;

        PropagateConstantAnnotationsOverVars(AbstractCompiler compiler, boolean forbidChanges) {
            this.compiler = compiler;
            this.assertOnChange = forbidChanges;
        }

        @Override
        public void process(Node externs, Node root) {
            NodeTraversal.traverseRoots(this.compiler, this, externs, root);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName() || n.isStringKey()) {
                Var var;
                if (n.getString().isEmpty()) {
                    return;
                }
                JSDocInfo info = null;
                Var var2 = var = n.isName() ? (Var)t.getScope().getVar(n.getString()) : null;
                if (var != null) {
                    info = var.getJSDocInfo();
                }
                boolean shouldBeConstant = info != null && info.isConstant() || NodeUtil.isConstantByConvention(this.compiler.getCodingConvention(), n);
                boolean isMarkedConstant = n.getBooleanProp(Node.IS_CONSTANT_NAME);
                if (shouldBeConstant && !isMarkedConstant) {
                    if (this.assertOnChange) {
                        String name = n.getString();
                        throw new IllegalStateException("Unexpected const change.\n  name: " + name + "\n  parent:" + n.getParent().toStringTree());
                    }
                    n.putBooleanProp(Node.IS_CONSTANT_NAME, true);
                }
            }
        }
    }
}

