/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.LatticeElement;
import com.google.javascript.rhino.HamtPMap;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.PMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MaybeReachingVariableUse
extends DataFlowAnalysis<Node, ReachingUses> {
    private final Set<Var> escaped;
    private final Map<String, Var> allVarsInFn;

    MaybeReachingVariableUse(ControlFlowGraph<Node> cfg, Set<Var> escaped, Map<String, Var> allVarsInFn) {
        super(cfg);
        this.escaped = escaped;
        this.allVarsInFn = allVarsInFn;
    }

    @Override
    boolean isForward() {
        return false;
    }

    @Override
    ReachingUses createEntryLattice() {
        return new ReachingUses();
    }

    @Override
    ReachingUses createInitialEstimateLattice() {
        return new ReachingUses();
    }

    @Override
    DataFlowAnalysis.FlowJoiner<ReachingUses> createFlowJoiner() {
        return new ReachingUsesJoinOp();
    }

    @Override
    ReachingUses flowThrough(Node n, ReachingUses input) {
        ReachingUses output = new ReachingUses(input);
        boolean conditional = this.hasExceptionHandler(n);
        this.computeMayUse(n, n, output, conditional);
        return output;
    }

    private boolean hasExceptionHandler(Node cfgNode) {
        List branchEdges = this.getCfg().getOutEdges(cfgNode);
        for (DiGraph.DiGraphEdge diGraphEdge : branchEdges) {
            if (diGraphEdge.getValue() != ControlFlowGraph.Branch.ON_EX) continue;
            return true;
        }
        return false;
    }

    private void computeMayUse(Node n, Node cfgNode, ReachingUses output, boolean conditional) {
        switch (n.getToken()) {
            case BLOCK: 
            case ROOT: 
            case FUNCTION: {
                return;
            }
            case NAME: {
                if (NodeUtil.isLhsByDestructuring(n)) {
                    if (!conditional) {
                        this.removeFromUseIfLocal(n.getString(), output);
                    }
                } else {
                    this.addToUseIfLocal(n.getString(), cfgNode, output);
                }
                return;
            }
            case WHILE: 
            case DO: 
            case IF: 
            case FOR: {
                Node condExpr = NodeUtil.getConditionExpression(n);
                this.computeMayUse(condExpr, cfgNode, output, conditional);
                return;
            }
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: {
                Node lhs = n.getFirstChild();
                Node rhs = lhs.getNext();
                if (NodeUtil.isNameDeclaration(lhs) && (lhs = lhs.getLastChild()).isDestructuringLhs()) {
                    lhs = lhs.getFirstChild();
                }
                if (lhs.isName() && !conditional) {
                    this.removeFromUseIfLocal(lhs.getString(), output);
                } else if (lhs.isDestructuringPattern()) {
                    this.computeMayUse(lhs, cfgNode, output, true);
                }
                this.computeMayUse(rhs, cfgNode, output, conditional);
                return;
            }
            case AND: 
            case OR: 
            case COALESCE: 
            case OPTCHAIN_GETPROP: 
            case OPTCHAIN_GETELEM: {
                this.computeMayUse(n.getLastChild(), cfgNode, output, true);
                this.computeMayUse(n.getFirstChild(), cfgNode, output, conditional);
                return;
            }
            case OPTCHAIN_CALL: {
                for (Node c = n.getLastChild(); c != n.getFirstChild(); c = c.getPrevious()) {
                    this.computeMayUse(c, cfgNode, output, true);
                }
                this.computeMayUse(n.getFirstChild(), cfgNode, output, conditional);
                return;
            }
            case HOOK: {
                this.computeMayUse(n.getLastChild(), cfgNode, output, true);
                this.computeMayUse(n.getSecondChild(), cfgNode, output, true);
                this.computeMayUse(n.getFirstChild(), cfgNode, output, conditional);
                return;
            }
            case VAR: 
            case LET: 
            case CONST: {
                Node varName = n.getFirstChild();
                Preconditions.checkState((boolean)n.hasChildren(), (String)"AST should be normalized (%s)", (Object)n);
                if (varName.isDestructuringLhs()) {
                    this.computeMayUse(varName.getFirstChild(), cfgNode, output, conditional);
                    this.computeMayUse(varName.getSecondChild(), cfgNode, output, conditional);
                } else if (varName.hasChildren()) {
                    this.computeMayUse(varName.getFirstChild(), cfgNode, output, conditional);
                    if (!conditional) {
                        this.removeFromUseIfLocal(varName.getString(), output);
                    }
                }
                return;
            }
            case DEFAULT_VALUE: {
                if (n.getFirstChild().isDestructuringPattern()) {
                    this.computeMayUse(n.getFirstChild(), cfgNode, output, conditional);
                    this.computeMayUse(n.getSecondChild(), cfgNode, output, true);
                    break;
                }
                if (n.getFirstChild().isName()) {
                    if (!conditional) {
                        this.removeFromUseIfLocal(n.getFirstChild().getString(), output);
                    }
                    this.computeMayUse(n.getSecondChild(), cfgNode, output, true);
                    break;
                }
                this.computeMayUse(n.getSecondChild(), cfgNode, output, true);
                this.computeMayUse(n.getFirstChild(), cfgNode, output, conditional);
                break;
            }
            default: {
                if (NodeUtil.isAssignmentOp(n) && n.getFirstChild().isName()) {
                    Preconditions.checkState((!NodeUtil.isLogicalAssignmentOp(n) ? 1 : 0) != 0);
                    Node name = n.getFirstChild();
                    if (!conditional) {
                        this.removeFromUseIfLocal(name.getString(), output);
                    }
                    if (!n.isAssign()) {
                        this.addToUseIfLocal(name.getString(), cfgNode, output);
                    }
                    this.computeMayUse(name.getNext(), cfgNode, output, conditional);
                    break;
                }
                if (n.isAssign() && n.getFirstChild().isDestructuringPattern()) {
                    this.computeMayUse(n.getFirstChild(), cfgNode, output, conditional);
                    this.computeMayUse(n.getSecondChild(), cfgNode, output, conditional);
                    break;
                }
                for (Node c = n.getLastChild(); c != null; c = c.getPrevious()) {
                    this.computeMayUse(c, cfgNode, output, conditional);
                }
            }
        }
    }

    private void addToUseIfLocal(String name, Node node, ReachingUses use) {
        Var var = this.allVarsInFn.get(name);
        if (var == null) {
            return;
        }
        if (!this.escaped.contains(var)) {
            use.put(var, node);
        }
    }

    private void removeFromUseIfLocal(String name, ReachingUses use) {
        Var var = this.allVarsInFn.get(name);
        if (var == null) {
            return;
        }
        if (!this.escaped.contains(var)) {
            use.removeAll(var);
        }
    }

    Iterable<Node> getUses(String name, Node defNode) {
        DiGraph.DiGraphNode n = this.getCfg().getNode(defNode);
        Preconditions.checkNotNull((Object)n);
        DataFlowAnalysis.LinearFlowState state = (DataFlowAnalysis.LinearFlowState)n.getAnnotation();
        return ((ReachingUses)state.getOut()).get(this.allVarsInFn.get(name));
    }

    private static class ReachingUsesJoinOp
    implements DataFlowAnalysis.FlowJoiner<ReachingUses> {
        final ReachingUses result = new ReachingUses();

        private ReachingUsesJoinOp() {
        }

        @Override
        public void joinFlow(ReachingUses uses) {
            this.result.join(uses);
        }

        @Override
        public ReachingUses finish() {
            return this.result;
        }
    }

    static final class ReachingUses
    implements LatticeElement {
        private PMap<Var, PMap<Node, Node>> mayUsePMap = HamtPMap.empty();

        public ReachingUses() {
        }

        public ReachingUses(ReachingUses other) {
            this.mayUsePMap = other.mayUsePMap;
        }

        public Iterable<Node> get(Var v) {
            PMap<Node, Node> uses = this.mayUsePMap.get(v);
            return uses != null ? uses.keys() : ImmutableList.of();
        }

        public void removeAll(Var v) {
            this.mayUsePMap = this.mayUsePMap.minus(v);
        }

        public void put(Var v, Node n) {
            PMap<Node, Node> newValues;
            PMap<Node, Node> values = this.mayUsePMap.get(v);
            if (values == null) {
                values = HamtPMap.empty();
            }
            if ((newValues = values.plus(n, n)) != values) {
                this.mayUsePMap = this.mayUsePMap.plus(v, newValues);
            }
        }

        public void join(ReachingUses other) {
            this.mayUsePMap = this.mayUsePMap.reconcile(other.mayUsePMap, (var, thisVal, thatVal) -> {
                if (thisVal == null) {
                    return thatVal;
                }
                if (thatVal == null) {
                    return thisVal;
                }
                return thisVal.reconcile(thatVal, (node, unused1, unused2) -> node);
            });
        }

        public boolean equals(Object other) {
            return other instanceof ReachingUses && ((ReachingUses)other).mayUsePMap.equivalent(this.mayUsePMap, ReachingUses::equalMaps);
        }

        private static boolean equalMaps(PMap<Node, Node> map1, PMap<Node, Node> map2) {
            return map1 == map2 || map1.equivalent(map2, ReachingUses::equalNodes);
        }

        private static boolean equalNodes(Node n1, Node n2) {
            return n1 == n2;
        }

        public int hashCode() {
            throw new UnsupportedOperationException("the hashcode of this object is not stable");
        }
    }
}

