/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckJSDoc;
import com.google.javascript.jscomp.CheckSideEffects;
import com.google.javascript.jscomp.CheckSuper;
import com.google.javascript.jscomp.CheckTypeImportCodeReferences;
import com.google.javascript.jscomp.ClosureCheckModule;
import com.google.javascript.jscomp.ClosureRewriteClass;
import com.google.javascript.jscomp.CombinedCompilerPass;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DefaultPassConfig;
import com.google.javascript.jscomp.GatherModuleMetadata;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PassListBuilder;
import com.google.javascript.jscomp.VariableReferenceCheck;
import com.google.javascript.jscomp.lint.CheckConstPrivateProperties;
import com.google.javascript.jscomp.lint.CheckConstantCaseNames;
import com.google.javascript.jscomp.lint.CheckDefaultExportOfGoogModule;
import com.google.javascript.jscomp.lint.CheckDuplicateCase;
import com.google.javascript.jscomp.lint.CheckEmptyStatements;
import com.google.javascript.jscomp.lint.CheckEnums;
import com.google.javascript.jscomp.lint.CheckExtraRequires;
import com.google.javascript.jscomp.lint.CheckGoogModuleTypeScriptName;
import com.google.javascript.jscomp.lint.CheckInterfaces;
import com.google.javascript.jscomp.lint.CheckJSDocStyle;
import com.google.javascript.jscomp.lint.CheckMissingSemicolon;
import com.google.javascript.jscomp.lint.CheckNullabilityModifiers;
import com.google.javascript.jscomp.lint.CheckPrimitiveAsObject;
import com.google.javascript.jscomp.lint.CheckPrototypeProperties;
import com.google.javascript.jscomp.lint.CheckProvidesSorted;
import com.google.javascript.jscomp.lint.CheckRequiresSorted;
import com.google.javascript.jscomp.lint.CheckUnusedLabels;
import com.google.javascript.jscomp.lint.CheckUnusedPrivateProperties;
import com.google.javascript.jscomp.lint.CheckUselessBlocks;
import com.google.javascript.jscomp.lint.CheckVar;
import java.util.List;

class LintPassConfig
extends PassConfig.PassConfigDelegate {
    private final PassFactory gatherModuleMetadataPass = PassFactory.builder().setName("gatherModuleMetadata").setInternalFactory(compiler -> new GatherModuleMetadata((AbstractCompiler)compiler, compiler.getOptions().getProcessCommonJSModules(), compiler.getOptions().getModuleResolutionMode())).build();
    private final PassFactory earlyLintChecks = PassFactory.builder().setName("earlyLintChecks").setInternalFactory(compiler -> new CombinedCompilerPass((AbstractCompiler)compiler, (List<NodeTraversal.Callback>)ImmutableList.of((Object)new CheckConstPrivateProperties((AbstractCompiler)compiler), (Object)new CheckConstantCaseNames((AbstractCompiler)compiler), (Object)new CheckDefaultExportOfGoogModule((AbstractCompiler)compiler), (Object)new CheckDuplicateCase((AbstractCompiler)compiler), (Object)new CheckEmptyStatements((AbstractCompiler)compiler), (Object)new CheckEnums((AbstractCompiler)compiler), (Object)new CheckExtraRequires((AbstractCompiler)compiler, this.options.getUnusedImportsToRemove()), (Object)new CheckGoogModuleTypeScriptName((AbstractCompiler)compiler), (Object)new CheckJSDocStyle((AbstractCompiler)compiler), (Object)new CheckJSDoc((AbstractCompiler)compiler), (Object)new CheckMissingSemicolon((AbstractCompiler)compiler), (Object)new CheckSuper((AbstractCompiler)compiler), (Object[])new NodeTraversal.Callback[]{new CheckPrimitiveAsObject((AbstractCompiler)compiler), new ClosureCheckModule((AbstractCompiler)compiler, compiler.getModuleMetadataMap()), new CheckNullabilityModifiers((AbstractCompiler)compiler), new CheckProvidesSorted(CheckProvidesSorted.Mode.COLLECT_AND_REPORT), new CheckRequiresSorted(CheckRequiresSorted.Mode.COLLECT_AND_REPORT), new CheckSideEffects((AbstractCompiler)compiler, true, false), new CheckTypeImportCodeReferences((AbstractCompiler)compiler), new CheckUnusedLabels((AbstractCompiler)compiler), new CheckUnusedPrivateProperties((AbstractCompiler)compiler), new CheckUselessBlocks((AbstractCompiler)compiler), new CheckVar((AbstractCompiler)compiler)}))).build();
    private final PassFactory variableReferenceCheck = PassFactory.builder().setName("variableReferenceCheck").setRunInFixedPointLoop(true).setInternalFactory(VariableReferenceCheck::new).build();
    private final PassFactory closureRewriteClass = PassFactory.builder().setName("closureRewriteClass").setInternalFactory(ClosureRewriteClass::new).build();
    private final PassFactory lateLintChecks = PassFactory.builder().setName("lateLintChecks").setInternalFactory(compiler -> new CombinedCompilerPass((AbstractCompiler)compiler, (List<NodeTraversal.Callback>)ImmutableList.of((Object)new CheckInterfaces((AbstractCompiler)compiler), (Object)new CheckPrototypeProperties((AbstractCompiler)compiler)))).build();

    LintPassConfig(CompilerOptions options) {
        super(new DefaultPassConfig(options));
    }

    @Override
    protected PassListBuilder getChecks() {
        PassListBuilder passes = new PassListBuilder(this.options);
        passes.maybeAdd(this.gatherModuleMetadataPass);
        passes.maybeAdd(this.earlyLintChecks);
        passes.maybeAdd(this.variableReferenceCheck);
        passes.maybeAdd(this.closureRewriteClass);
        passes.maybeAdd(this.lateLintChecks);
        return passes;
    }

    @Override
    protected PassListBuilder getOptimizations() {
        return new PassListBuilder(this.options);
    }

    @Override
    protected PassListBuilder getFinalizations() {
        return new PassListBuilder(this.options);
    }
}

