/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Es6TemplateLiterals;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.TranspilationUtil;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.nullness.Nullable;

public final class LateEs6ToEs3Converter
implements NodeTraversal.Callback,
CompilerPass {
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final Es6TemplateLiterals templateLiteralConverter;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.COMPUTED_PROPERTIES, FeatureSet.Feature.MEMBER_DECLARATIONS, FeatureSet.Feature.TEMPLATE_LITERALS);
    private @Nullable Node templateLitInsertionPoint = null;
    private static final String FRESH_COMP_PROP_VAR = "$jscomp$compprop";

    public LateEs6ToEs3Converter(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.templateLiteralConverter = new Es6TemplateLiterals(compiler);
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case SCRIPT: {
                this.templateLitInsertionPoint = n.getFirstChild();
                break;
            }
            case GETTER_DEF: 
            case SETTER_DEF: {
                if (!FeatureSet.ES3.contains(this.compiler.getOptions().getOutputFeatureSet())) break;
                TranspilationUtil.cannotConvert(this.compiler, n, "ES5 getters/setters (consider using --language_out=ES5)");
                return false;
            }
            case FUNCTION: {
                if (!n.isAsyncFunction()) break;
                throw new IllegalStateException("async functions should have already been converted");
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case ASSIGN: {
                QualifiedName qName;
                Node lhs = n.getFirstChild();
                Node rhs = n.getSecondChild();
                if (!lhs.isGetProp() || !rhs.isFunction() || !lhs.getFirstChild().isName() || !(qName = QualifiedName.of("$jscomp.createTemplateTagFirstArgWithRaw")).matches(lhs)) break;
                Preconditions.checkNotNull((Object)n.getParent(), (Object)n);
                Preconditions.checkState((boolean)n.getParent().isExprResult(), (Object)n);
                this.templateLitInsertionPoint = n.getParent().getNext();
                break;
            }
            case OBJECTLIT: {
                this.visitObject(n);
                break;
            }
            case MEMBER_FUNCTION_DEF: {
                if (!parent.isObjectLit()) break;
                this.visitMemberFunctionDefInObjectLit(n);
                break;
            }
            case TAGGED_TEMPLATELIT: {
                this.templateLiteralConverter.visitTaggedTemplateLiteral(t, n, this.templateLitInsertionPoint);
                break;
            }
            case TEMPLATELIT: {
                if (parent.isTaggedTemplateLit()) break;
                this.templateLiteralConverter.visitTemplateLiteral(t, n);
                break;
            }
        }
    }

    private void visitMemberFunctionDefInObjectLit(Node n) {
        String name = n.getString();
        Node nameNode = n.getFirstFirstChild();
        Node stringKey = this.astFactory.createStringKey(name, n.removeFirstChild());
        stringKey.setJSDocInfo(n.getJSDocInfo());
        n.replaceWith(stringKey);
        stringKey.srcref(nameNode);
        this.compiler.reportChangeToEnclosingScope(stringKey);
    }

    private void visitObject(Node obj) {
        for (Node child = obj.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isComputedProp()) continue;
            this.visitObjectWithComputedProperty(obj);
            return;
        }
    }

    private void visitObjectWithComputedProperty(Node obj) {
        Preconditions.checkArgument((boolean)obj.isObjectLit());
        List<Node> props = new ArrayList();
        Node currElement = obj.getFirstChild();
        AstFactory.Type objectType = AstFactory.type(obj);
        while (currElement != null) {
            if (currElement.getBooleanProp(Node.COMPUTED_PROP_GETTER) || currElement.getBooleanProp(Node.COMPUTED_PROP_SETTER)) {
                TranspilationUtil.cannotConvertYet(this.compiler, currElement, "computed getter/setter in an object literal");
                return;
            }
            if (currElement.isGetterDef() || currElement.isSetterDef()) {
                currElement = currElement.getNext();
                continue;
            }
            Node nextNode = currElement.getNext();
            currElement.detach();
            props.add(currElement);
            currElement = nextNode;
        }
        String objName = FRESH_COMP_PROP_VAR + (String)this.compiler.getUniqueNameIdSupplier().get();
        props = Lists.reverse(props);
        Node result = this.astFactory.createName(objName, objectType);
        for (Node propdef : props) {
            if (propdef.isComputedProp()) {
                Node propertyExpression = propdef.removeFirstChild();
                Node value = propdef.removeFirstChild();
                result = this.astFactory.createComma(this.astFactory.createAssign(this.astFactory.createGetElem(this.astFactory.createName(objName, objectType), propertyExpression), value), result);
                continue;
            }
            Node val = propdef.removeFirstChild();
            boolean isQuotedAccess = propdef.isQuotedString();
            propdef.setToken(Token.STRINGLIT);
            propdef.setColor(StandardColors.STRING);
            propdef.putBooleanProp(Node.QUOTED_PROP, false);
            Node objNameNode = this.astFactory.createName(objName, objectType);
            Node access = isQuotedAccess ? this.astFactory.createGetElem(objNameNode, propdef) : this.astFactory.createGetProp(objNameNode, propdef.getString(), AstFactory.type(propdef));
            result = this.astFactory.createComma(this.astFactory.createAssign(access, val), result);
        }
        Node statement = obj;
        while (!NodeUtil.isStatement(statement)) {
            statement = statement.getParent();
        }
        result.srcrefTreeIfMissing(obj);
        obj.replaceWith(result);
        Node var = IR.var(this.astFactory.createName(objName, objectType), obj);
        var.srcrefTreeIfMissing(statement);
        var.insertBefore(statement);
        this.compiler.reportChangeToEnclosingScope(var);
    }
}

