/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.debugging.sourcemap.proto.Mapping;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.JsMessageDefinition;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.base.format.SimpleFormat;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jspecify.nullness.Nullable;

@GwtIncompatible(value="JsMessage, java.util.regex")
public abstract class JsMessageVisitor
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private static final String MSG_FUNCTION_NAME = "goog.getMsg";
    private static final String MSG_FALLBACK_FUNCTION_NAME = "goog.getMsgWithFallback";
    private static final String MSG_EXTERNAL_PREFIX = "MSG_EXTERNAL_";
    static final DiagnosticType MESSAGE_HAS_NO_DESCRIPTION = DiagnosticType.warning("JSC_MSG_HAS_NO_DESCRIPTION", "Message {0} has no description. Add @desc JsDoc tag.");
    static final DiagnosticType MESSAGE_HAS_NO_TEXT = DiagnosticType.warning("JSC_MSG_HAS_NO_TEXT", "Message value of {0} is just an empty string. Empty messages are forbidden.");
    public static final DiagnosticType MESSAGE_TREE_MALFORMED = DiagnosticType.error("JSC_MSG_TREE_MALFORMED", "Message parse tree malformed. {0}");
    static final DiagnosticType MESSAGE_HAS_NO_VALUE = DiagnosticType.error("JSC_MSG_HAS_NO_VALUE", "message node {0} has no value");
    static final DiagnosticType MESSAGE_DUPLICATE_KEY = DiagnosticType.error("JSC_MSG_KEY_DUPLICATED", "duplicate message variable name found for {0}, initial definition {1}:{2}");
    static final DiagnosticType MESSAGE_NODE_IS_ORPHANED = DiagnosticType.error("JSC_MSG_ORPHANED_NODE", "goog.getMsg() function could be used only with MSG_* property or variable");
    public static final DiagnosticType MESSAGE_NOT_INITIALIZED_CORRECTLY = DiagnosticType.warning("JSC_MSG_NOT_INITIALIZED_CORRECTLY", "message not initialized using goog.getMsg");
    public static final DiagnosticType BAD_FALLBACK_SYNTAX = DiagnosticType.error("JSC_MSG_BAD_FALLBACK_SYNTAX", SimpleFormat.format("Bad syntax. Expected syntax: %s(MSG_1, MSG_2)", "goog.getMsgWithFallback"));
    public static final DiagnosticType FALLBACK_ARG_ERROR = DiagnosticType.error("JSC_MSG_FALLBACK_ARG_ERROR", "Could not find message entry for fallback argument {0}");
    static final String MSG_PREFIX = "MSG_";
    private static final Pattern SCOPED_ALIASES_PREFIX_PATTERN = Pattern.compile("\\$jscomp\\$scope\\$\\S+\\$MSG_");
    private static final Pattern MSG_UNNAMED_PATTERN = Pattern.compile("MSG_UNNAMED.*");
    private final JsMessage.IdGenerator idGenerator;
    final AbstractCompiler compiler;
    private final Map<String, MessageLocation> messageNames = new LinkedHashMap<String, MessageLocation>();
    private final Map<Var, JsMessage> unnamedMessages = new LinkedHashMap<Var, JsMessage>();
    private final Set<Node> googMsgNodes = new LinkedHashSet<Node>();
    private static final ImmutableSet<String> MESSAGE_OPTION_NAMES = ImmutableSet.of((Object)"html", (Object)"unescapeHtmlEntities", (Object)"example", (Object)"original_code");

    protected JsMessageVisitor(AbstractCompiler compiler, JsMessage.IdGenerator idGenerator) {
        this.compiler = compiler;
        this.idGenerator = idGenerator;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        for (Node msgNode : this.googMsgNodes) {
            this.compiler.report(JSError.make(msgNode, MESSAGE_NODE_IS_ORPHANED, new String[0]));
        }
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node unused) {
        this.collectGetMsgCall(traversal, node);
        this.checkMessageInitialization(traversal, node);
    }

    private void checkMessageInitialization(NodeTraversal traversal, Node node) {
        String desc;
        String messageKeyFinal;
        String messageId;
        boolean isExternal;
        boolean isAnonymous;
        CallNodeMsgData callNodeMsgData;
        String alternateMessageId;
        String meaning;
        String description;
        boolean msgNodeIsACall;
        JSDocInfo jsDocInfo;
        Node msgNode;
        String originalMessageKey;
        String possiblyObfuscatedMessageKey;
        Node parent = node.getParent();
        switch (node.getToken()) {
            case NAME: {
                if (parent == null || !NodeUtil.isNameDeclaration(parent)) {
                    return;
                }
                possiblyObfuscatedMessageKey = node.getString();
                originalMessageKey = node.getOriginalName();
                msgNode = node.getFirstChild();
                jsDocInfo = parent.getJSDocInfo();
                break;
            }
            case ASSIGN: {
                Node getProp = node.getFirstChild();
                if (!getProp.isGetProp()) {
                    return;
                }
                possiblyObfuscatedMessageKey = getProp.getString();
                originalMessageKey = getProp.getOriginalName();
                msgNode = node.getLastChild();
                jsDocInfo = node.getJSDocInfo();
                break;
            }
            case STRING_KEY: {
                if (node.isQuotedString() || !node.hasChildren() || parent.isObjectPattern()) {
                    return;
                }
                Preconditions.checkState((boolean)parent.isObjectLit(), (Object)parent);
                possiblyObfuscatedMessageKey = node.getString();
                originalMessageKey = node.getOriginalName();
                msgNode = node.getFirstChild();
                jsDocInfo = node.getJSDocInfo();
                break;
            }
            default: {
                return;
            }
        }
        String messageKeyFromLhs = originalMessageKey != null ? originalMessageKey : possiblyObfuscatedMessageKey;
        boolean bl = msgNodeIsACall = msgNode != null && msgNode.isCall();
        if (!this.isMessageName(messageKeyFromLhs)) {
            return;
        }
        if (msgNode == null) {
            this.compiler.report(JSError.make(node, MESSAGE_HAS_NO_VALUE, messageKeyFromLhs));
            return;
        }
        if (JsMessageVisitor.isLegalMessageVarAlias(msgNode)) {
            return;
        }
        if (!msgNodeIsACall) {
            this.compiler.report(JSError.make(node, MESSAGE_NOT_INITIALIZED_CORRECTLY, new String[0]));
            return;
        }
        this.googMsgNodes.remove(msgNode);
        Mapping.OriginalMapping mapping = this.compiler.getSourceMapping(traversal.getSourceName(), node.getLineno(), node.getCharno());
        String sourceName = mapping != null ? mapping.getOriginalFile() + ":" + mapping.getLineNumber() : traversal.getSourceName() + ":" + node.getLineno();
        if (jsDocInfo != null) {
            description = jsDocInfo.getDescription();
            meaning = jsDocInfo.getMeaning();
            alternateMessageId = jsDocInfo.getAlternateMessageId();
        } else {
            description = null;
            meaning = null;
            alternateMessageId = null;
        }
        try {
            callNodeMsgData = this.extractCallNodeMsgData(msgNode);
        }
        catch (MalformedException ex) {
            this.compiler.report(JSError.make(ex.getNode(), MESSAGE_TREE_MALFORMED, ex.getMessage()));
            return;
        }
        String messageText = callNodeMsgData.getMessageText();
        ImmutableList<JsMessage.Part> messageParts = callNodeMsgData.getMessageParts();
        String externalMessageId = JsMessageVisitor.getExternalMessageId(messageKeyFromLhs);
        if (externalMessageId != null) {
            isAnonymous = false;
            isExternal = true;
            messageId = externalMessageId;
            messageKeyFinal = messageKeyFromLhs;
        } else {
            isExternal = false;
            String meaningForIdGeneration = meaning;
            if (JsMessageVisitor.isUnnamedMessageName(messageKeyFromLhs)) {
                isAnonymous = true;
                messageKeyFinal = this.generateKeyFromMessageText(messageText);
                if (meaningForIdGeneration == null) {
                    meaningForIdGeneration = messageKeyFinal;
                }
            } else {
                isAnonymous = false;
                messageKeyFinal = messageKeyFromLhs;
                if (meaningForIdGeneration == null) {
                    meaningForIdGeneration = JsMessageVisitor.removeScopedAliasesPrefix(messageKeyFromLhs);
                }
            }
            messageId = this.idGenerator == null ? meaningForIdGeneration : this.idGenerator.generateId(meaningForIdGeneration, (List<JsMessage.Part>)messageParts);
        }
        JsMessage extractedMessage = new JsMessage.Builder().appendParts((List<JsMessage.Part>)messageParts).setPlaceholderNameToExampleMap((Map<String, String>)callNodeMsgData.getPlaceholderExampleMap()).setPlaceholderNameToOriginalCodeMap((Map<String, String>)callNodeMsgData.getPlaceholderOriginalCodeMap()).setIsAnonymous(isAnonymous).setIsExternalMsg(isExternal).setKey(messageKeyFinal).setSourceName(sourceName).setDesc(description).setMeaning(meaning).setAlternateId(alternateMessageId).setId(messageId).build();
        if (!extractedMessage.isAnonymous() && !extractedMessage.isExternal()) {
            this.checkIfMessageDuplicated(extractedMessage.getKey(), msgNode);
        }
        if (extractedMessage.isAnonymous()) {
            this.trackUnnamedMessage(traversal, extractedMessage, possiblyObfuscatedMessageKey);
        } else {
            this.trackNormalMessage(extractedMessage, extractedMessage.getKey(), msgNode);
        }
        if (extractedMessage.isEmpty()) {
            this.compiler.report(JSError.make(node, MESSAGE_HAS_NO_TEXT, extractedMessage.getKey()));
        }
        if (((desc = extractedMessage.getDesc()) == null || desc.trim().isEmpty()) && !extractedMessage.isExternal()) {
            this.compiler.report(JSError.make(node, MESSAGE_HAS_NO_DESCRIPTION, extractedMessage.getKey()));
        }
        JsMessageDefinition msgDefinition = new JsMessageDefinition(){

            @Override
            public Node getMessageNode() {
                return msgNode;
            }

            @Override
            public Node getTemplateTextNode() {
                return callNodeMsgData.getTemplateTextNode();
            }

            @Override
            public @Nullable Node getPlaceholderValuesNode() {
                return callNodeMsgData.getPlaceholderValuesNode();
            }

            @Override
            public ImmutableMap<String, Node> getPlaceholderValueMap() {
                return callNodeMsgData.getPlaceholderValueMap();
            }

            @Override
            public boolean shouldEscapeLessThan() {
                return callNodeMsgData.shouldEscapeLessThan();
            }

            @Override
            public boolean shouldUnescapeHtmlEntities() {
                return callNodeMsgData.shouldUnescapeHtmlEntities();
            }
        };
        this.processJsMessage(extractedMessage, msgDefinition);
    }

    public static @Nullable String getExternalMessageId(String messageKey) {
        if (messageKey.startsWith(MSG_EXTERNAL_PREFIX)) {
            int start;
            char c;
            int end;
            for (end = start = MSG_EXTERNAL_PREFIX.length(); end < messageKey.length() && (c = messageKey.charAt(end)) <= '9' && c >= '0'; ++end) {
            }
            if (end > start) {
                return messageKey.substring(start, end);
            }
        }
        return null;
    }

    private String generateKeyFromMessageText(String msgText) {
        long nonnegativeHash = Long.MAX_VALUE & JsMessage.Hash.hash64(msgText);
        return MSG_PREFIX + Ascii.toUpperCase((String)Long.toString(nonnegativeHash, 36));
    }

    private void collectGetMsgCall(NodeTraversal traversal, Node call) {
        if (!call.isCall()) {
            return;
        }
        if (call.getFirstChild().matchesQualifiedName(MSG_FUNCTION_NAME)) {
            this.googMsgNodes.add(call);
        } else if (call.getFirstChild().matchesQualifiedName(MSG_FALLBACK_FUNCTION_NAME)) {
            this.visitFallbackFunctionCall(traversal, call);
        }
    }

    private void trackNormalMessage(JsMessage message, String msgName, Node msgNode) {
        MessageLocation location = new MessageLocation(message, msgNode);
        this.messageNames.put(msgName, location);
    }

    private void trackUnnamedMessage(NodeTraversal t, JsMessage message, String msgNameInScope) {
        Var var = (Var)t.getScope().getVar(msgNameInScope);
        if (var != null) {
            this.unnamedMessages.put(var, message);
        }
    }

    private static boolean isLegalMessageVarAlias(Node msgNode) {
        String originalName;
        if (msgNode.isGetProp() && msgNode.isQualifiedName() && msgNode.getString().startsWith(MSG_PREFIX)) {
            return true;
        }
        if (!msgNode.isName()) {
            return false;
        }
        String string = originalName = msgNode.getOriginalName() != null ? msgNode.getOriginalName() : msgNode.getString();
        return originalName.startsWith(MSG_PREFIX);
    }

    private @Nullable JsMessage getTrackedUnnamedMessage(NodeTraversal t, String msgNameInScope) {
        Var var = (Var)t.getScope().getVar(msgNameInScope);
        if (var != null) {
            return this.unnamedMessages.get(var);
        }
        return null;
    }

    private @Nullable JsMessage getTrackedNormalMessage(String msgName) {
        MessageLocation location = this.messageNames.get(msgName);
        return location == null ? null : location.message;
    }

    private void checkIfMessageDuplicated(String msgName, Node msgNode) {
        if (this.messageNames.containsKey(msgName)) {
            MessageLocation location = this.messageNames.get(msgName);
            this.compiler.report(JSError.make(msgNode, MESSAGE_DUPLICATE_KEY, msgName, location.messageNode.getSourceFileName(), Integer.toString(location.messageNode.getLineno())));
        }
    }

    private static String extractStringFromStringExprNode(Node node) throws MalformedException {
        switch (node.getToken()) {
            case STRINGLIT: {
                return node.getString();
            }
            case TEMPLATELIT: {
                if (node.hasOneChild()) {
                    return (String)Preconditions.checkNotNull((Object)node.getFirstChild().getCookedString());
                }
                throw new MalformedException("Template literals with substitutions are not allowed.", node);
            }
            case ADD: {
                StringBuilder sb = new StringBuilder();
                for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
                    sb.append(JsMessageVisitor.extractStringFromStringExprNode(child));
                }
                return sb.toString();
            }
        }
        throw new MalformedException("literal string or concatenation expected", node);
    }

    private CallNodeMsgData extractCallNodeMsgData(Node node) throws MalformedException {
        Preconditions.checkState((boolean)node.isCall());
        Node fnNameNode = node.getFirstChild();
        if (fnNameNode.matchesQualifiedName(MSG_FUNCTION_NAME)) {
            return this.extractGoogGetMsgData(node);
        }
        throw new MalformedException("Message initialized using unrecognized function. Please use goog.getMsg() instead.", fnNameNode);
    }

    private CallNodeMsgData extractGoogGetMsgData(Node callNode) throws MalformedException {
        GoogGetMsgParsedText googGetMsgParsedText;
        final Node msgTextNode = callNode.getSecondChild();
        if (msgTextNode == null) {
            throw new MalformedException("Message string literal expected", callNode);
        }
        final Node valuesObjLit = msgTextNode.getNext();
        Node optionsBagArgument = valuesObjLit == null ? null : valuesObjLit.getNext();
        String msgTextString = JsMessageVisitor.extractStringFromStringExprNode(msgTextNode);
        try {
            googGetMsgParsedText = JsMessageVisitor.extractGoogGetMsgParsedText(msgTextString);
        }
        catch (JsMessage.PlaceholderFormatException e) {
            throw new MalformedException(e.getMessage(), msgTextNode);
        }
        ObjectLiteralMap placeholderObjectLiteralMap = JsMessageVisitor.extractObjectLiteralMap(valuesObjLit);
        ImmutableSet<String> placeholderNamesFromText = googGetMsgParsedText.getPlaceholderNames();
        placeholderObjectLiteralMap.checkForRequiredKeys((Set<String>)placeholderNamesFromText, placeholderName -> new MalformedException("Unrecognized message placeholder referenced: " + placeholderName, msgTextNode));
        placeholderObjectLiteralMap.checkForUnexpectedKeys((Set<String>)placeholderNamesFromText, placeholderName -> "Unused message placeholder: " + placeholderName);
        final ImmutableMap<String, Node> placeholderValuesMap = placeholderObjectLiteralMap.extractValueMap();
        final JsMessageOptions jsMessageOptions = this.extractJsMessageOptions(optionsBagArgument);
        jsMessageOptions.checkForUnknownPlaceholders((Set<String>)placeholderNamesFromText);
        return new CallNodeMsgData(){

            @Override
            public Node getTemplateTextNode() {
                return msgTextNode;
            }

            @Override
            public String getMessageText() {
                return googGetMsgParsedText.getText();
            }

            @Override
            public ImmutableList<JsMessage.Part> getMessageParts() {
                return googGetMsgParsedText.getParts();
            }

            @Override
            public Node getPlaceholderValuesNode() {
                return valuesObjLit;
            }

            @Override
            public ImmutableMap<String, Node> getPlaceholderValueMap() {
                return placeholderValuesMap;
            }

            @Override
            public ImmutableMap<String, String> getPlaceholderExampleMap() {
                return jsMessageOptions.getPlaceholderExampleMap();
            }

            @Override
            public ImmutableMap<String, String> getPlaceholderOriginalCodeMap() {
                return jsMessageOptions.getPlaceholderOriginalCodeMap();
            }

            @Override
            public boolean shouldEscapeLessThan() {
                return jsMessageOptions.isEscapeLessThan();
            }

            @Override
            public boolean shouldUnescapeHtmlEntities() {
                return jsMessageOptions.isUnescapeHtmlEntities();
            }
        };
    }

    private JsMessageOptions extractJsMessageOptions(@Nullable Node optionsBag) throws MalformedException {
        ObjectLiteralMap objectLiteralMap = JsMessageVisitor.extractObjectLiteralMap(optionsBag);
        objectLiteralMap.checkForUnexpectedKeys((Set<String>)MESSAGE_OPTION_NAMES, optionName -> "Unknown option: " + optionName);
        final boolean isEscapeLessThan = objectLiteralMap.getBooleanValueOrFalse("html");
        final boolean isUnescapeHtmlEntities = objectLiteralMap.getBooleanValueOrFalse("unescapeHtmlEntities");
        Node exampleValueNode = objectLiteralMap.getValueNode("example");
        final ObjectLiteralMap exampleObjectLiteralMap = JsMessageVisitor.extractObjectLiteralMap(exampleValueNode);
        final ImmutableMap<String, String> placeholderExamplesMap = exampleObjectLiteralMap.extractStringToStringMap();
        Node originalCodeValueNode = objectLiteralMap.getValueNode("original_code");
        final ObjectLiteralMap originalCodeObjectLiteralMap = JsMessageVisitor.extractObjectLiteralMap(originalCodeValueNode);
        final ImmutableMap<String, String> placeholderOriginalCodeMap = originalCodeObjectLiteralMap.extractStringToStringMap();
        return new JsMessageOptions(){

            @Override
            public boolean isEscapeLessThan() {
                return isEscapeLessThan;
            }

            @Override
            public boolean isUnescapeHtmlEntities() {
                return isUnescapeHtmlEntities;
            }

            @Override
            public ImmutableMap<String, String> getPlaceholderExampleMap() {
                return placeholderExamplesMap;
            }

            @Override
            public ImmutableMap<String, String> getPlaceholderOriginalCodeMap() {
                return placeholderOriginalCodeMap;
            }

            @Override
            public void checkForUnknownPlaceholders(Set<String> knownPlaceholders) throws MalformedException {
                exampleObjectLiteralMap.checkForUnexpectedKeys(knownPlaceholders, unknownName -> "Unknown placeholder: " + unknownName);
                originalCodeObjectLiteralMap.checkForUnexpectedKeys(knownPlaceholders, unknownName -> "Unknown placeholder: " + unknownName);
            }
        };
    }

    private static boolean extractBooleanStringKeyValue(@Nullable Node stringKeyNode) throws MalformedException {
        if (stringKeyNode == null) {
            return false;
        }
        Node valueNode = stringKeyNode.getOnlyChild();
        if (valueNode.isTrue()) {
            return true;
        }
        if (valueNode.isFalse()) {
            return false;
        }
        throw new MalformedException(stringKeyNode.getString() + ": Literal true or false expected", valueNode);
    }

    public static ObjectLiteralMap extractObjectLiteralMap(@Nullable Node objLit) throws MalformedException {
        if (objLit == null) {
            return new ObjectLiteralMapImpl((Map<String, Node>)ImmutableMap.of());
        }
        if (!objLit.isObjectLit()) {
            throw new MalformedException("object literal expected", objLit);
        }
        LinkedHashMap<String, Node> stringToStringKeyMap = new LinkedHashMap<String, Node>();
        for (Node stringKey = objLit.getFirstChild(); stringKey != null; stringKey = stringKey.getNext()) {
            if (!stringKey.isStringKey()) {
                throw new MalformedException("string key expected", stringKey);
            }
            String key = stringKey.getString();
            if (stringToStringKeyMap.containsKey(key)) {
                throw new MalformedException("duplicate string key: " + key, stringKey);
            }
            stringToStringKeyMap.put(stringKey.getString(), stringKey);
        }
        return new ObjectLiteralMapImpl(stringToStringKeyMap);
    }

    public static ImmutableList<JsMessage.Part> parseJsMessageTextIntoParts(String originalMsgText) throws JsMessage.PlaceholderFormatException {
        GoogGetMsgParsedText googGetMsgParsedText = JsMessageVisitor.extractGoogGetMsgParsedText(originalMsgText);
        return googGetMsgParsedText.getParts();
    }

    private static GoogGetMsgParsedText extractGoogGetMsgParsedText(final String originalMsgText) throws JsMessage.PlaceholderFormatException {
        String msgText = originalMsgText;
        ImmutableList.Builder partsBuilder = ImmutableList.builder();
        ImmutableSet.Builder placeholderNamesBuilder = ImmutableSet.builder();
        while (true) {
            int phEnd;
            int phBegin;
            if ((phBegin = msgText.indexOf("{$")) < 0) {
                partsBuilder.add((Object)JsMessage.StringPart.create(msgText));
                break;
            }
            if (phBegin > 0) {
                partsBuilder.add((Object)JsMessage.StringPart.create(msgText.substring(0, phBegin)));
            }
            if ((phEnd = msgText.indexOf("}", phBegin)) < 0) {
                throw new JsMessage.PlaceholderFormatException("Placeholder incorrectly formatted");
            }
            String phName = msgText.substring(phBegin + "{$".length(), phEnd);
            if (!JsMessage.isLowerCamelCaseWithNumericSuffixes(phName)) {
                throw new JsMessage.PlaceholderFormatException("Placeholder name not in lowerCamelCase: " + phName);
            }
            placeholderNamesBuilder.add((Object)phName);
            partsBuilder.add((Object)JsMessage.PlaceholderReference.createForJsName(phName));
            int nextPos = phEnd + "}".length();
            if (nextPos >= msgText.length()) break;
            msgText = msgText.substring(nextPos);
        }
        final ImmutableSet placeholderNames = placeholderNamesBuilder.build();
        final ImmutableList parts = partsBuilder.build();
        return new GoogGetMsgParsedText(){

            @Override
            public String getText() {
                return originalMsgText;
            }

            @Override
            public ImmutableSet<String> getPlaceholderNames() {
                return placeholderNames;
            }

            @Override
            public ImmutableList<JsMessage.Part> getParts() {
                return parts;
            }
        };
    }

    private void visitFallbackFunctionCall(NodeTraversal t, Node call) {
        if (!(call.hasXChildren(3) && JsMessageVisitor.isMessageIdentifier(call.getSecondChild()) && JsMessageVisitor.isMessageIdentifier(call.getLastChild()))) {
            this.compiler.report(JSError.make(call, BAD_FALLBACK_SYNTAX, new String[0]));
            return;
        }
        Node firstArg = call.getSecondChild();
        JsMessage firstMessage = this.getJsMessageFromNode(t, firstArg);
        if (firstMessage == null) {
            this.compiler.report(JSError.make(firstArg, FALLBACK_ARG_ERROR, firstArg.getQualifiedName()));
            return;
        }
        Node secondArg = firstArg.getNext();
        JsMessage secondMessage = this.getJsMessageFromNode(t, secondArg);
        if (secondMessage == null) {
            this.compiler.report(JSError.make(secondArg, FALLBACK_ARG_ERROR, secondArg.getQualifiedName()));
            return;
        }
        this.processMessageFallback(call, firstMessage, secondMessage);
    }

    protected abstract void processJsMessage(JsMessage var1, JsMessageDefinition var2);

    void processMessageFallback(Node callNode, JsMessage message1, JsMessage message2) {
    }

    boolean isMessageName(String identifier) {
        return identifier.startsWith(MSG_PREFIX) || JsMessageVisitor.isScopedAliasesPrefix(identifier);
    }

    private static boolean isMessageIdentifier(Node node) {
        String qname = node.getQualifiedName();
        return qname != null && qname.contains(MSG_PREFIX);
    }

    private @Nullable JsMessage getJsMessageFromNode(NodeTraversal t, Node node) {
        String messageName = node.getQualifiedName();
        if (messageName == null || !messageName.contains(MSG_PREFIX)) {
            return null;
        }
        String messageKey = messageName.substring(messageName.indexOf(MSG_PREFIX));
        if (JsMessageVisitor.isUnnamedMessageName(messageKey)) {
            return this.getTrackedUnnamedMessage(t, messageName);
        }
        return this.getTrackedNormalMessage(messageKey);
    }

    private static boolean isUnnamedMessageName(String identifier) {
        return MSG_UNNAMED_PATTERN.matcher(identifier).matches();
    }

    protected void checkNode(@Nullable Node node, Token type) throws MalformedException {
        if (node == null) {
            throw new MalformedException("Expected node type " + type + "; found: null", node);
        }
        if (node.getToken() != type) {
            throw new MalformedException("Expected node type " + type + "; found: " + node.getToken(), node);
        }
    }

    public static boolean isScopedAliasesPrefix(String name) {
        return SCOPED_ALIASES_PREFIX_PATTERN.matcher(name).lookingAt();
    }

    public static String removeScopedAliasesPrefix(String name) {
        return SCOPED_ALIASES_PREFIX_PATTERN.matcher(name).replaceFirst(MSG_PREFIX);
    }

    private static class MessageLocation {
        private final JsMessage message;
        private final Node messageNode;

        private MessageLocation(JsMessage message, Node messageNode) {
            this.message = message;
            this.messageNode = messageNode;
        }
    }

    static class MalformedException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final Node node;

        MalformedException(String message, Node node) {
            super(message);
            this.node = node;
        }

        Node getNode() {
            return this.node;
        }
    }

    private static interface GoogGetMsgParsedText {
        public String getText();

        public ImmutableSet<String> getPlaceholderNames();

        public ImmutableList<JsMessage.Part> getParts();
    }

    private static class ObjectLiteralMapImpl
    implements ObjectLiteralMap {
        private final Map<String, Node> stringToStringKeyMap;
        private ImmutableMap<String, Node> valueMap = null;
        private ImmutableMap<String, String> stringMap = null;

        private ObjectLiteralMapImpl(Map<String, Node> stringToStringKeyMap) {
            this.stringToStringKeyMap = stringToStringKeyMap;
        }

        @Override
        public @Nullable Node getValueNode(String key) {
            Node stringKeyNode = this.stringToStringKeyMap.get(key);
            return stringKeyNode == null ? null : stringKeyNode.getOnlyChild();
        }

        @Override
        public boolean getBooleanValueOrFalse(String key) throws MalformedException {
            Node stringKeyNode = this.stringToStringKeyMap.get(key);
            return JsMessageVisitor.extractBooleanStringKeyValue(stringKeyNode);
        }

        @Override
        public ImmutableMap<String, Node> extractValueMap() {
            if (this.valueMap == null) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry<String, Node> entry : this.stringToStringKeyMap.entrySet()) {
                    builder.put((Object)entry.getKey(), (Object)entry.getValue().getOnlyChild());
                }
                this.valueMap = builder.buildOrThrow();
            }
            return this.valueMap;
        }

        @Override
        public ImmutableMap<String, String> extractStringToStringMap() throws MalformedException {
            if (this.stringMap == null) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry<String, Node> entry : this.stringToStringKeyMap.entrySet()) {
                    builder.put((Object)entry.getKey(), (Object)JsMessageVisitor.extractStringFromStringExprNode(entry.getValue().getOnlyChild()));
                }
                this.stringMap = builder.buildOrThrow();
            }
            return this.stringMap;
        }

        @Override
        public void checkForUnexpectedKeys(Set<String> expectedKeys, Function<String, String> createErrorMessage) throws MalformedException {
            for (String key : this.stringToStringKeyMap.keySet()) {
                if (expectedKeys.contains(key)) continue;
                throw new MalformedException(createErrorMessage.apply(key), this.stringToStringKeyMap.get(key));
            }
        }

        @Override
        public void checkForRequiredKeys(Set<String> requiredKeys, Function<String, MalformedException> createException) throws MalformedException {
            for (String requiredKey : requiredKeys) {
                if (this.stringToStringKeyMap.containsKey(requiredKey)) continue;
                throw createException.apply(requiredKey);
            }
        }
    }

    public static interface ObjectLiteralMap {
        public boolean getBooleanValueOrFalse(String var1) throws MalformedException;

        public ImmutableMap<String, Node> extractValueMap();

        public ImmutableMap<String, String> extractStringToStringMap() throws MalformedException;

        public @Nullable Node getValueNode(String var1);

        public void checkForUnexpectedKeys(Set<String> var1, Function<String, String> var2) throws MalformedException;

        public void checkForRequiredKeys(Set<String> var1, Function<String, MalformedException> var2) throws MalformedException;
    }

    private static interface JsMessageOptions {
        public boolean isEscapeLessThan();

        public boolean isUnescapeHtmlEntities();

        public ImmutableMap<String, String> getPlaceholderExampleMap();

        public ImmutableMap<String, String> getPlaceholderOriginalCodeMap();

        public void checkForUnknownPlaceholders(Set<String> var1) throws MalformedException;
    }

    private static interface CallNodeMsgData {
        public Node getTemplateTextNode();

        public String getMessageText();

        public ImmutableList<JsMessage.Part> getMessageParts();

        public Node getPlaceholderValuesNode();

        public ImmutableMap<String, Node> getPlaceholderValueMap();

        public ImmutableMap<String, String> getPlaceholderExampleMap();

        public ImmutableMap<String, String> getPlaceholderOriginalCodeMap();

        public boolean shouldEscapeLessThan();

        public boolean shouldUnescapeHtmlEntities();
    }
}

