/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.jscomp.AutoValue_JsMessage;
import com.google.javascript.jscomp.AutoValue_JsMessage_PlaceholderReference;
import com.google.javascript.jscomp.AutoValue_JsMessage_StringPart;
import com.google.javascript.jscomp.base.format.SimpleFormat;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jspecify.nullness.Nullable;

@AutoValue
public abstract class JsMessage {
    public static final String PH_JS_PREFIX = "{$";
    public static final String PH_JS_SUFFIX = "}";
    private static final Pattern JS_PLACEHOLDER_NAME_RE = Pattern.compile("[a-z][a-zA-Z\\d]*[_\\d]*");
    private static final Pattern CANONICAL_PLACEHOLDER_NAME_RE = Pattern.compile("[A-Z\\d_]*");

    public abstract @Nullable String getSourceName();

    public abstract String getKey();

    public abstract boolean isAnonymous();

    public abstract boolean isExternal();

    public abstract String getId();

    public abstract ImmutableList<Part> getParts();

    public abstract @Nullable String getAlternateId();

    public abstract @Nullable String getDesc();

    public abstract @Nullable String getMeaning();

    public abstract boolean isHidden();

    public abstract ImmutableMap<String, String> getPlaceholderNameToExampleMap();

    public abstract ImmutableMap<String, String> getPlaceholderNameToOriginalCodeMap();

    public abstract ImmutableSet<String> jsPlaceholderNames();

    public String getPlaceholderOriginalCode(PlaceholderReference placeholderReference) {
        return (String)this.getPlaceholderNameToOriginalCodeMap().getOrDefault((Object)placeholderReference.getStoredPlaceholderName(), (Object)"-");
    }

    public String getPlaceholderExample(PlaceholderReference placeholderReference) {
        return (String)this.getPlaceholderNameToExampleMap().getOrDefault((Object)placeholderReference.getStoredPlaceholderName(), (Object)"-");
    }

    public String asJsMessageString() {
        StringBuilder sb = new StringBuilder();
        for (Part p : this.getParts()) {
            if (p.isPlaceholder()) {
                sb.append(PH_JS_PREFIX).append(p.getJsPlaceholderName()).append(PH_JS_SUFFIX);
                continue;
            }
            sb.append(p.getString());
        }
        return sb.toString();
    }

    public final String asIcuMessageString() {
        StringBuilder sb = new StringBuilder();
        for (Part p : this.getParts()) {
            if (p.isPlaceholder()) {
                sb.append('{').append(p.getCanonicalPlaceholderName()).append('}');
                continue;
            }
            sb.append(p.getString());
        }
        return sb.toString();
    }

    public final boolean isEmpty() {
        for (Part part : this.getParts()) {
            if (!part.isPlaceholder() && part.getString().length() <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCamelCaseWithNumericSuffixes(String input) {
        return JS_PLACEHOLDER_NAME_RE.matcher(input).matches();
    }

    public static String toLowerCamelCaseWithNumericSuffixes(String input) {
        int suffixStart = input.length();
        while (suffixStart > 0) {
            int numberStart;
            char ch = '\u0000';
            for (numberStart = suffixStart; numberStart > 0 && Character.isDigit(ch = input.charAt(numberStart - 1)); --numberStart) {
            }
            if (numberStart <= 0 || numberStart >= suffixStart || ch != '_') break;
            suffixStart = numberStart - 1;
        }
        if (suffixStart == input.length()) {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, input);
        }
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, input.substring(0, suffixStart)) + input.substring(suffixStart);
    }

    public static boolean isCanonicalPlaceholderNameFormat(String name) {
        return CANONICAL_PLACEHOLDER_NAME_RE.matcher(name).matches();
    }

    public static interface IdGenerator {
        public String generateId(String var1, List<Part> var2);
    }

    static final class Hash {
        private static final long SEED64 = 3141592653589793238L;
        private static final long CONSTANT64 = -2266404186210603134L;

        private Hash() {
        }

        static long hash64(@Nullable String value) {
            return Hash.hash64(value, 3141592653589793238L);
        }

        private static long hash64(@Nullable String value, long seed) {
            if (value == null) {
                return Hash.hash64(null, 0, 0, seed);
            }
            return Hash.hash64(value.getBytes(StandardCharsets.UTF_8), seed);
        }

        private static long hash64(byte[] value, long seed) {
            return Hash.hash64(value, 0, value == null ? 0 : value.length, seed);
        }

        private static long hash64(byte @Nullable [] value, int offset, int length, long seed) {
            long a;
            long b = a = -2266404186210603134L;
            long c = seed;
            int keylen = length;
            while (keylen >= 24) {
                a += Hash.word64At(value, offset);
                a -= (b += Hash.word64At(value, offset + 8));
                a -= (c += Hash.word64At(value, offset + 16));
                b -= c;
                b -= (a ^= c >>> 43);
                c -= a;
                c -= (b ^= a << 9);
                a -= b;
                a -= (c ^= b >>> 8);
                b -= c;
                b -= (a ^= c >>> 38);
                c -= a;
                c -= (b ^= a << 23);
                a -= b;
                a -= (c ^= b >>> 5);
                b -= c;
                b -= (a ^= c >>> 35);
                c -= a;
                c -= (b ^= a << 49);
                a -= b;
                a -= (c ^= b >>> 11);
                b -= c;
                b -= (a ^= c >>> 12);
                c -= a;
                c -= (b ^= a << 18);
                c ^= b >>> 22;
                keylen -= 24;
                offset += 24;
            }
            c += (long)length;
            if (keylen >= 16) {
                if (keylen == 23) {
                    c += (long)value[offset + 22] << 56;
                }
                if (keylen >= 22) {
                    c += ((long)value[offset + 21] & 0xFFL) << 48;
                }
                if (keylen >= 21) {
                    c += ((long)value[offset + 20] & 0xFFL) << 40;
                }
                if (keylen >= 20) {
                    c += ((long)value[offset + 19] & 0xFFL) << 32;
                }
                if (keylen >= 19) {
                    c += ((long)value[offset + 18] & 0xFFL) << 24;
                }
                if (keylen >= 18) {
                    c += ((long)value[offset + 17] & 0xFFL) << 16;
                }
                if (keylen >= 17) {
                    c += ((long)value[offset + 16] & 0xFFL) << 8;
                }
                if (keylen >= 16) {
                    b += Hash.word64At(value, offset + 8);
                    a += Hash.word64At(value, offset);
                }
            } else if (keylen >= 8) {
                if (keylen == 15) {
                    b += ((long)value[offset + 14] & 0xFFL) << 48;
                }
                if (keylen >= 14) {
                    b += ((long)value[offset + 13] & 0xFFL) << 40;
                }
                if (keylen >= 13) {
                    b += ((long)value[offset + 12] & 0xFFL) << 32;
                }
                if (keylen >= 12) {
                    b += ((long)value[offset + 11] & 0xFFL) << 24;
                }
                if (keylen >= 11) {
                    b += ((long)value[offset + 10] & 0xFFL) << 16;
                }
                if (keylen >= 10) {
                    b += ((long)value[offset + 9] & 0xFFL) << 8;
                }
                if (keylen >= 9) {
                    b += (long)value[offset + 8] & 0xFFL;
                }
                if (keylen >= 8) {
                    a += Hash.word64At(value, offset);
                }
            } else {
                if (keylen == 7) {
                    a += ((long)value[offset + 6] & 0xFFL) << 48;
                }
                if (keylen >= 6) {
                    a += ((long)value[offset + 5] & 0xFFL) << 40;
                }
                if (keylen >= 5) {
                    a += ((long)value[offset + 4] & 0xFFL) << 32;
                }
                if (keylen >= 4) {
                    a += ((long)value[offset + 3] & 0xFFL) << 24;
                }
                if (keylen >= 3) {
                    a += ((long)value[offset + 2] & 0xFFL) << 16;
                }
                if (keylen >= 2) {
                    a += ((long)value[offset + 1] & 0xFFL) << 8;
                }
                if (keylen >= 1) {
                    a += (long)value[offset + 0] & 0xFFL;
                }
            }
            return Hash.mix64(a, b, c);
        }

        private static long word64At(byte[] bytes, int offset) {
            return ((long)bytes[offset + 0] & 0xFFL) + (((long)bytes[offset + 1] & 0xFFL) << 8) + (((long)bytes[offset + 2] & 0xFFL) << 16) + (((long)bytes[offset + 3] & 0xFFL) << 24) + (((long)bytes[offset + 4] & 0xFFL) << 32) + (((long)bytes[offset + 5] & 0xFFL) << 40) + (((long)bytes[offset + 6] & 0xFFL) << 48) + (((long)bytes[offset + 7] & 0xFFL) << 56);
        }

        private static long mix64(long a, long b, long c) {
            a -= b;
            a -= c;
            b -= c;
            b -= (a ^= c >>> 43);
            c -= a;
            c -= (b ^= a << 9);
            a -= b;
            a -= (c ^= b >>> 8);
            b -= c;
            b -= (a ^= c >>> 38);
            c -= a;
            c -= (b ^= a << 23);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 35);
            c -= a;
            c -= (b ^= a << 49);
            a -= b;
            a -= (c ^= b >>> 11);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 18);
            return c ^= b >>> 22;
        }
    }

    @GwtIncompatible(value="java.util.regex")
    public static final class Builder {
        private @Nullable String key = null;
        private String meaning;
        private String desc;
        private boolean hidden;
        private boolean isAnonymous = false;
        private boolean isExternal = false;
        private @Nullable String id;
        private @Nullable String alternateId;
        private final List<Part> parts = new ArrayList<Part>();
        private final Set<String> jsPlaceholderNames = new LinkedHashSet<String>();
        private ImmutableMap<String, String> placeholderNameToExampleMap = ImmutableMap.of();
        private ImmutableMap<String, String> placeholderNameToOriginalCodeMap = ImmutableMap.of();
        private String sourceName;

        public String getKey() {
            return this.key;
        }

        @CanIgnoreReturnValue
        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder appendPart(Part part) {
            Preconditions.checkNotNull((Object)part);
            this.parts.add(part);
            if (part.isPlaceholder()) {
                this.jsPlaceholderNames.add(part.getJsPlaceholderName());
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder appendParts(List<Part> parts) {
            for (Part part : parts) {
                this.appendPart(part);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder appendJsPlaceholderReference(String name) {
            Preconditions.checkNotNull((Object)name, (Object)"Placeholder name could not be null");
            this.parts.add(PlaceholderReference.createForJsName(name));
            this.jsPlaceholderNames.add(name);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder appendCanonicalPlaceholderReference(String name) {
            Preconditions.checkNotNull((Object)name, (Object)"Placeholder name could not be null");
            PlaceholderReference placeholder = PlaceholderReference.createForCanonicalName(name);
            this.parts.add(placeholder);
            this.jsPlaceholderNames.add(placeholder.getJsPlaceholderName());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder appendStringPart(String part) {
            Preconditions.checkNotNull((Object)part, (Object)"String part of the message could not be null");
            this.parts.add(StringPart.create(part));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPlaceholderNameToExampleMap(Map<String, String> map) {
            this.placeholderNameToExampleMap = ImmutableMap.copyOf(map);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPlaceholderNameToOriginalCodeMap(Map<String, String> map) {
            this.placeholderNameToOriginalCodeMap = ImmutableMap.copyOf(map);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDesc(@Nullable String desc) {
            this.desc = desc;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMeaning(@Nullable String meaning) {
            this.meaning = meaning;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAlternateId(@Nullable String alternateId) {
            this.alternateId = alternateId;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setIsHidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setIsAnonymous(boolean isAnonymous) {
            this.isAnonymous = isAnonymous;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setId(String id) {
            Preconditions.checkState((this.id == null ? 1 : 0) != 0, (String)"id already set to '%s': cannot change it to '%s'", (Object)this.id, (Object)id);
            this.id = id;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setIsExternalMsg(boolean isExternalMsg) {
            this.isExternal = isExternalMsg;
            return this;
        }

        public boolean hasParts() {
            return !this.parts.isEmpty();
        }

        public List<Part> getParts() {
            return this.parts;
        }

        public JsMessage build() {
            Preconditions.checkNotNull((Object)this.key, (Object)"key has not been set");
            Preconditions.checkNotNull((Object)this.id, (Object)"id has not been set");
            Preconditions.checkState((!this.isExternal || !this.isAnonymous ? 1 : 0) != 0, (Object)"a message cannot be both anonymous and external");
            if (this.alternateId != null && this.alternateId.equals(this.id)) {
                this.alternateId = null;
            }
            return new AutoValue_JsMessage(this.sourceName, this.key, this.isAnonymous, this.isExternal, this.id, (ImmutableList<Part>)ImmutableList.copyOf(this.parts), this.alternateId, this.desc, this.meaning, this.hidden, this.placeholderNameToExampleMap, this.placeholderNameToOriginalCodeMap, (ImmutableSet<String>)ImmutableSet.copyOf(this.jsPlaceholderNames));
        }
    }

    @AutoValue
    public static abstract class PlaceholderReference
    implements Part {
        static PlaceholderReference createForJsName(String name) {
            Preconditions.checkArgument((boolean)JsMessage.isLowerCamelCaseWithNumericSuffixes(name), (String)"invalid JS placeholder name format: '%s'", (Object)name);
            return new AutoValue_JsMessage_PlaceholderReference(name, false);
        }

        public static PlaceholderReference createForCanonicalName(String name) {
            Preconditions.checkArgument((boolean)JsMessage.isCanonicalPlaceholderNameFormat(name), (String)"not a canonical placeholder name format: '%s'", (Object)name);
            return new AutoValue_JsMessage_PlaceholderReference(name, true);
        }

        public abstract String getStoredPlaceholderName();

        public abstract boolean isCanonicalFormat();

        @Override
        public boolean isPlaceholder() {
            return true;
        }

        @Override
        public String getJsPlaceholderName() {
            String storedPlaceholderName = this.getStoredPlaceholderName();
            return this.isCanonicalFormat() ? JsMessage.toLowerCamelCaseWithNumericSuffixes(storedPlaceholderName) : storedPlaceholderName;
        }

        @Override
        public String getCanonicalPlaceholderName() {
            String storedPlaceholderName = this.getStoredPlaceholderName();
            return this.isCanonicalFormat() ? storedPlaceholderName : CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, storedPlaceholderName);
        }

        @Override
        public String getString() {
            throw new UnsupportedOperationException(SimpleFormat.format("not a string part: '%s'", this.getJsPlaceholderName()));
        }
    }

    @AutoValue
    public static abstract class StringPart
    implements Part {
        @Override
        public abstract String getString();

        public static StringPart create(String str) {
            return new AutoValue_JsMessage_StringPart(str);
        }

        @Override
        public boolean isPlaceholder() {
            return false;
        }

        @Override
        public String getJsPlaceholderName() {
            throw new UnsupportedOperationException(SimpleFormat.format("not a placeholder: '%s'", this.getString()));
        }

        @Override
        public String getCanonicalPlaceholderName() {
            throw new UnsupportedOperationException(SimpleFormat.format("not a placeholder: '%s'", this.getString()));
        }
    }

    public static interface Part {
        public boolean isPlaceholder();

        public String getJsPlaceholderName();

        public String getCanonicalPlaceholderName();

        public String getString();
    }

    public static final class PlaceholderFormatException
    extends Exception {
        public PlaceholderFormatException(String msg) {
            super(msg);
        }
    }
}

